# Generated by default/object.tt
package Paws::GlueDataBrew::FilesLimit;
  use Moose;
  has MaxFiles => (is => 'ro', isa => 'Int', required => 1);
  has Order => (is => 'ro', isa => 'Str');
  has OrderedBy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::FilesLimit

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::FilesLimit object:

  $service_obj->Method(Att1 => { MaxFiles => $value, ..., OrderedBy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::FilesLimit object:

  $result = $service_obj->Method(...);
  $result->Att1->MaxFiles

=head1 DESCRIPTION

Represents a limit imposed on number of Amazon S3 files that should be
selected for a dataset from a connected Amazon S3 path.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MaxFiles => Int

The number of Amazon S3 files to select.


=head2 Order => Str

A criteria to use for Amazon S3 files sorting before their selection.
By default uses DESCENDING order, i.e. most recent files are selected
first. Anotherpossible value is ASCENDING.


=head2 OrderedBy => Str

A criteria to use for Amazon S3 files sorting before their selection.
By default uses LAST_MODIFIED_DATE as a sorting criteria. Currently
it's the only allowed value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

