use Unicode::Collate::CJK::GB2312;
+{
   locale_version => 0.88,
   overrideCJK => \&Unicode::Collate::CJK::GB2312::weightGB2312,
   entry => <<'ENTRY', # for DUCET v6.1.0
0101      ; [.15D4.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.15D4.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.15D4.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.15D4.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.15D4.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.15D4.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.15D4.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.15D4.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.15D4.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.15D4.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.15D4.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.15D4.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.15D4.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.15D4.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.15D4.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.15D4.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.15D4.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.15D4.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.15D4.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.15D4.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.1631.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.1631.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.1631.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.1631.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.1631.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.1631.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.1631.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.1631.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.1631.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.1631.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.1631.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.1631.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
011A      ; [.1631.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.1631.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.1631.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.1631.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.1631.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.1631.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.1631.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.1631.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.1631.0021.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.1631.0021.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.1631.0021.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.1631.0021.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.1631.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.1631.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.1631.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.1631.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.1631.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.1631.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.1631.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.1631.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.1631.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.1631.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.1631.0023.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.1631.0023.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.1631.0023.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.1631.0023.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.1631.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.1631.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.1631.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.1631.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.1631.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.1631.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.1631.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.1631.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.1631.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.1631.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.1631.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.1631.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.1631.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.1631.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.1631.0025.0002.00EA][.0000.004E.0002.0303] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.1631.0025.0008.00CA][.0000.004E.0002.0303] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.1631.0025.0002.00EA][.0000.0064.0002.0309] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.1631.0025.0008.00CA][.0000.0064.0002.0309] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.1631.0025.0002.00EA][.0000.0070.0002.0323] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.1631.0025.0008.00CA][.0000.0070.0002.0323] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.16B2.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.16B2.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.16B2.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.16B2.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.16B2.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.16B2.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.16B2.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.16B2.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.16B2.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.16B2.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.16B2.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.16B2.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.16B2.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.16B2.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.16B2.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.16B2.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.16B2.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.16B2.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.16B2.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.16B2.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.1726.001C.0002.006D] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.1726.001C.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.1726.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.1726.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.1726.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.1726.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.1726.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.1726.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.1726.001E.0002.006D] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.1726.001E.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.1726.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.1726.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.1726.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.1726.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.1734.001C.0002.006E] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.1734.001C.0008.004E] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.1734.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.1734.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.1734.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.1734.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.1734.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.1734.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.1734.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.1734.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
0147      ; [.1734.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.1734.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.1734.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.1734.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.1734.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.1734.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.1734.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.1734.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1756.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1756.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1756.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1756.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1756.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1756.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1756.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1756.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1756.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1756.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1756.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1756.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1756.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1756.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1756.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1756.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1756.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1756.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1756.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1756.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.181B.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.181B.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.181B.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.181B.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.181B.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.181B.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.181B.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.181B.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.181B.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.181B.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.181B.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.181B.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.181B.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.181B.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.181B.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.181B.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.181B.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.181B.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.181B.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.181B.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.181B.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.181B.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.181B.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.181B.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.181B.0021.0002.01D6] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.181B.0021.0008.01D5] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.181B.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.181B.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.181B.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.181B.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.181B.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.181B.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.181B.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.181B.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.181B.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.181B.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.181B.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.181B.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.181B.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.181B.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.181B.0023.0002.01DA] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.181B.0023.0008.01D9] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.181B.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.181B.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.181B.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.181B.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.181B.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.181B.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.181B.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.181B.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.181B.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.181B.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.181B.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.181B.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.181B.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.181B.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
E2D8      ; [.8EAB.0020.0002.E2D8] # <unknown>
E2D9      ; [.8EAC.0020.0002.E2D9] # <unknown>
E2DA      ; [.8EAD.0020.0002.E2DA] # <unknown>
E2DB      ; [.8EAE.0020.0002.E2DB] # <unknown>
E2DC      ; [.8EAF.0020.0002.E2DC] # <unknown>
F967      ; [.80D6.0020.0002.4E0D] # CJK COMPATIBILITY IDEOGRAPH-F967
F905      ; [.8185.0020.0002.4E32] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.8AED.0020.0002.4E38] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.81D9.0020.0002.4E39] # CJK COMPATIBILITY IDEOGRAPH-F95E
2F800     ; [.8635.0020.0002.4E3D] # CJK COMPATIBILITY IDEOGRAPH-2F800
F9BA      ; [.8668.0020.0002.4E86] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.865E.0020.0002.4EAE] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.899D.0020.0002.4EC0] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.868B.0020.0002.4EE4] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.879A.0020.0002.4F60] # CJK COMPATIBILITY IDEOGRAPH-2F804
F9B5      ; [.863C.0020.0002.4F8B] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.8B4D.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.8B4D.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-2F805
F965      ; [.80A0.0020.0002.4FBF] # CJK COMPATIBILITY IDEOGRAPH-F965
2F80B     ; [.8BB2.0020.0002.50CF] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.8662.0020.0002.50DA] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.893B.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.893B.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.8EB2.0020.0002.5140] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.815D.0020.0002.5145] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.873B.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.873B.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.8AC8.0020.0002.5154] # CJK COMPATIBILITY IDEOGRAPH-2F80F
FA72      ; [.88DA.0020.0002.5168] # CJK COMPATIBILITY IDEOGRAPH-FA72
F9D1      ; [.8696.0020.0002.516D] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.8562.0020.0002.5177] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.8484.0020.0002.5180] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.8D70.0020.0002.518D] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.8709.0020.0002.5192] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.873A.0020.0002.5195] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.890E.0020.0002.5197] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.8D40.0020.0002.51A4] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.823F.0020.0002.51AC] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.85D7.0020.0002.51B5] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.85D7.0020.0002.51B5] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.8623.0020.0002.51B7] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.8656.0020.0002.51C9] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.8685.0020.0002.51CC] # CJK COMPATIBILITY IDEOGRAPH-F955
2F81D     ; [.8FF2.0020.0002.51F5] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.88FF.0020.0002.5203] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.88A1.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.88A1.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.866D.0020.0002.5217] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.863A.0020.0002.5229] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.81A3.0020.0002.523A] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.85AD.0020.0002.523B] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.833D.0020.0002.5272] # CJK COMPATIBILITY IDEOGRAPH-2F822
F98A      ; [.8643.0020.0002.529B] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.8670.0020.0002.52A3] # CJK COMPATIBILITY IDEOGRAPH-F99D
2F992     ; [.860C.0020.0002.52B3] # CJK COMPATIBILITY IDEOGRAPH-2F992
FA76      ; [.8CFB.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.8CFB.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.873C.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.873C.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.8614.0020.0002.52D2] # CJK COMPATIBILITY IDEOGRAPH-F952
FA34      ; [.88AB.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.88AB.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-2F827
FA77      ; [.8964.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.8964.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.805B.0020.0002.5305] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.81A9.0020.0002.5306] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.806E.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.806E.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.879B.0020.0002.533F] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.8445.0020.0002.5349] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.806D.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.806D.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.80C4.0020.0002.535A] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.847B.0020.0002.5373] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.86CC.0020.0002.5375] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F831     ; [.88B5.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.88B5.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.88B5.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F833
2F836     ; [.8477.0020.0002.53CA] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.8FEE.0020.0002.53DF] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.8567.0020.0002.53E5] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.84F5.0020.0002.53EB] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.9154.0020.0002.53F1] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.915B.0020.0002.5406] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.8633.0020.0002.540F] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.867C.0020.0002.541D] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.8B5F.0020.0002.5438] # CJK COMPATIBILITY IDEOGRAPH-2F83D
2F83E     ; [.8143.0020.0002.5448] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.8E2F.0020.0002.5468] # CJK COMPATIBILITY IDEOGRAPH-2F83F
F99E      ; [.8C47.0020.0002.54BD] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.8A6D.0020.0002.5510] # CJK COMPATIBILITY IDEOGRAPH-2F842
FA79      ; [.919C.0020.0002.5555] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F845     ; [.8953.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.8953.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.85ED.0020.0002.5587] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.91B8.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.91B8.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.83D3.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.83D3.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F849     ; [.8D92.0020.0002.55B3] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA38      ; [.886A.0020.0002.5668] # CJK COMPATIBILITY IDEOGRAPH-FA38
F9A9      ; [.91F1.0020.0002.56F9] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F855     ; [.8BEC.0020.0002.578B] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.8140.0020.0002.57CE] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.9023.0020.0002.57F4] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.9029.0020.0002.580D] # CJK COMPATIBILITY IDEOGRAPH-2F854
F96C      ; [.892A.0020.0002.585E] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.8762.0020.0002.58A8] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F851     ; [.8E64.0020.0002.58EE] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85D     ; [.8273.0020.0002.591A] # CJK COMPATIBILITY IDEOGRAPH-2F85D
FA7E      ; [.8C56.0020.0002.5944] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.8785.0020.0002.5948] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.8868.0020.0002.5951] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8079.0020.0002.5954] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.896A.0020.0002.5962] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.87C3.0020.0002.5973] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.93E3.0020.0002.59D8] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.846E.0020.0002.59EC] # CJK COMPATIBILITY IDEOGRAPH-2F862
FA80      ; [.93F1.0020.0002.5A62] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F986     ; [.95FD.0020.0002.5AB5] # CJK COMPATIBILITY IDEOGRAPH-2F986
FA04      ; [.8DA1.0020.0002.5B85] # CJK COMPATIBILITY IDEOGRAPH-FA04
F9BC      ; [.9391.0020.0002.5BEE] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F872     ; [.89C4.0020.0002.5BFF] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.84D0.0020.0002.5C06] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.910F.0020.0002.5C22] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.87A9.0020.0002.5C3F] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.8AC5.0020.0002.5C60] # CJK COMPATIBILITY IDEOGRAPH-2F877
F9DF      ; [.86BF.0020.0002.5C65] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.93CD.0020.0002.5C6E] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.93CD.0020.0002.5C6E] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.9206.0020.0002.5C8D] # CJK COMPATIBILITY IDEOGRAPH-2F87A
2F87F     ; [.922E.0020.0002.5D6B] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F881     ; [.8C2F.0020.0002.5DE1] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.812B.0020.0002.5DE2] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.8F50.0020.0002.5DFD] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F886     ; [.870A.0020.0002.5E3D] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.87A1.0020.0002.5E74] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.825B.0020.0002.5EA6] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.9293.0020.0002.5EB3] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.89E7.0020.0002.5EB6] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.864B.0020.0002.5EC9] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.8607.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.8607.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.9295.0020.0002.5ED2] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.85E9.0020.0002.5ED3] # CJK COMPATIBILITY IDEOGRAPH-FA0B
2F890     ; [.9106.0020.0002.5EFE] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.87BF.0020.0002.5F04] # CJK COMPATIBILITY IDEOGRAPH-F943
2F874     ; [.81E6.0020.0002.5F53] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.8BED.0020.0002.5F62] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.80E5.0020.0002.5F69] # CJK COMPATIBILITY IDEOGRAPH-FA84
F9D8      ; [.86C4.0020.0002.5F8B] # CJK COMPATIBILITY IDEOGRAPH-F9D8
FA85      ; [.9243.0020.0002.5FAD] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.88FB.0020.0002.5FCD] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.8E11.0020.0002.5FD7] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.87A5.0020.0002.5FF5] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.87C2.0020.0002.6012] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.864C.0020.0002.601C] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA3D      ; [.8443.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.8443.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
FA86      ; [.92C8.0020.0002.60D8] # CJK COMPATIBILITY IDEOGRAPH-FA86
FA88      ; [.8D33.0020.0002.6108] # CJK COMPATIBILITY IDEOGRAPH-FA88
2F8A6     ; [.819F.0020.0002.6148] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.842E.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.842E.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.8984.0020.0002.614E] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.8984.0020.0002.614E] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA3E      ; [.858F.0020.0002.6168] # CJK COMPATIBILITY IDEOGRAPH-FA3E
FA3F      ; [.8D8E.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.8D8E.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.8D8E.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
2F8B2     ; [.8142.0020.0002.6210] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.9554.0020.0002.621B] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.86B9.0020.0002.622E] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.81CE.0020.0002.6234] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.8064.0020.0002.62B1] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.85EC.0020.0002.62C9] # CJK COMPATIBILITY IDEOGRAPH-F925
FA02      ; [.8ADD.0020.0002.62D3] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.802D.0020.0002.62D4] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.8827.0020.0002.62FC] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.899B.0020.0002.62FE] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.8AF1.0020.0002.633D] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.856B.0020.0002.6350] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
F9A4      ; [.87A4.0020.0002.637B] # CJK COMPATIBILITY IDEOGRAPH-F9A4
F975      ; [.86CE.0020.0002.63A0] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.8C57.0020.0002.63A9] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.9130.0020.0002.63C4] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.8A1A.0020.0002.641C] # CJK COMPATIBILITY IDEOGRAPH-FA8E
FA8F      ; [.9133.0020.0002.6452] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.875D.0020.0002.6469] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
FA41      ; [.874D.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.874D.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.801C.0020.0002.6556] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.8537.0020.0002.656C] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F9BE      ; [.866C.0020.0002.6599] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.86BE.0020.0002.65C5] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.848F.0020.0002.65E2] # CJK COMPATIBILITY IDEOGRAPH-FA42
F9E0      ; [.8CB2.0020.0002.6613] # CJK COMPATIBILITY IDEOGRAPH-F9E0
FA12      ; [.88B8.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.88B8.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA91
FA43      ; [.89D9.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.89D9.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.8066.0020.0002.66B4] # CJK COMPATIBILITY IDEOGRAPH-FA06
F901      ; [.834B.0020.0002.66F4] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8D4     ; [.8E9F.0020.0002.6700] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.8609.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.8609.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.8609.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.8B00.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.8B00.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.862D.0020.0002.674E] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.94AB.0020.0002.6753] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.8DBD.0020.0002.6756] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.94AC.0020.0002.675E] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9F4      ; [.8673.0020.0002.6797] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.8695.0020.0002.67F3] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.8634.0020.0002.6817] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.8657.0020.0002.6881] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.8710.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.8710.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.8625.0020.0002.68A8] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.94F8.0020.0002.6942] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EF     ; [.81A5.0020.0002.6B21] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
FA95      ; [.81CC.0020.0002.6B79] # CJK COMPATIBILITY IDEOGRAPH-FA95
F972      ; [.897F.0020.0002.6C88] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.8C55.0020.0002.6CBF] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.8733.0020.0002.6CCC] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.8797.0020.0002.6CE5] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.86E0.0020.0002.6D1B] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.8247.0020.0002.6D1E] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.87DE.0020.0002.6D3E] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.8694.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.8694.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.8694.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.83D1.0020.0002.6D69] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.860A.0020.0002.6D6A] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.83AE.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.83AE.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.8523.0020.0002.6D78] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.87B0.0020.0002.6D85] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.8679.0020.0002.6DCB] # CJK COMPATIBILITY IDEOGRAPH-F9F5
2F90E     ; [.8C4A.0020.0002.6DF9] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.9335.0020.0002.6E1A] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.832A.0020.0002.6E2F] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.9345.0020.0002.6E6E] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.868C.0020.0002.6E9C] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.879E.0020.0002.6EBA] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.8216.0020.0002.6EC7] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.8E7D.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.8E7D.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.8415.0020.0002.6ED1] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.86A4.0020.0002.6F0F] # CJK COMPATIBILITY IDEOGRAPH-F94E
2F90F     ; [.812A.0020.0002.6F6E] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F915     ; [.9382.0020.0002.701B] # CJK COMPATIBILITY IDEOGRAPH-2F915
2F913     ; [.9383.0020.0002.7039] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F835     ; [.843B.0020.0002.7070] # CJK COMPATIBILITY IDEOGRAPH-2F835
F9FB      ; [.8E1E.0020.0002.7099] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.8A66.0020.0002.70AD] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.866F.0020.0002.70C8] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.8612.0020.0002.70D9] # CJK COMPATIBILITY IDEOGRAPH-F916
2F91C     ; [.9638.0020.0002.7145] # CJK COMPATIBILITY IDEOGRAPH-2F91C
FA48      ; [.8E46.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.8E46.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.8664.0020.0002.71CE] # CJK COMPATIBILITY IDEOGRAPH-F9C0
2F920     ; [.9647.0020.0002.7228] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.8577.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.8577.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.860D.0020.0002.7262] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.8B6D.0020.0002.7280] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.82A9.0020.0002.72AF] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F92B      ; [.8606.0020.0002.72FC] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.8E40.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.8E40.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F961      ; [.86C5.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.86C5.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.8AFA.0020.0002.738B] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.867E.0020.0002.73B2] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.9484.0020.0002.73DE] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.862C.0020.0002.7406] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.868D.0020.0002.7409] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.8E72.0020.0002.7422] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.9493.0020.0002.745C] # CJK COMPATIBILITY IDEOGRAPH-2F92F
FAA3      ; [.8416.0020.0002.753B] # CJK COMPATIBILITY IDEOGRAPH-FAA3
2F936     ; [.946F.0020.0002.753E] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.8691.0020.0002.7559] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.86CF.0020.0002.7565] # CJK COMPATIBILITY IDEOGRAPH-F976
F9E5      ; [.863E.0020.0002.75E2] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.97D4.0020.0002.7610] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.8B24.0020.0002.761F] # CJK COMPATIBILITY IDEOGRAPH-FAA5
FA17      ; [.8CC1.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.8CC1.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.898D.0020.0002.76DB] # CJK COMPATIBILITY IDEOGRAPH-FAA7
FAA8      ; [.8E04.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.8E04.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.898C.0020.0002.7701] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F946     ; [.8DDB.0020.0002.771F] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.8DDB.0020.0002.771F] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.8E76.0020.0002.7740] # CJK COMPATIBILITY IDEOGRAPH-FAAA
FA9D      ; [.8897.0020.0002.77A7] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.968F.0020.0002.784E] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.868F.0020.0002.786B] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.86B0.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.86B0.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.806B.0020.0002.7891] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.8619.0020.0002.78CA] # CJK COMPATIBILITY IDEOGRAPH-F947
FA18      ; [.8630.0020.0002.793C] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.8974.0020.0002.793E] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.8860.0020.0002.7948] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.9654.0020.0002.7949] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA50      ; [.8E97.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.8E97.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.8E54.0020.0002.795D] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.897E.0020.0002.795E] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.8BAA.0020.0002.7965] # CJK COMPATIBILITY IDEOGRAPH-FA1A
FA1B      ; [.82F2.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.82F2.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-2F956
2F957     ; [.9779.0020.0002.79EB] # CJK COMPATIBILITY IDEOGRAPH-2F957
FA55      ; [.8AC0.0020.0002.7A81] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.863F.0020.0002.7ACB] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.98CB.0020.0002.7B20] # CJK COMPATIBILITY IDEOGRAPH-F9F8
2F962     ; [.8E5E.0020.0002.7BC6] # CJK COMPATIBILITY IDEOGRAPH-2F962
FAAE      ; [.861F.0020.0002.7C7B] # CJK COMPATIBILITY IDEOGRAPH-FAAE
F9F9      ; [.8640.0020.0002.7C92] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.852E.0020.0002.7CBE] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.8A6E.0020.0002.7CD6] # CJK COMPATIBILITY IDEOGRAPH-FA03
2F968     ; [.9934.0020.0002.7CE8] # CJK COMPATIBILITY IDEOGRAPH-2F968
F96A      ; [.8A40.0020.0002.7D22] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.861A.0020.0002.7D2F] # CJK COMPATIBILITY IDEOGRAPH-F94F
FA59      ; [.82A2.0020.0002.7E41] # CJK COMPATIBILITY IDEOGRAPH-FA59
FA5A      ; [.89DB.0020.0002.7F72] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.96E1.0020.0002.7F79] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F9AF      ; [.8684.0020.0002.7F9A] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.8D29.0020.0002.7FBD] # CJK COMPATIBILITY IDEOGRAPH-FA1E
F934      ; [.860E.0020.0002.8001] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.8DD4.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.8DD4.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.8DD4.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.9833.0020.0002.8046] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F953      ; [.861E.0020.0002.808B] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.95D0.0020.0002.80AD] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.8D36.0020.0002.80B2] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.8815.0020.0002.813E] # CJK COMPATIBILITY IDEOGRAPH-2F985
FA5C      ; [.816D.0020.0002.81ED] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.98FF.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.98FF.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.9901.0020.0002.8204] # CJK COMPATIBILITY IDEOGRAPH-2F98C
F97C      ; [.8659.0020.0002.826F] # CJK COMPATIBILITY IDEOGRAPH-F97C
FA5D      ; [.903A.0020.0002.8279] # CJK COMPATIBILITY IDEOGRAPH-FA5D
FA5E      ; [.903A.0020.0002.8279] # CJK COMPATIBILITY IDEOGRAPH-FA5E
2F990     ; [.8D2C.0020.0002.828B] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.9042.0020.0002.8291] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.8DF8.0020.0002.829D] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.8411.0020.0002.82B1] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.82AD.0020.0002.82B3] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.8C3C.0020.0002.82BD] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.8923.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.8923.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.85C1.0020.0002.82E6] # CJK COMPATIBILITY IDEOGRAPH-2F996
F9FE      ; [.8103.0020.0002.8336] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.842D.0020.0002.8352] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99A     ; [.8908.0020.0002.8363] # CJK COMPATIBILITY IDEOGRAPH-2F99A
2F99D     ; [.8700.0020.0002.83BD] # CJK COMPATIBILITY IDEOGRAPH-2F99D
2F9A1     ; [.8558.0020.0002.83CA] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.857D.0020.0002.83CC] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.80E6.0020.0002.83DC] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
F958      ; [.867F.0020.0002.83F1] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.86DF.0020.0002.843D] # CJK COMPATIBILITY IDEOGRAPH-F918
FA5F      ; [.8E4B.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.8E4B.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F9C2      ; [.90E7.0020.0002.84FC] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.90EB.0020.0002.8564] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
2F9B3     ; [.87C5.0020.0002.8650] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
2F9B7     ; [.985A.0020.0002.86A9] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
F911      ; [.86D8.0020.0002.87BA] # CJK COMPATIBILITY IDEOGRAPH-F911
FA08      ; [.8BEF.0020.0002.884C] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.8C9D.0020.0002.8863] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.866E.0020.0002.88C2] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F912      ; [.86DE.0020.0002.88F8] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.83E1.0020.0002.8910] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.981C.0020.0002.8941] # CJK COMPATIBILITY IDEOGRAPH-FAB6
FAB7      ; [.8301.0020.0002.8986] # CJK COMPATIBILITY IDEOGRAPH-FAB7
2F9D2     ; [.996E.0020.0002.8C55] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D7     ; [.8863.0020.0002.8D77] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.9977.0020.0002.8DBC] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.802E.0020.0002.8DCB] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.86B2.0020.0002.8DEF] # CJK COMPATIBILITY IDEOGRAPH-F937
2F98D     ; [.819E.0020.0002.8F9E] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.8136.0020.0002.8FB0] # CJK COMPATIBILITY IDEOGRAPH-F971
FA66      ; [.9396.0020.0002.8FB6] # CJK COMPATIBILITY IDEOGRAPH-FA66
FA25      ; [.8CB8.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.8CB8.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA67
F92C      ; [.8608.0020.0002.90CE] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA26      ; [.824F.0020.0002.90FD] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.8611.0020.0002.916A] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.996C.0020.0002.91B4] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.862E.0020.0002.91CC] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.865C.0020.0002.91CF] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.8515.0020.0002.91D1] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9C6      ; [.891D.0020.0002.962E] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.86A5.0020.0002.964B] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.84DA.0020.0002.964D] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.8687.0020.0002.9675] # CJK COMPATIBILITY IDEOGRAPH-F959
F9DC      ; [.869C.0020.0002.9686] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9B2      ; [.8680.0020.0002.96F6] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.8616.0020.0002.96F7] # CJK COMPATIBILITY IDEOGRAPH-F949
F938      ; [.86B1.0020.0002.9732] # CJK COMPATIBILITY IDEOGRAPH-F938
FA1C      ; [.853B.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.853B.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FAC8
F940      ; [.86B4.0020.0002.9E7F] # CJK COMPATIBILITY IDEOGRAPH-F940
F9F3      ; [.9A5C.0020.0002.9E9F] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.86E4.0020.0002.9EBB] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.8627.0020.0002.9ECE] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.96AE.0020.0002.9EF9] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA18     ; [.99CF.0020.0002.9EFE] # CJK COMPATIBILITY IDEOGRAPH-2FA18
2FA1C     ; [.8084.0020.0002.9F3B] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
ENTRY
};
