use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'Dev::Util',
    DISTNAME           => 'Dev-Util',
    AUTHOR             => 'Matt Martini <matt@imaginarywave.com>',
    VERSION_FROM       => 'lib/Dev/Util.pm',
    ABSTRACT_FROM      => 'lib/Dev/Util.pm',
    LICENSE            => 'gpl_3',
    MIN_PERL_VERSION   => '5.018',
    PL_FILES           => {},
    BUILD_REQUIRES     => { 'ExtUtils::MakeMaker' => 0, },
    CONFIGURE_REQUIRES => { 'ExtUtils::MakeMaker' => 0, },
    PREREQ_PM          => {
                       'Archive::Tar'    => 3.04,
                       'Carp'            => 1.50,
                       'English'         => 0,
                       'Exporter'        => 0,
                       'File::Basename'  => 0,
                       'File::Copy'      => 0,
                       'File::Find'      => 0,
                       'File::Spec'      => 3.75,
                       'File::Temp'      => 0.2312,
                       'IO::File'        => 1.55,
                       'IO::Handle'      => 1.55,
                       'IO::Interactive' => 1.027,
                       'IO::Prompt'      => 0.997004,
                       'IPC::Cmd'        => 1.04,
                       'Import::Into'    => 1.002005,
                       'List::Util'      => 1.66,
                       'Module::Runtime' => 0.018,
                       'Readonly'        => 2.05,
                       'Term::ANSIColor' => 5.01,
                       'Term::ReadKey'   => 2.38,
                       'autodie'         => 0,
                       'strict'          => 0,
                       'utf8'            => 0,
                       'version'         => 0,
                       'warnings'        => 0,
                 },
    TEST_REQUIRES => {     'ExtUtils::Manifest'            => 0,
                           'File::Compare'                 => 1.1006,
                           'File::Path'                    => 2.18,
                           'Path::Tiny'                    => 0.148,
                           'Socket'                        => 2.040,
                           'Test2::Require::AuthorTesting' => 1.302219,
                           'Test2::Require::Module'        => 1.302219,
                           'Test2::Tools::Exception'       => 1.302219,
                           'Test2::Tools::Ref'             => 1.302219,
                           'Test2::V0'                     => 1.302219,
                           'Test::More'                    => 1.302219,
                           'Test::Perl::Critic'            => 1.04,
                           'Test::PerlTidy'                => 20230226,
                     },
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {   repository => {
                                         type => 'git',
                                         url => 'https://github.com/mattmartini/Dev-Util.git',
                                         web => 'https://github.com/mattmartini/Dev-Util'
                           },
                     }
                  },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES    => 'Dev-Util-*' },
    ## NOECHO => '', # make debug output if empty
);

# XT_TEST_REQUIRES => {     'App::Yath'                           => 0,
#                           'Pod::Coverage'                       => '0.18',
#                           'Perl::Critic'                        => 0,
#                           'Pod::Wordlist'                       => '1.27',
#                           'Test2::Bundle::More'                 => 0,
#                           'Test2::Tools::PerlCritic'            => 0,
#                           'Test::EOL'                           => 0,
#                           'Test::Kwalitee'                      => 0,
#                           'Test::Mojibake'                      => 0,
#                           'Test::NoTabs'                        => 0,
#                           'Test::Pod'                           => '1.22',
#                           'Test::Pod::Coverage'                 => '1.08',
#                           'Test::Pod::Spelling::CommonMistakes' => '1.001',
#                           'Test::Portability::Files'            => 0,
#                           'Test::Spelling'                      => '0.25',
#                           'Test::Strict'                        => 0,
#                           'Test::Version'                       => '2.09',
#                           'YAML'                                => '1.30',
#                     },
