######################################################################
#
# JIPSJ_by_CP932.pl
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# NEC Corporation Standard character set dictionary <BASIC>
# Document number ZBB10-3
#
# NEC Corporation Standard character set dictionary <EXTENSION>
# Document number ZBB11-2

use strict;

my %JIPSJ_by_CP932 = ();

my @JIPSJ_by_CP932_a = map { (split(/ /,$_))[3,4] } split(/\n/,<<'END');
 92CB  92CB B6F5
 FA9C  FA9C 444D
V 8D56 V 8D56 BDB6
 FAD0  FAD0 3937
 81CA  81CA A5CF
 849F  849F 2C24
 84A0  84A0 2C26
 84A1  84A1 2C30
 84A2  84A2 2C34
 84A3  84A3 2C3C
 84A4  84A4 2C38
 84A5  84A5 2C40
 84A6  84A6 2C50
 84A7  84A7 2C48
 84A8  84A8 2C58
 84A9  84A9 2C60
 84AA  84AA 2C25
 84AB  84AB 2C27
 84AC  84AC 2C33
 84AD  84AD 2C37
 84AE  84AE 2C3F
 84AF  84AF 2C3B
 84B0  84B0 2C47
 84B1  84B1 2C57
 84B2  84B2 2C4F
 84B3  84B3 2C5F
 84B4  84B4 2C6F
 84B5  84B5 2C44
 84B6  84B6 2C53
 84B7  84B7 2C4C
 84B8  84B8 2C5B
 84B9  84B9 2C63
 84BA  84BA 2C41
 84BB  84BB 2C54
 84BC  84BC 2C49
 84BD  84BD 2C5C
 84BE  84BE 2C66
 8784  8784 2D64
V FA56 V FA56 A3F9
W FA57 W FA57 A3FA
^ FA5E ^ FA5E D2B9
_ FA5F _ FA5F D1ED
b FA62 b FA62 C2FE
g FA67 g FA67 BAC7
j FA6A j FA6A B2D3
| FA7C | FA7C B3D2
 FA83  FA83 D4A8
 FA8A  FA8A B4EC
 FA8B  FA8B B4EF
 FA90  FA90 B5BE
 FA92  FA92 B5CF
 FA96  FA96 B6D6
 FA9B  FA9B B6E7
 FA9D  FA9D B7A8
 FAA0  FAA0 B7CB
 FAA3  FAA3 B7D3
 FAAA  FAAA B8D4
 FAAE  FAAE B9A9
 FAAF  FAAF B9B1
 FAB0  FAB0 C6B7
 FAB1  FAB1 B9BA
 FABA  FABA BAEC
 FABB  FABB BAFE
 FABC  FABC BBA9
 FABD  FABD BBB1
 FAC1  FAC1 BBC9
 FAC3  FAC3 BBD4
 FAC9  FAC9 BCCC
 FACA  FACA BCD9
 FACD  FACD BCF0
 FAD5  FAD5 BDD6
 FAD8  FAD8 BDE4
 FADE  FADE BDD1
 FAE0  FAE0 BEBE
 FAE5  FAE5 BEE2
 FAE7  FAE7 BFBA
 FAE8  FAE8 BFBC
 FAEA  FAEA BFD7
 FAEE  FAEE BFE6
 FAF2  FAF2 C0A8
B FB42 B FB42 C1D9
C FB43 C FB43 C1CD
D FB44 D FB44 C1DF
H FB48 H FB48 C1F4
P FB50 P FB50 C2F1
X FB58 X FB58 C3CE
Y FB59 Y FB59 C3D0
^ FB5E ^ FB5E C3F8
f FB66 f FB66 C4CB
k FB6B k FB6B C4ED
n FB6E n FB6E C5AC
p FB70 p FB70 C5D3
r FB72 r FB72 C5DA
u FB75 u FB75 C5E5
| FB7C | FB7C C6DA
} FB7D } FB7D C6DD
~ FB7E ~ FB7E C6EB
 FB80  FB80 C6F7
 FB82  FB82 C7A6
 FB85  FB85 C7F5
 FB86  FB86 C7F7
 FB89  FB89 C8E8
 FB8B  FB8B C9AC
 FB8D  FB8D C9B6
 FB8E  FB8E C9BD
 FB92  FB92 C9F6
 FB94  FB94 CBD3
 FB9D  FB9D CCFD
 FB9E  FB9E CDA9
 FB9F  FB9F CDC2
 FBA0  FBA0 CDD3
 FBA1  FBA1 CDE2
 FBA2  FBA2 CEA4
 FBA9  FBA9 CEEA
 FBAC  FBAC CEFE
 FBAE  FBAE CFBB
 FBB0  FBB0 CFC5
 FBB1  FBB1 CFC7
 FBB3  FBB3 CFFD
 FBB4  FBB4 D0C2
 FBB5  FBB5 D0CD
 FBB6  FBB6 D0EC
 FBB7  FBB7 D0F2
 FBB8  FBB8 D0F3
 FBCE  FBCE D1E6
 FBD3  FBD3 D2A6
 FBDA  FBDA D2B7
 FBE8  FBE8 D2FC
 FBE9  FBE9 D3B9
 FBEA  FBEA D3C0
 FBEE  FBEE D3D5
 FBF0  FBF0 D3D9
 FBF2  FBF2 D3DC
 FBF6  FBF6 D4B3
 FBF7  FBF7 D4B4
 FBF9  FBF9 D4B8
 FBFA  FBFA D4C3
 FBFB  FBFB D4D7
 FBFC  FBFC D4DC
B FC42 B FC42 D4EF
I FC49 I FC49 D5DA
K FC4B K FC4B D5EB
END

my @JIPSJ_by_CP932_b = map { (split(/ /,$_))[3,4] } split(/\n/,<<'END');
 92CB  92CB B6F5
 FA9C  FA9C 444D
V 8D56 V 8D56 BDB6
 FAD0  FAD0 3937
 81CA  81CA A5CF
 849F  849F 2C24
 84A0  84A0 2C26
 84A1  84A1 2C30
 84A2  84A2 2C34
 84A3  84A3 2C3C
 84A4  84A4 2C38
 84A5  84A5 2C40
 84A6  84A6 2C50
 84A7  84A7 2C48
 84A8  84A8 2C58
 84A9  84A9 2C60
 84AA  84AA 2C25
 84AB  84AB 2C27
 84AC  84AC 2C33
 84AD  84AD 2C37
 84AE  84AE 2C3F
 84AF  84AF 2C3B
 84B0  84B0 2C47
 84B1  84B1 2C57
 84B2  84B2 2C4F
 84B3  84B3 2C5F
 84B4  84B4 2C6F
 84B5  84B5 2C44
 84B6  84B6 2C53
 84B7  84B7 2C4C
 84B8  84B8 2C5B
 84B9  84B9 2C63
 84BA  84BA 2C41
 84BB  84BB 2C54
 84BC  84BC 2C49
 84BD  84BD 2C5C
 84BE  84BE 2C66
 8784  8784 2D64
V FA56 V FA56 A3F9
W FA57 W FA57 A3FA
^ FA5E ^ FA5E D2B9
_ FA5F _ FA5F D1ED
b FA62 b FA62 C2FE
g FA67 g FA67 BAC7
j FA6A j FA6A B2D3
| FA7C | FA7C B3D2
 FA83  FA83 D4A8
 FA8A  FA8A B4EC
 FA8B  FA8B B4EF
 FA90  FA90 B5BE
 FA92  FA92 B5CF
 FA96  FA96 B6D6
 FA9B  FA9B B6E7
 FA9D  FA9D B7A8
 FAA0  FAA0 B7CB
 FAA3  FAA3 B7D3
 FAAA  FAAA B8D4
 FAAE  FAAE B9A9
 FAAF  FAAF B9B1
 FAB0  FAB0 C6B7
 FAB1  FAB1 B9BA
 FABA  FABA BAEC
 FABB  FABB BAFE
 FABC  FABC BBA9
 FABD  FABD BBB1
 FAC1  FAC1 BBC9
 FAC3  FAC3 BBD4
 FAC9  FAC9 BCCC
 FACA  FACA BCD9
 FACD  FACD BCF0
 FAD5  FAD5 BDD6
 FAD8  FAD8 BDE4
 FADE  FADE BDD1
 FAE0  FAE0 BEBE
 FAE5  FAE5 BEE2
 FAE7  FAE7 BFBA
 FAE8  FAE8 BFBC
 FAEA  FAEA BFD7
 FAEE  FAEE BFE6
 FAF2  FAF2 C0A8
B FB42 B FB42 C1D9
C FB43 C FB43 C1CD
D FB44 D FB44 C1DF
H FB48 H FB48 C1F4
P FB50 P FB50 C2F1
X FB58 X FB58 C3CE
Y FB59 Y FB59 C3D0
^ FB5E ^ FB5E C3F8
f FB66 f FB66 C4CB
k FB6B k FB6B C4ED
n FB6E n FB6E C5AC
p FB70 p FB70 C5D3
r FB72 r FB72 C5DA
u FB75 u FB75 C5E5
| FB7C | FB7C C6DA
} FB7D } FB7D C6DD
~ FB7E ~ FB7E C6EB
 FB80  FB80 C6F7
 FB82  FB82 C7A6
 FB85  FB85 C7F5
 FB86  FB86 C7F7
 FB89  FB89 C8E8
 FB8B  FB8B C9AC
 FB8D  FB8D C9B6
 FB8E  FB8E C9BD
 FB92  FB92 C9F6
 FB94  FB94 CBD3
 FB9D  FB9D CCFD
 FB9E  FB9E CDA9
 FB9F  FB9F CDC2
 FBA0  FBA0 CDD3
 FBA1  FBA1 CDE2
 FBA2  FBA2 CEA4
 FBA9  FBA9 CEEA
 FBAC  FBAC CEFE
 FBAE  FBAE CFBB
 FBB0  FBB0 CFC5
 FBB1  FBB1 CFC7
 FBB3  FBB3 CFFD
 FBB4  FBB4 D0C2
 FBB5  FBB5 D0CD
 FBB6  FBB6 D0EC
 FBB7  FBB7 D0F2
 FBB8  FBB8 D0F3
 FBCE  FBCE D1E6
 FBD3  FBD3 D2A6
 FBDA  FBDA D2B7
 FBE8  FBE8 D2FC
 FBE9  FBE9 D3B9
 FBEA  FBEA D3C0
 FBEE  FBEE D3D5
 FBF0  FBF0 D3D9
 FBF2  FBF2 D3DC
 FBF6  FBF6 D4B3
 FBF7  FBF7 D4B4
 FBF9  FBF9 D4B8
 FBFA  FBFA D4C3
 FBFB  FBFB D4D7
 FBFC  FBFC D4DC
B FC42 B FC42 D4EF
I FC49 I FC49 D5DA
K FC4B K FC4B D5EB
END

for (@JIPSJ_by_CP932_a) {
    if (not /^[0123456789ABCDEF]{4}$/) {
        die;
    }
}

my %JIPSJ_by_CP932_a = @JIPSJ_by_CP932_a;
if (scalar(keys %JIPSJ_by_CP932_a) != scalar(@JIPSJ_by_CP932_a)/2) {
    die;
}

my %reverse_JIPSJ_by_CP932_a = reverse @JIPSJ_by_CP932_a;
if (scalar(keys %reverse_JIPSJ_by_CP932_a) != scalar(@JIPSJ_by_CP932_a)/2) {
    die;
}

for (@JIPSJ_by_CP932_b) {
    if (not /^[0123456789ABCDEF]{4}$/) {
        die;
    }
}

my %JIPSJ_by_CP932_b = @JIPSJ_by_CP932_b;
if (scalar(keys %JIPSJ_by_CP932_b) != scalar(@JIPSJ_by_CP932_b)/2) {
    die;
}

my %reverse_JIPSJ_by_CP932_b = reverse @JIPSJ_by_CP932_b;
if (scalar(keys %reverse_JIPSJ_by_CP932_b) != scalar(@JIPSJ_by_CP932_b)/2) {
    die;
}

if ("@JIPSJ_by_CP932_a" ne "@JIPSJ_by_CP932_b") {
    while (@JIPSJ_by_CP932_a or @JIPSJ_by_CP932_b) {
        my $a = shift @JIPSJ_by_CP932_a;
        my $b = shift @JIPSJ_by_CP932_b;
        if ($a ne $b) {
            print STDERR "A=$a\n";
            print STDERR "B=$b\n";
            print STDERR "\n";
        }
    }
    die;
}

%JIPSJ_by_CP932 = @JIPSJ_by_CP932_a;

sub JIPSJ_by_CP932 {
    my($cp932) = @_;
    return $JIPSJ_by_CP932{$cp932};
}

sub keys_of_JIPSJ_by_CP932 {
    return keys %JIPSJ_by_CP932;
}

sub values_of_JIPSJ_by_CP932 {
    return values %JIPSJ_by_CP932;
}

1;

__END__
