=begin comment

BMLT

BMLT Admin API Documentation

The version of the OpenAPI document: 1.0.0

Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package BmltClient::RootServerApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use BmltClient::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'BmltClient::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = BmltClient::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# auth_logout
#
# Revokes a token
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'auth_logout' } = {
        summary => 'Revokes a token',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub auth_logout {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/api/v1/auth/logout';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# auth_refresh
#
# Revokes and issues a new token
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'auth_refresh' } = {
        summary => 'Revokes and issues a new token',
        params => $params,
        returns => 'Token',
        };
}
# @return Token
#
sub auth_refresh {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/api/v1/auth/refresh';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Token', $response);
    return $_response_object;
}

#
# auth_token
#
# Creates a token
#
# @param TokenCredentials $token_credentials User credentials (required)
{
    my $params = {
    'token_credentials' => {
        data_type => 'TokenCredentials',
        description => 'User credentials',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'auth_token' } = {
        summary => 'Creates a token',
        params => $params,
        returns => 'Token',
        };
}
# @return Token
#
sub auth_token {
    my ($self, %args) = @_;

    # verify the required parameter 'token_credentials' is set
    unless (exists $args{'token_credentials'}) {
      croak("Missing the required parameter 'token_credentials' when calling auth_token");
    }

    # parse inputs
    my $_resource_path = '/api/v1/auth/token';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'token_credentials'}) {
        $_body_data = $args{'token_credentials'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Token', $response);
    return $_response_object;
}

#
# create_format
#
# Creates a format
#
# @param FormatCreate $format_create Pass in format object (required)
{
    my $params = {
    'format_create' => {
        data_type => 'FormatCreate',
        description => 'Pass in format object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_format' } = {
        summary => 'Creates a format',
        params => $params,
        returns => 'Format',
        };
}
# @return Format
#
sub create_format {
    my ($self, %args) = @_;

    # verify the required parameter 'format_create' is set
    unless (exists $args{'format_create'}) {
      croak("Missing the required parameter 'format_create' when calling create_format");
    }

    # parse inputs
    my $_resource_path = '/api/v1/formats';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'format_create'}) {
        $_body_data = $args{'format_create'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Format', $response);
    return $_response_object;
}

#
# create_meeting
#
# Creates a meeting
#
# @param MeetingCreate $meeting_create Pass in meeting object (required)
{
    my $params = {
    'meeting_create' => {
        data_type => 'MeetingCreate',
        description => 'Pass in meeting object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_meeting' } = {
        summary => 'Creates a meeting',
        params => $params,
        returns => 'Meeting',
        };
}
# @return Meeting
#
sub create_meeting {
    my ($self, %args) = @_;

    # verify the required parameter 'meeting_create' is set
    unless (exists $args{'meeting_create'}) {
      croak("Missing the required parameter 'meeting_create' when calling create_meeting");
    }

    # parse inputs
    my $_resource_path = '/api/v1/meetings';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'meeting_create'}) {
        $_body_data = $args{'meeting_create'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Meeting', $response);
    return $_response_object;
}

#
# create_service_body
#
# Creates a service body
#
# @param ServiceBodyCreate $service_body_create Pass in service body object (required)
{
    my $params = {
    'service_body_create' => {
        data_type => 'ServiceBodyCreate',
        description => 'Pass in service body object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_service_body' } = {
        summary => 'Creates a service body',
        params => $params,
        returns => 'ServiceBody',
        };
}
# @return ServiceBody
#
sub create_service_body {
    my ($self, %args) = @_;

    # verify the required parameter 'service_body_create' is set
    unless (exists $args{'service_body_create'}) {
      croak("Missing the required parameter 'service_body_create' when calling create_service_body");
    }

    # parse inputs
    my $_resource_path = '/api/v1/servicebodies';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'service_body_create'}) {
        $_body_data = $args{'service_body_create'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ServiceBody', $response);
    return $_response_object;
}

#
# create_user
#
# Creates a user
#
# @param UserCreate $user_create Pass in user object (required)
{
    my $params = {
    'user_create' => {
        data_type => 'UserCreate',
        description => 'Pass in user object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_user' } = {
        summary => 'Creates a user',
        params => $params,
        returns => 'User',
        };
}
# @return User
#
sub create_user {
    my ($self, %args) = @_;

    # verify the required parameter 'user_create' is set
    unless (exists $args{'user_create'}) {
      croak("Missing the required parameter 'user_create' when calling create_user");
    }

    # parse inputs
    my $_resource_path = '/api/v1/users';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'user_create'}) {
        $_body_data = $args{'user_create'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('User', $response);
    return $_response_object;
}

#
# delete_format
#
# Deletes a format
#
# @param int $format_id ID of format (required)
{
    my $params = {
    'format_id' => {
        data_type => 'int',
        description => 'ID of format',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_format' } = {
        summary => 'Deletes a format',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_format {
    my ($self, %args) = @_;

    # verify the required parameter 'format_id' is set
    unless (exists $args{'format_id'}) {
      croak("Missing the required parameter 'format_id' when calling delete_format");
    }

    # parse inputs
    my $_resource_path = '/api/v1/formats/{formatId}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'format_id'}) {
        my $_base_variable = "{" . "formatId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# delete_meeting
#
# Deletes a meeting
#
# @param int $meeting_id ID of meeting (required)
{
    my $params = {
    'meeting_id' => {
        data_type => 'int',
        description => 'ID of meeting',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_meeting' } = {
        summary => 'Deletes a meeting',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_meeting {
    my ($self, %args) = @_;

    # verify the required parameter 'meeting_id' is set
    unless (exists $args{'meeting_id'}) {
      croak("Missing the required parameter 'meeting_id' when calling delete_meeting");
    }

    # parse inputs
    my $_resource_path = '/api/v1/meetings/{meetingId}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'meeting_id'}) {
        my $_base_variable = "{" . "meetingId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'meeting_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# delete_service_body
#
# Deletes a service body
#
# @param int $service_body_id ID of service body (required)
{
    my $params = {
    'service_body_id' => {
        data_type => 'int',
        description => 'ID of service body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_service_body' } = {
        summary => 'Deletes a service body',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_service_body {
    my ($self, %args) = @_;

    # verify the required parameter 'service_body_id' is set
    unless (exists $args{'service_body_id'}) {
      croak("Missing the required parameter 'service_body_id' when calling delete_service_body");
    }

    # parse inputs
    my $_resource_path = '/api/v1/servicebodies/{serviceBodyId}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'service_body_id'}) {
        my $_base_variable = "{" . "serviceBodyId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'service_body_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# delete_user
#
# Deletes a user
#
# @param int $user_id ID of user (required)
{
    my $params = {
    'user_id' => {
        data_type => 'int',
        description => 'ID of user',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_user' } = {
        summary => 'Deletes a user',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_user {
    my ($self, %args) = @_;

    # verify the required parameter 'user_id' is set
    unless (exists $args{'user_id'}) {
      croak("Missing the required parameter 'user_id' when calling delete_user");
    }

    # parse inputs
    my $_resource_path = '/api/v1/users/{userId}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'user_id'}) {
        my $_base_variable = "{" . "userId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'user_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# get_format
#
# Retrieves a format
#
# @param int $format_id ID of format (required)
{
    my $params = {
    'format_id' => {
        data_type => 'int',
        description => 'ID of format',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_format' } = {
        summary => 'Retrieves a format',
        params => $params,
        returns => 'Format',
        };
}
# @return Format
#
sub get_format {
    my ($self, %args) = @_;

    # verify the required parameter 'format_id' is set
    unless (exists $args{'format_id'}) {
      croak("Missing the required parameter 'format_id' when calling get_format");
    }

    # parse inputs
    my $_resource_path = '/api/v1/formats/{formatId}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'format_id'}) {
        my $_base_variable = "{" . "formatId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Format', $response);
    return $_response_object;
}

#
# get_formats
#
# Retrieves formats
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_formats' } = {
        summary => 'Retrieves formats',
        params => $params,
        returns => 'ARRAY[Format]',
        };
}
# @return ARRAY[Format]
#
sub get_formats {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/api/v1/formats';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Format]', $response);
    return $_response_object;
}

#
# get_meeting
#
# Retrieves a meeting
#
# @param int $meeting_id ID of meeting (required)
{
    my $params = {
    'meeting_id' => {
        data_type => 'int',
        description => 'ID of meeting',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_meeting' } = {
        summary => 'Retrieves a meeting',
        params => $params,
        returns => 'Meeting',
        };
}
# @return Meeting
#
sub get_meeting {
    my ($self, %args) = @_;

    # verify the required parameter 'meeting_id' is set
    unless (exists $args{'meeting_id'}) {
      croak("Missing the required parameter 'meeting_id' when calling get_meeting");
    }

    # parse inputs
    my $_resource_path = '/api/v1/meetings/{meetingId}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'meeting_id'}) {
        my $_base_variable = "{" . "meetingId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'meeting_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Meeting', $response);
    return $_response_object;
}

#
# get_meetings
#
# Retrieves meetings
#
# @param string $meeting_ids comma delimited meeting ids (optional)
# @param string $days comma delimited day ids between 0-6 (optional)
# @param string $service_body_ids comma delimited service body ids (optional)
# @param string $search_string string (optional)
{
    my $params = {
    'meeting_ids' => {
        data_type => 'string',
        description => 'comma delimited meeting ids',
        required => '0',
    },
    'days' => {
        data_type => 'string',
        description => 'comma delimited day ids between 0-6',
        required => '0',
    },
    'service_body_ids' => {
        data_type => 'string',
        description => 'comma delimited service body ids',
        required => '0',
    },
    'search_string' => {
        data_type => 'string',
        description => 'string',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_meetings' } = {
        summary => 'Retrieves meetings',
        params => $params,
        returns => 'ARRAY[Meeting]',
        };
}
# @return ARRAY[Meeting]
#
sub get_meetings {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/api/v1/meetings';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'meeting_ids'}) {
        $query_params->{'meetingIds'} = $self->{api_client}->to_query_value($args{'meeting_ids'});
    }

    # query params
    if ( exists $args{'days'}) {
        $query_params->{'days'} = $self->{api_client}->to_query_value($args{'days'});
    }

    # query params
    if ( exists $args{'service_body_ids'}) {
        $query_params->{'serviceBodyIds'} = $self->{api_client}->to_query_value($args{'service_body_ids'});
    }

    # query params
    if ( exists $args{'search_string'}) {
        $query_params->{'searchString'} = $self->{api_client}->to_query_value($args{'search_string'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Meeting]', $response);
    return $_response_object;
}

#
# get_service_bodies
#
# Retrieves service bodies
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_service_bodies' } = {
        summary => 'Retrieves service bodies',
        params => $params,
        returns => 'ARRAY[ServiceBody]',
        };
}
# @return ARRAY[ServiceBody]
#
sub get_service_bodies {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/api/v1/servicebodies';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[ServiceBody]', $response);
    return $_response_object;
}

#
# get_service_body
#
# Retrieves a service body
#
# @param int $service_body_id ID of service body (required)
{
    my $params = {
    'service_body_id' => {
        data_type => 'int',
        description => 'ID of service body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_service_body' } = {
        summary => 'Retrieves a service body',
        params => $params,
        returns => 'ServiceBody',
        };
}
# @return ServiceBody
#
sub get_service_body {
    my ($self, %args) = @_;

    # verify the required parameter 'service_body_id' is set
    unless (exists $args{'service_body_id'}) {
      croak("Missing the required parameter 'service_body_id' when calling get_service_body");
    }

    # parse inputs
    my $_resource_path = '/api/v1/servicebodies/{serviceBodyId}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'service_body_id'}) {
        my $_base_variable = "{" . "serviceBodyId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'service_body_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ServiceBody', $response);
    return $_response_object;
}

#
# get_user
#
# Retrieves a single user
#
# @param int $user_id ID of user (required)
{
    my $params = {
    'user_id' => {
        data_type => 'int',
        description => 'ID of user',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_user' } = {
        summary => 'Retrieves a single user',
        params => $params,
        returns => 'User',
        };
}
# @return User
#
sub get_user {
    my ($self, %args) = @_;

    # verify the required parameter 'user_id' is set
    unless (exists $args{'user_id'}) {
      croak("Missing the required parameter 'user_id' when calling get_user");
    }

    # parse inputs
    my $_resource_path = '/api/v1/users/{userId}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'user_id'}) {
        my $_base_variable = "{" . "userId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'user_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('User', $response);
    return $_response_object;
}

#
# get_users
#
# Retrieves users
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_users' } = {
        summary => 'Retrieves users',
        params => $params,
        returns => 'ARRAY[User]',
        };
}
# @return ARRAY[User]
#
sub get_users {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/api/v1/users';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[User]', $response);
    return $_response_object;
}

#
# partial_update_user
#
# Patches a user
#
# @param int $user_id ID of user (required)
# @param UserPartialUpdate $user_partial_update Pass in fields you want to update. (required)
{
    my $params = {
    'user_id' => {
        data_type => 'int',
        description => 'ID of user',
        required => '1',
    },
    'user_partial_update' => {
        data_type => 'UserPartialUpdate',
        description => 'Pass in fields you want to update.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'partial_update_user' } = {
        summary => 'Patches a user',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub partial_update_user {
    my ($self, %args) = @_;

    # verify the required parameter 'user_id' is set
    unless (exists $args{'user_id'}) {
      croak("Missing the required parameter 'user_id' when calling partial_update_user");
    }

    # verify the required parameter 'user_partial_update' is set
    unless (exists $args{'user_partial_update'}) {
      croak("Missing the required parameter 'user_partial_update' when calling partial_update_user");
    }

    # parse inputs
    my $_resource_path = '/api/v1/users/{userId}';

    my $_method = 'PATCH';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'user_id'}) {
        my $_base_variable = "{" . "userId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'user_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'user_partial_update'}) {
        $_body_data = $args{'user_partial_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# patch_format
#
# Patches a format
#
# @param int $format_id ID of format (required)
# @param FormatPartialUpdate $format_partial_update Pass in fields you want to update. (required)
{
    my $params = {
    'format_id' => {
        data_type => 'int',
        description => 'ID of format',
        required => '1',
    },
    'format_partial_update' => {
        data_type => 'FormatPartialUpdate',
        description => 'Pass in fields you want to update.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'patch_format' } = {
        summary => 'Patches a format',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub patch_format {
    my ($self, %args) = @_;

    # verify the required parameter 'format_id' is set
    unless (exists $args{'format_id'}) {
      croak("Missing the required parameter 'format_id' when calling patch_format");
    }

    # verify the required parameter 'format_partial_update' is set
    unless (exists $args{'format_partial_update'}) {
      croak("Missing the required parameter 'format_partial_update' when calling patch_format");
    }

    # parse inputs
    my $_resource_path = '/api/v1/formats/{formatId}';

    my $_method = 'PATCH';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'format_id'}) {
        my $_base_variable = "{" . "formatId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'format_partial_update'}) {
        $_body_data = $args{'format_partial_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# patch_meeting
#
# Patches a meeting
#
# @param int $meeting_id ID of meeting (required)
# @param MeetingPartialUpdate $meeting_partial_update Pass in fields you want to update. (required)
{
    my $params = {
    'meeting_id' => {
        data_type => 'int',
        description => 'ID of meeting',
        required => '1',
    },
    'meeting_partial_update' => {
        data_type => 'MeetingPartialUpdate',
        description => 'Pass in fields you want to update.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'patch_meeting' } = {
        summary => 'Patches a meeting',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub patch_meeting {
    my ($self, %args) = @_;

    # verify the required parameter 'meeting_id' is set
    unless (exists $args{'meeting_id'}) {
      croak("Missing the required parameter 'meeting_id' when calling patch_meeting");
    }

    # verify the required parameter 'meeting_partial_update' is set
    unless (exists $args{'meeting_partial_update'}) {
      croak("Missing the required parameter 'meeting_partial_update' when calling patch_meeting");
    }

    # parse inputs
    my $_resource_path = '/api/v1/meetings/{meetingId}';

    my $_method = 'PATCH';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'meeting_id'}) {
        my $_base_variable = "{" . "meetingId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'meeting_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'meeting_partial_update'}) {
        $_body_data = $args{'meeting_partial_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# patch_service_body
#
# Patches a service body
#
# @param int $service_body_id ID of service body (required)
# @param ServiceBodyPartialUpdate $service_body_partial_update Pass in fields you want to update. (required)
{
    my $params = {
    'service_body_id' => {
        data_type => 'int',
        description => 'ID of service body',
        required => '1',
    },
    'service_body_partial_update' => {
        data_type => 'ServiceBodyPartialUpdate',
        description => 'Pass in fields you want to update.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'patch_service_body' } = {
        summary => 'Patches a service body',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub patch_service_body {
    my ($self, %args) = @_;

    # verify the required parameter 'service_body_id' is set
    unless (exists $args{'service_body_id'}) {
      croak("Missing the required parameter 'service_body_id' when calling patch_service_body");
    }

    # verify the required parameter 'service_body_partial_update' is set
    unless (exists $args{'service_body_partial_update'}) {
      croak("Missing the required parameter 'service_body_partial_update' when calling patch_service_body");
    }

    # parse inputs
    my $_resource_path = '/api/v1/servicebodies/{serviceBodyId}';

    my $_method = 'PATCH';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'service_body_id'}) {
        my $_base_variable = "{" . "serviceBodyId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'service_body_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'service_body_partial_update'}) {
        $_body_data = $args{'service_body_partial_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# update_format
#
# Updates a format
#
# @param int $format_id ID of format (required)
# @param FormatUpdate $format_update Pass in format object (required)
{
    my $params = {
    'format_id' => {
        data_type => 'int',
        description => 'ID of format',
        required => '1',
    },
    'format_update' => {
        data_type => 'FormatUpdate',
        description => 'Pass in format object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_format' } = {
        summary => 'Updates a format',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub update_format {
    my ($self, %args) = @_;

    # verify the required parameter 'format_id' is set
    unless (exists $args{'format_id'}) {
      croak("Missing the required parameter 'format_id' when calling update_format");
    }

    # verify the required parameter 'format_update' is set
    unless (exists $args{'format_update'}) {
      croak("Missing the required parameter 'format_update' when calling update_format");
    }

    # parse inputs
    my $_resource_path = '/api/v1/formats/{formatId}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'format_id'}) {
        my $_base_variable = "{" . "formatId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'format_update'}) {
        $_body_data = $args{'format_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# update_meeting
#
# Updates a meeting
#
# @param int $meeting_id ID of meeting (required)
# @param MeetingUpdate $meeting_update Pass in meeting object (required)
{
    my $params = {
    'meeting_id' => {
        data_type => 'int',
        description => 'ID of meeting',
        required => '1',
    },
    'meeting_update' => {
        data_type => 'MeetingUpdate',
        description => 'Pass in meeting object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_meeting' } = {
        summary => 'Updates a meeting',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub update_meeting {
    my ($self, %args) = @_;

    # verify the required parameter 'meeting_id' is set
    unless (exists $args{'meeting_id'}) {
      croak("Missing the required parameter 'meeting_id' when calling update_meeting");
    }

    # verify the required parameter 'meeting_update' is set
    unless (exists $args{'meeting_update'}) {
      croak("Missing the required parameter 'meeting_update' when calling update_meeting");
    }

    # parse inputs
    my $_resource_path = '/api/v1/meetings/{meetingId}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'meeting_id'}) {
        my $_base_variable = "{" . "meetingId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'meeting_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'meeting_update'}) {
        $_body_data = $args{'meeting_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# update_service_body
#
# Updates a Service Body
#
# @param int $service_body_id ID of service body (required)
# @param ServiceBodyUpdate $service_body_update Pass in service body object (required)
{
    my $params = {
    'service_body_id' => {
        data_type => 'int',
        description => 'ID of service body',
        required => '1',
    },
    'service_body_update' => {
        data_type => 'ServiceBodyUpdate',
        description => 'Pass in service body object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_service_body' } = {
        summary => 'Updates a Service Body',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub update_service_body {
    my ($self, %args) = @_;

    # verify the required parameter 'service_body_id' is set
    unless (exists $args{'service_body_id'}) {
      croak("Missing the required parameter 'service_body_id' when calling update_service_body");
    }

    # verify the required parameter 'service_body_update' is set
    unless (exists $args{'service_body_update'}) {
      croak("Missing the required parameter 'service_body_update' when calling update_service_body");
    }

    # parse inputs
    my $_resource_path = '/api/v1/servicebodies/{serviceBodyId}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'service_body_id'}) {
        my $_base_variable = "{" . "serviceBodyId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'service_body_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'service_body_update'}) {
        $_body_data = $args{'service_body_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# update_user
#
# Update single user
#
# @param int $user_id ID of user (required)
# @param UserUpdate $user_update Pass in user object (required)
{
    my $params = {
    'user_id' => {
        data_type => 'int',
        description => 'ID of user',
        required => '1',
    },
    'user_update' => {
        data_type => 'UserUpdate',
        description => 'Pass in user object',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_user' } = {
        summary => 'Update single user',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub update_user {
    my ($self, %args) = @_;

    # verify the required parameter 'user_id' is set
    unless (exists $args{'user_id'}) {
      croak("Missing the required parameter 'user_id' when calling update_user");
    }

    # verify the required parameter 'user_update' is set
    unless (exists $args{'user_update'}) {
      croak("Missing the required parameter 'user_update' when calling update_user");
    }

    # parse inputs
    my $_resource_path = '/api/v1/users/{userId}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'user_id'}) {
        my $_base_variable = "{" . "userId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'user_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'user_update'}) {
        $_body_data = $args{'user_update'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(bmltToken )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

1;
