=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsHypelinksApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_hypelinks_delete_worksheet_hyperlink
#
# Delete worksheet hyperlink by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $hyperlink_index The hyperlink&#39;s index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'hyperlink_index' => {
        data_type => 'int',
        description => 'The hyperlink&#39;s index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_delete_worksheet_hyperlink' } = { 
    	summary => 'Delete worksheet hyperlink by index.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_hypelinks_delete_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_delete_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_delete_worksheet_hyperlink");
    }

    # verify the required parameter 'hyperlink_index' is set
    unless (exists $args{'hyperlink_index'}) {
      croak("Missing the required parameter 'hyperlink_index' when calling cells_hypelinks_delete_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'hyperlink_index'}) {
        my $_base_variable = "{" . "hyperlinkIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'hyperlink_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_delete_worksheet_hyperlinks
#
# Delete all hyperlinks in worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_delete_worksheet_hyperlinks' } = { 
    	summary => 'Delete all hyperlinks in worksheet.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_hypelinks_delete_worksheet_hyperlinks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_delete_worksheet_hyperlinks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_delete_worksheet_hyperlinks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_get_worksheet_hyperlink
#
# Get worksheet hyperlink by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $hyperlink_index The hyperlink&#39;s index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'hyperlink_index' => {
        data_type => 'int',
        description => 'The hyperlink&#39;s index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_get_worksheet_hyperlink' } = { 
    	summary => 'Get worksheet hyperlink by index.',
        params => $params,
        returns => 'HyperlinkResponse',
        };
}
# @return HyperlinkResponse
#
sub cells_hypelinks_get_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_get_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_get_worksheet_hyperlink");
    }

    # verify the required parameter 'hyperlink_index' is set
    unless (exists $args{'hyperlink_index'}) {
      croak("Missing the required parameter 'hyperlink_index' when calling cells_hypelinks_get_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'hyperlink_index'}) {
        my $_base_variable = "{" . "hyperlinkIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'hyperlink_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinkResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_get_worksheet_hyperlinks
#
# Get worksheet hyperlinks.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_get_worksheet_hyperlinks' } = { 
    	summary => 'Get worksheet hyperlinks.',
        params => $params,
        returns => 'HyperlinksResponse',
        };
}
# @return HyperlinksResponse
#
sub cells_hypelinks_get_worksheet_hyperlinks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_get_worksheet_hyperlinks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_get_worksheet_hyperlinks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinksResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_post_worksheet_hyperlink
#
# Update worksheet hyperlink by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $hyperlink_index The hyperlink&#39;s index. (required)
# @param Hyperlink $hyperlink Hyperlink object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'hyperlink_index' => {
        data_type => 'int',
        description => 'The hyperlink&#39;s index.',
        required => '1',
    },
    'hyperlink' => {
        data_type => 'Hyperlink',
        description => 'Hyperlink object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_post_worksheet_hyperlink' } = { 
    	summary => 'Update worksheet hyperlink by index.',
        params => $params,
        returns => 'HyperlinkResponse',
        };
}
# @return HyperlinkResponse
#
sub cells_hypelinks_post_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_post_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_post_worksheet_hyperlink");
    }

    # verify the required parameter 'hyperlink_index' is set
    unless (exists $args{'hyperlink_index'}) {
      croak("Missing the required parameter 'hyperlink_index' when calling cells_hypelinks_post_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'hyperlink_index'}) {
        my $_base_variable = "{" . "hyperlinkIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'hyperlink_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'hyperlink'}) {
        $_body_data = $args{'hyperlink'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinkResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_put_worksheet_hyperlink
#
# Add worksheet hyperlink.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $first_row  (required)
# @param int $first_column  (required)
# @param int $total_rows  (required)
# @param int $total_columns  (required)
# @param string $address  (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'first_row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'first_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'address' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_put_worksheet_hyperlink' } = { 
    	summary => 'Add worksheet hyperlink.',
        params => $params,
        returns => 'HyperlinkResponse',
        };
}
# @return HyperlinkResponse
#
sub cells_hypelinks_put_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'first_row' is set
    unless (exists $args{'first_row'}) {
      croak("Missing the required parameter 'first_row' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'first_column' is set
    unless (exists $args{'first_column'}) {
      croak("Missing the required parameter 'first_column' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'address' is set
    unless (exists $args{'address'}) {
      croak("Missing the required parameter 'address' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_row'}) {
        $query_params->{'firstRow'} = $self->{api_client}->to_query_value($args{'first_row'});
    }

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'address'}) {
        $query_params->{'address'} = $self->{api_client}->to_query_value($args{'address'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinkResponse', $response);
    return $_response_object;
}

1;
