#include "abi_products.h"

namespace goes
{
    namespace grb
    {
        namespace products
        {
            namespace ABI
            {
                std::map<int, GRBProductABI> ABI_IMAGE_PRODUCTS = {
                    // Mode 6, Full Disk
                    {0x90, {6, FULL_DISK, 1}},
                    {0x91, {6, FULL_DISK, 2}},
                    {0x92, {6, FULL_DISK, 3}},
                    {0x93, {6, FULL_DISK, 4}},
                    {0x94, {6, FULL_DISK, 5}},
                    {0x95, {6, FULL_DISK, 6}},
                    {0x96, {6, FULL_DISK, 7}},
                    {0x97, {6, FULL_DISK, 8}},
                    {0x98, {6, FULL_DISK, 9}},
                    {0x99, {6, FULL_DISK, 10}},
                    {0x9A, {6, FULL_DISK, 11}},
                    {0x9B, {6, FULL_DISK, 12}},
                    {0x9C, {6, FULL_DISK, 13}},
                    {0x9D, {6, FULL_DISK, 14}},
                    {0x9E, {6, FULL_DISK, 15}},
                    {0x9F, {6, FULL_DISK, 16}},

                    // Mode 6, CONUS
                    {0xB0, {6, CONUS, 1}},
                    {0xB1, {6, CONUS, 2}},
                    {0xB2, {6, CONUS, 3}},
                    {0xB3, {6, CONUS, 4}},
                    {0xB4, {6, CONUS, 5}},
                    {0xB5, {6, CONUS, 6}},
                    {0xB6, {6, CONUS, 7}},
                    {0xB7, {6, CONUS, 8}},
                    {0xB8, {6, CONUS, 9}},
                    {0xB9, {6, CONUS, 10}},
                    {0xBA, {6, CONUS, 11}},
                    {0xBB, {6, CONUS, 12}},
                    {0xBC, {6, CONUS, 13}},
                    {0xBD, {6, CONUS, 14}},
                    {0xBE, {6, CONUS, 15}},
                    {0xBF, {6, CONUS, 16}},

                    // Mode 6, Meso-1
                    {0xD0, {6, MESO_1, 1}},
                    {0xD1, {6, MESO_1, 2}},
                    {0xD2, {6, MESO_1, 3}},
                    {0xD3, {6, MESO_1, 4}},
                    {0xD4, {6, MESO_1, 5}},
                    {0xD5, {6, MESO_1, 6}},
                    {0xD6, {6, MESO_1, 7}},
                    {0xD7, {6, MESO_1, 8}},
                    {0xD8, {6, MESO_1, 9}},
                    {0xD9, {6, MESO_1, 10}},
                    {0xDA, {6, MESO_1, 11}},
                    {0xDB, {6, MESO_1, 12}},
                    {0xDC, {6, MESO_1, 13}},
                    {0xDD, {6, MESO_1, 14}},
                    {0xDE, {6, MESO_1, 15}},
                    {0xDF, {6, MESO_1, 16}},

                    // Mode 6, Meso-2
                    {0xF0, {6, MESO_2, 1}},
                    {0xF1, {6, MESO_2, 2}},
                    {0xF2, {6, MESO_2, 3}},
                    {0xF3, {6, MESO_2, 4}},
                    {0xF4, {6, MESO_2, 5}},
                    {0xF5, {6, MESO_2, 6}},
                    {0xF6, {6, MESO_2, 7}},
                    {0xF7, {6, MESO_2, 8}},
                    {0xF8, {6, MESO_2, 9}},
                    {0xF9, {6, MESO_2, 10}},
                    {0xFA, {6, MESO_2, 11}},
                    {0xFB, {6, MESO_2, 12}},
                    {0xFC, {6, MESO_2, 13}},
                    {0xFD, {6, MESO_2, 14}},
                    {0xFE, {6, MESO_2, 15}},
                    {0xFF, {6, MESO_2, 16}},

                    // Mode 3, Full Disk
                    {0x110, {3, FULL_DISK, 1}},
                    {0x111, {3, FULL_DISK, 2}},
                    {0x112, {3, FULL_DISK, 3}},
                    {0x113, {3, FULL_DISK, 4}},
                    {0x114, {3, FULL_DISK, 5}},
                    {0x115, {3, FULL_DISK, 6}},
                    {0x116, {3, FULL_DISK, 7}},
                    {0x117, {3, FULL_DISK, 8}},
                    {0x118, {3, FULL_DISK, 9}},
                    {0x119, {3, FULL_DISK, 10}},
                    {0x11A, {3, FULL_DISK, 11}},
                    {0x11B, {3, FULL_DISK, 12}},
                    {0x11C, {3, FULL_DISK, 13}},
                    {0x11D, {3, FULL_DISK, 14}},
                    {0x11E, {3, FULL_DISK, 15}},
                    {0x11F, {3, FULL_DISK, 16}},

                    // Mode 3, CONUS
                    {0x130, {3, CONUS, 1}},
                    {0x131, {3, CONUS, 2}},
                    {0x132, {3, CONUS, 3}},
                    {0x133, {3, CONUS, 4}},
                    {0x134, {3, CONUS, 5}},
                    {0x135, {3, CONUS, 6}},
                    {0x136, {3, CONUS, 7}},
                    {0x137, {3, CONUS, 8}},
                    {0x138, {3, CONUS, 9}},
                    {0x139, {3, CONUS, 10}},
                    {0x13A, {3, CONUS, 11}},
                    {0x13B, {3, CONUS, 12}},
                    {0x13C, {3, CONUS, 13}},
                    {0x13D, {3, CONUS, 14}},
                    {0x13E, {3, CONUS, 15}},
                    {0x13F, {3, CONUS, 16}},

                    // Mode 3, Meso-1
                    {0x150, {3, MESO_1, 1}},
                    {0x151, {3, MESO_1, 2}},
                    {0x152, {3, MESO_1, 3}},
                    {0x153, {3, MESO_1, 4}},
                    {0x154, {3, MESO_1, 5}},
                    {0x155, {3, MESO_1, 6}},
                    {0x156, {3, MESO_1, 7}},
                    {0x157, {3, MESO_1, 8}},
                    {0x158, {3, MESO_1, 9}},
                    {0x159, {3, MESO_1, 10}},
                    {0x15A, {3, MESO_1, 11}},
                    {0x15B, {3, MESO_1, 12}},
                    {0x15C, {3, MESO_1, 13}},
                    {0x15D, {3, MESO_1, 14}},
                    {0x15E, {3, MESO_1, 15}},
                    {0x15F, {3, MESO_1, 16}},

                    // Mode 3, Meso-2
                    {0x170, {3, MESO_2, 1}},
                    {0x171, {3, MESO_2, 2}},
                    {0x172, {3, MESO_2, 3}},
                    {0x173, {3, MESO_2, 4}},
                    {0x174, {3, MESO_2, 5}},
                    {0x175, {3, MESO_2, 6}},
                    {0x176, {3, MESO_2, 7}},
                    {0x177, {3, MESO_2, 8}},
                    {0x178, {3, MESO_2, 9}},
                    {0x179, {3, MESO_2, 10}},
                    {0x17A, {3, MESO_2, 11}},
                    {0x17B, {3, MESO_2, 12}},
                    {0x17C, {3, MESO_2, 13}},
                    {0x17D, {3, MESO_2, 14}},
                    {0x17E, {3, MESO_2, 15}},
                    {0x17F, {3, MESO_2, 16}},

                    // Mode 4, Full Disk
                    {0x190, {4, FULL_DISK, 1}},
                    {0x191, {4, FULL_DISK, 2}},
                    {0x192, {4, FULL_DISK, 3}},
                    {0x193, {4, FULL_DISK, 4}},
                    {0x194, {4, FULL_DISK, 5}},
                    {0x195, {4, FULL_DISK, 6}},
                    {0x196, {4, FULL_DISK, 7}},
                    {0x197, {4, FULL_DISK, 8}},
                    {0x198, {4, FULL_DISK, 9}},
                    {0x199, {4, FULL_DISK, 10}},
                    {0x19A, {4, FULL_DISK, 11}},
                    {0x19B, {4, FULL_DISK, 12}},
                    {0x19C, {4, FULL_DISK, 13}},
                    {0x19D, {4, FULL_DISK, 14}},
                    {0x19E, {4, FULL_DISK, 15}},
                    {0x19F, {4, FULL_DISK, 16}},

                    // Mode 4, CONUS
                    {0x1A0, {4, CONUS, 1}},
                    {0x1A1, {4, CONUS, 2}},
                    {0x1A2, {4, CONUS, 3}},
                    {0x1A3, {4, CONUS, 4}},
                    {0x1A4, {4, CONUS, 5}},
                    {0x1A5, {4, CONUS, 6}},
                    {0x1A6, {4, CONUS, 7}},
                    {0x1A7, {4, CONUS, 8}},
                    {0x1A8, {4, CONUS, 9}},
                    {0x1A9, {4, CONUS, 10}},
                    {0x1AA, {4, CONUS, 11}},
                    {0x1AB, {4, CONUS, 12}},
                    {0x1AC, {4, CONUS, 13}},
                    {0x1AD, {4, CONUS, 14}},
                    {0x1AE, {4, CONUS, 15}},
                    {0x1AF, {4, CONUS, 16}},
                };

                std::map<int, GRBProductABI> ABI_IMAGE_PRODUCTS_META = {
                    // Mode 6, Full Disk
                    {0x80, {6, FULL_DISK, 1}},
                    {0x81, {6, FULL_DISK, 2}},
                    {0x82, {6, FULL_DISK, 3}},
                    {0x83, {6, FULL_DISK, 4}},
                    {0x84, {6, FULL_DISK, 5}},
                    {0x85, {6, FULL_DISK, 6}},
                    {0x86, {6, FULL_DISK, 7}},
                    {0x87, {6, FULL_DISK, 8}},
                    {0x88, {6, FULL_DISK, 9}},
                    {0x89, {6, FULL_DISK, 10}},
                    {0x8A, {6, FULL_DISK, 11}},
                    {0x8B, {6, FULL_DISK, 12}},
                    {0x8C, {6, FULL_DISK, 13}},
                    {0x8D, {6, FULL_DISK, 14}},
                    {0x8E, {6, FULL_DISK, 15}},
                    {0x8F, {6, FULL_DISK, 16}},

                    // Mode 6, CONUS
                    {0xA0, {6, CONUS, 1}},
                    {0xA1, {6, CONUS, 2}},
                    {0xA2, {6, CONUS, 3}},
                    {0xA3, {6, CONUS, 4}},
                    {0xA4, {6, CONUS, 5}},
                    {0xA5, {6, CONUS, 6}},
                    {0xA6, {6, CONUS, 7}},
                    {0xA7, {6, CONUS, 8}},
                    {0xA8, {6, CONUS, 9}},
                    {0xA9, {6, CONUS, 10}},
                    {0xAA, {6, CONUS, 11}},
                    {0xAB, {6, CONUS, 12}},
                    {0xAC, {6, CONUS, 13}},
                    {0xAD, {6, CONUS, 14}},
                    {0xAE, {6, CONUS, 15}},
                    {0xAF, {6, CONUS, 16}},

                    // Mode 6, Meso-1
                    {0xC0, {6, MESO_1, 1}},
                    {0xC1, {6, MESO_1, 2}},
                    {0xC2, {6, MESO_1, 3}},
                    {0xC3, {6, MESO_1, 4}},
                    {0xC4, {6, MESO_1, 5}},
                    {0xC5, {6, MESO_1, 6}},
                    {0xC6, {6, MESO_1, 7}},
                    {0xC7, {6, MESO_1, 8}},
                    {0xC8, {6, MESO_1, 9}},
                    {0xC9, {6, MESO_1, 10}},
                    {0xCA, {6, MESO_1, 11}},
                    {0xCB, {6, MESO_1, 12}},
                    {0xCC, {6, MESO_1, 13}},
                    {0xCD, {6, MESO_1, 14}},
                    {0xCE, {6, MESO_1, 15}},
                    {0xCF, {6, MESO_1, 16}},

                    // Mode 6, Meso-2
                    {0xE0, {6, MESO_2, 1}},
                    {0xE1, {6, MESO_2, 2}},
                    {0xE2, {6, MESO_2, 3}},
                    {0xE3, {6, MESO_2, 4}},
                    {0xE4, {6, MESO_2, 5}},
                    {0xE5, {6, MESO_2, 6}},
                    {0xE6, {6, MESO_2, 7}},
                    {0xE7, {6, MESO_2, 8}},
                    {0xE8, {6, MESO_2, 9}},
                    {0xE9, {6, MESO_2, 10}},
                    {0xEA, {6, MESO_2, 11}},
                    {0xEB, {6, MESO_2, 12}},
                    {0xEC, {6, MESO_2, 13}},
                    {0xED, {6, MESO_2, 14}},
                    {0xEE, {6, MESO_2, 15}},
                    {0xEF, {6, MESO_2, 16}},

                    // Mode 3, Full Disk
                    {0x100, {3, FULL_DISK, 1}},
                    {0x101, {3, FULL_DISK, 2}},
                    {0x102, {3, FULL_DISK, 3}},
                    {0x103, {3, FULL_DISK, 4}},
                    {0x104, {3, FULL_DISK, 5}},
                    {0x105, {3, FULL_DISK, 6}},
                    {0x106, {3, FULL_DISK, 7}},
                    {0x107, {3, FULL_DISK, 8}},
                    {0x108, {3, FULL_DISK, 9}},
                    {0x109, {3, FULL_DISK, 10}},
                    {0x10A, {3, FULL_DISK, 11}},
                    {0x10B, {3, FULL_DISK, 12}},
                    {0x10C, {3, FULL_DISK, 13}},
                    {0x10D, {3, FULL_DISK, 14}},
                    {0x10E, {3, FULL_DISK, 15}},
                    {0x10F, {3, FULL_DISK, 16}},

                    // Mode 3, CONUS
                    {0x120, {3, CONUS, 1}},
                    {0x121, {3, CONUS, 2}},
                    {0x122, {3, CONUS, 3}},
                    {0x123, {3, CONUS, 4}},
                    {0x124, {3, CONUS, 5}},
                    {0x125, {3, CONUS, 6}},
                    {0x126, {3, CONUS, 7}},
                    {0x127, {3, CONUS, 8}},
                    {0x128, {3, CONUS, 9}},
                    {0x129, {3, CONUS, 10}},
                    {0x12A, {3, CONUS, 11}},
                    {0x12B, {3, CONUS, 12}},
                    {0x12C, {3, CONUS, 13}},
                    {0x12D, {3, CONUS, 14}},
                    {0x12E, {3, CONUS, 15}},
                    {0x12F, {3, CONUS, 16}},

                    // Mode 3, Meso-1
                    {0x140, {3, MESO_1, 1}},
                    {0x141, {3, MESO_1, 2}},
                    {0x142, {3, MESO_1, 3}},
                    {0x143, {3, MESO_1, 4}},
                    {0x144, {3, MESO_1, 5}},
                    {0x145, {3, MESO_1, 6}},
                    {0x146, {3, MESO_1, 7}},
                    {0x147, {3, MESO_1, 8}},
                    {0x148, {3, MESO_1, 9}},
                    {0x149, {3, MESO_1, 10}},
                    {0x14A, {3, MESO_1, 11}},
                    {0x14B, {3, MESO_1, 12}},
                    {0x14C, {3, MESO_1, 13}},
                    {0x14D, {3, MESO_1, 14}},
                    {0x14E, {3, MESO_1, 15}},
                    {0x14F, {3, MESO_1, 16}},

                    // Mode 3, Meso-2
                    {0x160, {3, MESO_2, 1}},
                    {0x161, {3, MESO_2, 2}},
                    {0x162, {3, MESO_2, 3}},
                    {0x163, {3, MESO_2, 4}},
                    {0x164, {3, MESO_2, 5}},
                    {0x165, {3, MESO_2, 6}},
                    {0x166, {3, MESO_2, 7}},
                    {0x167, {3, MESO_2, 8}},
                    {0x168, {3, MESO_2, 9}},
                    {0x169, {3, MESO_2, 10}},
                    {0x16A, {3, MESO_2, 11}},
                    {0x16B, {3, MESO_2, 12}},
                    {0x16C, {3, MESO_2, 13}},
                    {0x16D, {3, MESO_2, 14}},
                    {0x16E, {3, MESO_2, 15}},
                    {0x16F, {3, MESO_2, 16}},

                    // Mode 4, Full Disk
                    {0x180, {4, FULL_DISK, 1}},
                    {0x181, {4, FULL_DISK, 2}},
                    {0x182, {4, FULL_DISK, 3}},
                    {0x183, {4, FULL_DISK, 4}},
                    {0x184, {4, FULL_DISK, 5}},
                    {0x185, {4, FULL_DISK, 6}},
                    {0x186, {4, FULL_DISK, 7}},
                    {0x187, {4, FULL_DISK, 8}},
                    {0x188, {4, FULL_DISK, 9}},
                    {0x189, {4, FULL_DISK, 10}},
                    {0x18A, {4, FULL_DISK, 11}},
                    {0x18B, {4, FULL_DISK, 12}},
                    {0x18C, {4, FULL_DISK, 13}},
                    {0x18D, {4, FULL_DISK, 14}},
                    {0x18E, {4, FULL_DISK, 15}},
                    {0x18F, {4, FULL_DISK, 16}},

                    // Mode 4, CONUS
                    {0x190, {4, CONUS, 1}},
                    {0x191, {4, CONUS, 2}},
                    {0x192, {4, CONUS, 3}},
                    {0x193, {4, CONUS, 4}},
                    {0x194, {4, CONUS, 5}},
                    {0x195, {4, CONUS, 6}},
                    {0x196, {4, CONUS, 7}},
                    {0x197, {4, CONUS, 8}},
                    {0x198, {4, CONUS, 9}},
                    {0x199, {4, CONUS, 10}},
                    {0x19A, {4, CONUS, 11}},
                    {0x19B, {4, CONUS, 12}},
                    {0x19C, {4, CONUS, 13}},
                    {0x19D, {4, CONUS, 14}},
                    {0x19E, {4, CONUS, 15}},
                    {0x19F, {4, CONUS, 16}},
                };

                std::map<int, ABIChannelParameters> ABI_CHANNEL_PARAMS = {
                    {1, {1.0, 10}},
                    {2, {0.5, 12}},
                    {3, {1.0, 10}},
                    {4, {2.0, 11}},
                    {5, {1.0, 10}},
                    {6, {2.0, 10}},
                    {7, {2.0, 14}},
                    {8, {2.0, 12}},
                    {9, {2.0, 11}},
                    {10, {2.0, 12}},
                    {11, {2.0, 12}},
                    {12, {2.0, 11}},
                    {13, {2.0, 12}},
                    {14, {2.0, 12}},
                    {15, {2.0, 12}},
                    {16, {2.0, 10}},
                };

                std::string abiZoneToString(ABIScanType type)
                {
                    std::string zone = "UNKNOWN";
                    if (type == products::ABI::FULL_DISK)
                        zone = "FULLDISK";
                    else if (type == products::ABI::CONUS)
                        zone = "CONUS";
                    else if (type == products::ABI::MESO_1)
                        zone = "MESO1";
                    else if (type == products::ABI::MESO_2)
                        zone = "MESO2";
                    return zone;
                }
            }
        }
    }
}