In this example, a django app would be configured to use pycrowdsec. Remediations are as following.

- ban: These IP's would be redirected to a 403 page.
- captcha: These IP's would be required to solve a google recaptcha.


**Requirements:**

 - CrowdSec installed and listening on http://localhost:8080 . Find installation instructions [here](https://docs.crowdsec.net/Crowdsec/v1/getting_started/installation/)

 - Google reCaptcha API tokens. Find instructions [here](http://www.google.com/recaptcha/admin)


## Steps

- Set the following environment variables
  
```bash
export CROWDSEC_LAPI_KEY=<LAPI_KEY>
export GOOGLE_RECAPTCHA_PRIVATE_KEY=<PRIVATE_KEY>
export GOOGLE_RECAPTCHA_SITE_KEY=<SITE_KEY>
```
 
 **CROWDSEC_LAPI_KEY**: This can be generated by running the follwing command :

 ```bash
❯ sudo cscli bouncers add django_eg
Api key for 'django_eg':

   ab9512a45e258b36d38ba8e274c5f1e4  
 ```

 **GOOGLE_RECAPTCHA_PRIVATE_KEY** and **GOOGLE_RECAPTCHA_SITE_KEY**: Google would give these keys after setup completion


- Install dependencies, make sure you are in a virtual environment.

```bash
pip install -r requirements.txt
```

- Finally start django web app via :

```bash
python manage.py runserver
```

The web app would be served at http://localhost:8000 . It would display a simple "Hello" message.

- Now add some decisions:

```bash
sudo cscli decisions add --value 127.0.0.1  --type captcha
```

Now if you navigate to the web app, you would be required to solve the captcha.

You can also add a decision to ban some IP.

```bash
sudo cscli decisions add --value <BAD_IP>  --type ban
```

You can also remove remediations for some IP by running: 

```bash
sudo cscli decisions delete --ip <IP_TO_UNBAN>
```

By default each "decision" would be deleted after 4 hours.
