# -*- coding: utf-8 -*-
#
# Debian Package Repository documentation build configuration file, created by
# sphinx-quickstart on Sat Mar 28 17:08:58 2009.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# The contents of this file are pickled, so don't put values in the namespace
# that aren't pickleable (module imports are okay, they're removed automatically).
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys, os

# If your extensions are in another directory, add it here. If the directory
# is relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
#sys.path.append(os.path.abspath('.'))

def artworkdir():
    """Look into every parent dir for 'artwork' and return its relative path."""
    level = 0
    while True:
        target = os.path.join(*([os.path.pardir] * level + ['artwork']))
        if os.path.isdir(target):
            return target
        else:
            level += 1
        # if there is no way up
        if os.path.abspath(os.path.join(*([os.path.pardir] * level))) == \
           os.path.abspath(os.path.join(*([os.path.pardir] * (level + 1)))):
            raise(ValueError, "Cannot find 'artwork'.")


# General configuration
# ---------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
#extensions = []
sys.path.append(os.path.abspath('.'))
extensions = ['sphinxext.quote',
              'sphinxext.feed',
              'sphinx.ext.todo']

# show todo items
todo_include_todos = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Debian Neuroscience Package Repository'
copyright = u'2009-2014, NeuroDebian Team <team@neuro.debian.net>'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = ''
# The full version, including alpha/beta/rc tags.
release = ''

# Monkey patch "English" language regular expression so we could
# search for package names as well
import re
word_re = re.compile(r'[-.\w]+')

import sphinx.search
# older versions (before 1.1.3, 1.0.7 for sure) had no language
# customizations
if hasattr(sphinx.search, 'word_re'):
    sphinx.search.word_re = word_re
else:
    from sphinx.search.en import SearchEnglish
    SearchEnglish._word_re = word_re

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ['pkgs_addenum']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# Options for HTML output
# -----------------------

# The style sheet to use for HTML and HTML Help pages. A file of that name
# must exist either in Sphinx' static/ path, or in one of the custom paths
# given in html_static_path.
html_style = 'neurodebian.css'

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'default'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {'nosidebar': True}

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = project

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = "Debian Neuroscience"

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = os.path.join(artworkdir(), 'logo_tuned/fmri_w200.png')

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = False

# If false, no index is generated.
html_use_index = False

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
html_copy_source = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'debpkgrepo'


# Options for LaTeX output
# ------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, document class [howto/manual]).
latex_documents = [
  ('index', 'DebianPackageRepository.tex', 'Debian Package Repository Documentation',
   'Michael Hanke', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_use_modindex = True

# RSS feed
# --------
feed_base_url = 'http://neuro.debian.net'
feed_title = "NeuroDebian Insider"
feed_subtitle = "This solves all your problems"
feed_description = "A blog about using the ultimate operating system in neuroscience research"
feed_variants = {'planetdebian': {'filename': 'feeds/for-debian-planet.xml',
                                  'tag': 'debian'},
                 'all': {'filename': 'feeds/blog.xml', 'tag': None}}
feed_categories = ['debian', 'neuroscience']
feed_author_name = 'NeuroDebian team'
feed_author_email = 'team@neuro.debian.net'
