/* u_1_22.t:    Undefined behaviors on generating invalid pp-token by # and
        ## operators.   */

/* u.1.22:  Result of ## operator is not a valid pp-token.  */
#define NUM( dig, exp)  dig ## E+ ## exp
/*
 *   "E+" is a sequence of two pp-tokens "E" and "+", not a single pp-token.
 * The first ## concatenates the last pp-token of first argument with "E",
 * and the second ## concatenates "+" with the first pp-token of the second
 * argument.
 *   While "12E" (one of the sequence generated by the token concatenation)
 * is a valid pp-token, "+34" (the another sequence) is not a valid pp-token
 * and causes an undefined behavior.
 */
    NUM( 12, 34);

/* u.1.23:  Result of # operator is not a valid string literal. */
/*  "\\"\"";    This sequence is parsed to three tokens "\\" \ "", and will be
        diagnosed by compiler-proper unless diagnosed by preprocessor.  */
#define str( a)     #a
    str( \"");

