
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetaDataAttributes.h
    \\brief Definition of MetaData Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "MetaDataWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


MetaDataWrapper::MetaDataWrapper(): metadata_(new MetaData())

{

	
	
	
} 
MetaDataWrapper::MetaDataWrapper(MetaData* metadata): metadata_(metadata)
{
	
	
} 

MetaDataWrapper::~MetaDataWrapper()
{
	
}

void MetaDataWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("METADATA_PATH") ) {
		string path_value = request("METADATA_PATH");
		metadata_->path_ = path_value;
		}
	if  (request.countValues("JAVASCRIPT_PATH") ) {
		string javascript_value = request("JAVASCRIPT_PATH");
		metadata_->javascript_ = javascript_value;
		}
	if  (request.countValues("PROFILE_PATH") ) {
		string profile_value = request("PROFILE_PATH");
		metadata_->profile_ = profile_value;
		}
	if  (request.countValues("WORLD_FILE_PATH") ) {
		string world_file_value = request("WORLD_FILE_PATH");
		metadata_->world_file_ = world_file_value;
		}
	if  (request.countValues("METADATA_WMS_FILE") ) {
		string wms_file_value = request("METADATA_WMS_FILE");
		metadata_->wms_file_ = wms_file_value;
		}
	if  (request.countValues("EFI_PATH") ) {
		string efi_value = request("EFI_PATH");
		metadata_->efi_ = efi_value;
		}
	if  (request.countValues("EFI_TEMPLATE") ) {
		string efi_template_value = request("EFI_TEMPLATE");
		metadata_->efi_template_ = efi_template_value;
		}
	
	
}

void MetaDataWrapper::print(ostream& out)  const
{
	out << "MetaDataWrapper[]";
}


    



