/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-01-29 20:09
 */
 
#ifndef _UTILS_H_
#define _UTILS_H_
 
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <dirent.h>
#include <errno.h>
#include <time.h>
#include <string>
#include <cstring>
#include <sstream>
#include <iomanip>
#include <cctype>
#include <algorithm>
#include <stdio.h>
#include <libintl.h>
#include <locale.h>
#include <glib.h>
#include "sha1.h"

#define _(string)			gettext(string)
#define N(string)			string


inline std::string urlEncode(const unsigned char* str, size_t len)
{
		static const char unreserved_chars[] = "-_.!~*()"
			"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
			"0123456789";

		std::stringstream ret;
		ret << std::hex << std::setfill('0');
		for (size_t i = 0; i < len; ++i)
		{
			if (std::count(
					unreserved_chars
					, unreserved_chars+sizeof(unreserved_chars)-1
					, *str))
			{
				ret << *str;
			}
			else
			{
				ret << '%'
					<< std::setw(2)
					<< (int)(*str);
			}
			++str;
		}
		return ret.str();
}

inline std::string getUrlProtocol(const char* url)
{
	std::string str_url=url;
	
	std::string::size_type pos=str_url.find("://");
	if(pos==std::string::npos)
	{
		return "";
	}
	
	return str_url.substr(0, pos);
}

inline bool parseUrl(const char* url,std::string& host,unsigned short* port,std::string& path)
{
	std::string str_url=url;
	
	std::string::size_type pos=str_url.find("://");
	if(pos==std::string::npos)
	{
		return false;
	}
	
	str_url.erase(0,pos+3);
	
	pos=str_url.find(":");
	if(pos==std::string::npos)
	{
		*port=80;
		pos=str_url.find("/");
		if(pos==std::string::npos)
		{
			return false;
		}
		
		host=str_url.substr(0,pos);
		
		str_url.erase(0,pos);
	}
	else
	{
		host=str_url.substr(0,pos);
		
		str_url.erase(0,pos+1);
		
		pos=str_url.find("/");
		if(pos==std::string::npos)
		{
			return false;
		}
		
		std::string str_port=str_url.substr(0,pos);
		*port=(unsigned short)atoi(str_port.c_str());
		
		str_url.erase(0,pos);
	}
	
	if(str_url.length()==0)
	{
		path="/";
	}
	else
	{
		path=str_url;
	}	
	
	return true;
}
 
inline unsigned int GetTickCount()
{
	struct timeval tv;
    gettimeofday( &tv, NULL );
    // this will rollover ~ every 49.7 days
    return (unsigned int)(tv.tv_sec * 1000 + tv.tv_usec / 1000);
}

inline std::string shaString(char* data, size_t len)
{
	unsigned char buf[20];
	sha1_block((unsigned char*)data, len, buf);
	
	std::string result;
	result.append((const char*)buf, sizeof(buf));
	return result;
}

inline bool createDir(const char* path)
{
	std::string strPath = path;
	std::string::size_type pos = strPath.rfind('/');
	if(pos == std::string::npos)
	{
		return false;
	}
	if(pos != strPath.size()-1)
	{
		strPath.erase(pos+1, strPath.size()-pos-1);
	}
	
	std::string dirPath;
	for(;;)
	{
		std::string::size_type pos = strPath.find('/',1);
		if(pos == std::string::npos)
		{
			break;
		}
		
		dirPath += strPath.substr(0, pos);
		DIR* dir = opendir(dirPath.c_str());
		if(dir == NULL)
		{
			if(errno == ENOENT)
			{
				if(-1 == mkdir(dirPath.c_str(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH))
				{
					return false;
				}
			}
			else
			{
				return false;
			}
		}
		
		if(dir != NULL)
		{
			closedir(dir);
		}
		
		strPath.erase(0, pos);
	}
	
	return true;
}

inline std::string extractFileName(const char* fullPath)
{
	std::string strPath = fullPath;
	std::string::size_type pos = strPath.rfind('/');
	if(pos == std::string::npos)
	{
		return fullPath;
	}
	if(pos != strPath.size()-1)
	{
		return strPath.substr(pos+1, strPath.size()-pos-1);
	}
	
	return "";
}

inline std::string extractFilePath(const char* fullPath)
{
	std::string strPath = fullPath;
	std::string::size_type pos = strPath.rfind('/');
	if(pos == std::string::npos)
	{
		return "./";
	}
	if(pos != strPath.size()-1)
	{
		return strPath.substr(0, pos+1);
	}
	
	return fullPath;
}

inline std::string second2Str(unsigned int second)
{
	char buf[128];
	
	if(second<60)
	{
		sprintf(buf, "%u sec", second);
		return buf;
	}
	
	if(second>=60 && second<60*60)
	{
		unsigned int min = second / 60;
		unsigned int sec = second % 60;
		sprintf(buf, "%u min %u sec", min, sec);
		return buf;
	}
	
	unsigned int hou = second/(60*60);
	unsigned int min = (second%(60*60))/60;
	unsigned int sec = second % 60;
	sprintf(buf, "%u hou %u min %u sec", hou, min, sec);
	return buf;	
}

inline std::string byteCount2Str(int64_t count)
{
	char buf[128];
	
	if(count < 1024)
	{
		sprintf(buf, "%d B", (int)count);
		return buf;
	}
	
	if(count>=1024 && count<1024*1024)
	{
		float fcount = ((float)count)/1024.0f;
		sprintf(buf, "%01.2f KB", fcount);
		return buf;
	}
	
	if(count>=1024*1024 && count<1024*1024*1024)
	{
		float fcount = ((float)count)/(1024.0f*1024.0f);
		sprintf(buf, "%01.2f MB", fcount);
		return buf;		
	}
	
	float fcount = ((float)count)/(1024.0f*1024.0f*1024.0f);
	sprintf(buf, "%01.2f GB", fcount);
	return buf;		
}

inline int64_t htonll(int64_t number)
{
	if(htons(1) == 1)
	{
		return number;
	}
	
	return ( htonl( (number >> 32) & 0xFFFFFFFF) |
		 ((int64_t) (htonl(number & 0xFFFFFFFF))  << 32));
}

inline int64_t ntohll(int64_t number)
{
	if(htons(1) == 1)
	{
		return number;
	}
		
 	return ( htonl( (number >> 32) & 0xFFFFFFFF) |
		((int64_t) (htonl(number & 0xFFFFFFFF))  << 32));
}

inline std::string getPeerStr(const char* ip, unsigned short port)
{
	char buf[128];
	sprintf(buf, "%s:%u", ip, port);
	return buf;
}

inline char* convert_to_utf8(const char *input_text, const char *input_enc)
{
	if (input_text == NULL)
		return NULL;
	
	if (input_text[0] == 0)
		return g_strdup(input_text);
	  
	size_t len = strlen(input_text);
	if (!g_utf8_validate(input_text, len, NULL)) {
		gsize b_in, b_out;
		if (input_enc != NULL && *input_enc != 0 && 
				strcasecmp(input_enc, "UTF-8") != 0)
			return g_convert(input_text, len, "UTF-8", input_enc, &b_in, &b_out, NULL);
		else {
			const char *cs;
			if (g_get_charset(&cs) || strcmp(cs, "ANSI_X3.4-1968") == 0) 
				// locale is either already utf8 or ASCII so conversion won't help 
				// - we use fallback character set - iso8859-1
				return g_convert(input_text, len, "UTF-8", "ISO8859-1", &b_in, &b_out, NULL);
			else
				return g_convert(input_text, len, "UTF-8", cs, &b_in, &b_out, NULL);
		}
	}
	return g_strdup(input_text);
}

inline char* convert_from_utf8(const char *input_text, const char *output_enc)
{
	if (input_text == NULL)
		return NULL;
	
	if (input_text[0] == 0)
		return g_strdup(input_text);
	  
	size_t len = strlen(input_text);

	gsize b_in, b_out;
	if (output_enc != NULL && *output_enc != 0 && 
			strcasecmp(output_enc, "UTF-8") != 0)
		return g_convert(input_text, len, output_enc, "UTF-8", &b_in, &b_out, NULL);
	else {
		const char *cs;
		if (g_get_charset(&cs)) 
			// locale is already utf8 so conversion won't help - we use 
			// fallback character set - iso8859-1
			return g_convert(input_text, len,  "ISO8859-1", "UTF-8", &b_in, &b_out, NULL);
		else
			return g_convert(input_text, len, cs, "UTF-8", &b_in, &b_out, NULL);
	}
	return g_strdup(input_text);
}

inline std::string str_to_utf8(const char *input_text, const char *input_enc)
{
	if (input_text == NULL || input_text[0] == '\0')
		return std::string("");
	char *p = convert_to_utf8(input_text, input_enc);
	std::string ret("");
	if (p != NULL) {
		ret = p;
		g_free(p);
	}
	return ret;
}

inline std::string filename_from_utf8(const char *input_text)
{
	gsize bytes_read;
	gsize bytes_written;
	
	gchar* ret = g_filename_from_utf8(input_text, -1, &bytes_read, &bytes_written, NULL);
	std::string result = ret;
	g_free(ret);
	
	return result;
}

inline std::string locale_to_utf8(const char *input_text)
{
	gsize bytes_read;
	gsize bytes_written;
	
	gchar* ret = g_locale_to_utf8(input_text, -1, &bytes_read, &bytes_written, NULL);
	std::string result = ret;
	g_free(ret);
	
	return result;	
}


#endif
