// CHECKSTYLE:OFF
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

// This file was generated automatically by the Snowball to Java compiler

package opennlp.tools.stemmer.snowball;


 /**
  * This class was automatically generated by a Snowball to Java compiler
  * It implements the stemming algorithm defined by a snowball script.
  */
class turkishStemmer extends opennlp.tools.stemmer.snowball.AbstractSnowballStemmer {

        private final static turkishStemmer methodObject = new turkishStemmer ();

                private final static Among a_0[] = {
                    new Among ( "m", -1, -1, "", methodObject ),
                    new Among ( "n", -1, -1, "", methodObject ),
                    new Among ( "miz", -1, -1, "", methodObject ),
                    new Among ( "niz", -1, -1, "", methodObject ),
                    new Among ( "muz", -1, -1, "", methodObject ),
                    new Among ( "nuz", -1, -1, "", methodObject ),
                    new Among ( "m\u00FCz", -1, -1, "", methodObject ),
                    new Among ( "n\u00FCz", -1, -1, "", methodObject ),
                    new Among ( "m\u0131z", -1, -1, "", methodObject ),
                    new Among ( "n\u0131z", -1, -1, "", methodObject )
                };

                private final static Among a_1[] = {
                    new Among ( "leri", -1, -1, "", methodObject ),
                    new Among ( "lar\u0131", -1, -1, "", methodObject )
                };

                private final static Among a_2[] = {
                    new Among ( "ni", -1, -1, "", methodObject ),
                    new Among ( "nu", -1, -1, "", methodObject ),
                    new Among ( "n\u00FC", -1, -1, "", methodObject ),
                    new Among ( "n\u0131", -1, -1, "", methodObject )
                };

                private final static Among a_3[] = {
                    new Among ( "in", -1, -1, "", methodObject ),
                    new Among ( "un", -1, -1, "", methodObject ),
                    new Among ( "\u00FCn", -1, -1, "", methodObject ),
                    new Among ( "\u0131n", -1, -1, "", methodObject )
                };

                private final static Among a_4[] = {
                    new Among ( "a", -1, -1, "", methodObject ),
                    new Among ( "e", -1, -1, "", methodObject )
                };

                private final static Among a_5[] = {
                    new Among ( "na", -1, -1, "", methodObject ),
                    new Among ( "ne", -1, -1, "", methodObject )
                };

                private final static Among a_6[] = {
                    new Among ( "da", -1, -1, "", methodObject ),
                    new Among ( "ta", -1, -1, "", methodObject ),
                    new Among ( "de", -1, -1, "", methodObject ),
                    new Among ( "te", -1, -1, "", methodObject )
                };

                private final static Among a_7[] = {
                    new Among ( "nda", -1, -1, "", methodObject ),
                    new Among ( "nde", -1, -1, "", methodObject )
                };

                private final static Among a_8[] = {
                    new Among ( "dan", -1, -1, "", methodObject ),
                    new Among ( "tan", -1, -1, "", methodObject ),
                    new Among ( "den", -1, -1, "", methodObject ),
                    new Among ( "ten", -1, -1, "", methodObject )
                };

                private final static Among a_9[] = {
                    new Among ( "ndan", -1, -1, "", methodObject ),
                    new Among ( "nden", -1, -1, "", methodObject )
                };

                private final static Among a_10[] = {
                    new Among ( "la", -1, -1, "", methodObject ),
                    new Among ( "le", -1, -1, "", methodObject )
                };

                private final static Among a_11[] = {
                    new Among ( "ca", -1, -1, "", methodObject ),
                    new Among ( "ce", -1, -1, "", methodObject )
                };

                private final static Among a_12[] = {
                    new Among ( "im", -1, -1, "", methodObject ),
                    new Among ( "um", -1, -1, "", methodObject ),
                    new Among ( "\u00FCm", -1, -1, "", methodObject ),
                    new Among ( "\u0131m", -1, -1, "", methodObject )
                };

                private final static Among a_13[] = {
                    new Among ( "sin", -1, -1, "", methodObject ),
                    new Among ( "sun", -1, -1, "", methodObject ),
                    new Among ( "s\u00FCn", -1, -1, "", methodObject ),
                    new Among ( "s\u0131n", -1, -1, "", methodObject )
                };

                private final static Among a_14[] = {
                    new Among ( "iz", -1, -1, "", methodObject ),
                    new Among ( "uz", -1, -1, "", methodObject ),
                    new Among ( "\u00FCz", -1, -1, "", methodObject ),
                    new Among ( "\u0131z", -1, -1, "", methodObject )
                };

                private final static Among a_15[] = {
                    new Among ( "siniz", -1, -1, "", methodObject ),
                    new Among ( "sunuz", -1, -1, "", methodObject ),
                    new Among ( "s\u00FCn\u00FCz", -1, -1, "", methodObject ),
                    new Among ( "s\u0131n\u0131z", -1, -1, "", methodObject )
                };

                private final static Among a_16[] = {
                    new Among ( "lar", -1, -1, "", methodObject ),
                    new Among ( "ler", -1, -1, "", methodObject )
                };

                private final static Among a_17[] = {
                    new Among ( "niz", -1, -1, "", methodObject ),
                    new Among ( "nuz", -1, -1, "", methodObject ),
                    new Among ( "n\u00FCz", -1, -1, "", methodObject ),
                    new Among ( "n\u0131z", -1, -1, "", methodObject )
                };

                private final static Among a_18[] = {
                    new Among ( "dir", -1, -1, "", methodObject ),
                    new Among ( "tir", -1, -1, "", methodObject ),
                    new Among ( "dur", -1, -1, "", methodObject ),
                    new Among ( "tur", -1, -1, "", methodObject ),
                    new Among ( "d\u00FCr", -1, -1, "", methodObject ),
                    new Among ( "t\u00FCr", -1, -1, "", methodObject ),
                    new Among ( "d\u0131r", -1, -1, "", methodObject ),
                    new Among ( "t\u0131r", -1, -1, "", methodObject )
                };

                private final static Among a_19[] = {
                    new Among ( "cas\u0131na", -1, -1, "", methodObject ),
                    new Among ( "cesine", -1, -1, "", methodObject )
                };

                private final static Among a_20[] = {
                    new Among ( "di", -1, -1, "", methodObject ),
                    new Among ( "ti", -1, -1, "", methodObject ),
                    new Among ( "dik", -1, -1, "", methodObject ),
                    new Among ( "tik", -1, -1, "", methodObject ),
                    new Among ( "duk", -1, -1, "", methodObject ),
                    new Among ( "tuk", -1, -1, "", methodObject ),
                    new Among ( "d\u00FCk", -1, -1, "", methodObject ),
                    new Among ( "t\u00FCk", -1, -1, "", methodObject ),
                    new Among ( "d\u0131k", -1, -1, "", methodObject ),
                    new Among ( "t\u0131k", -1, -1, "", methodObject ),
                    new Among ( "dim", -1, -1, "", methodObject ),
                    new Among ( "tim", -1, -1, "", methodObject ),
                    new Among ( "dum", -1, -1, "", methodObject ),
                    new Among ( "tum", -1, -1, "", methodObject ),
                    new Among ( "d\u00FCm", -1, -1, "", methodObject ),
                    new Among ( "t\u00FCm", -1, -1, "", methodObject ),
                    new Among ( "d\u0131m", -1, -1, "", methodObject ),
                    new Among ( "t\u0131m", -1, -1, "", methodObject ),
                    new Among ( "din", -1, -1, "", methodObject ),
                    new Among ( "tin", -1, -1, "", methodObject ),
                    new Among ( "dun", -1, -1, "", methodObject ),
                    new Among ( "tun", -1, -1, "", methodObject ),
                    new Among ( "d\u00FCn", -1, -1, "", methodObject ),
                    new Among ( "t\u00FCn", -1, -1, "", methodObject ),
                    new Among ( "d\u0131n", -1, -1, "", methodObject ),
                    new Among ( "t\u0131n", -1, -1, "", methodObject ),
                    new Among ( "du", -1, -1, "", methodObject ),
                    new Among ( "tu", -1, -1, "", methodObject ),
                    new Among ( "d\u00FC", -1, -1, "", methodObject ),
                    new Among ( "t\u00FC", -1, -1, "", methodObject ),
                    new Among ( "d\u0131", -1, -1, "", methodObject ),
                    new Among ( "t\u0131", -1, -1, "", methodObject )
                };

                private final static Among a_21[] = {
                    new Among ( "sa", -1, -1, "", methodObject ),
                    new Among ( "se", -1, -1, "", methodObject ),
                    new Among ( "sak", -1, -1, "", methodObject ),
                    new Among ( "sek", -1, -1, "", methodObject ),
                    new Among ( "sam", -1, -1, "", methodObject ),
                    new Among ( "sem", -1, -1, "", methodObject ),
                    new Among ( "san", -1, -1, "", methodObject ),
                    new Among ( "sen", -1, -1, "", methodObject )
                };

                private final static Among a_22[] = {
                    new Among ( "mi\u015F", -1, -1, "", methodObject ),
                    new Among ( "mu\u015F", -1, -1, "", methodObject ),
                    new Among ( "m\u00FC\u015F", -1, -1, "", methodObject ),
                    new Among ( "m\u0131\u015F", -1, -1, "", methodObject )
                };

                private final static Among a_23[] = {
                    new Among ( "b", -1, 1, "", methodObject ),
                    new Among ( "c", -1, 2, "", methodObject ),
                    new Among ( "d", -1, 3, "", methodObject ),
                    new Among ( "\u011F", -1, 4, "", methodObject )
                };

                private static final char g_vowel[] = {17, 65, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 8, 0, 0, 0, 0, 0, 0, 1 };

                private static final char g_U[] = {1, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 1 };

                private static final char g_vowel1[] = {1, 64, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 };

                private static final char g_vowel2[] = {17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130 };

                private static final char g_vowel3[] = {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 };

                private static final char g_vowel4[] = {17 };

                private static final char g_vowel5[] = {65 };

                private static final char g_vowel6[] = {65 };

        private boolean B_continue_stemming_noun_suffixes;
        private int I_strlen;

                private void copy_from(turkishStemmer other) {
                    B_continue_stemming_noun_suffixes = other.B_continue_stemming_noun_suffixes;
                    I_strlen = other.I_strlen;
                    super.copy_from(other);
                }

                private boolean r_check_vowel_harmony() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
                    // (, line 111
                    // test, line 112
                    v_1 = limit - cursor;
                    // (, line 113
                    // (, line 114
                    // goto, line 114
                    golab0: while(true)
                    {
                        v_2 = limit - cursor;
                        lab1: do {
                            if (!(in_grouping_b(g_vowel, 97, 305)))
                            {
                                break lab1;
                            }
                            cursor = limit - v_2;
                            break golab0;
                        } while (false);
                        cursor = limit - v_2;
                        if (cursor <= limit_backward)
                        {
                            return false;
                        }
                        cursor--;
                    }
                    // (, line 115
                    // or, line 116
                    lab2: do {
                        v_3 = limit - cursor;
                        lab3: do {
                            // (, line 116
                            // literal, line 116
                            if (!(eq_s_b(1, "a")))
                            {
                                break lab3;
                            }
                            // goto, line 116
                            golab4: while(true)
                            {
                                v_4 = limit - cursor;
                                lab5: do {
                                    if (!(in_grouping_b(g_vowel1, 97, 305)))
                                    {
                                        break lab5;
                                    }
                                    cursor = limit - v_4;
                                    break golab4;
                                } while (false);
                                cursor = limit - v_4;
                                if (cursor <= limit_backward)
                                {
                                    break lab3;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab6: do {
                            // (, line 117
                            // literal, line 117
                            if (!(eq_s_b(1, "e")))
                            {
                                break lab6;
                            }
                            // goto, line 117
                            golab7: while(true)
                            {
                                v_5 = limit - cursor;
                                lab8: do {
                                    if (!(in_grouping_b(g_vowel2, 101, 252)))
                                    {
                                        break lab8;
                                    }
                                    cursor = limit - v_5;
                                    break golab7;
                                } while (false);
                                cursor = limit - v_5;
                                if (cursor <= limit_backward)
                                {
                                    break lab6;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab9: do {
                            // (, line 118
                            // literal, line 118
                            if (!(eq_s_b(1, "\u0131")))
                            {
                                break lab9;
                            }
                            // goto, line 118
                            golab10: while(true)
                            {
                                v_6 = limit - cursor;
                                lab11: do {
                                    if (!(in_grouping_b(g_vowel3, 97, 305)))
                                    {
                                        break lab11;
                                    }
                                    cursor = limit - v_6;
                                    break golab10;
                                } while (false);
                                cursor = limit - v_6;
                                if (cursor <= limit_backward)
                                {
                                    break lab9;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab12: do {
                            // (, line 119
                            // literal, line 119
                            if (!(eq_s_b(1, "i")))
                            {
                                break lab12;
                            }
                            // goto, line 119
                            golab13: while(true)
                            {
                                v_7 = limit - cursor;
                                lab14: do {
                                    if (!(in_grouping_b(g_vowel4, 101, 105)))
                                    {
                                        break lab14;
                                    }
                                    cursor = limit - v_7;
                                    break golab13;
                                } while (false);
                                cursor = limit - v_7;
                                if (cursor <= limit_backward)
                                {
                                    break lab12;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab15: do {
                            // (, line 120
                            // literal, line 120
                            if (!(eq_s_b(1, "o")))
                            {
                                break lab15;
                            }
                            // goto, line 120
                            golab16: while(true)
                            {
                                v_8 = limit - cursor;
                                lab17: do {
                                    if (!(in_grouping_b(g_vowel5, 111, 117)))
                                    {
                                        break lab17;
                                    }
                                    cursor = limit - v_8;
                                    break golab16;
                                } while (false);
                                cursor = limit - v_8;
                                if (cursor <= limit_backward)
                                {
                                    break lab15;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab18: do {
                            // (, line 121
                            // literal, line 121
                            if (!(eq_s_b(1, "\u00F6")))
                            {
                                break lab18;
                            }
                            // goto, line 121
                            golab19: while(true)
                            {
                                v_9 = limit - cursor;
                                lab20: do {
                                    if (!(in_grouping_b(g_vowel6, 246, 252)))
                                    {
                                        break lab20;
                                    }
                                    cursor = limit - v_9;
                                    break golab19;
                                } while (false);
                                cursor = limit - v_9;
                                if (cursor <= limit_backward)
                                {
                                    break lab18;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab21: do {
                            // (, line 122
                            // literal, line 122
                            if (!(eq_s_b(1, "u")))
                            {
                                break lab21;
                            }
                            // goto, line 122
                            golab22: while(true)
                            {
                                v_10 = limit - cursor;
                                lab23: do {
                                    if (!(in_grouping_b(g_vowel5, 111, 117)))
                                    {
                                        break lab23;
                                    }
                                    cursor = limit - v_10;
                                    break golab22;
                                } while (false);
                                cursor = limit - v_10;
                                if (cursor <= limit_backward)
                                {
                                    break lab21;
                                }
                                cursor--;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        // (, line 123
                        // literal, line 123
                        if (!(eq_s_b(1, "\u00FC")))
                        {
                            return false;
                        }
                        // goto, line 123
                        golab24: while(true)
                        {
                            v_11 = limit - cursor;
                            lab25: do {
                                if (!(in_grouping_b(g_vowel6, 246, 252)))
                                {
                                    break lab25;
                                }
                                cursor = limit - v_11;
                                break golab24;
                            } while (false);
                            cursor = limit - v_11;
                            if (cursor <= limit_backward)
                            {
                                return false;
                            }
                            cursor--;
                        }
                    } while (false);
                    cursor = limit - v_1;
                    return true;
                }

                private boolean r_mark_suffix_with_optional_n_consonant() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
                    // (, line 132
                    // or, line 134
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 133
                            // (, line 133
                            // test, line 133
                            v_2 = limit - cursor;
                            // literal, line 133
                            if (!(eq_s_b(1, "n")))
                            {
                                break lab1;
                            }
                            cursor = limit - v_2;
                            // next, line 133
                            if (cursor <= limit_backward)
                            {
                                break lab1;
                            }
                            cursor--;
                            // (, line 133
                            // test, line 133
                            v_3 = limit - cursor;
                            if (!(in_grouping_b(g_vowel, 97, 305)))
                            {
                                break lab1;
                            }
                            cursor = limit - v_3;
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 135
                        // (, line 135
                        // not, line 135
                        {
                            v_4 = limit - cursor;
                            lab2: do {
                                // (, line 135
                                // test, line 135
                                v_5 = limit - cursor;
                                // literal, line 135
                                if (!(eq_s_b(1, "n")))
                                {
                                    break lab2;
                                }
                                cursor = limit - v_5;
                                return false;
                            } while (false);
                            cursor = limit - v_4;
                        }
                        // test, line 135
                        v_6 = limit - cursor;
                        // (, line 135
                        // next, line 135
                        if (cursor <= limit_backward)
                        {
                            return false;
                        }
                        cursor--;
                        // (, line 135
                        // test, line 135
                        v_7 = limit - cursor;
                        if (!(in_grouping_b(g_vowel, 97, 305)))
                        {
                            return false;
                        }
                        cursor = limit - v_7;
                        cursor = limit - v_6;
                    } while (false);
                    return true;
                }

                private boolean r_mark_suffix_with_optional_s_consonant() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
                    // (, line 143
                    // or, line 145
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 144
                            // (, line 144
                            // test, line 144
                            v_2 = limit - cursor;
                            // literal, line 144
                            if (!(eq_s_b(1, "s")))
                            {
                                break lab1;
                            }
                            cursor = limit - v_2;
                            // next, line 144
                            if (cursor <= limit_backward)
                            {
                                break lab1;
                            }
                            cursor--;
                            // (, line 144
                            // test, line 144
                            v_3 = limit - cursor;
                            if (!(in_grouping_b(g_vowel, 97, 305)))
                            {
                                break lab1;
                            }
                            cursor = limit - v_3;
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 146
                        // (, line 146
                        // not, line 146
                        {
                            v_4 = limit - cursor;
                            lab2: do {
                                // (, line 146
                                // test, line 146
                                v_5 = limit - cursor;
                                // literal, line 146
                                if (!(eq_s_b(1, "s")))
                                {
                                    break lab2;
                                }
                                cursor = limit - v_5;
                                return false;
                            } while (false);
                            cursor = limit - v_4;
                        }
                        // test, line 146
                        v_6 = limit - cursor;
                        // (, line 146
                        // next, line 146
                        if (cursor <= limit_backward)
                        {
                            return false;
                        }
                        cursor--;
                        // (, line 146
                        // test, line 146
                        v_7 = limit - cursor;
                        if (!(in_grouping_b(g_vowel, 97, 305)))
                        {
                            return false;
                        }
                        cursor = limit - v_7;
                        cursor = limit - v_6;
                    } while (false);
                    return true;
                }

                private boolean r_mark_suffix_with_optional_y_consonant() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
                    // (, line 153
                    // or, line 155
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 154
                            // (, line 154
                            // test, line 154
                            v_2 = limit - cursor;
                            // literal, line 154
                            if (!(eq_s_b(1, "y")))
                            {
                                break lab1;
                            }
                            cursor = limit - v_2;
                            // next, line 154
                            if (cursor <= limit_backward)
                            {
                                break lab1;
                            }
                            cursor--;
                            // (, line 154
                            // test, line 154
                            v_3 = limit - cursor;
                            if (!(in_grouping_b(g_vowel, 97, 305)))
                            {
                                break lab1;
                            }
                            cursor = limit - v_3;
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 156
                        // (, line 156
                        // not, line 156
                        {
                            v_4 = limit - cursor;
                            lab2: do {
                                // (, line 156
                                // test, line 156
                                v_5 = limit - cursor;
                                // literal, line 156
                                if (!(eq_s_b(1, "y")))
                                {
                                    break lab2;
                                }
                                cursor = limit - v_5;
                                return false;
                            } while (false);
                            cursor = limit - v_4;
                        }
                        // test, line 156
                        v_6 = limit - cursor;
                        // (, line 156
                        // next, line 156
                        if (cursor <= limit_backward)
                        {
                            return false;
                        }
                        cursor--;
                        // (, line 156
                        // test, line 156
                        v_7 = limit - cursor;
                        if (!(in_grouping_b(g_vowel, 97, 305)))
                        {
                            return false;
                        }
                        cursor = limit - v_7;
                        cursor = limit - v_6;
                    } while (false);
                    return true;
                }

                private boolean r_mark_suffix_with_optional_U_vowel() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
                    // (, line 159
                    // or, line 161
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 160
                            // (, line 160
                            // test, line 160
                            v_2 = limit - cursor;
                            if (!(in_grouping_b(g_U, 105, 305)))
                            {
                                break lab1;
                            }
                            cursor = limit - v_2;
                            // next, line 160
                            if (cursor <= limit_backward)
                            {
                                break lab1;
                            }
                            cursor--;
                            // (, line 160
                            // test, line 160
                            v_3 = limit - cursor;
                            if (!(out_grouping_b(g_vowel, 97, 305)))
                            {
                                break lab1;
                            }
                            cursor = limit - v_3;
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 162
                        // (, line 162
                        // not, line 162
                        {
                            v_4 = limit - cursor;
                            lab2: do {
                                // (, line 162
                                // test, line 162
                                v_5 = limit - cursor;
                                if (!(in_grouping_b(g_U, 105, 305)))
                                {
                                    break lab2;
                                }
                                cursor = limit - v_5;
                                return false;
                            } while (false);
                            cursor = limit - v_4;
                        }
                        // test, line 162
                        v_6 = limit - cursor;
                        // (, line 162
                        // next, line 162
                        if (cursor <= limit_backward)
                        {
                            return false;
                        }
                        cursor--;
                        // (, line 162
                        // test, line 162
                        v_7 = limit - cursor;
                        if (!(out_grouping_b(g_vowel, 97, 305)))
                        {
                            return false;
                        }
                        cursor = limit - v_7;
                        cursor = limit - v_6;
                    } while (false);
                    return true;
                }

                private boolean r_mark_possessives() {
                    // (, line 166
                    // among, line 167
                    if (find_among_b(a_0, 10) == 0)
                    {
                        return false;
                    }
                    // (, line 169
                    // call mark_suffix_with_optional_U_vowel, line 169
                    if (!r_mark_suffix_with_optional_U_vowel())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_sU() {
                    // (, line 172
                    // call check_vowel_harmony, line 173
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    if (!(in_grouping_b(g_U, 105, 305)))
                    {
                        return false;
                    }
                    // (, line 175
                    // call mark_suffix_with_optional_s_consonant, line 175
                    if (!r_mark_suffix_with_optional_s_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_lArI() {
                    // (, line 178
                    // among, line 179
                    if (find_among_b(a_1, 2) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_yU() {
                    // (, line 182
                    // call check_vowel_harmony, line 183
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    if (!(in_grouping_b(g_U, 105, 305)))
                    {
                        return false;
                    }
                    // (, line 185
                    // call mark_suffix_with_optional_y_consonant, line 185
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_nU() {
                    // (, line 188
                    // call check_vowel_harmony, line 189
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 190
                    if (find_among_b(a_2, 4) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_nUn() {
                    // (, line 193
                    // call check_vowel_harmony, line 194
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 195
                    if (find_among_b(a_3, 4) == 0)
                    {
                        return false;
                    }
                    // (, line 196
                    // call mark_suffix_with_optional_n_consonant, line 196
                    if (!r_mark_suffix_with_optional_n_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_yA() {
                    // (, line 199
                    // call check_vowel_harmony, line 200
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 201
                    if (find_among_b(a_4, 2) == 0)
                    {
                        return false;
                    }
                    // (, line 202
                    // call mark_suffix_with_optional_y_consonant, line 202
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_nA() {
                    // (, line 205
                    // call check_vowel_harmony, line 206
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 207
                    if (find_among_b(a_5, 2) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_DA() {
                    // (, line 210
                    // call check_vowel_harmony, line 211
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 212
                    if (find_among_b(a_6, 4) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ndA() {
                    // (, line 215
                    // call check_vowel_harmony, line 216
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 217
                    if (find_among_b(a_7, 2) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_DAn() {
                    // (, line 220
                    // call check_vowel_harmony, line 221
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 222
                    if (find_among_b(a_8, 4) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ndAn() {
                    // (, line 225
                    // call check_vowel_harmony, line 226
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 227
                    if (find_among_b(a_9, 2) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ylA() {
                    // (, line 230
                    // call check_vowel_harmony, line 231
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 232
                    if (find_among_b(a_10, 2) == 0)
                    {
                        return false;
                    }
                    // (, line 233
                    // call mark_suffix_with_optional_y_consonant, line 233
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ki() {
                    // (, line 236
                    // literal, line 237
                    if (!(eq_s_b(2, "ki")))
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ncA() {
                    // (, line 240
                    // call check_vowel_harmony, line 241
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 242
                    if (find_among_b(a_11, 2) == 0)
                    {
                        return false;
                    }
                    // (, line 243
                    // call mark_suffix_with_optional_n_consonant, line 243
                    if (!r_mark_suffix_with_optional_n_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_yUm() {
                    // (, line 246
                    // call check_vowel_harmony, line 247
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 248
                    if (find_among_b(a_12, 4) == 0)
                    {
                        return false;
                    }
                    // (, line 249
                    // call mark_suffix_with_optional_y_consonant, line 249
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_sUn() {
                    // (, line 252
                    // call check_vowel_harmony, line 253
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 254
                    if (find_among_b(a_13, 4) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_yUz() {
                    // (, line 257
                    // call check_vowel_harmony, line 258
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 259
                    if (find_among_b(a_14, 4) == 0)
                    {
                        return false;
                    }
                    // (, line 260
                    // call mark_suffix_with_optional_y_consonant, line 260
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_sUnUz() {
                    // (, line 263
                    // among, line 264
                    if (find_among_b(a_15, 4) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_lAr() {
                    // (, line 267
                    // call check_vowel_harmony, line 268
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 269
                    if (find_among_b(a_16, 2) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_nUz() {
                    // (, line 272
                    // call check_vowel_harmony, line 273
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 274
                    if (find_among_b(a_17, 4) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_DUr() {
                    // (, line 277
                    // call check_vowel_harmony, line 278
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 279
                    if (find_among_b(a_18, 8) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_cAsInA() {
                    // (, line 282
                    // among, line 283
                    if (find_among_b(a_19, 2) == 0)
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_yDU() {
                    // (, line 286
                    // call check_vowel_harmony, line 287
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 288
                    if (find_among_b(a_20, 32) == 0)
                    {
                        return false;
                    }
                    // (, line 292
                    // call mark_suffix_with_optional_y_consonant, line 292
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ysA() {
                    // (, line 296
                    // among, line 297
                    if (find_among_b(a_21, 8) == 0)
                    {
                        return false;
                    }
                    // (, line 298
                    // call mark_suffix_with_optional_y_consonant, line 298
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_ymUs_() {
                    // (, line 301
                    // call check_vowel_harmony, line 302
                    if (!r_check_vowel_harmony())
                    {
                        return false;
                    }
                    // among, line 303
                    if (find_among_b(a_22, 4) == 0)
                    {
                        return false;
                    }
                    // (, line 304
                    // call mark_suffix_with_optional_y_consonant, line 304
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_mark_yken() {
                    // (, line 307
                    // literal, line 308
                    if (!(eq_s_b(3, "ken")))
                    {
                        return false;
                    }
                    // (, line 308
                    // call mark_suffix_with_optional_y_consonant, line 308
                    if (!r_mark_suffix_with_optional_y_consonant())
                    {
                        return false;
                    }
                    return true;
                }

                private boolean r_stem_nominal_verb_suffixes() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
                    // (, line 311
                    // [, line 312
                    ket = cursor;
                    // set continue_stemming_noun_suffixes, line 313
                    B_continue_stemming_noun_suffixes = true;
                    // or, line 315
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 314
                            // or, line 314
                            lab2: do {
                                v_2 = limit - cursor;
                                lab3: do {
                                    // call mark_ymUs_, line 314
                                    if (!r_mark_ymUs_())
                                    {
                                        break lab3;
                                    }
                                    break lab2;
                                } while (false);
                                cursor = limit - v_2;
                                lab4: do {
                                    // call mark_yDU, line 314
                                    if (!r_mark_yDU())
                                    {
                                        break lab4;
                                    }
                                    break lab2;
                                } while (false);
                                cursor = limit - v_2;
                                lab5: do {
                                    // call mark_ysA, line 314
                                    if (!r_mark_ysA())
                                    {
                                        break lab5;
                                    }
                                    break lab2;
                                } while (false);
                                cursor = limit - v_2;
                                // call mark_yken, line 314
                                if (!r_mark_yken())
                                {
                                    break lab1;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab6: do {
                            // (, line 316
                            // call mark_cAsInA, line 316
                            if (!r_mark_cAsInA())
                            {
                                break lab6;
                            }
                            // (, line 316
                            // or, line 316
                            lab7: do {
                                v_3 = limit - cursor;
                                lab8: do {
                                    // call mark_sUnUz, line 316
                                    if (!r_mark_sUnUz())
                                    {
                                        break lab8;
                                    }
                                    break lab7;
                                } while (false);
                                cursor = limit - v_3;
                                lab9: do {
                                    // call mark_lAr, line 316
                                    if (!r_mark_lAr())
                                    {
                                        break lab9;
                                    }
                                    break lab7;
                                } while (false);
                                cursor = limit - v_3;
                                lab10: do {
                                    // call mark_yUm, line 316
                                    if (!r_mark_yUm())
                                    {
                                        break lab10;
                                    }
                                    break lab7;
                                } while (false);
                                cursor = limit - v_3;
                                lab11: do {
                                    // call mark_sUn, line 316
                                    if (!r_mark_sUn())
                                    {
                                        break lab11;
                                    }
                                    break lab7;
                                } while (false);
                                cursor = limit - v_3;
                                lab12: do {
                                    // call mark_yUz, line 316
                                    if (!r_mark_yUz())
                                    {
                                        break lab12;
                                    }
                                    break lab7;
                                } while (false);
                                cursor = limit - v_3;
                            } while (false);
                            // call mark_ymUs_, line 316
                            if (!r_mark_ymUs_())
                            {
                                break lab6;
                            }
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab13: do {
                            // (, line 318
                            // call mark_lAr, line 319
                            if (!r_mark_lAr())
                            {
                                break lab13;
                            }
                            // ], line 319
                            bra = cursor;
                            // delete, line 319
                            slice_del();
                            // try, line 319
                            v_4 = limit - cursor;
                            lab14: do {
                                // (, line 319
                                // [, line 319
                                ket = cursor;
                                // (, line 319
                                // or, line 319
                                lab15: do {
                                    v_5 = limit - cursor;
                                    lab16: do {
                                        // call mark_DUr, line 319
                                        if (!r_mark_DUr())
                                        {
                                            break lab16;
                                        }
                                        break lab15;
                                    } while (false);
                                    cursor = limit - v_5;
                                    lab17: do {
                                        // call mark_yDU, line 319
                                        if (!r_mark_yDU())
                                        {
                                            break lab17;
                                        }
                                        break lab15;
                                    } while (false);
                                    cursor = limit - v_5;
                                    lab18: do {
                                        // call mark_ysA, line 319
                                        if (!r_mark_ysA())
                                        {
                                            break lab18;
                                        }
                                        break lab15;
                                    } while (false);
                                    cursor = limit - v_5;
                                    // call mark_ymUs_, line 319
                                    if (!r_mark_ymUs_())
                                    {
                                        cursor = limit - v_4;
                                        break lab14;
                                    }
                                } while (false);
                            } while (false);
                            // unset continue_stemming_noun_suffixes, line 320
                            B_continue_stemming_noun_suffixes = false;
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab19: do {
                            // (, line 323
                            // call mark_nUz, line 323
                            if (!r_mark_nUz())
                            {
                                break lab19;
                            }
                            // (, line 323
                            // or, line 323
                            lab20: do {
                                v_6 = limit - cursor;
                                lab21: do {
                                    // call mark_yDU, line 323
                                    if (!r_mark_yDU())
                                    {
                                        break lab21;
                                    }
                                    break lab20;
                                } while (false);
                                cursor = limit - v_6;
                                // call mark_ysA, line 323
                                if (!r_mark_ysA())
                                {
                                    break lab19;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab22: do {
                            // (, line 325
                            // (, line 325
                            // or, line 325
                            lab23: do {
                                v_7 = limit - cursor;
                                lab24: do {
                                    // call mark_sUnUz, line 325
                                    if (!r_mark_sUnUz())
                                    {
                                        break lab24;
                                    }
                                    break lab23;
                                } while (false);
                                cursor = limit - v_7;
                                lab25: do {
                                    // call mark_yUz, line 325
                                    if (!r_mark_yUz())
                                    {
                                        break lab25;
                                    }
                                    break lab23;
                                } while (false);
                                cursor = limit - v_7;
                                lab26: do {
                                    // call mark_sUn, line 325
                                    if (!r_mark_sUn())
                                    {
                                        break lab26;
                                    }
                                    break lab23;
                                } while (false);
                                cursor = limit - v_7;
                                // call mark_yUm, line 325
                                if (!r_mark_yUm())
                                {
                                    break lab22;
                                }
                            } while (false);
                            // ], line 325
                            bra = cursor;
                            // delete, line 325
                            slice_del();
                            // try, line 325
                            v_8 = limit - cursor;
                            lab27: do {
                                // (, line 325
                                // [, line 325
                                ket = cursor;
                                // call mark_ymUs_, line 325
                                if (!r_mark_ymUs_())
                                {
                                    cursor = limit - v_8;
                                    break lab27;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 327
                        // call mark_DUr, line 327
                        if (!r_mark_DUr())
                        {
                            return false;
                        }
                        // ], line 327
                        bra = cursor;
                        // delete, line 327
                        slice_del();
                        // try, line 327
                        v_9 = limit - cursor;
                        lab28: do {
                            // (, line 327
                            // [, line 327
                            ket = cursor;
                            // (, line 327
                            // or, line 327
                            lab29: do {
                                v_10 = limit - cursor;
                                lab30: do {
                                    // call mark_sUnUz, line 327
                                    if (!r_mark_sUnUz())
                                    {
                                        break lab30;
                                    }
                                    break lab29;
                                } while (false);
                                cursor = limit - v_10;
                                lab31: do {
                                    // call mark_lAr, line 327
                                    if (!r_mark_lAr())
                                    {
                                        break lab31;
                                    }
                                    break lab29;
                                } while (false);
                                cursor = limit - v_10;
                                lab32: do {
                                    // call mark_yUm, line 327
                                    if (!r_mark_yUm())
                                    {
                                        break lab32;
                                    }
                                    break lab29;
                                } while (false);
                                cursor = limit - v_10;
                                lab33: do {
                                    // call mark_sUn, line 327
                                    if (!r_mark_sUn())
                                    {
                                        break lab33;
                                    }
                                    break lab29;
                                } while (false);
                                cursor = limit - v_10;
                                lab34: do {
                                    // call mark_yUz, line 327
                                    if (!r_mark_yUz())
                                    {
                                        break lab34;
                                    }
                                    break lab29;
                                } while (false);
                                cursor = limit - v_10;
                            } while (false);
                            // call mark_ymUs_, line 327
                            if (!r_mark_ymUs_())
                            {
                                cursor = limit - v_9;
                                break lab28;
                            }
                        } while (false);
                    } while (false);
                    // ], line 328
                    bra = cursor;
                    // delete, line 328
                    slice_del();
                    return true;
                }

                private boolean r_stem_suffix_chain_before_ki() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
                    // (, line 332
                    // [, line 333
                    ket = cursor;
                    // call mark_ki, line 334
                    if (!r_mark_ki())
                    {
                        return false;
                    }
                    // (, line 335
                    // or, line 342
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 336
                            // call mark_DA, line 336
                            if (!r_mark_DA())
                            {
                                break lab1;
                            }
                            // ], line 336
                            bra = cursor;
                            // delete, line 336
                            slice_del();
                            // try, line 336
                            v_2 = limit - cursor;
                            lab2: do {
                                // (, line 336
                                // [, line 336
                                ket = cursor;
                                // or, line 338
                                lab3: do {
                                    v_3 = limit - cursor;
                                    lab4: do {
                                        // (, line 337
                                        // call mark_lAr, line 337
                                        if (!r_mark_lAr())
                                        {
                                            break lab4;
                                        }
                                        // ], line 337
                                        bra = cursor;
                                        // delete, line 337
                                        slice_del();
                                        // try, line 337
                                        v_4 = limit - cursor;
                                        lab5: do {
                                            // (, line 337
                                            // call stem_suffix_chain_before_ki, line 337
                                            if (!r_stem_suffix_chain_before_ki())
                                            {
                                                cursor = limit - v_4;
                                                break lab5;
                                            }
                                        } while (false);
                                        break lab3;
                                    } while (false);
                                    cursor = limit - v_3;
                                    // (, line 339
                                    // call mark_possessives, line 339
                                    if (!r_mark_possessives())
                                    {
                                        cursor = limit - v_2;
                                        break lab2;
                                    }
                                    // ], line 339
                                    bra = cursor;
                                    // delete, line 339
                                    slice_del();
                                    // try, line 339
                                    v_5 = limit - cursor;
                                    lab6: do {
                                        // (, line 339
                                        // [, line 339
                                        ket = cursor;
                                        // call mark_lAr, line 339
                                        if (!r_mark_lAr())
                                        {
                                            cursor = limit - v_5;
                                            break lab6;
                                        }
                                        // ], line 339
                                        bra = cursor;
                                        // delete, line 339
                                        slice_del();
                                        // call stem_suffix_chain_before_ki, line 339
                                        if (!r_stem_suffix_chain_before_ki())
                                        {
                                            cursor = limit - v_5;
                                            break lab6;
                                        }
                                    } while (false);
                                } while (false);
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab7: do {
                            // (, line 343
                            // call mark_nUn, line 343
                            if (!r_mark_nUn())
                            {
                                break lab7;
                            }
                            // ], line 343
                            bra = cursor;
                            // delete, line 343
                            slice_del();
                            // try, line 343
                            v_6 = limit - cursor;
                            lab8: do {
                                // (, line 343
                                // [, line 343
                                ket = cursor;
                                // or, line 345
                                lab9: do {
                                    v_7 = limit - cursor;
                                    lab10: do {
                                        // (, line 344
                                        // call mark_lArI, line 344
                                        if (!r_mark_lArI())
                                        {
                                            break lab10;
                                        }
                                        // ], line 344
                                        bra = cursor;
                                        // delete, line 344
                                        slice_del();
                                        break lab9;
                                    } while (false);
                                    cursor = limit - v_7;
                                    lab11: do {
                                        // (, line 346
                                        // [, line 346
                                        ket = cursor;
                                        // or, line 346
                                        lab12: do {
                                            v_8 = limit - cursor;
                                            lab13: do {
                                                // call mark_possessives, line 346
                                                if (!r_mark_possessives())
                                                {
                                                    break lab13;
                                                }
                                                break lab12;
                                            } while (false);
                                            cursor = limit - v_8;
                                            // call mark_sU, line 346
                                            if (!r_mark_sU())
                                            {
                                                break lab11;
                                            }
                                        } while (false);
                                        // ], line 346
                                        bra = cursor;
                                        // delete, line 346
                                        slice_del();
                                        // try, line 346
                                        v_9 = limit - cursor;
                                        lab14: do {
                                            // (, line 346
                                            // [, line 346
                                            ket = cursor;
                                            // call mark_lAr, line 346
                                            if (!r_mark_lAr())
                                            {
                                                cursor = limit - v_9;
                                                break lab14;
                                            }
                                            // ], line 346
                                            bra = cursor;
                                            // delete, line 346
                                            slice_del();
                                            // call stem_suffix_chain_before_ki, line 346
                                            if (!r_stem_suffix_chain_before_ki())
                                            {
                                                cursor = limit - v_9;
                                                break lab14;
                                            }
                                        } while (false);
                                        break lab9;
                                    } while (false);
                                    cursor = limit - v_7;
                                    // (, line 348
                                    // call stem_suffix_chain_before_ki, line 348
                                    if (!r_stem_suffix_chain_before_ki())
                                    {
                                        cursor = limit - v_6;
                                        break lab8;
                                    }
                                } while (false);
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 351
                        // call mark_ndA, line 351
                        if (!r_mark_ndA())
                        {
                            return false;
                        }
                        // (, line 351
                        // or, line 353
                        lab15: do {
                            v_10 = limit - cursor;
                            lab16: do {
                                // (, line 352
                                // call mark_lArI, line 352
                                if (!r_mark_lArI())
                                {
                                    break lab16;
                                }
                                // ], line 352
                                bra = cursor;
                                // delete, line 352
                                slice_del();
                                break lab15;
                            } while (false);
                            cursor = limit - v_10;
                            lab17: do {
                                // (, line 354
                                // (, line 354
                                // call mark_sU, line 354
                                if (!r_mark_sU())
                                {
                                    break lab17;
                                }
                                // ], line 354
                                bra = cursor;
                                // delete, line 354
                                slice_del();
                                // try, line 354
                                v_11 = limit - cursor;
                                lab18: do {
                                    // (, line 354
                                    // [, line 354
                                    ket = cursor;
                                    // call mark_lAr, line 354
                                    if (!r_mark_lAr())
                                    {
                                        cursor = limit - v_11;
                                        break lab18;
                                    }
                                    // ], line 354
                                    bra = cursor;
                                    // delete, line 354
                                    slice_del();
                                    // call stem_suffix_chain_before_ki, line 354
                                    if (!r_stem_suffix_chain_before_ki())
                                    {
                                        cursor = limit - v_11;
                                        break lab18;
                                    }
                                } while (false);
                                break lab15;
                            } while (false);
                            cursor = limit - v_10;
                            // (, line 356
                            // call stem_suffix_chain_before_ki, line 356
                            if (!r_stem_suffix_chain_before_ki())
                            {
                                return false;
                            }
                        } while (false);
                    } while (false);
                    return true;
                }

                private boolean r_stem_noun_suffixes() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
            int v_12;
            int v_13;
            int v_14;
            int v_15;
            int v_16;
            int v_17;
            int v_18;
            int v_19;
            int v_20;
            int v_21;
            int v_22;
            int v_23;
            int v_24;
            int v_25;
            int v_26;
            int v_27;
                    // (, line 361
                    // or, line 363
                    lab0: do {
                        v_1 = limit - cursor;
                        lab1: do {
                            // (, line 362
                            // [, line 362
                            ket = cursor;
                            // call mark_lAr, line 362
                            if (!r_mark_lAr())
                            {
                                break lab1;
                            }
                            // ], line 362
                            bra = cursor;
                            // delete, line 362
                            slice_del();
                            // try, line 362
                            v_2 = limit - cursor;
                            lab2: do {
                                // (, line 362
                                // call stem_suffix_chain_before_ki, line 362
                                if (!r_stem_suffix_chain_before_ki())
                                {
                                    cursor = limit - v_2;
                                    break lab2;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab3: do {
                            // (, line 364
                            // [, line 364
                            ket = cursor;
                            // call mark_ncA, line 364
                            if (!r_mark_ncA())
                            {
                                break lab3;
                            }
                            // ], line 364
                            bra = cursor;
                            // delete, line 364
                            slice_del();
                            // try, line 365
                            v_3 = limit - cursor;
                            lab4: do {
                                // (, line 365
                                // or, line 367
                                lab5: do {
                                    v_4 = limit - cursor;
                                    lab6: do {
                                        // (, line 366
                                        // [, line 366
                                        ket = cursor;
                                        // call mark_lArI, line 366
                                        if (!r_mark_lArI())
                                        {
                                            break lab6;
                                        }
                                        // ], line 366
                                        bra = cursor;
                                        // delete, line 366
                                        slice_del();
                                        break lab5;
                                    } while (false);
                                    cursor = limit - v_4;
                                    lab7: do {
                                        // (, line 368
                                        // [, line 368
                                        ket = cursor;
                                        // or, line 368
                                        lab8: do {
                                            v_5 = limit - cursor;
                                            lab9: do {
                                                // call mark_possessives, line 368
                                                if (!r_mark_possessives())
                                                {
                                                    break lab9;
                                                }
                                                break lab8;
                                            } while (false);
                                            cursor = limit - v_5;
                                            // call mark_sU, line 368
                                            if (!r_mark_sU())
                                            {
                                                break lab7;
                                            }
                                        } while (false);
                                        // ], line 368
                                        bra = cursor;
                                        // delete, line 368
                                        slice_del();
                                        // try, line 368
                                        v_6 = limit - cursor;
                                        lab10: do {
                                            // (, line 368
                                            // [, line 368
                                            ket = cursor;
                                            // call mark_lAr, line 368
                                            if (!r_mark_lAr())
                                            {
                                                cursor = limit - v_6;
                                                break lab10;
                                            }
                                            // ], line 368
                                            bra = cursor;
                                            // delete, line 368
                                            slice_del();
                                            // call stem_suffix_chain_before_ki, line 368
                                            if (!r_stem_suffix_chain_before_ki())
                                            {
                                                cursor = limit - v_6;
                                                break lab10;
                                            }
                                        } while (false);
                                        break lab5;
                                    } while (false);
                                    cursor = limit - v_4;
                                    // (, line 370
                                    // [, line 370
                                    ket = cursor;
                                    // call mark_lAr, line 370
                                    if (!r_mark_lAr())
                                    {
                                        cursor = limit - v_3;
                                        break lab4;
                                    }
                                    // ], line 370
                                    bra = cursor;
                                    // delete, line 370
                                    slice_del();
                                    // call stem_suffix_chain_before_ki, line 370
                                    if (!r_stem_suffix_chain_before_ki())
                                    {
                                        cursor = limit - v_3;
                                        break lab4;
                                    }
                                } while (false);
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab11: do {
                            // (, line 374
                            // [, line 374
                            ket = cursor;
                            // (, line 374
                            // or, line 374
                            lab12: do {
                                v_7 = limit - cursor;
                                lab13: do {
                                    // call mark_ndA, line 374
                                    if (!r_mark_ndA())
                                    {
                                        break lab13;
                                    }
                                    break lab12;
                                } while (false);
                                cursor = limit - v_7;
                                // call mark_nA, line 374
                                if (!r_mark_nA())
                                {
                                    break lab11;
                                }
                            } while (false);
                            // (, line 375
                            // or, line 377
                            lab14: do {
                                v_8 = limit - cursor;
                                lab15: do {
                                    // (, line 376
                                    // call mark_lArI, line 376
                                    if (!r_mark_lArI())
                                    {
                                        break lab15;
                                    }
                                    // ], line 376
                                    bra = cursor;
                                    // delete, line 376
                                    slice_del();
                                    break lab14;
                                } while (false);
                                cursor = limit - v_8;
                                lab16: do {
                                    // (, line 378
                                    // call mark_sU, line 378
                                    if (!r_mark_sU())
                                    {
                                        break lab16;
                                    }
                                    // ], line 378
                                    bra = cursor;
                                    // delete, line 378
                                    slice_del();
                                    // try, line 378
                                    v_9 = limit - cursor;
                                    lab17: do {
                                        // (, line 378
                                        // [, line 378
                                        ket = cursor;
                                        // call mark_lAr, line 378
                                        if (!r_mark_lAr())
                                        {
                                            cursor = limit - v_9;
                                            break lab17;
                                        }
                                        // ], line 378
                                        bra = cursor;
                                        // delete, line 378
                                        slice_del();
                                        // call stem_suffix_chain_before_ki, line 378
                                        if (!r_stem_suffix_chain_before_ki())
                                        {
                                            cursor = limit - v_9;
                                            break lab17;
                                        }
                                    } while (false);
                                    break lab14;
                                } while (false);
                                cursor = limit - v_8;
                                // (, line 380
                                // call stem_suffix_chain_before_ki, line 380
                                if (!r_stem_suffix_chain_before_ki())
                                {
                                    break lab11;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab18: do {
                            // (, line 384
                            // [, line 384
                            ket = cursor;
                            // (, line 384
                            // or, line 384
                            lab19: do {
                                v_10 = limit - cursor;
                                lab20: do {
                                    // call mark_ndAn, line 384
                                    if (!r_mark_ndAn())
                                    {
                                        break lab20;
                                    }
                                    break lab19;
                                } while (false);
                                cursor = limit - v_10;
                                // call mark_nU, line 384
                                if (!r_mark_nU())
                                {
                                    break lab18;
                                }
                            } while (false);
                            // (, line 384
                            // or, line 384
                            lab21: do {
                                v_11 = limit - cursor;
                                lab22: do {
                                    // (, line 384
                                    // call mark_sU, line 384
                                    if (!r_mark_sU())
                                    {
                                        break lab22;
                                    }
                                    // ], line 384
                                    bra = cursor;
                                    // delete, line 384
                                    slice_del();
                                    // try, line 384
                                    v_12 = limit - cursor;
                                    lab23: do {
                                        // (, line 384
                                        // [, line 384
                                        ket = cursor;
                                        // call mark_lAr, line 384
                                        if (!r_mark_lAr())
                                        {
                                            cursor = limit - v_12;
                                            break lab23;
                                        }
                                        // ], line 384
                                        bra = cursor;
                                        // delete, line 384
                                        slice_del();
                                        // call stem_suffix_chain_before_ki, line 384
                                        if (!r_stem_suffix_chain_before_ki())
                                        {
                                            cursor = limit - v_12;
                                            break lab23;
                                        }
                                    } while (false);
                                    break lab21;
                                } while (false);
                                cursor = limit - v_11;
                                // (, line 384
                                // call mark_lArI, line 384
                                if (!r_mark_lArI())
                                {
                                    break lab18;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab24: do {
                            // (, line 386
                            // [, line 386
                            ket = cursor;
                            // call mark_DAn, line 386
                            if (!r_mark_DAn())
                            {
                                break lab24;
                            }
                            // ], line 386
                            bra = cursor;
                            // delete, line 386
                            slice_del();
                            // try, line 386
                            v_13 = limit - cursor;
                            lab25: do {
                                // (, line 386
                                // [, line 386
                                ket = cursor;
                                // (, line 387
                                // or, line 389
                                lab26: do {
                                    v_14 = limit - cursor;
                                    lab27: do {
                                        // (, line 388
                                        // call mark_possessives, line 388
                                        if (!r_mark_possessives())
                                        {
                                            break lab27;
                                        }
                                        // ], line 388
                                        bra = cursor;
                                        // delete, line 388
                                        slice_del();
                                        // try, line 388
                                        v_15 = limit - cursor;
                                        lab28: do {
                                            // (, line 388
                                            // [, line 388
                                            ket = cursor;
                                            // call mark_lAr, line 388
                                            if (!r_mark_lAr())
                                            {
                                                cursor = limit - v_15;
                                                break lab28;
                                            }
                                            // ], line 388
                                            bra = cursor;
                                            // delete, line 388
                                            slice_del();
                                            // call stem_suffix_chain_before_ki, line 388
                                            if (!r_stem_suffix_chain_before_ki())
                                            {
                                                cursor = limit - v_15;
                                                break lab28;
                                            }
                                        } while (false);
                                        break lab26;
                                    } while (false);
                                    cursor = limit - v_14;
                                    lab29: do {
                                        // (, line 390
                                        // call mark_lAr, line 390
                                        if (!r_mark_lAr())
                                        {
                                            break lab29;
                                        }
                                        // ], line 390
                                        bra = cursor;
                                        // delete, line 390
                                        slice_del();
                                        // try, line 390
                                        v_16 = limit - cursor;
                                        lab30: do {
                                            // (, line 390
                                            // call stem_suffix_chain_before_ki, line 390
                                            if (!r_stem_suffix_chain_before_ki())
                                            {
                                                cursor = limit - v_16;
                                                break lab30;
                                            }
                                        } while (false);
                                        break lab26;
                                    } while (false);
                                    cursor = limit - v_14;
                                    // (, line 392
                                    // call stem_suffix_chain_before_ki, line 392
                                    if (!r_stem_suffix_chain_before_ki())
                                    {
                                        cursor = limit - v_13;
                                        break lab25;
                                    }
                                } while (false);
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab31: do {
                            // (, line 396
                            // [, line 396
                            ket = cursor;
                            // or, line 396
                            lab32: do {
                                v_17 = limit - cursor;
                                lab33: do {
                                    // call mark_nUn, line 396
                                    if (!r_mark_nUn())
                                    {
                                        break lab33;
                                    }
                                    break lab32;
                                } while (false);
                                cursor = limit - v_17;
                                // call mark_ylA, line 396
                                if (!r_mark_ylA())
                                {
                                    break lab31;
                                }
                            } while (false);
                            // ], line 396
                            bra = cursor;
                            // delete, line 396
                            slice_del();
                            // try, line 397
                            v_18 = limit - cursor;
                            lab34: do {
                                // (, line 397
                                // or, line 399
                                lab35: do {
                                    v_19 = limit - cursor;
                                    lab36: do {
                                        // (, line 398
                                        // [, line 398
                                        ket = cursor;
                                        // call mark_lAr, line 398
                                        if (!r_mark_lAr())
                                        {
                                            break lab36;
                                        }
                                        // ], line 398
                                        bra = cursor;
                                        // delete, line 398
                                        slice_del();
                                        // call stem_suffix_chain_before_ki, line 398
                                        if (!r_stem_suffix_chain_before_ki())
                                        {
                                            break lab36;
                                        }
                                        break lab35;
                                    } while (false);
                                    cursor = limit - v_19;
                                    lab37: do {
                                        // (, line 400
                                        // [, line 400
                                        ket = cursor;
                                        // or, line 400
                                        lab38: do {
                                            v_20 = limit - cursor;
                                            lab39: do {
                                                // call mark_possessives, line 400
                                                if (!r_mark_possessives())
                                                {
                                                    break lab39;
                                                }
                                                break lab38;
                                            } while (false);
                                            cursor = limit - v_20;
                                            // call mark_sU, line 400
                                            if (!r_mark_sU())
                                            {
                                                break lab37;
                                            }
                                        } while (false);
                                        // ], line 400
                                        bra = cursor;
                                        // delete, line 400
                                        slice_del();
                                        // try, line 400
                                        v_21 = limit - cursor;
                                        lab40: do {
                                            // (, line 400
                                            // [, line 400
                                            ket = cursor;
                                            // call mark_lAr, line 400
                                            if (!r_mark_lAr())
                                            {
                                                cursor = limit - v_21;
                                                break lab40;
                                            }
                                            // ], line 400
                                            bra = cursor;
                                            // delete, line 400
                                            slice_del();
                                            // call stem_suffix_chain_before_ki, line 400
                                            if (!r_stem_suffix_chain_before_ki())
                                            {
                                                cursor = limit - v_21;
                                                break lab40;
                                            }
                                        } while (false);
                                        break lab35;
                                    } while (false);
                                    cursor = limit - v_19;
                                    // call stem_suffix_chain_before_ki, line 402
                                    if (!r_stem_suffix_chain_before_ki())
                                    {
                                        cursor = limit - v_18;
                                        break lab34;
                                    }
                                } while (false);
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab41: do {
                            // (, line 406
                            // [, line 406
                            ket = cursor;
                            // call mark_lArI, line 406
                            if (!r_mark_lArI())
                            {
                                break lab41;
                            }
                            // ], line 406
                            bra = cursor;
                            // delete, line 406
                            slice_del();
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab42: do {
                            // (, line 408
                            // call stem_suffix_chain_before_ki, line 408
                            if (!r_stem_suffix_chain_before_ki())
                            {
                                break lab42;
                            }
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        lab43: do {
                            // (, line 410
                            // [, line 410
                            ket = cursor;
                            // or, line 410
                            lab44: do {
                                v_22 = limit - cursor;
                                lab45: do {
                                    // call mark_DA, line 410
                                    if (!r_mark_DA())
                                    {
                                        break lab45;
                                    }
                                    break lab44;
                                } while (false);
                                cursor = limit - v_22;
                                lab46: do {
                                    // call mark_yU, line 410
                                    if (!r_mark_yU())
                                    {
                                        break lab46;
                                    }
                                    break lab44;
                                } while (false);
                                cursor = limit - v_22;
                                // call mark_yA, line 410
                                if (!r_mark_yA())
                                {
                                    break lab43;
                                }
                            } while (false);
                            // ], line 410
                            bra = cursor;
                            // delete, line 410
                            slice_del();
                            // try, line 410
                            v_23 = limit - cursor;
                            lab47: do {
                                // (, line 410
                                // [, line 410
                                ket = cursor;
                                // (, line 410
                                // or, line 410
                                lab48: do {
                                    v_24 = limit - cursor;
                                    lab49: do {
                                        // (, line 410
                                        // call mark_possessives, line 410
                                        if (!r_mark_possessives())
                                        {
                                            break lab49;
                                        }
                                        // ], line 410
                                        bra = cursor;
                                        // delete, line 410
                                        slice_del();
                                        // try, line 410
                                        v_25 = limit - cursor;
                                        lab50: do {
                                            // (, line 410
                                            // [, line 410
                                            ket = cursor;
                                            // call mark_lAr, line 410
                                            if (!r_mark_lAr())
                                            {
                                                cursor = limit - v_25;
                                                break lab50;
                                            }
                                        } while (false);
                                        break lab48;
                                    } while (false);
                                    cursor = limit - v_24;
                                    // call mark_lAr, line 410
                                    if (!r_mark_lAr())
                                    {
                                        cursor = limit - v_23;
                                        break lab47;
                                    }
                                } while (false);
                                // ], line 410
                                bra = cursor;
                                // delete, line 410
                                slice_del();
                                // [, line 410
                                ket = cursor;
                                // call stem_suffix_chain_before_ki, line 410
                                if (!r_stem_suffix_chain_before_ki())
                                {
                                    cursor = limit - v_23;
                                    break lab47;
                                }
                            } while (false);
                            break lab0;
                        } while (false);
                        cursor = limit - v_1;
                        // (, line 412
                        // [, line 412
                        ket = cursor;
                        // or, line 412
                        lab51: do {
                            v_26 = limit - cursor;
                            lab52: do {
                                // call mark_possessives, line 412
                                if (!r_mark_possessives())
                                {
                                    break lab52;
                                }
                                break lab51;
                            } while (false);
                            cursor = limit - v_26;
                            // call mark_sU, line 412
                            if (!r_mark_sU())
                            {
                                return false;
                            }
                        } while (false);
                        // ], line 412
                        bra = cursor;
                        // delete, line 412
                        slice_del();
                        // try, line 412
                        v_27 = limit - cursor;
                        lab53: do {
                            // (, line 412
                            // [, line 412
                            ket = cursor;
                            // call mark_lAr, line 412
                            if (!r_mark_lAr())
                            {
                                cursor = limit - v_27;
                                break lab53;
                            }
                            // ], line 412
                            bra = cursor;
                            // delete, line 412
                            slice_del();
                            // call stem_suffix_chain_before_ki, line 412
                            if (!r_stem_suffix_chain_before_ki())
                            {
                                cursor = limit - v_27;
                                break lab53;
                            }
                        } while (false);
                    } while (false);
                    return true;
                }

                private boolean r_post_process_last_consonants() {
            int among_var;
                    // (, line 415
                    // [, line 416
                    ket = cursor;
                    // substring, line 416
                    among_var = find_among_b(a_23, 4);
                    if (among_var == 0)
                    {
                        return false;
                    }
                    // ], line 416
                    bra = cursor;
                    switch(among_var) {
                        case 0:
                            return false;
                        case 1:
                            // (, line 417
                            // <-, line 417
                            slice_from("p");
                            break;
                        case 2:
                            // (, line 418
                            // <-, line 418
                            slice_from("\u00E7");
                            break;
                        case 3:
                            // (, line 419
                            // <-, line 419
                            slice_from("t");
                            break;
                        case 4:
                            // (, line 420
                            // <-, line 420
                            slice_from("k");
                            break;
                    }
                    return true;
                }

                private boolean r_append_U_to_stems_ending_with_d_or_g() {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
            int v_12;
            int v_13;
            int v_14;
            int v_15;
                    // (, line 430
                    // test, line 431
                    v_1 = limit - cursor;
                    // (, line 431
                    // or, line 431
                    lab0: do {
                        v_2 = limit - cursor;
                        lab1: do {
                            // literal, line 431
                            if (!(eq_s_b(1, "d")))
                            {
                                break lab1;
                            }
                            break lab0;
                        } while (false);
                        cursor = limit - v_2;
                        // literal, line 431
                        if (!(eq_s_b(1, "g")))
                        {
                            return false;
                        }
                    } while (false);
                    cursor = limit - v_1;
                    // or, line 433
                    lab2: do {
                        v_3 = limit - cursor;
                        lab3: do {
                            // (, line 432
                            // test, line 432
                            v_4 = limit - cursor;
                            // (, line 432
                            // (, line 432
                            // goto, line 432
                            golab4: while(true)
                            {
                                v_5 = limit - cursor;
                                lab5: do {
                                    if (!(in_grouping_b(g_vowel, 97, 305)))
                                    {
                                        break lab5;
                                    }
                                    cursor = limit - v_5;
                                    break golab4;
                                } while (false);
                                cursor = limit - v_5;
                                if (cursor <= limit_backward)
                                {
                                    break lab3;
                                }
                                cursor--;
                            }
                            // or, line 432
                            lab6: do {
                                v_6 = limit - cursor;
                                lab7: do {
                                    // literal, line 432
                                    if (!(eq_s_b(1, "a")))
                                    {
                                        break lab7;
                                    }
                                    break lab6;
                                } while (false);
                                cursor = limit - v_6;
                                // literal, line 432
                                if (!(eq_s_b(1, "\u0131")))
                                {
                                    break lab3;
                                }
                            } while (false);
                            cursor = limit - v_4;
                            // <+, line 432
                            {
                                int c = cursor;
                                insert(cursor, cursor, "\u0131");
                                cursor = c;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab8: do {
                            // (, line 434
                            // test, line 434
                            v_7 = limit - cursor;
                            // (, line 434
                            // (, line 434
                            // goto, line 434
                            golab9: while(true)
                            {
                                v_8 = limit - cursor;
                                lab10: do {
                                    if (!(in_grouping_b(g_vowel, 97, 305)))
                                    {
                                        break lab10;
                                    }
                                    cursor = limit - v_8;
                                    break golab9;
                                } while (false);
                                cursor = limit - v_8;
                                if (cursor <= limit_backward)
                                {
                                    break lab8;
                                }
                                cursor--;
                            }
                            // or, line 434
                            lab11: do {
                                v_9 = limit - cursor;
                                lab12: do {
                                    // literal, line 434
                                    if (!(eq_s_b(1, "e")))
                                    {
                                        break lab12;
                                    }
                                    break lab11;
                                } while (false);
                                cursor = limit - v_9;
                                // literal, line 434
                                if (!(eq_s_b(1, "i")))
                                {
                                    break lab8;
                                }
                            } while (false);
                            cursor = limit - v_7;
                            // <+, line 434
                            {
                                int c = cursor;
                                insert(cursor, cursor, "i");
                                cursor = c;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        lab13: do {
                            // (, line 436
                            // test, line 436
                            v_10 = limit - cursor;
                            // (, line 436
                            // (, line 436
                            // goto, line 436
                            golab14: while(true)
                            {
                                v_11 = limit - cursor;
                                lab15: do {
                                    if (!(in_grouping_b(g_vowel, 97, 305)))
                                    {
                                        break lab15;
                                    }
                                    cursor = limit - v_11;
                                    break golab14;
                                } while (false);
                                cursor = limit - v_11;
                                if (cursor <= limit_backward)
                                {
                                    break lab13;
                                }
                                cursor--;
                            }
                            // or, line 436
                            lab16: do {
                                v_12 = limit - cursor;
                                lab17: do {
                                    // literal, line 436
                                    if (!(eq_s_b(1, "o")))
                                    {
                                        break lab17;
                                    }
                                    break lab16;
                                } while (false);
                                cursor = limit - v_12;
                                // literal, line 436
                                if (!(eq_s_b(1, "u")))
                                {
                                    break lab13;
                                }
                            } while (false);
                            cursor = limit - v_10;
                            // <+, line 436
                            {
                                int c = cursor;
                                insert(cursor, cursor, "u");
                                cursor = c;
                            }
                            break lab2;
                        } while (false);
                        cursor = limit - v_3;
                        // (, line 438
                        // test, line 438
                        v_13 = limit - cursor;
                        // (, line 438
                        // (, line 438
                        // goto, line 438
                        golab18: while(true)
                        {
                            v_14 = limit - cursor;
                            lab19: do {
                                if (!(in_grouping_b(g_vowel, 97, 305)))
                                {
                                    break lab19;
                                }
                                cursor = limit - v_14;
                                break golab18;
                            } while (false);
                            cursor = limit - v_14;
                            if (cursor <= limit_backward)
                            {
                                return false;
                            }
                            cursor--;
                        }
                        // or, line 438
                        lab20: do {
                            v_15 = limit - cursor;
                            lab21: do {
                                // literal, line 438
                                if (!(eq_s_b(1, "\u00F6")))
                                {
                                    break lab21;
                                }
                                break lab20;
                            } while (false);
                            cursor = limit - v_15;
                            // literal, line 438
                            if (!(eq_s_b(1, "\u00FC")))
                            {
                                return false;
                            }
                        } while (false);
                        cursor = limit - v_13;
                        // <+, line 438
                        {
                            int c = cursor;
                            insert(cursor, cursor, "\u00FC");
                            cursor = c;
                        }
                    } while (false);
                    return true;
                }

                private boolean r_more_than_one_syllable_word() {
            int v_1;
            int v_3;
                    // (, line 445
                    // test, line 446
                    v_1 = cursor;
                    // (, line 446
                    // atleast, line 446
                    {
                        int v_2 = 2;
                        // atleast, line 446
                        replab0: while(true)
                        {
                            v_3 = cursor;
                            lab1: do {
                                // (, line 446
                                // gopast, line 446
                                golab2: while(true)
                                {
                                    lab3: do {
                                        if (!(in_grouping(g_vowel, 97, 305)))
                                        {
                                            break lab3;
                                        }
                                        break golab2;
                                    } while (false);
                                    if (cursor >= limit)
                                    {
                                        break lab1;
                                    }
                                    cursor++;
                                }
                                v_2--;
                                continue replab0;
                            } while (false);
                            cursor = v_3;
                            break replab0;
                        }
                        if (v_2 > 0)
                        {
                            return false;
                        }
                    }
                    cursor = v_1;
                    return true;
                }

                private boolean r_is_reserved_word() {
            int v_1;
            int v_2;
            int v_4;
                    // (, line 449
                    // or, line 451
                    lab0: do {
                        v_1 = cursor;
                        lab1: do {
                            // test, line 450
                            v_2 = cursor;
                            // (, line 450
                            // gopast, line 450
                            golab2: while(true)
                            {
                                lab3: do {
                                    // literal, line 450
                                    if (!(eq_s(2, "ad")))
                                    {
                                        break lab3;
                                    }
                                    break golab2;
                                } while (false);
                                if (cursor >= limit)
                                {
                                    break lab1;
                                }
                                cursor++;
                            }
                            // (, line 450
                            I_strlen = 2;
                            // (, line 450
                            if (!(I_strlen == limit))
                            {
                                break lab1;
                            }
                            cursor = v_2;
                            break lab0;
                        } while (false);
                        cursor = v_1;
                        // test, line 452
                        v_4 = cursor;
                        // (, line 452
                        // gopast, line 452
                        golab4: while(true)
                        {
                            lab5: do {
                                // literal, line 452
                                if (!(eq_s(5, "soyad")))
                                {
                                    break lab5;
                                }
                                break golab4;
                            } while (false);
                            if (cursor >= limit)
                            {
                                return false;
                            }
                            cursor++;
                        }
                        // (, line 452
                        I_strlen = 5;
                        // (, line 452
                        if (!(I_strlen == limit))
                        {
                            return false;
                        }
                        cursor = v_4;
                    } while (false);
                    return true;
                }

                private boolean r_postlude() {
            int v_1;
            int v_2;
            int v_3;
                    // (, line 455
                    // not, line 456
                    {
                        v_1 = cursor;
                        lab0: do {
                            // (, line 456
                            // call is_reserved_word, line 456
                            if (!r_is_reserved_word())
                            {
                                break lab0;
                            }
                            return false;
                        } while (false);
                        cursor = v_1;
                    }
                    // backwards, line 457
                    limit_backward = cursor; cursor = limit;
                    // (, line 457
                    // do, line 458
                    v_2 = limit - cursor;
                    lab1: do {
                        // call append_U_to_stems_ending_with_d_or_g, line 458
                        if (!r_append_U_to_stems_ending_with_d_or_g())
                        {
                            break lab1;
                        }
                    } while (false);
                    cursor = limit - v_2;
                    // do, line 459
                    v_3 = limit - cursor;
                    lab2: do {
                        // call post_process_last_consonants, line 459
                        if (!r_post_process_last_consonants())
                        {
                            break lab2;
                        }
                    } while (false);
                    cursor = limit - v_3;
                    cursor = limit_backward;                    return true;
                }

                public boolean stem() {
            int v_1;
            int v_2;
                    // (, line 464
                    // (, line 465
                    // call more_than_one_syllable_word, line 465
                    if (!r_more_than_one_syllable_word())
                    {
                        return false;
                    }
                    // (, line 466
                    // backwards, line 467
                    limit_backward = cursor; cursor = limit;
                    // (, line 467
                    // do, line 468
                    v_1 = limit - cursor;
                    lab0: do {
                        // call stem_nominal_verb_suffixes, line 468
                        if (!r_stem_nominal_verb_suffixes())
                        {
                            break lab0;
                        }
                    } while (false);
                    cursor = limit - v_1;
                    // Boolean test continue_stemming_noun_suffixes, line 469
                    if (!(B_continue_stemming_noun_suffixes))
                    {
                        return false;
                    }
                    // do, line 470
                    v_2 = limit - cursor;
                    lab1: do {
                        // call stem_noun_suffixes, line 470
                        if (!r_stem_noun_suffixes())
                        {
                            break lab1;
                        }
                    } while (false);
                    cursor = limit - v_2;
                    cursor = limit_backward;                    // call postlude, line 473
                    if (!r_postlude())
                    {
                        return false;
                    }
                    return true;
                }

        public boolean equals( Object o ) {
            return o instanceof turkishStemmer;
        }

        public int hashCode() {
            return turkishStemmer.class.getName().hashCode();
        }



}

