#pragma once

//******************************************************************
// Iwa FractalNoise Fx
// An Fx emulating Fractal Noise effect in Adobe AfterEffect
//******************************************************************

#ifndef IWA_FRACTALNOISEFX_H
#define IWA_FRACTALNOISEFX_H

#include "tfxparam.h"
#include "tparamset.h"
#include "stdfx.h"

class Iwa_FractalNoiseFx final : public TStandardZeraryFx {
  FX_PLUGIN_DECLARATION(Iwa_FractalNoiseFx)

  enum FractalType {
    Basic = 0,
    TurbulentSmooth,
    TurbulentBasic,
    TurbulentSharp,
    Dynamic,
    DynamicTwist,
    Max,
    Rocky,
    FractalTypeCount
  };

  enum NoiseType { Block = 0, Smooth, NoiseTypeCount };

  struct FNParam {
    FractalType fractalType;
    NoiseType noiseType;
    bool invert;
    double rotation;
    TDimensionD scale;
    TPointD offsetTurbulence;
    bool perspectiveOffset;
    double complexity;
    double subInfluence;
    double subScaling;
    double subRotation;
    TPointD subOffset;
    double evolution;
    bool cycleEvolution;
    double cycleEvolutionRange;
    double dynamicIntensity;
    bool alphaRendering;
  };

protected:
  // Fractal Type tN^̎
  TIntEnumParamP m_fractalType;
  // Noise Type mCY̎
  TIntEnumParamP m_noiseType;
  // Invert ]
  TBoolParamP m_invert;
  /// Contrast RgXg
  /// Brightness 邳
  /// Overflow I[o[t[

  //- - - Transform gXtH[ - - -
  // Rotation ]
  TDoubleParamP m_rotation;
  // Uniform Scaling@cŒ
  TBoolParamP m_uniformScaling;
  // Scale XP[
  TDoubleParamP m_scale;
  // Scale Width XP[̕
  TDoubleParamP m_scaleW;
  // Scale Height XP[̍
  TDoubleParamP m_scaleH;
  // Offset Turbulence C̃ItZbg
  TPointParamP m_offsetTurbulence;
  // Perspective Offset ߃ItZbg
  TBoolParamP m_perspectiveOffset;

  // Complexity Gx
  TDoubleParamP m_complexity;

  //- - - Sub Settings Tuݒ - - -
  // Sub Influence Tueij
  TDoubleParamP m_subInfluence;
  // Sub Scaling@TuXP[
  TDoubleParamP m_subScaling;
  // Sub Rotation Tu]
  TDoubleParamP m_subRotation;
  // Sub Offset TũItZbg
  TPointParamP m_subOffset;
  // Center Subscale TuXP[𒆐S
  /// TBoolParamP m_centerSubscale;

  // Evolution WJ
  TDoubleParamP m_evolution;

  //- - - Evolution Options WJ̃IvV - - -
  // Cycle Evolution TCNWJ
  TBoolParamP m_cycleEvolution;
  // Cycle (in Evolution) TCNij
  TDoubleParamP m_cycleEvolutionRange;
  /// Random Seed _V[h
  /// Opacity  sx
  /// Blending Mode `惂[h

  // _Ci~bN̓x
  TDoubleParamP m_dynamicIntensity;

  // - - - additional parameters - - -
  TBoolParamP m_alphaRendering;

public:
  Iwa_FractalNoiseFx();
  bool canHandle(const TRenderSettings &info, double frame) override {
    return true;
  }
  bool doGetBBox(double frame, TRectD &bBox,
                 const TRenderSettings &ri) override;
  void doCompute(TTile &tile, double frame, const TRenderSettings &ri) override;

  void obtainParams(FNParam &param, const double frame, const TAffine &aff);

  template <typename RASTER, typename PIXEL>
  void outputRaster(const RASTER outRas, double *out_buf, const FNParam &param);

  void getParamUIs(TParamUIConcept *&concepts, int &length) override;

  // For Dynamic and Dynamic Twist patterns, the position offsets using gradient
  // / rotation of the parent pattern
  TPointD getSamplePos(int x, int y, const TDimension outDim,
                       const double *out_buf, const int gen, const double scale,
                       const FNParam &param);
  // convert the noise
  void convert(double *buf, const FNParam &param);
  // composite the base noise pattern
  void composite(double *out, double *buf, const double influence,
                 const FNParam &param);
  // finalize pattern (coverting the color space)
  void finalize(double *out, const FNParam &param);
};

#endif