/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInMFString.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.MFString;

public class EventInMFString extends EventIn
{
  public void setValue (String[] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (value == null)
      throw new IllegalArgumentException ();

    ((MFString) eventin_).setValue (value);

    sendEvent ();

    scene_.redraw ();
  }

  public void set1Value (int index, String value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (index < 0 || index >= ((MFString) eventin_).getValueCount () || value == null)
      throw new IllegalArgumentException ();

    String[] data = ((MFString) eventin_).getValueData ();
    data[index] = value;

    sendEvent ();

    scene_.redraw ();
  }
}
