/*
 * MenuDef - Menu structure definition
 * Copyright (c) 1997 IICM
 *
 * created: apesen, 19961212
 *
 * changed: apesen, 19961213
 * changed: kwagen, 19970602
 * changed: mpichler, 19970917
 *
 * $Id: MenuDef.java,v 1.17 1997/09/19 15:44:53 mpichler Exp $
 */

package iicm.vrml.vrwave;

import iicm.widgets.MenuBuilder;

class MenuDef
{
  static final int M_SEPARATOR     = MenuBuilder.SEPARATOR;
  // note: these constants must be consistent with Translator entries!
  // do not delete "@""@" markers, they are parsed by a script

  // File
  static final int M_File          = 0x00;  // @@ MenuFILE
  static final int M_Open          = 0x01;  // @@ FileOPEN : "F3"
  static final int M_OpenLocation  = 0x02;  // @@ "Open Location"
  static final int M_Reload        = 0x03;  // @@ "Reload" : "M-r"
  static final int M_SaveAs        = 0x04;  // @@ FileSAVEAS : "F2"
  static final int M_Export        = 0x05;  // @@ FileEXPORT
  static final int M_ExpVRML       = 0x06;  // @@ "VRML"
  static final int M_ExpSDF        = 0x07;  // @@ "SDF"
  static final int M_Edit          = 0x08;  // @@ FileEDIT : "e"
  static final int M_Print         = 0x09;  // @@ FilePRINT
  static final int M_CameraInfo    = 0x0a;  // @@ SpecialCAMERAINFO
  static final int M_MailTo        = 0x0b;  // @@ FileMAIL
  static final int M_ViewParser    = 0x0c;  // @@ FilePARSERERRORS
  static final int M_Exit          = 0x0d;  // @@ FileEXITVIEWER : "^x"

  // Navigate
  static final int M_Navigate      = 0x10;  // @@ MenuNAVIGATE
  static final int M_Flip          = 0x11;  // @@ NavFLIPOBJECT : "F4"
  static final int M_Walk          = 0x12;  // @@ NavWALK : "F5"
  static final int M_Fly           = 0x13;  // @@ NavFLY : "F6"
  static final int M_FlyTo         = 0x14;  // @@ NavFLYTO : "F7"
  static final int M_HeadsUp       = 0x15;  // @@ NavHEADSUP : "F8"
  static final int M_Viewpoints    = 0x16;  // @@ MenuVIEWPOINTS
  static final int M_PrevViewpoint = 0x17;  // @@ AnchorPREVIOUS : "PgUp"
  static final int M_NextViewpoint = 0x18;  // @@ AnchorNEXT : "PgDn"
  static final int M_ResetView     = 0x19;  // @@ NavigateRESETVIEW : "r"
  static final int M_LevelView     = 0x1a;  // @@ NavigateLEVELVIEW : "l"
  static final int M_UntiltView    = 0x1b;  // @@ NavigateUNTILTVIEW : "u"

  static final int M_Options       = 0x20;  // @@ MenuOPTIONS
  static final int M_OptEMWA       = 0x21;  // @@ OptionENABLEMOTION
  static final int M_OptVContr     = 0x22;  // @@ OptionVELOCITYCONTROL
  static final int M_OptFRContr    = 0x23;  // @@ OptionARBITRARYROTATIONS
  static final int M_OptCollisDet  = 0x24;  // @@ OptionCOLLISIONDETECTION
  static final int M_Settings      = 0x25;  // @@ NavigateSETTINGS
  static final int M_Spaceball     = 0x26;  // @@ NavigateSPACEBALL
  static final int M_Back          = 0x27;  // @@ NavigateBACK : "b"
  static final int M_Forward       = 0x28;  // @@ NavigateFORWARD : "f"
  static final int M_History       = 0x29;  // @@ NavigateHISTORY : "h"
  static final int M_Hold          = 0x2a;  // @@ NavigateHOLD : "H"

  // Anchors
  static final int M_Anchors       = 0x30;  // @@ MenuANCHORS
  static final int M_Attributes    = 0x31;  // @@ DocumentATTRIBUTES : "a"
  static final int M_Follow        = 0x32;  // @@ AnchorFOLLOW : "RET"
  static final int M_DefAsSource   = 0x33;  // @@ AnchorDEFINESOURCE
  static final int M_DefAsDest     = 0x34;  // @@ AnchorDEFINEDESTINATION
  static final int M_UseDefDest    = 0x35;  // @@ AnchorDEFAULTDESTINATION
  static final int M_Delete        = 0x36;  // @@ AnchorDELETE : "DEL"
  static final int M_SelectObj     = 0x37;  // @@ AnchorSELECTOBJECTS
  static final int M_SelectGrp     = 0x38;  // @@ AnchorSELECTGROUPS
  static final int M_DeselectOG    = 0x39;  // @@ AnchorDESELECT

  // Display
  static final int M_Display       = 0x40;  // @@ MenuVIEW
  static final int M_Wireframe     = 0x41;  // @@ DisplayWIREFRAME : "^w"
  static final int M_HiddenLine    = 0x42;  // @@ DisplayHIDDENLINE : "^h"
  static final int M_FlatShading   = 0x43;  // @@ DisplayFLATSHADING : "^f"
  static final int M_SmoothShading = 0x44;  // @@ DisplaySMOOTHSHADING : "^s"
  static final int M_Texturing     = 0x45;  // @@ DisplayTEXTURING : "^t"
  static final int M_Interactive   = 0x46;  // @@ DisplayINTERACTIVE
  static final int M_ITheSame      = 0x47;  // @@ DisplayTHESAME : "^u"
  static final int M_IWireframe    = 0x48;  // @@ DisplayWIREFRAME : "^W"
  static final int M_IHiddenLine   = 0x49;  // @@ DisplayHIDDENLINE : "^H"
  static final int M_IFlatShading  = 0x4a;  // @@ DisplayFLATSHADING : "^F"
  static final int M_ISmoothShad   = 0x4b;  // @@ DisplaySMOOTHSHADING : "^S"
  static final int M_ITexturing    = 0x4c;  // @@ DisplayTEXTURING : "^T"
  static final int M_Behaviour     = 0x4d;  // @@ "Behaviour" : "^b"
  static final int M_Interaction   = 0x4e;  // @@ "Interaction" : "^b"

  static final int M_RenderMode    = 0x50;  // @@ RenderRENDERMODE
  static final int M_RMDepthBuf    = 0x51;  // @@ RenderZBUFFER : "D"
  static final int M_RMBSPTree     = 0x52;  // @@ RenderBSPTREE : "B"
  static final int M_RMPlainBSP    = 0x53;  // @@ RenderBSPPLAIN
  static final int M_RMbfcBSP      = 0x54;  // @@ RenderBSPBACKFACECULLING
  static final int M_RMsvolBSP     = 0x55;  // @@ RenderBSPSHADOWVOLUME
  static final int M_ShowFramerate = 0x56;  // @@ OptionSHOWFRAMERATE
  static final int M_ShowTitle     = 0x57;  // @@ OptionSHOWTITLE

  static final int M_AAliasing     = 0x60;  // @@ OptionAALIASING
  static final int M_AALines       = 0x61;  // @@ OptionAALINES : "^L"
  static final int M_AATexturesOff = 0x62;  // @@ "Textures: Off" : "^N"
  static final int M_AATextures1   = 0x63;  // @@ "1"
  static final int M_AATextures2   = 0x64;  // @@ "2"
  static final int M_AATextures3   = 0x65;  // @@ "3"
  static final int M_AATextures4   = 0x66;  // @@ "4"
  static final int M_AATexturesOn  = 0x67;  // @@ "Textures: On" : "^M"
  static final int M_TwoSidedPoly  = 0x68;  // @@ OptionTWOSIDEDPOLYS
  static final int M_TSPon         = 0x69;  // @@ TwosidedON
  static final int M_TSPauto       = 0x6a;  // @@ TwosidedAUTO
  static final int M_TSPoff        = 0x6b;  // @@ TwosidedOFF

  static final int M_LightnigCalc  = 0x70;  // @@ OptionDOLIGHTING
  static final int M_LCon          = 0x71;  // @@ TwosidedON
  static final int M_LCauto        = 0x72;  // @@ TwosidedAUTO
  static final int M_LCoff         = 0x73;  // @@ TwosidedOFF
  static final int M_LConText      = 0x74;  // @@ OptionTEXTURELIGHTING
  static final int M_LCnoMat       = 0x75;  // @@ OptionNOMATERIAL
  static final int M_Transparency  = 0x76;  // @@ OptionTRANSPARENCY
  static final int M_TPoff         = 0x77;  // @@ TransparencyOFF
  static final int M_TPstipple     = 0x78;  // @@ TransparencySTIPPLE
  static final int M_TPblending    = 0x79;  // @@ TransparencyBLENDING
  static final int M_TPonText      = 0x7a;  // @@ OptionTEXTURELIGHTING

  static final int M_ViewingLight  = 0x80;  // @@ "Headlight"
  static final int M_Anchor        = 0x81;  // @@ MenuANCHORS
  static final int M_ADisplay      = 0x82;  // @@ AnchorDISPLAY : "F9"
  static final int M_ABrightness   = 0x83;  // @@ AnchBRIGHTNESS
  static final int M_AColCode      = 0x84;  // @@ AnchCOLORCODE
  static final int M_AColEdges     = 0x85;  // @@ AnchCOLOREDGES

  static final int M_Colour        = 0x90;  // @@ MenuCOLOR
  static final int M_CChoose       = 0x91;  // @@ "Colours..."
  static final int M_CBackgnd      = 0x92;  // @@ ColorBACKGROUND
  static final int M_CBGndBLACK    = 0x93;  // @@ ColBLACK
  static final int M_CBGndCYAN     = 0x94;  // @@ ColCYAN
  static final int M_CBGndGRAY     = 0x95;  // @@ ColGRAY
  static final int M_CBGndGREEN    = 0x96;  // @@ ColGREEN
  static final int M_CBGndLGRAY    = 0x97;  // @@ ColLIGHTGRAY
  static final int M_CBGndMAGENTA  = 0x98;  // @@ ColMAGENTA
  static final int M_CBGndORANGE   = 0x99;  // @@ ColORANGE
  static final int M_CBGndPURPLE   = 0x9a;  // @@ ColPURPLE
  static final int M_CBGndREDBROWN = 0x9b;  // @@ ColREDBROWN
  static final int M_CBGndYELLOW   = 0x9c;  // @@ ColYELLOW
  static final int M_CBGndWHITE    = 0x9d;  // @@ ColWHITE

  // Help
  static final int M_Help          = 0xa0;  // @@ MenuHELP
  static final int M_Overview      = 0xa1;  // @@ HelpOVERVIEW : "F1"
  static final int M_Index         = 0xa2;  // @@ HelpINDEX
  static final int M_Homepage      = 0xa3;  // @@ "VRwave Homepage"
  static final int M_About         = 0xa4;  // @@ HelpABOUTPRODUCT

  static final int M_NUMMENUITEMS  = 0xa5;  // no. of menu item strings

  // menu structure definition
  static final int[][][] MenuIDs =
  {
    {{ M_File }},
    {
      { M_Open },
      { M_OpenLocation },
      { M_Reload },
      { M_SaveAs },
//       { M_Export,
//           M_ExpVRML,
//           M_ExpSDF
//       },
      { M_Edit },
      { M_Print },
      { M_CameraInfo },
//       { M_MailTo },
      { M_ViewParser },
      { M_SEPARATOR },
      { M_Exit }
    },
    {{ M_Navigate }},
    {
      { M_Flip    | MenuBuilder.RADIOITEM },
      { M_Walk    | MenuBuilder.RADIOITEM },
//       { M_Fly     | MenuBuilder.RADIOITEM },
      { M_FlyTo   | MenuBuilder.RADIOITEM },
      { M_HeadsUp | MenuBuilder.RADIOITEM },
      { M_SEPARATOR },
      { M_Viewpoints,
          M_PrevViewpoint,
          M_NextViewpoint,
        //  M_SEPARATOR,
        // viewpoints should be added dynamically here
      },
      { M_ResetView },
      { M_LevelView },
      { M_UntiltView },
      { M_SEPARATOR },
      { M_Options,
//           M_OptEMWA,
//           M_OptVContr,
//           M_OptFRContr,
//           M_OptCollisDet
      },
      { M_Settings },
//       { M_Spaceball },
//       { M_SEPARATOR },
//       { M_Back },
//       { M_Forward },
//       { M_History },
//       { M_SEPARATOR },
//       { M_Hold }
    },
//     {{ M_Anchors }},
//     {
//       { M_Attributes },
//       { M_Follow },
//       { M_SEPARATOR },
//       { M_DefAsSource },
//       { M_DefAsDest },
//       { M_UseDefDest },
//       { M_SEPARATOR },
//       { M_Delete },
//       { M_SEPARATOR },
//       { M_SelectObj | MenuBuilder.RADIOITEM },
//       { M_SelectGrp | MenuBuilder.RADIOITEM },
//       { M_DeselectOG }
//     },
    {{ M_Display }},
    {
      { M_RenderMode,
          M_Wireframe     | MenuBuilder.RADIOITEM,
          M_HiddenLine    | MenuBuilder.RADIOITEM,
          M_FlatShading   | MenuBuilder.RADIOITEM,
          M_SmoothShading | MenuBuilder.RADIOITEM,
          M_Texturing     | MenuBuilder.RADIOITEM,
//           M_SEPARATOR,
//           M_RMDepthBuf | MenuBuilder.RADIOITEM,
//           M_RMBSPTree  | MenuBuilder.RADIOITEM,
//           M_SEPARATOR,
//           M_RMPlainBSP | MenuBuilder.RADIOITEM,
//           M_RMbfcBSP   | MenuBuilder.RADIOITEM,
//           M_RMsvolBSP  | MenuBuilder.RADIOITEM
      },
      { M_Interactive,
          M_ITheSame     | MenuBuilder.RADIOITEM,
          // M_SEPARATOR,  // all belong into one group
          M_IWireframe   | MenuBuilder.RADIOITEM,
          M_IHiddenLine  | MenuBuilder.RADIOITEM,
          M_IFlatShading | MenuBuilder.RADIOITEM,
          M_ISmoothShad  | MenuBuilder.RADIOITEM,
          M_ITexturing   | MenuBuilder.RADIOITEM
      },
      { M_SEPARATOR },
      { M_Behaviour     | MenuBuilder.TOGGLEITEM },
      { M_Interaction   | MenuBuilder.TOGGLEITEM },
      { M_ShowFramerate | MenuBuilder.TOGGLEITEM },
//       { M_ShowTitle },
      { M_AAliasing,
          M_AALines | MenuBuilder.TOGGLEITEM,
          M_SEPARATOR,
          M_AATexturesOff | MenuBuilder.RADIOITEM,
          M_AATextures1   | MenuBuilder.RADIOITEM,
          M_AATextures2   | MenuBuilder.RADIOITEM,
          M_AATextures3   | MenuBuilder.RADIOITEM,
          M_AATextures4   | MenuBuilder.RADIOITEM,
          M_AATexturesOn  | MenuBuilder.RADIOITEM
      },
      { M_TwoSidedPoly,
          M_TSPon   | MenuBuilder.RADIOITEM,
          M_TSPauto | MenuBuilder.RADIOITEM,
          M_TSPoff  | MenuBuilder.RADIOITEM
      },
      { M_LightnigCalc,
          M_LCon   | MenuBuilder.RADIOITEM,
          M_LCauto | MenuBuilder.RADIOITEM,
          M_LCoff  | MenuBuilder.RADIOITEM,
          M_SEPARATOR,
          M_LConText | MenuBuilder.TOGGLEITEM,
          M_SEPARATOR,
          M_LCnoMat  | MenuBuilder.TOGGLEITEM
      },
      { M_Transparency,
          M_TPoff      | MenuBuilder.RADIOITEM,
          M_TPstipple  | MenuBuilder.RADIOITEM,
          M_TPblending | MenuBuilder.RADIOITEM,
          M_SEPARATOR,
          M_TPonText   | MenuBuilder.TOGGLEITEM
      },
      { M_ViewingLight | MenuBuilder.TOGGLEITEM },
      { M_SEPARATOR },
//       { M_Anchor,
//           M_ADisplay | MenuBuilder.TOGGLEITEM,
//           M_SEPARATOR,
//           M_ABrightness | MenuBuilder.RADIOITEM,
//           M_AColCode    | MenuBuilder.RADIOITEM,
//           M_AColEdges   | MenuBuilder.RADIOITEM
//       },
      { M_CChoose
      },
      { M_CBackgnd,
        M_CBGndBLACK,
        M_CBGndGRAY,
        M_CBGndLGRAY,
        M_CBGndWHITE,
      }
    },
    {{ M_Help }},
    {
      { M_Overview },
      // { M_Index },
      { M_SEPARATOR },
      { M_Homepage },
      { M_SEPARATOR },
      { M_About }
    }
  };

} // MenuDef
