/*
 * <copyright>
 *
 * Copyright (c) 1996,97
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the `pw' VRML 2.0 parser.
 *
 * </copyright>
 */
/*
 * Script.java
 * Copyright (c) 1996,97 IICM
 *
 * created: krosch, 19960824
 *
 * changed: krosch, 19970115
 * changed: apesen, 19970410
 * changed: mpichler, 19970604
 *
 * $Id: Script.java,v 1.7 1997/06/04 17:07:50 mpichler Exp $
 */


package iicm.vrml.pw; 

import java.io.*;
import java.util.*;


// Script

public class Script extends Common
{
  public MFString url;
  public SFBool directOutput, mustEvaluate;

  public final static String STR_URL = "url";
  public final static String STR_DIRECTOUTPUT = "directOutput";
  public final static String STR_MUSTEVALUATE = "mustEvaluate";

  public String nodeName ()
  {
    return NodeNames.NODE_SCRIPT;
  }

  // also Script fields stored in subfields
  // Hashtable scriptfields = new Hashtable ();

  public void traverse (Traverser t)
  {
    t.tScript (this);
  }

  Script ()
  {
    // ordinary fields
    addField (STR_URL, url = new MFString (), Field.F_EXPOSEDFIELD);
    addField (STR_DIRECTOUTPUT, directOutput = new SFBool (false), Field.F_FIELD);
    addField (STR_MUSTEVALUATE, mustEvaluate = new SFBool (false), Field.F_FIELD);
  }

  /**
   * check for base field name (ordinary fields)
   */

  boolean isOrdinaryField (String fname)
  {
    return (fname.equals (STR_URL) || fname.equals (STR_DIRECTOUTPUT) || fname.equals (STR_MUSTEVALUATE));
  }

  /**
   * read the fields (inside "{" ... "}"): static and field declarations
   */

  void readFields (VRMLparser parser)
  {
    StrTokenizer st = parser.istok;
    ParserOutput pout = parser.pout;

    try
    {
      while (st.skipCommentReturn (true) && !st.eof () && st.nextChar () != '}')
      {
        String fclass = st.readIdentifier ();  // field or event class or static field

        // ordinary fields
        Field field = null;
        if (fclass != null && isOrdinaryField (fclass))
          field = (Field) subfields.get (fclass);
        if (field != null)
        {
          String fname = fclass;

          if (pout.debug_)
            pout.debug ("  - reading field " + fname);

          field.readFieldValue (parser);  // may be inside prototype here
          if (field.readError ())
            pout.error ("field " + fname + " had invalid data" + atCurrLine (st));
          continue;
        }
        // else: field/event declaration

        if (fclass == null || !(fclass.equals (Field.STR_FIELD) || fclass.equals (Field.STR_EVENTIN)
          || fclass.equals (Field.STR_EVENTOUT)))
        {
          pout.error ("Script fields must be declared as one of:\n" +
            Field.STR_FIELD + ", "  + Field.STR_EVENTIN + ", " + Field.STR_EVENTOUT +
            ". Got " + fclass + atCurrLine (st));
          return;  // ignore remaining fields
        }

        st.skipComment ();
        if (st.eof () || st.nextChar () == '}')
        { // '}' not read
          pout.error ("premature end of Script field " + fclass + atCurrLine (st));
          return;
        }
        String ftypename = st.readIdentifier ();  // field type name

        st.skipComment ();
        if (ftypename == null || st.eof () || st.nextChar () == '}')
        { // '}' not read
          pout.error ("premature end of field Script field " + fclass + " " + ftypename + atCurrLine (st));
          return;
        }
        String fidname = st.readIdentifier ();  // field identifier name
        if (fidname == null)
        { pout.error ("field identifier expected for Script field " + fclass + " " + ftypename + atCurrLine (st));
          return;
        }

        if (subfields.get (fidname) != null)  // non-unique: error (override)
          pout.error ("Script field " + fidname + " not unique within current SCRIPT" + atCurrLine (st));

        if (pout.debug_)
          pout.debug ("  . reading Script field " + fidname);

        field = FieldNames.createFieldFromName (ftypename);
        if (field != null)
        {
          // scriptfields.put (fidname, field);  // register this field/eventIn/eventOut
          // added to subfields to allow uniform event ROUTEs

          // not only fields, also events may have an IS clause inside PROTO nodes
          field.readISdeclaration (parser);

          if (fclass.equals (Field.STR_FIELD))
          {
            addField (fidname, field, Field.F_FIELD);
            // field.setFieldClass (Field.F_FIELD);
            // read default field value
            field.readValue (parser);
            if (field.readError ())
              pout.error ("Script field " + fidname + " had invalid data" + atCurrLine (st));
          }
          else if (fclass.equals (Field.STR_EVENTIN))
            addField (fidname, field, Field.F_EVENTIN);  // field.setFieldClass (Field.F_EVENTIN);
          else if (fclass.equals (Field.STR_EVENTOUT))
            addField (fidname, field, Field.F_EVENTOUT);  // field.setFieldClass (Field.F_EVENTOUT);
          else
            pout.error ("Internal error. Field classification " + fclass + " not valid");
        }
        else
          pout.error ("invalid field type name " + ftypename + " (no such type)" + atCurrLine (st));
      } // until "}" or EOF
    }
    catch (IOException e)
    {
      pout.error ("IOException on reading Script definitions " + atCurrLine (st));
      return;
    }

    // '}' was not read from stream

  } // readFields

//   public void writeSubfields (PrintStream os, Hashtable writtenrefs)
//   {
//     // ordinary fields
//     super.writeSubfields (os, writtenrefs);

//     // declared script fields/events
//     Enumeration e = scriptfields.keys ();
//     while (e.hasMoreElements ())
//     {
//       String fname = (String) e. nextElement ();
//       Field f = (Field) scriptfields.get (fname);
//       os.print ("\t" + f.getFieldClassName () + " " + f.fieldName () + " " + fname + " ");
//       if ((f.getFieldClass() & Field.F_FIELD) != 0)  // default value only for fields/exposedFields 
//         f.writeFieldValue (os, writtenrefs);
//       os.println ();
//     }
//   }

  /**
   * writeSubfield: output value of fields
   */

  public void writeSubfield (String fname, Field f, PrintStream os, Hashtable writtenrefs)
  {
    // ordinary field
    if (isOrdinaryField (fname))
      super.writeSubfield (fname, f, os, writtenrefs);
    else  // declared script field/event
    {
      os.print ("\t" + f.getFieldClassName () + " " + f.fieldName () + " " + fname + " ");
      if ((f.getFieldClass() & Field.F_FIELD) != 0)  // output value for fields only
        f.writeFieldValue (os, writtenrefs);
      os.println ();
    }
  }

} // Script  
