/*
 * <copyright>
 *
 * Copyright (c) 1996,97
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the `pw' VRML 2.0 parser.
 *
 * </copyright>
 */
/*
 * ReadTest.java
 * pw ("parse world") test app
 * usage: ReadTest VRMLfile
 * Copyright (c) 1997 IICM
 *
 * created: mpichler, 19960724
 *
 * changed: mpichler, 19970414
 *
 * $Id: ReadTest.java,v 1.9 1997/06/04 12:10:29 mpichler Exp $
 */


package iicm.vrml.pw;

import java.io.*;


class ReadTest
{
  public static void main (String args[])
  {
//    System.out.println ("Hello Parser!");
    if (args.length < 1)
    {
      System.out.println ("usage: Readtest VRMLFILE");
      return;
    }

    try
    {
      // VRMLparser parser = new VRMLparser (new FileInputStream (args [0]));
      VRMLparser parser = new VRMLparser (Decompression.filter (args [0]));
      // VRMLparser parser = new VRMLparser (new DecompressionStream (args [0]));  // equivalent
      long time = System.currentTimeMillis ();
      GroupNode root = parser.readStream ();
      time = System.currentTimeMillis () - time;

      System.out.println ("*** Parsing time (ms): " + time);
      if (root != null)
      {
        if (false)  // dump to terminal
        {
          System.out.println ("====================");
          parser.writeHeader (System.out);
          root.writeNodes (System.out);
          System.out.println ("====================");
        }
        else  // dump to file
        {
          FileOutputStream file = new FileOutputStream ("pwout.wrl");
          PrintStream os = new PrintStream (file);  // wrapper
          System.out.println ("=== dumping data to pwout.wrl ===");
          parser.writeHeader (os);
          root.writeNodes (os);
          os.close ();
          System.out.println ("=== finished ===");
        }
      }
      else
      {
        System.out.println ("error on parsing " + args [0]);
        if (parser.getVersion () == 0.0f)
          System.out.println ("unrecognized header");
      }
    }
    catch (IOException e)
    {
      System.out.println ("error on reading " + args [0]);
      // e.printStackTrace ();
      System.out.println (e.getMessage ());  // just prints file name
    }
//     catch (FileNotFoundException e)

  }
} // ReadTest
