/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.debug;

import java.io.FileInputStream;
import java.io.InputStream;
import org.yecht.DefaultYAMLParser;
import org.yecht.NullNodeHandler;
import org.yecht.Parser;
import org.yecht.Pointer;
import org.yecht.TokenScanner;
import org.yecht.YAML;

public class TimeScanning {
    public static void main(String[] args) throws Exception {
        String filename = args[0];
        int len = 8000;
        int read = 0;
        int currRead = 0;
        byte[] buffer = new byte[1024];
        byte[] input = new byte[len];
        FileInputStream is = new FileInputStream(filename);
        while ((currRead = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
            if (read + currRead >= len) {
                input = YAML.realloc(input, len *= 2);
            }
            System.arraycopy(buffer, 0, input, read, currRead);
            read += currRead;
        }
        int times = 10000;
        long before = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            Parser parser = Parser.newParser();
            parser.str(Pointer.create(input, 0), read, null);
            parser.handler(new NullNodeHandler());
            parser.errorHandler(null);
            parser.implicitTyping(true);
            parser.taguriExpansion(true);
            DefaultYAMLParser.yyInput s = TokenScanner.createScanner(parser);
            int tok = -1;
            while (tok != 0) {
                s.advance();
                tok = s.token();
            }
        }
        long after = System.currentTimeMillis();
        System.err.println("scanning " + filename + " " + times + " times took " + (after - before) + "ms");
    }
}

