/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CollocationOptimizationException;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import java.util.HashSet;

public final class RouterInfo {
    private final RouterPrx _router;
    private ObjectPrx _clientProxy;
    private ObjectPrx _serverProxy;
    private ObjectAdapter _adapter;
    private HashSet _identities = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    RouterInfo(RouterPrx router) {
        this._router = router;
        if (!$assertionsDisabled && this._router == null) {
            throw new AssertionError();
        }
    }

    public synchronized void destroy() {
        this._clientProxy = null;
        this._serverProxy = null;
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)obj)._router);
        }
        return false;
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    public synchronized ObjectPrx getClientProxy() {
        if (this._clientProxy == null) {
            this._clientProxy = this._router.getClientProxy();
            if (this._clientProxy == null) {
                throw new NoEndpointException();
            }
            this._clientProxy = this._clientProxy.ice_router(null);
            try {
                this._clientProxy = this._clientProxy.ice_timeout(this._router.ice_getConnection().timeout());
            }
            catch (CollocationOptimizationException collocationOptimizationException) {
                // empty catch block
            }
        }
        return this._clientProxy;
    }

    public synchronized void setClientProxy(ObjectPrx clientProxy) {
        this._clientProxy = clientProxy.ice_router(null);
        try {
            this._clientProxy = this._clientProxy.ice_timeout(this._router.ice_getConnection().timeout());
        }
        catch (CollocationOptimizationException collocationOptimizationException) {
            // empty catch block
        }
    }

    public ObjectPrx getServerProxy() {
        if (this._serverProxy == null) {
            this._serverProxy = this._router.getServerProxy();
            if (this._serverProxy == null) {
                throw new NoEndpointException();
            }
            this._serverProxy = this._serverProxy.ice_router(null);
        }
        return this._serverProxy;
    }

    public void setServerProxy(ObjectPrx serverProxy) {
        this._serverProxy = serverProxy.ice_router(null);
    }

    public synchronized void addProxy(ObjectPrx proxy) {
        if (!$assertionsDisabled && proxy == null) {
            throw new AssertionError();
        }
        if (!this._identities.contains(proxy.ice_getIdentity())) {
            ObjectPrx[] proxies = new ObjectPrx[]{proxy};
            ObjectPrx[] evictedProxies = this._router.addProxies(proxies);
            this._identities.add(proxy.ice_getIdentity());
            for (int i = 0; i < evictedProxies.length; ++i) {
                this._identities.remove(evictedProxies[i].ice_getIdentity());
            }
        }
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        this._adapter = adapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    static {
        $assertionsDisabled = !RouterInfo.class.desiredAssertionStatus();
    }
}

