/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "WAVEdit.h"

#include "common/Exception.h"
#include "common/SoundFile.h"

int main(int argc, char *argv[])
{
	if (argc < 6) {
		::fprintf(stderr, "Usage: WAVEdit <start time> <end time> <samle rate> <infile> <outfile>\n");
		return 1;
	}

	int        startTime = ::atoi(argv[1]);
	int          endTime = ::atoi(argv[2]);
	int         sampRate = ::atoi(argv[3]);
	wxString inFileName  = wxString(argv[4]);
	wxString outFileName = wxString(argv[5]);

	try {
		CWAVEdit noise(startTime, endTime, sampRate, inFileName, outFileName);
		noise.run();
	}
	catch (CException& ex) {
		::fprintf(stderr, "WAVEdit: error: %s\n", ex.getMessage().c_str());
		return 1;
	}
	catch (...) {
		::fprintf(stderr, "WAVEdit: an error has occured\n");
		return 1;
	}

	return 0;
}

CWAVEdit::CWAVEdit(int startTime, int endTime, int sampRate, const wxString& inFileName, const wxString& outFileName) :
m_startTime(startTime),
m_endTime(endTime),
m_sampRate(sampRate),
m_inFileName(inFileName),
m_outFileName(outFileName)
{
}

CWAVEdit::~CWAVEdit()
{
}

void CWAVEdit::run()
{
	int startSamp = m_startTime * m_sampRate;
	int   endSamp = m_endTime * m_sampRate;

	CSoundFile in(m_inFileName, m_sampRate);
	in.openRead();

	CSoundFile out(m_outFileName, m_sampRate, 8);
	out.openWrite();

	for (int i = 0; i < endSamp; i++) {
		double audio;
		int len = 1;
		in.read(&audio, len);

		if (len <= 0) break;

		if (i >= startSamp)
			out.write(&audio, len);
	}

	in.close();
	out.close();
}
