/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MMessage.h"

#include <wx/listimpl.cpp>

WX_DEFINE_LIST(CJT6MMessageList);

CJT6MMessage::CJT6MMessage(const wxString& id, double time, int length, int strength, int DF, int count, const wxString& text) :
m_id(id),
m_time(time),
m_length(length),
m_strength(strength),
m_df(DF),
m_count(count),
m_text(text)
{
}

CJT6MMessage::~CJT6MMessage()
{
}

wxString CJT6MMessage::getId() const
{
	return m_id;
}

double CJT6MMessage::getTime() const
{
	return m_time;
}

int CJT6MMessage::getLength() const
{
	return m_length;
}

int CJT6MMessage::getStrength() const
{
	return m_strength;
}

int CJT6MMessage::getDF() const
{
	return m_df;
}

int CJT6MMessage::getCount() const
{
	return m_count;
}

wxString CJT6MMessage::getText() const
{
	return m_text;
}
