/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MSend.h"
#include "JT6MCardReceive.h"
#include "JT6MController.h"

CJT6MController::CJT6MController(ISoundDev* soundDev, CPTTPort* pttPort) :
CController(soundDev, pttPort)
{
}

CJT6MController::~CJT6MController()
{
}

CSend* CJT6MController::createSendThread(const wxString& name, ISoundDev* soundDev, CPTTPort* pttPort)
{
	CSend* send = new CJT6MSend(name, soundDev, pttPort);

	send->Create();
	send->Run();

	return send;
}

CReceive* CJT6MController::createReceiveThread(const wxString& name, ISoundDev* soundDev, EWho who)
{
	CReceive* receive = new CJT6MCardReceive(name, soundDev, who);

	receive->Create();
	receive->Run();

	return receive;
}
