/*
 *   Copyright (C) 2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	RingBuffer_H
#define	RingBuffer_H

#include <wx/wx.h>

class CRingBuffer {

    public:
    	CRingBuffer(int size);
	virtual ~CRingBuffer();

	virtual void empty();
	virtual bool isEmpty() const;
	virtual int  getEmptyLength() const;
	virtual int  getDataLength() const;

	virtual int  putData(double* data, int len);
	virtual int  putData(float* data, unsigned long len);

	virtual int  getData(double* data, int len);
	virtual int  getData(float* data, unsigned long len);

    private:
	int     m_size;
	double* m_buffer;
	int     m_inPtr;
	int     m_outPtr;
};

#endif
