/*
 *   Copyright (C) 2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "PathPreferences.h"

const int BORDER_SIZE = 5;

CPathPreferences::CPathPreferences(wxWindow* parent, int id, const wxString& audioPath, const wxString& textPath) :
wxPanel(parent, id),
m_audioPath(NULL),
m_textPath(NULL)
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	wxBoxSizer* audioSizer = new wxBoxSizer(wxHORIZONTAL);

	wxSize labelSize(75, -1);
	wxSize textSize(200, -1);

	wxStaticText* audioLabel = new wxStaticText(this, -1, wxT("Sound Files"), wxDefaultPosition, labelSize);
	audioSizer->Add(audioLabel, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	m_audioPath = new wxTextCtrl(this, -1, audioPath, wxDefaultPosition, textSize);
	audioSizer->Add(m_audioPath, 0, wxALL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(audioSizer, 0, wxALL, BORDER_SIZE);

	wxBoxSizer* textSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* textLabel = new wxStaticText(this, -1, wxT("Text Files"), wxDefaultPosition, labelSize);
	textSizer->Add(textLabel, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	m_textPath = new wxTextCtrl(this, -1, textPath, wxDefaultPosition, textSize);
	textSizer->Add(m_textPath, 0, wxALL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(textSizer, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}


CPathPreferences::~CPathPreferences()
{
}

wxString CPathPreferences::getAudioPath() const
{
	wxASSERT(m_audioPath != NULL);

	return m_audioPath->GetValue();
}

wxString CPathPreferences::getTextPath() const
{
	wxASSERT(m_textPath != NULL);

	return m_textPath->GetValue();
}
