(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.

Lemma mean1 : forall x y:Z, (x <= y)%Z -> (x <= (x + y) / 2)%Z.
Proof.
intros.
assert ((x + y) / 2 >= (x + x) / 2)%Z.
apply Z_div_ge; omega.
assert (((x + x) / 2)%Z = x); auto with *.
replace (x + x)%Z with (0 + x * 2)%Z; auto with *.
rewrite (Z_div_plus 0 x 2); auto with *.
Qed.

Lemma mean2 : forall x y:Z, (x < y)%Z -> ((x + y) / 2 < y)%Z.
Proof.
intros.
apply (Zmult_lt_reg_r ((x + y) / 2) y) with (p:=2).
auto with *.
replace ((x + y) / 2 * 2)%Z with (2 * ((x + y) / 2))%Z; auto with *.
assert (2 * ((x + y) / 2) <= x + y)%Z.
apply (Z_mult_div_ge (x + y) 2).
auto with *.
omega.
Qed.

Hint Resolve mean1 mean2 .

Proof.
intuition.
ring ((x+1)*(x+1)).
assert (0 <= x*x); auto with *.
Save.

Proof.
intuition.
Save.

Proof.
intuition.
subst sup0; trivial.
subst.
replace (inf + sup + 1)%Z with (inf + (sup - 1) + 1 * 2)%Z;
 try omega.
rewrite Z_div_plus; try omega.
assert (inf <= (inf + (sup - 1)) / 2)%Z.
apply mean1; omega.
omega.
unfold Zwf.
split; try omega.
subst.
 replace (inf + sup + 1)%Z with (inf + 1 + sup)%Z; try omega.
assert ((inf + 1 + sup) / 2 < sup)%Z.
apply mean2; omega.
omega.
Save.

Proof.
intuition.
subst; omega.
subst.
replace (inf + sup + 1)%Z with (inf + 1 + sup)%Z; try omega.
assert ((inf + 1 + sup) / 2 < sup)%Z.
apply mean2; omega.
omega.
unfold Zwf; split; try omega.
subst.
replace (inf + sup + 1)%Z with (inf + 1 + sup)%Z; try omega.
assert (inf + 1 <= (inf + 1 + sup) / 2)%Z.
apply mean1; omega.
omega.
Save.

Proof.
intuition.
subst sup; omega.
Qed.


