#!/usr/local/bin/perl
# Execute a backup on schedule

$no_acl_check++;
require './backup-config-lib.pl';
&foreign_require("mailboxes", "mailboxes-lib.pl");

# Get the backup
$backup = &get_backup($ARGV[0]);
$backup || die "Failed to find backup $ARGV[0]";

# Do it
@mods = split(/\s+/, $backup->{'mods'});
$err = &execute_backup(\@mods, $backup->{'dest'}, \$size);

# Send off the results
if (($err || $backup->{'emode'} == 0) && $backup->{'email'}) {
	foreach $m (@mods) {
		%minfo = &get_module_info($m);
		$mlist .= "    $minfo{'desc'}\n";
		}
	$host = &get_system_hostname();
	$nice = &nice_dest($backup->{'dest'});
	$nice =~ s/<[^>]+>//g;
	$err =~ s/<[^>]+>//g;
	if ($err) {
		$msg = "Backup of modules:\n".
		       $mlist.
		       "\n".
		       "to $nice failed :\n\n".
		       "    $err\n";
		$subject = "Configuration backup on $host failed";
		}
	else {
		$msg = "Backup of modules:\n".
		       $mlist.
		       "\n".
		       "to $nice succeeded.\n".
		       "Final backup file size was ".&nice_size($size)."\n";
		$subject = "Configuration backup on $host succeeded";
		}
	$mail = { 'headers' => [ [ 'From', $config{'from_addr'} ||
					   "webmin\@$host" ],
				 [ 'To', $backup->{'email'} ],
				 [ 'Subject', $subject ] ],
		  'body' => $msg };
	&mailboxes::send_mail($mail);
	}

