# proc-monitor.pl
# Check if some process is running

sub get_proc_status
{
&foreign_require("proc", "proc-lib.pl");
foreach $p (&foreign_call("proc", "list_processes")) {
	if ($p->{'args'} =~ /$_[0]->{'cmd'}/i) {
		return { 'up' => 1,
			 'desc' => &text('proc_pid', $p->{'pid'}) };
		}
	}
return { 'up' => 0 };
}

sub show_proc_dialog
{
print "<tr> <td><b>$text{'proc_cmd'}</b></td>\n";
print "<td><input name=cmd size=20 value='$_[0]->{'cmd'}'></td>\n";
}

sub parse_proc_dialog
{
&depends_check($_[0], "proc");
$in{'cmd'} || &error($text{'proc_ecmd'});
$_[0]->{'cmd'} = $in{'cmd'};
}

