#!/usr/local/bin/perl
# delete_pack.cgi
# Ask if the user wants to delete a package, and if so do it

require './cluster-software-lib.pl';
&foreign_require("software", "software-lib.pl");
&ReadParse();

@servers = &list_servers();
@hosts = &list_software_hosts();
if ($in{'server'} < 0) {
	# Find servers that have the package
	foreach $h (@hosts) {
		foreach $p (@{$h->{'packages'}}) {
			if ($p->{'name'} eq $in{'package'}) {
				local ($s) = grep { $_->{'id'} == $h->{'id'} }
						  @servers;
				push(@got, $s);
				$gotmap{$s} = $h;
				$best = $s if (!$s->{'id'});
				last;
				}
			}
		}
	$s = $best ? $best : $got[0];
	}
else {
	($s) = grep { $_->{'id'} == $in{'server'} } @servers;
	($h) = grep { $_->{'id'} == $in{'server'} } @hosts;
	@got = ( $s );
	$gotmap{$s} = $h;
	}
&remote_foreign_require($s->{'host'}, "software", "software-lib.pl");

# Setup error handler for down hosts
sub del_error
{
$del_error_msg = join("", @_);
}
&remote_error_setup(\&del_error);

&header($text{'delete_title'}, "", "delete_pack");
print "<hr>\n";
if ($in{'sure'}) {
	# do the deletion in separate processes
	print "<br><b>",&text('delete_header', $in{'package'}),"</b><p>\n";
	$p = 0;
	foreach $g (@got) {
		local ($rh = "READ$p", $wh = "WRITE$p");
		pipe($rh, $wh);
		if (!fork()) {
			close($rh);
			&remote_foreign_require($g->{'host'}, "software",
					     "software-lib.pl") if ($s ne $g);
			local $error = &remote_foreign_call($g->{'host'},
			   "software", "delete_package", $in{'package'}, \%in);
			if ($del_error_msg) {
				print $wh &serialise_variable($del_error_msg);
				}
			elsif ($error) {
				print $wh &serialise_variable($error);
				}
			else {
				print $wh &serialise_variable("");
				}
			close($wh);
			exit;
			}
		close($wh);
		$p++;
		}

	# Read back the results
	$p = 0;
	foreach $g (@got) {
		local $rh = "READ$p";
		local $line = <$rh>;
		local $rv = &unserialise_variable($line);
		close($rh);
		local $d = $g->{'desc'} ? $g->{'desc'} : $g->{'host'};

		if ($rv) {
			print &text('delete_error', $d, $rv),"<br>\n";
			}
		else {
			print &text('delete_success', $d),"<br>\n";
			local $h = $gotmap{$g};
			local @newpacks = grep { $_->{'name'} ne $in{'package'} } @{$h->{'packages'}};
			$h->{'packages'} = \@newpacks;
			&save_software_host($h);
			}

		$p++;
		}
	print "<p><b>$text{'delete_done'}</b><p>\n";
	}
else {
	# Ask if the user is sure..
	$n = &remote_foreign_call($s->{'host'}, "software", "check_files",
				  $in{'package'});
	$files = &remote_eval($s->{'host'}, "software", "\\%files");
	$sz = 0;
	for($i=0; $i<$n; $i++) {
		if ($files->{$i,'type'} == 0) { $sz += $files->{$i,'size'}; }
		}
	print "<center>\n";
	if ($in{'server'} < 0) {
		print &text('delete_rusure', "<b>$in{'package'}</b>", $n, $sz),"<br>\n";
		}
	else {
		print &text('delete_rusure2', "<b>$in{'package'}</b>", $n, $sz,
			    $s->{'desc'} ? $s->{'desc'} : $s->{'host'}),"<br>\n";
		}
	print "<form action=delete_pack.cgi>\n";
	print "<input type=hidden name=package value=\"$in{'package'}\">\n";
	print "<input type=hidden name=server value=\"$in{'server'}\">\n";
	print "<input type=hidden name=sure value=1>\n";
	print "<input type=hidden name=search value=\"$in{'search'}\">\n";
	print "<input type=submit value=\"$text{'delete_ok'}\"><p>\n";
	if (defined(&software::delete_options)) {
		&foreign_call("software", "delete_options", $p);
		}
	print "</center></form>\n";
	}

&remote_finished();
print "<hr>\n";
&footer("", $text{'index_return'});

