#!/usr/local/bin/perl
# save_forwarding.cgi
# Save global forwarding options

require './bind8-lib.pl';
%access = &get_module_acl();
$access{'defaults'} || &error($text{'forwarding_ecannot'});
&error_setup($text{'forwarding_err'});
&ReadParse();

&lock_file($config{'chroot'}.$config{'named_conf'});
$conf = &get_config();
$options = &find("options", $conf);
&save_address('forwarders', $options, 1, 1);
&save_choice('forward', $options, 1);
&save_opt('max-transfer-time-in', \&check_mins, $options, 1);
&save_choice('transfer-format', $options, 1);
&save_opt('transfers-in', \&check_trans, $options, 1);

&flush_file_lines();
&unlock_file($config{'chroot'}.$config{'named_conf'});
&webmin_log("forwarding", undef, undef, \%in);
&redirect("");

sub check_mins
{
return $_[0] =~ /^\d+$/ ? undef : $text{'forwarding_emins'};
}

sub check_trans
{
return $_[0] =~ /^\d+$/ ? undef : $text{'forwarding_etrans'};
}

