// Clears the resize options
function webdeveloper_clearResize()
{
    window.opener.webdeveloper_resizeDescription = null;
    window.opener.webdeveloper_resizeHeight      = null;
    window.opener.webdeveloper_resizeViewport    = false;
    window.opener.webdeveloper_resizeWidth       = null;
}

// Initializes the resize dialog box
function webdeveloper_initializeResize()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the first argument equals add
    if(window.arguments[0] == "add")
    {
        document.title = stringBundle.getString("webdeveloper_addResize");
    }
    else
    {
        document.title = stringBundle.getString("webdeveloper_editResize");

        document.getElementById("webdeveloper.resize.description").value = window.arguments[1];
        document.getElementById("webdeveloper.resize.width").value       = window.arguments[2];
        document.getElementById("webdeveloper.resize.height").value      = window.arguments[3];
        document.getElementById("webdeveloper.resize.viewport").checked  = window.arguments[4];
    }
}

// Saves the resize option
function webdeveloper_saveResize()
{
    var description  = document.getElementById("webdeveloper.resize.description").value.trim();
    var errors       = "";
    var height       = document.getElementById("webdeveloper.resize.height").value.trim();
    var stringBundle = document.getElementById("webdeveloper-string-bundle");
    var viewport     = document.getElementById("webdeveloper.resize.viewport").checked;
    var width        = document.getElementById("webdeveloper.resize.width").value.trim();

    // If the description is empty
    if(!description)
    {
        errors += stringBundle.getString("webdeveloper_emptyDescription") + "\n";
    }

    // If the width is empty or not a number or less than zero
    if(!width || parseInt(width) != width || width <= 0)
    {
        errors += stringBundle.getString("webdeveloper_invalidWidth") + "\n";
    }

    // If the height is empty or not a number or less than zero
    if(!height || parseInt(height) != height || height <= 0)
    {
        errors += stringBundle.getString("webdeveloper_invalidHeight") + "\n";
    }

    // If there are errors
    if(errors)
    {
        webdeveloper_error(errors.trim());

        return false;
    }
    else
    {
        window.opener.webdeveloper_resizeDescription = description;
        window.opener.webdeveloper_resizeHeight      = height;
        window.opener.webdeveloper_resizeViewport    = viewport;
        window.opener.webdeveloper_resizeWidth       = width;

        return true;
    }
}
