/*****************************************************************************
 * This software is Copyright (C) 1998 by Rafal Wierzbicki. I accept no
 * responsibility for anything this software may or may not do to your system
 * - you use it completely at your own risk. This software comes under the GPL
 * licence. See the COPYING file for full legal details.
 *
 * $Id: wallp.h,v 1.3 1999/03/25 22:51:29 rafal Exp $
 *****************************************************************************/
#ifndef WALLP_H
#define WALLP_H

#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include "../config.h"
enum image_style { NONE = 0, CENTER, TILE, SCALE, ASPECT };

enum image_style STYLE;
int PREVIEW_ONLY;
int AUTO_START;
unsigned int no_of_list_items;
char init_entry[7];
GtkWidget *preview_area;
GtkWidget *icon_area;
GtkWidget *list;
GtkEntry  *entry;
Display *dpy;

void read_list_from_file(char *oldstyle);
char *style_string(void);
int parse_style(char *string);
void write_control_file(void);
void dump_list_to_file(void);
void select_row(int selection);
void create_list(void);
void list_add(gchar *buffer);
int put_image_on_root (char *imageFile, int STYLE);
int preview (char *imageFile, int STYLE);
void init_wallp (void);
void wallp_logo (void);

#endif
