/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb/vdkb_table.h>
#include <vdkb/vdkb_tabledlg.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_widpopmenu.h>
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBTable
// put here vdk class name string
#define VDK_CLASS "VDKTable"
// put here vdk class name
#define VDK_ANCESTOR  VDKTable
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "table"

//=================================================================
extern char* wi_widget_prompts[];
static char buff[128];
int CLASS::Counter = 0;

/*
 properties
 */
char* vdktable_props[] =
{
COLSPACING,
ROWSPACING,
ROWS_INTERNAL,
COLUMNS_INTERNAL,
HOMOGENEOUS,
0
};

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);


/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
/*
 */
bool
CLASS::OnButtonPressed(VDKObject* sender, GdkEvent* event)
{
  // pass to ancestor so widget will be marked
  VDKBEventContainer::OnButtonPressed(this,event);
  return true;
}
//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner,
		     int rows,int cols,bool homo):
  VDKBEventContainer(name,owner),rows(rows),cols(cols),homo(homo)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer,
		     int rows,int cols,bool homo):
    VDKBEventContainer(name,outer->Owner()),rows(rows),cols(cols),homo(homo)
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  Init();
 }
/*
 */
void
CLASS::Init()
{
  int t;
  // add  frame properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdktable_props[t]; t++)
    proplist.add(VDKBProperty(vdktable_props[t]));

  SetPropValue(COLSPACING,"2");
  SetPropValue(ROWSPACING,"2");
  sprintf(buff,"%d",rows);
  SetPropValue(ROWS_INTERNAL,buff);
  sprintf(buff,"%d",cols);
  SetPropValue(COLUMNS_INTERNAL,buff);
  SetPropValue(HOMOGENEOUS,homo ? CHECK_TRUE : CHECK_FALSE);
  AddBox(name);
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  delBox = new VDKMenuItem(popmenu,_("Remove table"));
  setsize = new VDKMenuItem(popmenu,_(wi_widget_prompts[19]));
  selectparent =  new VDKMenuItem(popmenu,_(wi_widget_prompts[20]));
  SignalConnect(selectparent,"activate",
		&CLASS::SelectParentContainer);
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  SignalConnect(setsize,"activate",&CLASS::SetBoxSize);
  EventConnect("button_press_event", &CLASS::OnButtonPressed);
  EventConnect("button_release_event",&VDKBObject::ButtonReleased);
  EventConnect("enter_notify_event",&VDKBObject::OnEnter);
  EventConnect("leave_notify_event",&VDKBObject::OnLeave);
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
}
/*
 */
void
CLASS::AddBox(char* name)
{
  container = gtk_table_new(rows,cols,homo);
  gtk_table_set_row_spacings(GTK_TABLE(container),2);
  gtk_table_set_col_spacings(GTK_TABLE(container),2);
  gtk_container_add(GTK_CONTAINER(widget),container);
  gtk_widget_show(container);
}

/*
we use justify for row and expand for col
really only boxes should be added
to a table here
FIX ME: check obj class here !!
extra args unused
 */
void
CLASS::AddWidget(VDKObject* obj, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  int row = justify;
  int col = expand;
  VDKBEventContainer::Add(obj,l_justify,true,fill,padding);
  gtk_table_attach(GTK_TABLE(container),
		   obj->Widget(),
		   col,col+1,row,row+1,
		   GtkAttachOptions(GTK_FILL | GTK_EXPAND),
		   GtkAttachOptions(GTK_FILL | GTK_EXPAND),
		   padding,padding);

  VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(obj);
  if(vdkbobj)
    {
      VDKBEventBox* box = dynamic_cast<VDKBEventBox*>(vdkbobj);
      if(box)
	{
	  sprintf(buff,"%d",row);
	  box->SetPropValue(TABLEROW,buff);
	  sprintf(buff,"%d",col);
	  box->SetPropValue(TABLECOL,buff);
	  box->PreviewFlag = true;
	  box->Outerbox(this);
	}
    }
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  int r =3,c = 3;
  CLASS* table = NULL;
  // ask to user how many rows and cols
  for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      owner->ChildWithName(buff)!= (VDKObject*) NULL;
      CLASS::Counter++)
    sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
  Vdkb_tabledlgForm* dlg = new Vdkb_tabledlgForm(owner,NULL,&r,&c);
  dlg->Setup();
  dlg->ShowModal();
  // user cancelled
  if (!r || !c)
    return 3;
  if(owner->Active)
    {
      table = new CLASS(buff,owner,r,c,true);
      int y,z;
      for(y = 0; y < r; y++)
	for (z = 0; z < c; z++)
	  {
	    for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
		owner->ChildWithName(buff) != (VDKObject*) NULL;
		VDKBEventBox::Counter++)
	      sprintf(buff,"vbox%d",VDKBEventBox::Counter);
	    VDKBEventBox *box = new VDKBEventBox(buff,table);
	    table->AddWidget(box,y,z);
	  }
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      table->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      table->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(table,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	  container->AddWidget(table);
	  table->outerbox = container;
	}
      else if(! owner->Active->AddToParent(table,ev))
	// target isn't a container
	  result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result && table)
    table->Destroy();
 return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventContainer::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;", PROP_ROWS_INTERNAL,
	  (char*) GetProp(ROWS_INTERNAL));
  fprintf(fp,"\n\t%s%s;", PROP_COLUMNS_INTERNAL,
	  (char*) GetProp(COLUMNS_INTERNAL));
  fprintf(fp,"\n\t%s%s;", PROP_ROWSPACING,
	  (char*) GetProp(ROWSPACING));
  fprintf(fp,"\n\t%s%s;", PROP_COLSPACING,
	  (char*) GetProp(COLSPACING));
  fprintf(fp,"\n\t%s%s;", PROP_HOMOGENEOUS,
	  (char*) GetProp(HOMOGENEOUS));
}
/*
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char bw[16];
  char arg[16];
  int rowspace = 2;
  int colspace = 2;
  //  char arg[128];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];
  // rows, columns, homogeneous
  int rows = 2,cols = 2;
  if(parser.GetParam(arg,buffer,PROP_ROWS_INTERNAL))
    rows = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_COLUMNS_INTERNAL))
    cols = atoi(arg);
  bool  homogeneous =
    !strcmp(parser.GetParam(arg,buffer,PROP_HOMOGENEOUS),CHECK_TRUE);
  if(parser.GetParam(arg,buffer,PROP_ROWSPACING) &&
     strcmp(arg,NIHIL_PROP))
    rowspace = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_COLSPACING) &&
     strcmp(arg,NIHIL_PROP))
    colspace = atoi(arg);

  sprintf(temp,"\n%s = new VDKTable(this,%d,%d,%s);" ,
	  obj_name, rows,cols,homogeneous ? CHECK_TRUE : CHECK_FALSE);
  strcpy(source,temp);
  sprintf(temp,"\n%s->RowSpacing = %d;\n%s->ColSpacing = %d;",
	  obj_name,rowspace,obj_name,colspace);
  strcat(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }

  if(parser.GetParam(bw,buffer,PROP_BORDERWIDTH) &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[32];
  CLASS* table;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0,homogeneous;
  int bw; // border width
  int rowspace = 2;
  int colspace = 2;
  //
  int rows = 2,cols = 2;
  if(parser.GetParam(arg,buffer,PROP_ROWS_INTERNAL))
    rows = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_COLUMNS_INTERNAL))
    cols = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification =  atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand =  atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
  homogeneous = !strcmp(parser.GetParam(arg,buffer,PROP_HOMOGENEOUS),
			CHECK_TRUE);
  if(parser.GetParam(arg,buffer,PROP_BORDERWIDTH) &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  if(parser.GetParam(arg,buffer,PROP_ROWSPACING) &&
     strcmp(arg,NIHIL_PROP))
    rowspace = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_COLSPACING) &&
     strcmp(arg,NIHIL_PROP))
    colspace = atoi(arg);

  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      table = new CLASS(obj_name,owner->InnerBox(),rows,cols,homogeneous);
      gtk_table_set_row_spacings (GTK_TABLE(table->Container()),rowspace);
      gtk_table_set_col_spacings (GTK_TABLE(table->Container()),colspace);
      owner->AddWidget(table,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  table = new CLASS(obj_name,container,rows,cols,homogeneous);
	  gtk_table_set_row_spacings (GTK_TABLE(table->Container()),rowspace);
	  gtk_table_set_col_spacings (GTK_TABLE(table->Container()),colspace);
	  container->AddWidget(table,justification,expand,
			       fill,padding,true);
	  table->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  // call ancestor to set common properties
  VDKBObject::CreateWidget(table,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    table->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      table->BorderWidth(bw);
      sprintf(buff,"%d",bw);
      table->SetPropValue(BORDERWIDTH,buff);
    }
  sprintf(buff,"%d",rowspace);
  table->SetPropValue(ROWSPACING,buff);
  sprintf(buff,"%d",colspace);
  table->SetPropValue(COLSPACING,buff);
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */

VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKString True = CHECK_TRUE;
  int bw = 0;
  VDKBox* tframe = dynamic_cast<VDKBox*>(VDKBEventContainer::ExtraWidget(isp));
  if(!tframe)
    return NULL;
  VDKTable *table = new VDKTable(inspector,4,2);
  table->SetSize(219,-1);

  homogeneous = new VDKCheckButton(inspector,_("Homogeneous"));
  table->AddToCell(homogeneous,0,1);
  homogeneous->Checked = GetProp("Homogeneous") == True;
  homogeneous->Parent(this);
  SignalConnect(homogeneous,"toggled",&CLASS::OnSetHomogeneous);

  table->AddToCell(new VDKLabel(inspector,_("Rows spacing:")),1,0);
  bw = atoi( (char*) GetProp(ROWSPACING));
  rowspacing = new VDKSpinButton(inspector, bw, 0, 20 , 1 ,0 );
  rowspacing->SetSize(100,-1);
  table->AddToCell(rowspacing,1,1);

  table->AddToCell(new VDKLabel(inspector,_("Columns spacing:")),2,0);
  bw = atoi( (char*) GetProp(COLSPACING));
  colspacing = new VDKSpinButton(inspector, bw, 0, 20 , 1 ,0 );
  colspacing->SetSize(100,-1);
  table->AddToCell(colspacing,2,1);

  VDKLabelButton* sbutton =
    new VDKLabelButton(inspector,_("Change spacing"));
  table->AddToCell(sbutton,3,1);
  sbutton->Parent(this);
  SignalConnect(sbutton,"clicked",&CLASS::OnRowColSpacing);
  tframe->Add(table,l_justify,false,false,false);
  return tframe;
}

/*
 */
bool
CLASS::OnSetHomogeneous(VDKObject*)
{
  SetPropValue(HOMOGENEOUS, 
	       homogeneous->Checked ? CHECK_TRUE : CHECK_FALSE);
  homo = homogeneous->Checked ? true : false;
  gtk_table_set_homogeneous  (GTK_TABLE(container),
			      homogeneous->Checked ? true : false);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnRowColSpacing(VDKObject*)
{
  sprintf(buff,"%d",(int) rowspacing->ValueAsInt);
  SetPropValue(ROWSPACING,buff);
  gtk_table_set_row_spacings (GTK_TABLE(container),
			      (int) rowspacing->ValueAsInt);
  sprintf(buff,"%d",(int) colspacing->ValueAsInt);
  SetPropValue(COLSPACING,buff);
  gtk_table_set_col_spacings (GTK_TABLE(container),
			      (int) colspacing->ValueAsInt);
  inspector->FormNeedToBeChanged();
  return true;
}


