/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_packer_h
#define _vdkb_packer_h

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_evbox.h>
#include <vdk/menu.h>
#include <vdk/vdkpacker.h>


class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBPacker: public VDKBEventContainer
{
 protected:
  VDKPacker* packer;
  VDKMenuItem *delBox;
  VDKMenuItem *delwidget,*setsize;
  // property controls used by object inspector
  VDKLabelButton* set;
  void Init();
 public:
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  VDKObjectContainer*  ExtraWidget(VDKBObjectInspector* isp);
  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKBPacker(char* name, VDKForm* owner);
  VDKBPacker(char* name, VDKBEventContainer* outer);
  virtual ~VDKBPacker() {}
  void AddBox();
  void PopMenu() { popmenu->Popup(); }

  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);


  bool DelBox(VDKObject* sender);

  virtual int Type() { return vdkbpacker_class; }

  virtual int isA() { return vdkbpacker_class; }

  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);

  virtual char* VDKName() { return "VDKPacker"; }
  bool SetBoxSize(VDKObject* sender);
  // designer
  DECLARE_EVENT_LIST(VDKBPacker);
  DECLARE_SIGNAL_LIST(VDKBPacker);
};

#endif

