/***************************************************************************
                          dchubsearch.h  -  description
                             -------------------
    begin                : Fri Mar 15 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCHUBSEARCH_H
#define DCHUBSEARCH_H

/**
  *@author Mathias Kster
  */

#include <qtimer.h>
#include <qworkspace.h>

#include <DCDialogHubSearch.h>
#include <dclib/csearchmanager.h>
#include <dcwidget.h>

class QStringList;

typedef enum eGroupSearchResultType {
	egsrtNONE,
	egsrtFILE,
	egsrtSIZE,
	egsrtNICK,
	egsrtSLOTS_FREE,
	egsrtHUB,
	egsrtPATH,
	egsrtHOST,
	egsrtHASH
} eGroupSearchResultType;

class DCHubSearch : public DCDialogHubSearch  {
Q_OBJECT

public:
	/** construtor */
	DCHubSearch(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCHubSearch();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** search result */
	bool DC_SearchResult( CMessageSearchResult * MessageSearchResult );

	/** callback function */
	int DC_CallBack( CObject *, CObject * );

	/** overridden so that the columns are resized on show() */
	virtual void show();

	/** */
	void StopSearch() { m_SearchManager.StopSearch(); };
	/** */
	bool IsSearch() { return m_SearchManager.IsSearch(); };

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );
	/** event filter */
	bool eventFilter( QObject * object, QEvent * event );

private:
	/** */
	void DC_LogMessage( CMessageLog * MessageLog );

	/** show all search results */
	void ShowResults( bool bClearList );

	/** */
	void SetSearchView( bool enabled );

	/** get the search string with protocol */
	CDCMessage * GetSearchObject();
	/** */
	void UpdateHidden( bool SearchFileOnly, int FreeSlots, bool Filter=FALSE );
        /** */
	int selectedItems(QListView * list,QPtrList<QListViewItem> & lst);

	/** */
	QListViewItem * ShowSearchResult( CMessageSearchResult * MessageSearchResult, QListView * parent );
	/** */
	QListViewItem * ShowSearchResult( CMessageSearchResult * MessageSearchResult, DC_ListResult * parent );
	/** */
	bool AddSearchResult( CMessageSearchResult * MessageSearchResult, DC_ListResult * item );

	/** */
	void GroupSearchResults( eGroupSearchResultType type );

	/** */
	void RemoveSelectedSearch( QPtrList<QListViewItem> * );

	/** */
	void startSearch();
	/** */
	void addHistory( CDCMessage * msg = 0 );

	/** store all messages from udp socket */
	CList<CObject> * m_pMessageList;
	/** */
	CList<CObject> * m_pSearchQueryList;
	/** store all search results */
	CList<CObject> * m_pSearchResultList;
	/** search history */
	CList<CDCMessage> * m_pSearchHistory;
	/** */
	CThread SocketCallbackThread;
	/** */
	QWorkspace *m_pWorkspace;
	/** */
	QTimer m_Timer;
	/** old search state */
	bool m_bSearchState;
	/** */
	CSearchManager m_SearchManager;

private slots:
	/** */
	void timerDone();
	/** */
	void slotSearchReturnPressed();
	/** */
	void slotAddSearchQueue();
	/** */
	void slotReset();
	/** */
	void slotChangedFreeSlots( int free_slots );
	/** */
	void slotToggledSearchFileOnly( bool chkstate );
	/** */
	void slotDoubleClickedSearchResult( QListViewItem * item );
	/** */
	void slotRightButtonClickedSearchResult( QListViewItem *, const QPoint &, int );
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange(QWidget*);
	/** */
	void slotRefreshConnectedHubs();
	/** */
	void slotTextFilterResults();
	/** */
	void slotTextFilterReset();
	/** */
	void slotRightButtonClickedSearch( QListViewItem *, const QPoint &, int );
	/** */
	void slotSearchSelected(int);
	/** */
	void slotPurgeHistory();
};

/** */
extern DCHubSearch * g_pHubSearch;

#endif
