/***************************************************************************
                          dcconfig.h  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCONFIG_H
#define DCCONFIG_H

/**
  *@author Mathias Kster
  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpixmap.h>
#include <qvaluevector.h>
#include <qlistview.h>
#include <qheader.h>
#include <qptrlist.h>
#include <qimage.h>
#include <qobject.h>

#include <dclib/cconfig.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/parser.h>
#include <libxml/tree.h>

/** */
typedef enum eUserIconType {
	euitOPERATOR,
	euitUSER,
	euitUSER_AWAY
} eUserIconType;

/** */
typedef enum eUserSound {
	eusCONNECT,
	eusDISCONNECT,
	eusSEND,
	eusRECEIVE,
	eusFIRSTRECEIVE,
	eusNICKMENTIONED
} eUserSound;

/** */
typedef enum eTimeStamp {
	etsPRIVATECHAT,
	etsHUBCHAT
} eTimeStamp;

/** */
typedef enum eTransferViewOptions {
	etvoCHUNKPERCENT,
	etvoFILEPERCENT,
	etvoCHUNKSIZE,
	etvoFILESIZE,
	etvoDOWNLOADRATESINGLE,
	etvoELAPSEDTIMESINGLE,
	etvoDOWNLOADRATEMULTI,
	etvoELAPSEDTIMEMULTI
} eTransferViewOptions;

/** */
typedef enum eLogChatOptions {
	elcoENABLELOGGING,
	elcoAPPENDDATE,
	elcoAPPENDHUBNAME,
	elcoAPPENDHUBHOST,
	elcoDISABLEPUBLICCHAT,
	elcoENABLENICKNAMEFILTER,
	elcoNICKNAMEFILTER_ENABLELOGGING
} eLogChatOptions;

/** */
typedef enum eChatColor {
	eccCHATTIMESTAMP=0,
	eccCHATLOCALNICK,
	eccCHATLOCALTEXT,
	eccCHATREMOTENICK,
	eccCHATREMOTETEXT,
	eccCHATSTATUSNICK,
	eccCHATSTATUSTEXT,
	eccPUBLICCHATTIMESTAMP,
	eccPUBLICCHATLOCALNICK,
	eccPUBLICCHATLOCALTEXT,
	eccPUBLICCHATREMOTENICK,
	eccPUBLICCHATREMOTETEXT,
	eccPUBLICCHATSTATUSNICK,
	eccPUBLICCHATSTATUSTEXT,
	eccPUBLICPRIVATECHATNICK,
	eccPUBLICPRIVATECHATTEXT,
	eccCHATSAY,
	eccPUBLICCHATMENICK,
	eccOPNICK
} eChatColor;

typedef enum eClientColumn {
	eclcCOMMENT=0,
	eclcTAG,
	eclcEMAIL,
	eclcSPEED,
	eclcSHARE,
	eclcIP,
	eclcLOCKPK,
	eclcSUPPORTS,
	eclcNICK
} eClientColumn;

class CString;
class CThread;

/* Default application font. Needed from main.cpp too */
#define DEFAULT_APP_FONT	"Helvetica,12,-1,5,50,0,0,0,0,0"

class QProcess;
class QPixmap;
/** */
typedef QMap<QString, QString> StringMap;
/** */
typedef QMap<QString, StringMap*> SettingMap;

/** */
class DC_EmoticonObject : public CObject {
public:
	/** construtor */
	DC_EmoticonObject() {};
	/** destructor */
	virtual ~DC_EmoticonObject() {};

	/** */
	CString m_Text;
	/** */
	int left,top,right,bottom;
	/** */
	int m_nID;
};

/** */
class DC_HubFilterObject : public CObject {
public:
	/** construtor */
	DC_HubFilterObject() {
		m_nUser        = 0;
		m_bName        = FALSE;
		m_bServer      = FALSE;
		m_bDescription = FALSE;
	};
	/** destructor */
	virtual ~DC_HubFilterObject() {};

	/** */
	CString m_sFilterName;
	/** */
	CString m_sContains;
	/** */
	int m_nUser;
	/** */
	bool m_bName;
	/** */
	bool m_bServer;
	/** */
	bool m_bDescription;
};

/** Stores a user command for custom menus */
class DLL_EXPORT DC_UserMenuCommand : public CObject {
public:
	/** */
	DC_UserMenuCommand() {
		m_nID      = 0;
		m_nContext = 0;
		
	};
	/** */
	virtual ~DC_UserMenuCommand() {};
	/** The name of the menu command */
	CString m_sName;
	/** The command to send to the hub */
	CString m_sCommand;
	/** Menu id */
	int m_nID;
	/** Context is which menu(s) to put the command into */
	int m_nContext;
};

/** Stores a user custom chat command */
class DLL_EXPORT DC_UserChatCommand : public CObject {
public:
	/** */
	DC_UserChatCommand() {};
	/** */
	virtual ~DC_UserChatCommand() {};
	
	/** Name of the command */
	CString m_sName;
	/** Command string to run */
	CString m_sCommand;
};

/** Stores an auto response trigger and response pair */
class DC_AutoResponseObject : public CObject {
public:
	/** */
	DC_AutoResponseObject() {
		m_sTrigger = "";
		m_sResponse = "";
		m_bCaseSensitive = FALSE;
	};
	/** */
	virtual ~DC_AutoResponseObject() {};
	
	/** Trigger QT regexp */
	CString m_sTrigger;
	/** Response */
	CString m_sResponse;
	/** Case sensitive or not */
	bool m_bCaseSensitive;
};

class DCConfig : public CConfig {
public:
	/** construtor */
	DCConfig( CString configpath = "" );
	/** destructor */
	virtual ~DCConfig();

	/** */
	int Load();
	/** */
	int Save();

	/** */
	int LoadDCGui();
	/** */
	int SaveDCGui();
	/** */
	void ParseDCGuiConfig( xmlNodePtr node );

	/** */
	int LoadDCHubFilter( CStringList * list );
	/** */
	int SaveDCHubFilter( CStringList * list );

	/** */
	int LoadDCFriendList( CStringList * list );
	/** */
	int SaveDCFriendList( CStringList * list );

	/** */
	bool GetOpenPrivateChatWindow() const;
	/** */
	void SetOpenPrivateChatWindow( bool b );
	/** */
	long GetChatMaxParagraph() const;
	/** */
	void SetChatMaxParagraph( long i );
	/** */
	bool GetChatShowJoinsAndParts() const;
	/** */
	void SetChatShowJoinsAndParts( bool b );
	/** */
	bool GetChatShowJoinsAndPartsOnlyFav() const;
	/** */
	void SetChatShowJoinsAndPartsOnlyFav( bool b );

	/** */
	eUnit GetUnit() const;
	/** */
	void SetUnit( eUnit unit );
	/** */
	bool GetTransferViewOptions( eTransferViewOptions e ) const;
	/** */
	void SetTransferViewOptions( eTransferViewOptions e, bool b );
	/** */
	CString GetTheme() const;
	/** */
	void SetTheme( CString theme );
	/** */
	CString GetSendChat() const;
	/** */
	void SetSendChat( CString sendchat );
	/** */
	CString GetLanguageFile() const;
	/** */
	void SetLanguageFile( CString languagefile );
	/** */
	bool GetTabBar() const;
	/** */
	void SetTabBar( bool b );
	/** */
	bool GetToolBar() const;
	/** */
	void SetToolBar( bool b );
	/** */
	bool GetStatusBar() const;
	/** */
	void SetStatusBar( bool b );
	/** */
	bool GetUserListRightAlignment() const;
	/** */
	void SetUserListRightAlignment( bool b );

	/** */
	QPixmap * GetUserIcon( bool op, eClientMode clientmode, eUserAwayMode awaymode, eUserSpeed speed, eUserClientVersion version );
	/** */
	void PlaySound( eUserSound usersound );
	/** */
	void PlaySound( CString file );

	/** */
	void SetAppFont( CString font );
	/** */
	CString GetAppFont() const;

	/** */
	bool GetMap( CString name, StringMap *& map );

	/** */
	void SetGeometry( CString name, int x, int y, int width, int height );
	/** */
	void GetGeometry( CString name, int &x, int &y, int &width, int &height );

	/** */
	void SetAppGeometry( int width, int height );
	/** */
	void GetAppGeometry( int &width, int &height );
	/** */
	void SetTransferViewGeometry( int width, int height );
	/** */
	void GetTransferViewGeometry( int &width, int &height );
	/** */
	void SetTransferViewDocked( bool b );
	/** */
	bool GetTransferViewDocked() const;

	/** */
	bool GetSoundDisabled() const;
	/** */
	void SetSoundDisabled( bool disabled );
	/** */
	bool GetSoundDisabledAway() const;
	/** */
	void SetSoundDisabledAway( bool disabled );
	/** */
	bool GetExternalSoundPlayer() const;
	/** */
	void SetExternalSoundPlayer( bool externalsoundplayer );
	/** */
	CString GetExternalPlayer() const;
	/** */
	void SetExternalPlayer( CString externalplayer );
	/** */
	CString GetSoundFile( eUserSound usersound );
	/** */
	void SetSoundFile( eUserSound usersound, CString soundfile );
	/** */
	bool GetSoundEnabled( eUserSound usersound );
	/** */
	void SetSoundEnabled( eUserSound usersound, bool enabled );

	/** */
	void SetTimeStamp( eTimeStamp timestamp, bool enabled );
	/** */
	bool GetTimeStamp( eTimeStamp timestamp );

	/** */
	void SetLogChatOption( eLogChatOptions elco, bool enabled );
	/** */
	bool GetLogChatOption( eLogChatOptions elco );
	/** */
	void SetLogChatNickNameFilter( CList<CString> * list );
	/** */
	void GetLogChatNickNameFilter( CList<CString> * list );
	/** */
	bool CheckLogChatNickNameFilter( CString nick );

	/** */
	bool GetShowStatusMessage() const;
	/** */
	void SetShowStatusMessage( bool disabled );
	/** */
	bool GetShowTransferWin() const;
	/** */
	void SetShowTransferWin( bool disabled );

	/** */
	bool GetSendHidePrivateChatToPublicChat() const;
	/** */
	void SetSendHidePrivateChatToPublicChat( bool b );

	/** */
	bool GetEnableEmoticons() const;
	/** */
	void SetEnableEmoticons( bool b );

	/** */
	bool GetAutoAwayMode() const;
	/** */
	void SetAutoAwayMode( bool b );
	/** */
	int GetAutoAwayTime() const;
	/** */
	void SetAutoAwayTime( int n );

	/** */
	int GetChatMessageMaxLines() const;
	/** */
	void SetChatMessageMaxLines( int i );

	/** */
	int GetFloodCount() const;
	/** */
	void SetFloodCount( int i );
	/** */
	bool GetFloodOpKick() const;
	/** */
	void SetFloodOpKick( bool b );

	/** */
	bool GetThemeSupport() const;
	/** */
	void SetThemeSupport( bool b );
	/** */
	CString GetBackgroundPixmap() const;
	/** */
	void SetBackgroundPixmap( CString s );
	/** */
	CString GetBrowser() const;
	/** */
	void SetBrowser( CString s );

	/** */
	unsigned int GetDefaultDownloadMode() const;
	/** 0:ask, 1:single, 2:multi */
	void SetDefaultDownloadMode( unsigned int n );

	/** */
	bool GetEnableTray() const;
	/** */
	void SetEnableTray( bool b );
	/** */
	bool GetQueryOnExit() const;
	/** */
	void SetQueryOnExit( bool b );
	/** */
	bool GetQueryOnFileDelete() const;
	/** */
	void SetQueryOnFileDelete( bool b );

	/** */
	bool GetShowChatSendButton() const;
	/** */
	void SetShowChatSendButton( bool b );
	/** */
	bool GetShowChatInTab() const;
	/** */
	void SetShowChatInTab( bool b );
	/** */
	CString GetChatColor( eChatColor type ) const;
	/** */
	void SetChatColor( eChatColor type, CString s );
	/** */
	bool GetOpenClientWindowsMinimized() const;
	/** */
	void SetOpenClientWindowsMinimized( bool b );

	/** */
	bool GetClientColumn( eClientColumn e );
	/** */
	void SetClientColumn( eClientColumn e, bool b );

	/** */
	int GetClientColumnWidth( eClientColumn e );
	/** */
	void SetClientColumnWidth( eClientColumn e, int i );

	/** */
	bool InitMimeSourceFactory();
	/** */
	CList<DC_EmoticonObject> * EmoticonList();
	/** */
	QImage & GetEmoticonImage();

	/** */
	CString GetUserPhotoFileName() const;
	/** */
	void SetUserPhotoFileName( CString s );
	
	/** Get the defualt remote text encoding for filelist browsers */
	QString GetDefaultFBRemoteEncoding() const;
	/** Set the default remote text encoding for filelist browsers */
	void SetDefaultFBRemoteEncoding ( QString s );
	
	/** */
	QString GetValknutDataPath() const;
	/** */
	void SetValknutDataPath( QString s );
	
	/** Get the list of user chat commands */
	long GetUserChatCommands( CList<DC_UserChatCommand> * list );
	/** Set the list of user chat commands */
	void SetUserChatCommands( CList<DC_UserChatCommand> * list );
	
	/** Get the list of user menu commands */
	long GetUserMenuCommands( CList<DC_UserMenuCommand> * list );
	/** Set the list of user menu commands*/
	void SetUserMenuCommands( CList<DC_UserMenuCommand> * list );
	/** Loads the user icons */
	void SetUserIcons( QPixmap p );	
	
	/** Gets the theme for application icons */
	QString GetApplicationIconTheme() const;
	/** Sets the theme for application icons */
	void SetApplicationIconTheme( QString s );
	
	/** Gets the theme for emoticons */
	QString GetEmoticonTheme() const;
	/** Sets the theme for emoticons */
	void SetEmoticonTheme( QString s );
	
	/** Gets the theme for userlist icons */
	QString GetUserListIconTheme() const;
	/** Sets the theme for userlist icons */
	void SetUserListIconTheme( QString s );
	
	/** Gets the regexp of nicks to not open chat windows for */
	QString GetSuppressedNicks() const;
	/** Sets the regexp of nicks to not open chat windows for */
	void SetSuppressedNicks( QString s );
	
	/** Gets the action for double clicking a user */
	QString GetDoubleClickAction() const;
	/** Sets the action for double clicking a user */
	void SetDoubleClickAction( QString s );
	
	/** Gets if auto responder is enabled for main chat */
	bool GetAutoResponderEnabled() const;
	/** Enables/Disables the auto responder for main chat */
	void SetAutoResponderEnabled( bool b );
	/** Gets the list of auto response triggers and responses */
	long GetAutoResponses( CList<DC_AutoResponseObject> * list );
	/** Sets the list of auto response triggers and responses */
	void SetAutoResponses( CList<DC_AutoResponseObject> * list );
	/** Gets the minimum time between auto-responses */
	long GetAutoResponseDelay() const;
	/** Sets the minimum time between auto-responses */
	void SetAutoResponseDelay( long n );
	/** Gets list of nicks to not auto respond to */
	CString GetAutoResponseIgnores() const;
	/** Sets list of nicks to not auto respond to */
	void SetAutoResponseIgnores( CString s );
	/** Gets if the auto responder is enabled for PMs */
	bool GetAutoResponderEnabledForPM() const;
	/** Enables/Disabled the auto responder for private messages */
	void SetAutoResponderEnabledForPM( bool b );
	
	/** Gets filelist naming scheme version */
	int GetFilelistNamingSchemeVersion() const;
	/** Sets filelist naming scheme version */
	void SetFilelistNamingSchemeVersion( int i );
	/** Renames the filelists */
	void RenameStoredFilelists();
	
	/** Get show folders in right pane of filelist browser*/
	bool GetFoldersInRightPane() const;
	/** Set show folders in right pane of filelist browser */
	void SetFoldersInRightPane( bool b );
	/** Get show subfolder sizes in left pane of filelist browser */
	bool GetFolderSizesInLeftPane() const;
	/** Set show subfolder sizes in left pane of filelist browser */
	void SetFolderSizesInLeftPane( bool b );
	/** Get sort folders in right pane on top */
	bool GetFoldersInRightPaneOnTop() const;
	/** Set sort folders in right pane on top */
	void SetFoldersInRightPaneOnTop( bool b );
	
private:
	/** */
	QString m_sValknutDataPath;
	
	/** */
	SettingMap m_guiSettingMap;

	/** */
	bool bOpenPrivateChatWindow;
	/** */
	long m_nChatMaxParagraph;
	/** */
	bool bShowTransferWin;
	/** */
	bool bTabBar;
	/** */
	bool bToolBar;
	/** */
	bool bStatusBar;
	/** */
	bool bUserListRightAlignment;
	/** */
	eUnit m_eUnit;
	/** */
	CString sTheme;
	/** */
	CString sSendChat;
	/** */
	bool bThemeSupport;
	/** */
	CString sLanguageFile;
	/** Application font */
	CString sAppFont;
	/** Application height */
	int iAppHeight;
	/** Application Width */
	int iAppWidth;
	/** TransferView height */
	int iTransferViewHeight;
	/** TransferView Width */
	int iTransferViewWidth;
	/** TransferView Docked */
	int bTransferViewDocked;
	/** */
	bool bSoundDisabled;
	/** */
	bool bSoundDisabledAway;
	/** */
	bool bSoundEnabledConnect;
	/** */
	bool bSoundEnabledDisconnect;
	/** */
	bool bSoundEnabledSend;
	/** */
	bool bSoundEnabledReceive;
	/** */
	bool bSoundEnabledFirstReceive;
	/** */
	bool bSoundEnabledNickMentioned;
	/** */
	bool bExternalSoundPlayer;
	/** */
	CString sExternalPlayer;
	/** connect sound file */
	CString sSoundFileConnect;
	/** disconnect sound file */
	CString sSoundFileDisconnect;
	/** send sound file */
	CString sSoundFileSend;
	/** receive sound file */
	CString sSoundFileReceive;
	/** first receive sound file */
	CString sSoundFileFirstReceive;
	/** nick said in public chat */
	CString sSoundFileNickMentioned;

	/** */
	bool bEnableEmoticons;
	/** */
	bool bTimeStampPrivateChat;
	/** */
	bool bTimeStampHubChat;
	/** */
	bool bShowStatusMessage;
	/** */
	bool bSendHidePrivateChatToPublicChat;
	/** */
	bool bTVChunkPercent;
	/** */	
	bool bTVFilePercent;
	/** */	
	bool bTVChunkSize;
	/** */
	bool bTVFileSize;
	/** */	
	bool bTVDownloadRateSingle;
	/** */	
	bool bTVElapsedTimeSingle;
	/** */	
	bool bTVDownloadRateMulti;
	/** */	
	bool bTVElapsedTimeMulti;
		
	/** */
	bool m_bLogChatOption_1;
	/** */
	bool m_bLogChatOption_2;
	/** */
	bool m_bLogChatOption_3;
	/** */
	bool m_bLogChatOption_4;
	/** */
	bool m_bLogChatOption_5;
	/** */
	bool m_bLogChatOption_6;
	/** */
	bool m_bLogChatOption_7;
	/** */
	CList<CString> m_pLogChatNickNameFilter;

	/** */
	int iChatMessageMaxLines;
	/** */
	QMimeSourceFactory * m_pMimeSourceFactory;
	
	/** */
	int iFloodCount;
	/** */
	bool m_bFloodOpKick;

	/** */
	CList<DC_EmoticonObject> * m_EmoticonSettingList;
	/** */
	QImage m_EmoticonImage;

	/** */
	QProcess * pProcess;

	/** */
	QPixmap m_UserIconCache;
	/** */
	int m_nUICX,m_nUICY;
	/** */
	QImage m_UserIcons;

	/** 0:ask, 1:single, 2:multi */
	int iDefaultDownloadMode;
	/** */
	bool m_bAutoAwayMode;
	/** */
	int m_nAutoAwayTime;

	/** */
	bool m_bEnableTray;
	/** */
	bool bQueryOnExit;
	/** */
	bool bQueryOnFileDelete;
	/** */
	bool bShowChatSendButton;
	/** */
	CString sBackgroundPixmap;
	/** */
	CString sBrowser;
	/** */
	bool bShowChatInTab;
	/** */
	CString m_sChatColor_1;
	/** */
	CString m_sChatColor_2;
	/** */
	CString m_sChatColor_3;
	/** */
	CString m_sChatColor_4;
	/** */
	CString m_sChatColor_5;
	/** */
	CString m_sChatColor_6;
	/** */
	CString m_sChatColor_7;
	/** */
	CString m_sChatColor_8;
	/** */
	CString m_sChatColor_9;
	/** */
	CString m_sChatColor_10;
	/** */
	CString m_sChatColor_11;
	/** */
	CString m_sChatColor_12;
	/** */
	CString m_sChatColor_13;
	/** */
	CString m_sChatColor_14;
	/** */
	CString m_sChatColor_15;
	/** */
	CString m_sChatColor_16;
	/** */
	CString m_sChatColor_17;
	/** */
	CString m_sChatColor_18;
	/** Colour for operator nick */
	CString m_sChatColor_19;
	/** */
	bool bOpenClientWindowsMinimized;
	/** */
	bool m_bChatShowJoinsAndParts;
	/** */
	bool m_bChatShowJoinsAndPartsOnlyFav;

	/** The default remote text encoding for filelist browsers */
	QString m_sDefaultFBRemoteEncoding;
	
	/** */
	bool m_bClientColumnComment;
	/** */
	bool m_bClientColumnTag;
	/** */
	bool m_bClientColumnEMail;
	/** */
	bool m_bClientColumnSpeed;
	/** */
	bool m_bClientColumnShare;
	/** */
	bool m_bClientColumnIP;
	/** */
	bool m_bClientColumnLOCKPK;
	/** */
	bool m_bClientColumnSUPPORTS;

	/** */
	int iClientColumnNick;
	/** */
	int iClientColumnComment;
	/** */
	int iClientColumnTag;
	/** */
	int iClientColumnEMail;
	/** */
	int iClientColumnSpeed;
	/** */
	int iClientColumnShare;
	/** */
	int iClientColumnIP;
	/** */
	int iClientColumnLOCKPK;
	/** */
	int iClientColumnSUPPORTS;

	/** */
	CString m_sUserPhotoFileName;
	
	/** The list of user customized chat commands */
	CList<DC_UserChatCommand> m_lUserChatCommands;

	/** The list of user customized menu commands */
	CList<DC_UserMenuCommand> m_lUserMenuCommands;
	
	/** Theme for application icons */
	QString m_sApplicationIconTheme;
	
	/** Theme for emoticons */
	QString m_sEmoticonTheme;
	
	/** Theme for userlist icons */
	QString m_sUserListIconTheme;
	
	/** Regexp of nicks to not open chat windows for */
	QString m_sSuppressedNicks;
	
	/** Action to do on double clicking a user */
	QString m_sDoubleClickAction;
	
	/** True if auto responder is enabled for main chat */
	bool m_bAutoResponderEnabled;
	
	/** True if auto responder is enabled for private messages */
	bool m_bAutoResponderEnabledForPM;
	
	/** The list of auto response triggers and responses */
	CList<DC_AutoResponseObject> m_lAutoResponses;
	
	/** The time between consequtive auto-responses for a user */
	long m_nAutoResponseDelay;
	
	/** A list of nicks to not auto respond to */
	CString m_sAutoResponseIgnores;
	
	/** The filelist naming scheme version.
	  * This is set internally so that the filelists are renamed
	  * once only when upgrading to 0.3.10.
	  */
	int m_nFilelistNamingSchemeVersion;
	
	/** Saved QT4 QMainWindow state */
	QString m_sQT4MainWindowState;
	
	/** Show folders in right pane of filelist browser? */
	bool m_bFoldersInRightPane;
	/** Show subfolder sizes in left pane of filelist browser? */
	bool m_bFolderSizesInLeftPane;
	/** Sort folders in right pane on top */
	bool m_bFoldersInRightPaneOnTop;
};

/** global config */
extern DCConfig * g_pConfig;

/** inline functions */

/** */
inline bool DCConfig::GetOpenPrivateChatWindow() const
{ return bOpenPrivateChatWindow; }
/** */
inline void DCConfig::SetOpenPrivateChatWindow( bool b )
{ bOpenPrivateChatWindow = b; }
/** */
inline bool DCConfig::GetTabBar() const
{ return bTabBar; }
/** */
inline void DCConfig::SetTabBar( bool b )
{ bTabBar = b; }
/** */
inline bool DCConfig::GetToolBar() const
{ return bToolBar; }
/** */
inline void DCConfig::SetToolBar( bool b )
{ bToolBar = b; }
/** */
inline bool DCConfig::GetStatusBar() const
{ return bStatusBar; }
/** */
inline void DCConfig::SetStatusBar( bool b )
{ bStatusBar = b; }
/** */
inline bool DCConfig::GetUserListRightAlignment() const
{ return bUserListRightAlignment; }
/** */
inline void DCConfig::SetUserListRightAlignment( bool b )
{ bUserListRightAlignment = b; }
/** */
inline eUnit DCConfig::GetUnit() const
{ return m_eUnit; }
/** */
inline void DCConfig::SetUnit( eUnit unit )
{ m_eUnit = unit; }
/** */
inline CString DCConfig::GetTheme() const
{ return sTheme; }
/** */
inline void DCConfig::SetTheme( CString theme )
{ sTheme = theme; }

/** */
inline CString DCConfig::GetSendChat() const
{ return sSendChat; }
/** */
inline void DCConfig::SetSendChat( CString sendchat )
{ sSendChat = sendchat; }

/** */
inline CString DCConfig::GetLanguageFile() const
{ return sLanguageFile; }
/** */
inline void DCConfig::SetLanguageFile( CString languagefile )
{ sLanguageFile = languagefile; }

inline CString DCConfig::GetAppFont() const
{ return sAppFont; }
inline void DCConfig::SetAppFont(CString font)
{ sAppFont = font; }
/** */
inline void DCConfig::SetAppGeometry( int width, int height )
{ iAppWidth=width;iAppHeight=height; }
/** */
inline void DCConfig::GetAppGeometry( int &width, int &height )
{ width=iAppWidth;height=iAppHeight; }
/** */
inline void DCConfig::SetTransferViewGeometry( int width, int height )
{ iTransferViewWidth=width;iTransferViewHeight=height; }
/** */
inline void DCConfig::GetTransferViewGeometry( int &width, int &height )
{ width=iTransferViewWidth;height=iTransferViewHeight; }
/** */
inline void DCConfig::SetTransferViewDocked( bool b )
{ bTransferViewDocked = b; }
/** */
inline bool DCConfig::GetTransferViewDocked() const
{ return bTransferViewDocked; }
/** */
inline bool DCConfig::GetSoundDisabled() const
{ return bSoundDisabled; }
/** */
inline void DCConfig::SetSoundDisabled( bool disabled )
{ bSoundDisabled = disabled; }
/** */
inline bool DCConfig::GetSoundDisabledAway() const
{ return bSoundDisabledAway; }
/** */
inline void DCConfig::SetSoundDisabledAway( bool disabled )
{ bSoundDisabledAway = disabled; }
/** */
inline bool DCConfig::GetExternalSoundPlayer() const
{ return bExternalSoundPlayer; }
/** */
inline void DCConfig::SetExternalSoundPlayer( bool externalsoundplayer )
{ bExternalSoundPlayer = externalsoundplayer; }
/** */
inline CString DCConfig::GetExternalPlayer() const
{ return sExternalPlayer; }
/** */
inline void DCConfig::SetExternalPlayer( CString externalplayer )
{ sExternalPlayer = externalplayer; }
/** */
inline bool DCConfig::GetShowStatusMessage() const
{ return bShowStatusMessage; }
/** */
inline void DCConfig::SetShowStatusMessage( bool b )
{ bShowStatusMessage = b; }
/** */
inline bool DCConfig::GetShowTransferWin() const
{ return bShowTransferWin; }
/** */
inline void DCConfig::SetShowTransferWin( bool b )
{ bShowTransferWin = b; }
/** */
inline bool DCConfig::GetThemeSupport() const
{ return bThemeSupport; }
/** */
inline void DCConfig::SetThemeSupport( bool b )
{ bThemeSupport = b; }
/** */
inline bool DCConfig::GetSendHidePrivateChatToPublicChat() const
{ return bSendHidePrivateChatToPublicChat; }
/** */
inline void DCConfig::SetSendHidePrivateChatToPublicChat( bool b )
{ bSendHidePrivateChatToPublicChat = b; }
/** */
inline int DCConfig::GetChatMessageMaxLines() const
{ return iChatMessageMaxLines; }
/** */
inline void DCConfig::SetChatMessageMaxLines( int i )
{ iChatMessageMaxLines = i; }
/** */
inline void DCConfig::SetFloodCount( int i )
{ iFloodCount = i; }
/** */
inline int DCConfig::GetFloodCount() const
{ return iFloodCount; }
/** */
inline void DCConfig::SetFloodOpKick( bool b )
{ m_bFloodOpKick = b; }
/** */
inline bool DCConfig::GetFloodOpKick() const
{ return m_bFloodOpKick; }
/** */
inline unsigned int DCConfig::GetDefaultDownloadMode() const
{ return iDefaultDownloadMode; }
/** */
inline void DCConfig::SetDefaultDownloadMode( unsigned int n )
{ iDefaultDownloadMode = n; }
/** */
inline bool DCConfig::GetEnableEmoticons() const
{ return bEnableEmoticons; }
/** */
inline void DCConfig::SetEnableEmoticons( bool b )
{ bEnableEmoticons = b; }
/** */
inline bool DCConfig::GetQueryOnExit() const
{ return bQueryOnExit; }
/** */
inline void DCConfig::SetQueryOnExit( bool b )
{ bQueryOnExit = b; }
/** */
inline bool DCConfig::GetEnableTray() const
{ return m_bEnableTray; }
/** */
inline void DCConfig::SetEnableTray( bool b )
{ m_bEnableTray = b; }
/** */
inline bool DCConfig::GetQueryOnFileDelete() const
{ return bQueryOnFileDelete; }
/** */
inline void DCConfig::SetQueryOnFileDelete( bool b )
{ bQueryOnFileDelete = b; }
/** */
inline bool DCConfig::GetShowChatSendButton() const
{ return bShowChatSendButton; }
/** */
inline void DCConfig::SetShowChatSendButton( bool b )
{ bShowChatSendButton = b; }
/** */
inline CString DCConfig::GetBackgroundPixmap() const
{ return sBackgroundPixmap; }
/** */
inline void DCConfig::SetBackgroundPixmap( CString s )
{ sBackgroundPixmap = s; }
/** */
inline CString DCConfig::GetBrowser() const
{ return sBrowser; }
/** */
inline void DCConfig::SetBrowser( CString s )
{ sBrowser = s; }
/** */
inline bool DCConfig::GetShowChatInTab() const
{ return bShowChatInTab; }
/** */
inline void DCConfig::SetShowChatInTab( bool b )
{ bShowChatInTab = b; }
/** */
inline long DCConfig::GetChatMaxParagraph() const
{ return m_nChatMaxParagraph; }
/** */
inline void DCConfig::SetChatMaxParagraph( long i )
{ m_nChatMaxParagraph = i; }
/** */
inline bool DCConfig::GetOpenClientWindowsMinimized() const
{ return bOpenClientWindowsMinimized; }
/** */
inline void DCConfig::SetOpenClientWindowsMinimized( bool b )
{ bOpenClientWindowsMinimized = b; }
/** */
inline bool DCConfig::GetAutoAwayMode() const
{ return m_bAutoAwayMode; }
/** */
inline void DCConfig::SetAutoAwayMode( bool b )
{ m_bAutoAwayMode = b; }
/** */
inline int DCConfig::GetAutoAwayTime() const
{ return m_nAutoAwayTime; }
/** */
inline void DCConfig::SetAutoAwayTime( int n )
{ m_nAutoAwayTime = n; }
/** */
inline bool DCConfig::GetChatShowJoinsAndParts() const
{ return m_bChatShowJoinsAndParts; }
/** */
inline void DCConfig::SetChatShowJoinsAndParts( bool b )
{ m_bChatShowJoinsAndParts = b; }
/** */
inline bool DCConfig::GetChatShowJoinsAndPartsOnlyFav() const
{ return m_bChatShowJoinsAndPartsOnlyFav; }
/** */
inline void DCConfig::SetChatShowJoinsAndPartsOnlyFav( bool b )
{ m_bChatShowJoinsAndPartsOnlyFav = b; }
/** */
inline CString DCConfig::GetUserPhotoFileName() const
{ return m_sUserPhotoFileName; }
/** */
inline void DCConfig::SetUserPhotoFileName( CString s )
{ m_sUserPhotoFileName = s; }
/** */
inline QString DCConfig::GetDefaultFBRemoteEncoding() const
{ return m_sDefaultFBRemoteEncoding; }
/** */
inline void DCConfig::SetDefaultFBRemoteEncoding( QString s )
{ m_sDefaultFBRemoteEncoding = s; }
/** */
inline QString DCConfig::GetValknutDataPath() const
{ return m_sValknutDataPath; }
/** */
inline void DCConfig::SetValknutDataPath( QString s )
{ m_sValknutDataPath = s; }
/** */
inline QString DCConfig::GetApplicationIconTheme() const
{ return m_sApplicationIconTheme; }
/** */
inline void DCConfig::SetApplicationIconTheme( QString s )
{ m_sApplicationIconTheme = s; }
/** */
inline QString DCConfig::GetEmoticonTheme() const
{ return m_sEmoticonTheme; }
/** */
inline void DCConfig::SetEmoticonTheme( QString s )
{ m_sEmoticonTheme = s; }
/** */
inline QString DCConfig::GetUserListIconTheme() const
{ return m_sUserListIconTheme; }
/** */
inline void DCConfig::SetUserListIconTheme( QString s )
{ m_sUserListIconTheme = s; }
/** */
inline void DCConfig::SetUserIcons( QPixmap p )
{ m_UserIcons = p; }
/** */
inline QString DCConfig::GetSuppressedNicks() const
{ return m_sSuppressedNicks; }
/** */
inline void DCConfig::SetSuppressedNicks( QString s )
{ m_sSuppressedNicks = s; }
/** */
inline QString DCConfig::GetDoubleClickAction() const
{ return m_sDoubleClickAction; }
/** */
inline void DCConfig::SetDoubleClickAction( QString s )
{ m_sDoubleClickAction = s; }
/** */
inline bool DCConfig::GetAutoResponderEnabled() const
{ return m_bAutoResponderEnabled; }
/** */
inline void DCConfig::SetAutoResponderEnabled( bool b )
{ m_bAutoResponderEnabled = b; }
/** */
inline long DCConfig::GetAutoResponseDelay() const
{ return m_nAutoResponseDelay; }
/** */
inline void DCConfig::SetAutoResponseDelay( long n )
{ m_nAutoResponseDelay = n; }
/** */
inline CString DCConfig::GetAutoResponseIgnores() const
{ return m_sAutoResponseIgnores; }
/** */
inline void DCConfig::SetAutoResponseIgnores( CString s )
{ m_sAutoResponseIgnores = s; }
/** */
inline bool DCConfig::GetAutoResponderEnabledForPM() const
{ return m_bAutoResponderEnabledForPM; }
/** */
inline void DCConfig::SetAutoResponderEnabledForPM( bool b )
{ m_bAutoResponderEnabledForPM = b; }
/** */
inline int DCConfig::GetFilelistNamingSchemeVersion() const
{ return m_nFilelistNamingSchemeVersion; }
/** */
inline void DCConfig::SetFilelistNamingSchemeVersion( int i )
{ m_nFilelistNamingSchemeVersion = i; }
/** */
inline bool DCConfig::GetFoldersInRightPane() const
{ return m_bFoldersInRightPane; }
/** */
inline void DCConfig::SetFoldersInRightPane( bool b)
{ m_bFoldersInRightPane = b; }
/** */
inline bool DCConfig::GetFolderSizesInLeftPane() const
{ return m_bFolderSizesInLeftPane; }
/** */
inline void DCConfig::SetFolderSizesInLeftPane( bool b )
{ m_bFolderSizesInLeftPane = b; }
/** */
inline bool DCConfig::GetFoldersInRightPaneOnTop() const
{ return m_bFoldersInRightPaneOnTop; }
/** */
inline void DCConfig::SetFoldersInRightPaneOnTop( bool b )
{ m_bFoldersInRightPaneOnTop = b; }
#endif
