/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include <glib.h>
#include <string.h>

#include "toolElements.h"

/**
 * SECTION:toolElements
 * @short_description: introduce physical values for the chemical species.
 *
 * This is a data base associating symbol names and atomic
 * numbers. One can also get the covalent radius of chemical
 * species. It is convenient to plot bindings.
 *
 * Since: 3.4
 */

struct periodic_table
{
  gchar *name;
  float radcov;
};

#define NUMBER_OF_ELEMENTS 86
static struct periodic_table eles[NUMBER_OF_ELEMENTS] = {
 {"H",  0.75 },
 {"He",  0.75 },
 {"Li",  3.4 },
 {"Be",  2.3 },
 {"B",  1.55 },
 {"C",  1.45 },
 {"N",  1.42 },
 {"O",  1.38 },
 {"F",  1.35 },
 {"Ne",  1.35 },
 {"Na",  3.4 },
 {"Mg",  2.65 },
 {"Al",  2.23 },
 {"Si",  2.09 },
 {"P",  2. },
 {"S",  1.92 },
 {"Cl",  1.87 },
 {"Ar",  1.8 },
 {"K",  4. },
 {"Ca",  3.8 },
 {"Sc",  2.7 },
 {"Ti",  2.7 },
 {"V",  2.6 },
 {"Cr",  2.6 },
 {"Mn",  2.5 },
 {"Fe",  2.5 },
 {"Co",  2.4 },
 {"Ni",  2.3 },
 {"Cu",  2.8 },
 {"Zn",  2.7 },
 {"Ga",  2.4 },
 {"Ge",  2.4 },
 {"As",  2.3 },
 {"Se",  2.3 },
 {"Br",  2.2 },
 {"Kr",  2.2 },
 {"Rb",  4.5 },
 {"Sr",  4. },
 {"Y",  3.5 },
 {"Zr",  3. },
 {"Nb",  2.7 },
 {"Mo",  2.6 },
 {"Tc",  2.6 },
 {"Ru",  2.5 },
 {"Rh",  2.5 },
 {"Pd",  2.5 },
 {"Ag",  2.9 },
 {"Cd",  2.8 },
 {"In",  2.7 },
 {"Sn",  2.66 },
 {"Sb",  2.66 },
 {"Te",  2.53 },
 {"I",  2.5 },
 {"Xe",  2.5 },
 {"Cs",  4.5 },
 {"Ba",  4. },
 {"La",  3.5 },
 {"Ce",  3.5 },
 {"Pr",  3.44 },
 {"Nd",  3.38 },
 {"Pm",  3.33 },
 {"Sm",  3.27 },
 {"Eu",  3.21 },
 {"Gd",  3.15 },
 {"Tb",  3.09 },
 {"Dy",  3.03 },
 {"Ho",  2.97 },
 {"Er",  2.92 },
 {"Tm",  2.92 },
 {"Yb",  2.8 },
 {"Lu",  2.8 },
 {"Hf",  2.9 },
 {"Ta",  3.1 },
 {"W",  2.6 },
 {"Re",  2.6 },
 {"Os",  2.5 },
 {"Ir",  2.6 },
 {"Pt",  2.6 },
 {"Au",  4. },
 {"Hg",  3.2 },
 {"Tl",  3.2 },
 {"Pb",  3.3 },
 {"Bi",  2.9 },
 {"Po",  2.8 },
 {"At",  2.6 },
 {"Rn",  2.6 }
};


gboolean toolElementsGet_element(gchar **name, float *radcov, int zele)
{
  g_return_val_if_fail(zele > 0 && zele < 86, FALSE);

  if (name)
    *name = eles[zele - 1].name;
  if (radcov)
    *radcov = eles[zele - 1].radcov;

  return TRUE;
}

gboolean toolElementsGet_elementFromSymbol(int *zele, float *radcov, gchar *symbol)
{
  int i;

  for (i = 0; i < NUMBER_OF_ELEMENTS; i++)
    {
      if (!strcmp(symbol, eles[i].name))
	{
	  if (radcov)
	    *radcov = eles[i].radcov;
	  if (zele)
	    *zele = i;
	  return TRUE;
	}
    }
  return FALSE;
}
