//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Robert Denda 1997
// 
// uProfilerFunctionPointers.cc -- 
// 
// Author           : Robert Denda
// Created On       : Thu Jul 31 20:35:59 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jun 11 21:07:56 2005
// Update Count     : 76
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#include <uC++.h>
#include "uProfiler.h"


uProfiler *uProfiler::uProfilerInstance = NULL;

void (* uProfiler::uProfiler_RegisterTask)(uProfiler *, const uBaseTask &, const uSerial &, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &, const uSerial &, const uBaseTask &)) 0; 
void (* uProfiler::uProfiler_DeregisterTask)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_RegisterTaskStartExecution)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0; 
void (* uProfiler::uProfiler_RegisterTaskEndExecution)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_RegisterTaskMigrate)(uProfiler *, const uBaseTask &, const uCluster &, const uCluster &) = (void (*)(uProfiler *, const uBaseTask &, const uCluster &, const uCluster &)) 0;

void (* uProfiler::uProfiler_RegisterCluster)(uProfiler *, const uCluster &) = (void (*)(uProfiler *, const uCluster &)) 0;
void (* uProfiler::uProfiler_DeregisterCluster)(uProfiler *, const uCluster &) = (void(*)(uProfiler *, const uCluster &)) 0;

void (* uProfiler::uProfiler_RegisterProcessor)(uProfiler *, const uProcessor &) = (void (*)(uProfiler *, const uProcessor &)) 0;
void (* uProfiler::uProfiler_DeregisterProcessor)(uProfiler *, const uProcessor &) = (void (*)(uProfiler *, const uProcessor & )) 0;
void (* uProfiler::uProfiler_RegisterProcessorMigrate)(uProfiler *, const uProcessor &, const uCluster &, const uCluster &) = (void (*)(uProfiler *, const uProcessor &, const uCluster &, const uCluster &)) 0;

void (* uProfiler::uProfiler_RegisterFunctionEntry)(uProfiler *, uBaseTask *, unsigned int, unsigned int, unsigned int) = (void (*)(uProfiler *, uBaseTask *, unsigned int, unsigned int, unsigned int)) 0;
void (* uProfiler::uProfiler_RegisterFunctionExit)(uProfiler *, uBaseTask *) = (void (*)(uProfiler *, uBaseTask *)) 0;

void (* uProfiler::uProfiler_RegisterWait)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial &) = (void(*)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial &)) 0;
void (* uProfiler::uProfiler_RegisterReady)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial &) = (void(*)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial &)) 0;
void (* uProfiler::uProfiler_RegisterSignal)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial &) = (void(*)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial &)) 0;

void (* uProfiler::uProfiler_RegisterMonitor)(uProfiler *, const uSerial &, const char *, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const char *, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_DeregisterMonitor)(uProfiler *, const uSerial &, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_RegisterMutexFunctionEntryTry)(uProfiler *, const uSerial &, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_RegisterMutexFunctionEntryDone)(uProfiler *, const uSerial &, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const uBaseTask &)) 0;

void (* uProfiler::uProfiler_RegisterMutexFunctionExit)(uProfiler *, const uSerial &, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_RegisterAcceptStart)(uProfiler *, const uSerial &, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_RegisterAcceptEnd)(uProfiler *, const uSerial &, const uBaseTask &) = (void(*)(uProfiler *, const uSerial &, const uBaseTask &)) 0;

void (* uProfiler::uProfiler_RegisterCoroutine)(uProfiler *, const uBaseCoroutine &, const uSerial &) = (void(*)(uProfiler *, const uBaseCoroutine &, const uSerial &)) 0;
void (* uProfiler::uProfiler_DeregisterCoroutine)(uProfiler *, const uBaseCoroutine &) = (void(*)(uProfiler *, const uBaseCoroutine &)) 0;
void (* uProfiler::uProfiler_RegisterCoroutineBlock)(uProfiler *, const uBaseTask &, const uBaseCoroutine &) = (void(*)(uProfiler *, const uBaseTask &, const uBaseCoroutine &)) 0;    
void (* uProfiler::uProfiler_RegisterCoroutineUnblock)(uProfiler *, const uBaseTask &) = (void(*)(uProfiler *, const uBaseTask &)) 0;

void (* uProfiler::uProfiler_RegisterTaskExecState)(uProfiler *, const uBaseTask &, uBaseTask::State) = (void (*)(uProfiler *, const uBaseTask &, uBaseTask::State)) 0;

void (* uProfiler::uProfiler_Poll)(uProfiler *) = (void (*)(uProfiler *)) 0;

void (* uProfiler::uProfiler_RegisterSetName)(uProfiler *, const uBaseCoroutine &, const char *) = (void(*)(uProfiler *, const uBaseCoroutine &, const char *)) 0;

uMemoryInfoEntry *(* uProfiler::uProfiler_RegisterMemoryAllocate)(uProfiler *, void *, size_t, size_t ) = (uMemoryInfoEntry *(*)(uProfiler *, void *, size_t, size_t )) 0;
void (* uProfiler::uProfiler_RegisterMemoryDeallocate)(uProfiler *, void *, size_t, uMemoryInfoEntry * ) = (void (*)(uProfiler *, void *, size_t, uMemoryInfoEntry * )) 0;

// hooks for built in metrics ( they can't be activated by a user )

void (* uProfiler::uProfiler_BuiltInRegisterTaskBlock)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_BuiltInRegisterTaskUnblock)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &))0;
void (* uProfiler::uProfiler_BuiltInRegisterFunctionEntry)(uProfiler *) = (void (*)(uProfiler *)) 0;
void (* uProfiler::uProfiler_BuiltInRegisterFunctionExit )(uProfiler *) = (void (*)(uProfiler *)) 0;
void (* uProfiler::uProfiler_BuiltInRegisterProcessor)(uProfiler *, const uProcessor &) = (void (*)(uProfiler *, const uProcessor &)) 0;
void (* uProfiler::uProfiler_BuiltInDeregisterProcessor)(uProfiler *, const uProcessor &) = (void (*)(uProfiler *, const uProcessor &)) 0;
void (* uProfiler::uProfiler_BuiltInRegisterTaskStartSpin)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_BuiltInRegisterTaskStopSpin)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;

// dynamic memory allocation in uC++ kernel

void (* uProfiler::uProfiler_PreallocateMetricMemory)(uProfiler *, void **, const uBaseTask &) = (void (*)(uProfiler *, void **, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_PostallocateMetricMemory)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_SetMetricMemoryPointers)(uProfiler *, void **, const uBaseTask &) = (void (*)(uProfiler *, void **, const uBaseTask &)) 0;
void (* uProfiler::uProfiler_ResetMetricMemoryPointers)(uProfiler *, const uBaseTask &) = (void (*)(uProfiler *, const uBaseTask &)) 0;

// debugging

void (* uProfiler::uProfiler_printCallStack)(uProfileTaskSampler *) = (void(*)(uProfileTaskSampler *)) 0;


// Local Variables: //
// compile-command: "gmake install" //
// End: //
