/***************************************************************************
 *            menus.c
 *
 *  Sun Sep 24 12:12:13 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/** @file menus.c
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Sam Phillips <sam@usaworks.com> 
*/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "config.h"

#include <glib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtksheet.h>
#include "types.h"
#include "menus.h"
#include "field.h"
#include "filein.h"
#include "fileout.h"
#include "edit.h"
#include "main.h"
#include "sort.h"
#include "help.h"
#include "filter.h"
#include "report.h"
#include "tools.h"
#include "xmlmenu.h"

#define _(String) String

/** \brief Associate translatable strings
with menu actions. */
static GtkActionEntry entries[] = {
	/* name, stock id, label */
	{"FileMenuAction", NULL, _("_File"), NULL, NULL, NULL},
	{"RecentMenuAction", NULL, _("Re_cent"), NULL, NULL, NULL},
	{"EditMenuAction", NULL, _("_Edit"), NULL, NULL, NULL},
	{"SortMenuAction", NULL, _("_Sort"), NULL, NULL, NULL},
	{"FilterMenuAction", NULL, _("_Filter"), NULL, NULL, NULL},
	{"ReportMenuAction", NULL, _("_Report"), NULL, NULL, NULL},
	{"ColumnMenuAction", NULL, _("_Column"), NULL, NULL, NULL},
/*	{"ToolsMenuAction", NULL, _("_Tools"), NULL, NULL, NULL},*/
	/* tools replaces totals and vice versa */
	{"TotalsMenuAction", NULL, _("_Totals"), NULL, NULL, NULL},
	{"ReportColumnAction", NULL, _("_Column"), NULL, NULL, NULL},
	{"HelpMenuAction", NULL, _("_Help"), NULL, NULL, NULL},

	{"NewFileAction", GTK_STOCK_NEW, _("_New"),
			"<Control>N", _("Create a new list"),
		G_CALLBACK (new_file)},
	{"OpenFileAction", GTK_STOCK_OPEN,
			_("_Open"), "<Control>O",
		_("Open an existing list"), G_CALLBACK (open_file)},
	{"OpenRecentAction", NULL, _("Re_cent"), NULL, NULL, NULL},
	{"CloseFileAction", GTK_STOCK_CLOSE, _("_Close"), "<Control>W",
		_("Close this list"), G_CALLBACK (close_file)},
	{"SaveFileAction", GTK_STOCK_SAVE, _("_Save"), "<Control>S",
		_("Save the list"), G_CALLBACK (save_file)},
	{"SaveAsFileAction", GTK_STOCK_SAVE_AS, _("Save _As ..."), "",
		_("Save the list as a new file"), G_CALLBACK (save_as)},
	{"ImportFileAction", NULL, _("_Import..."), "",
		_("Import data for this list"), G_CALLBACK (file_import)},
	{"ExportFileAction", GTK_STOCK_CONVERT, _("_Export ..."), "",
		_("Export this list"), G_CALLBACK (file_export)},
	{"PrintFileAction", GTK_STOCK_PRINT, _("_Print"), "<Control>P",
		_("Print this report"), G_CALLBACK (print_cb)},
	{"PreviewFileAction", GTK_STOCK_PRINT_PREVIEW, _("Print Previe_w"),
		"<Control><Shift>P", _("Preview the printed report"),
		G_CALLBACK (print_preview_cb)},
	{"QuitAction", GTK_STOCK_QUIT, _("Quit QuickList"),
			"<control>Q", _("Quit the QuickList application"),
		G_CALLBACK (exit_action)},
	{"EditCutAction", GTK_STOCK_CUT, _("C_ut"), "<Control>X",
			_("Cut the selected cell to the clipboard"),
		G_CALLBACK (edit_cut)},
	{"EditCopyAction", GTK_STOCK_COPY, _("_Copy"), "<Control>C",
			_("Copy the selected cell to the clipboard"),
		G_CALLBACK (edit_copy)},
	{"EditCopyDownAction", NULL, _("Copy _Down"), "<alt>E",
			_("Copy the cell above into this cell"),
		G_CALLBACK (edit_ditto)},
	{"EditPasteAction", GTK_STOCK_PASTE, _("_Paste"), "<Control>V",
			_("Paste the clipboard contents into this cell"),
		G_CALLBACK (edit_paste)},
	{"EditClearAction", GTK_STOCK_CLEAR, _("C_lear"), "Delete",
			_("Clear the contents of this cell"),
		G_CALLBACK (edit_clear)},
	{"EditFillAction", GTK_STOCK_JUSTIFY_FILL, _("_Fill down"), "<Alt>D",
			_("Copy the top cell into the selected cells below"),
		G_CALLBACK (edit_fill_down)},
	{"EditAllAction", NULL, _("Select _All"), "<control>A",
			_("Select all cells in the list"),
		G_CALLBACK (edit_select_all)},
	{"EditInsertAction", NULL, _("_Insert a row"), "<alt>I",
			_("Insert a row beneath the current row"),
		G_CALLBACK (edit_insert_rows)},
	{"SortColumnAction", NULL, _("_Sort column"), "<alt>Y",
			_("Sort by column using the current pattern"),
		G_CALLBACK (sort_by_column)},
	/** \todo re-enable the Sort, Filter and Report menus
when the supporting code is fixed. */
/*	{"SortApplyAction", GTK_STOCK_APPLY, _("_Apply"), "",
		_("Apply the sort pattern"), G_CALLBACK (sort_apply)},
	{"SortAddAction", GTK_STOCK_ADD, _("Add _Pattern"), "",
		_("Add a sort pattern"), G_CALLBACK (sort_add)},
	{"SortEditAction", GTK_STOCK_EDIT, _("_Edit"), "",
		_("Edit a sort pattern"), G_CALLBACK (sort_edit)},
	{"SortDeleteAction", GTK_STOCK_DELETE, _("_Delete"), "",
		_("Delete a sort pattern"), G_CALLBACK (sort_delete)},*/
/*	{"FilterShowAction", NULL, _("Show _All"), "",
			_("Show all available filters"),
		G_CALLBACK (filter_show_all)},
	{"FilterApplyAction", GTK_STOCK_APPLY, _("Apply _Filter"), "",
			_("Select and apply a filter"),
		G_CALLBACK (filter_apply)},*/
/*	{"FilterAddAction", GTK_STOCK_ADD, _("_Add"), "",
		_("Add a new filter"), G_CALLBACK (filter_add)},
	{"FilterEditAction", GTK_STOCK_EDIT, _("_Edit"), "",
		_("Edit a filter"), G_CALLBACK (filter_edit)},
	{"FilterDeleteAction", GTK_STOCK_DELETE, _("_Delete"), "",
		_("Delete a filter"), G_CALLBACK (filter_delete)},*/
	{"ReportSelectAction", NULL, _("_Select"), "",
		_("Select a report to view"), G_CALLBACK (report_select)},
/*	{"ReportAddAction", GTK_STOCK_ADD, _("_Add"), "",
		_("Add a new report"), G_CALLBACK (report_add)},*/
	{"ColumnAddAction", GTK_STOCK_ADD, _("_Add"), "",
		_("Add a column to the list"), G_CALLBACK (column_add)},
	{"ColumnEditAction", GTK_STOCK_EDIT, _("_Edit"), "",
			_("Edit the type of the selected column"),
		G_CALLBACK (column_edit)},
	{"ColumnDeleteAction", GTK_STOCK_DELETE, _("_Delete"), "",
			_("Delete the selected column"),
		G_CALLBACK (column_delete)},
	/** \todo can't find the key for alt. or alt-left-arrow ?*/
	{"ColumnLeftAction", GTK_STOCK_GO_BACK, _("Move _Left"), "",
			_("Move the selected column left by one slot"),
		G_CALLBACK (column_left)},
	{"ColumnRightAction", GTK_STOCK_GO_FORWARD, _("Move _Right"), "",
			_("Move the selected column right by one slot"),
		G_CALLBACK (column_right)},
	{"ReportColumnAddAction", GTK_STOCK_ADD, _("_Add"), "",
		_("Add a new column"), G_CALLBACK (report_col_add)},
	{"ReportColumnDeleteAction", GTK_STOCK_DELETE, _("_Delete"),
			"", _("Delete column from report"),
		G_CALLBACK (report_col_del)},
	{"ReportColumnLeftAction", GTK_STOCK_GO_BACK, _("Move _Left"),
			"", _("Move the selected column left by one slot"),
		G_CALLBACK (report_col_left)},
	{"ReportColumnRightAction", GTK_STOCK_GO_FORWARD, _("Move _Right"),
			"", _("Move the selected column right by one slot"),
		G_CALLBACK (report_col_right)},
	{"ToolsFindAction", GTK_STOCK_FIND, _("_Find"), "<Alt>F",
		_("Search the list"), G_CALLBACK (tools_find)},
	/** \todo decide if there is any need for the tools menu */
/*	{"ToolsMatchAction", NULL, _("_Match"), "<Alt>M",
		_("Match tool"), G_CALLBACK (tools_match)},*/
/*	{"TotalsGroupAction", NULL, _("_Group"), "<alt>G",
		_("Total by group"), G_CALLBACK (report_totals_group)},
	{"TotalsTotalsAction", NULL, _("_Totals"), "<Alt>T",
		_("Totals"), G_CALLBACK (report_totals_total)},*/
	{"HelpManualAction", GTK_STOCK_HELP, _("Manual"), "F1",
		_("User Manual"), G_CALLBACK (qlhelp_manual)},
	{"HelpAboutAction", GTK_STOCK_ABOUT, _("_About"), NULL,
		_("About QuickList"), G_CALLBACK (qlhelp_credits)}

};
static guint n_entries = G_N_ELEMENTS (entries);

static void
menu_add_widget (GtkUIManager G_GNUC_UNUSED * ui, GtkWidget * widget,
	GtkContainer * container)
{
	gtk_box_pack_start (GTK_BOX (container), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
}

GtkWidget *
build_list_mb (QlContext * qlc)
{
	GtkAccelGroup *accel_group;
	GtkActionGroup *action_group;
	GError *error;
	GtkWidget *menubar, *menu_box;
	gchar *xmlmenupath;
	GList * items;

	items = NULL;
	error = NULL;
	xmlmenupath = g_strconcat (XMLMENUDIR, "/menus.xml", NULL);
	action_group = gtk_action_group_new ("QLActions");
	gtk_action_group_set_translation_domain (action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (action_group, entries, n_entries, qlc->parent);

	qlc->menu_manager = gtk_ui_manager_new ();
	gtk_ui_manager_insert_action_group (qlc->menu_manager, action_group, 0);
	gtk_ui_manager_set_add_tearoffs (qlc->menu_manager, TRUE);

	accel_group = gtk_ui_manager_get_accel_group (qlc->menu_manager);
	gtk_window_add_accel_group (GTK_WINDOW (qlc->parent), accel_group);

	gtk_ui_manager_add_ui_from_file (qlc->menu_manager, xmlmenupath, &error);

	if (error)
	{
		g_message ("building menus failed: %s", error->message);
		g_error_free (error);
	}
	menubar = gtk_menu_bar_new ();

	gtk_widget_show (menubar);
	menu_box = gtk_vbox_new (FALSE, 0);

	g_signal_connect (qlc->menu_manager, "add_widget",
		G_CALLBACK (menu_add_widget), menu_box);
	g_free (xmlmenupath);
	return menu_box;
}

GtkWidget *
build_report_mb (QlContext * qlc)
{
	GtkAccelGroup *accel_group;
	GtkActionGroup *action_group;
	GError *error;
	GtkWidget *menubar, *menu_box;
	gchar *xmlmenupath;

	xmlmenupath = g_strconcat (XMLMENUDIR, "/reports.xml", NULL);
	action_group = gtk_action_group_new ("QLActions");
	gtk_action_group_set_translation_domain (action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (action_group, entries, n_entries, NULL);
	accel_group = gtk_accel_group_new ();
	
	qlc->menu_manager = gtk_ui_manager_new ();
	gtk_ui_manager_insert_action_group (qlc->menu_manager, action_group, 0);

	error = NULL;
	gtk_ui_manager_add_ui_from_file (qlc->menu_manager, xmlmenupath, &error);

	if (error)
	{
		g_message ("building menus failed: %s", error->message);
		g_error_free (error);
	}
	menubar = gtk_menu_bar_new ();
	gtk_widget_show (menubar);
	menu_box = gtk_vbox_new (FALSE, 0);

	g_signal_connect (qlc->menu_manager, "add_widget",
		G_CALLBACK (menu_add_widget), menu_box);
	g_free (xmlmenupath);
	return menu_box;
}

void
menus_set_sensitive (QlContext * qlc, gchar * path, gboolean sensitive)
{
	GtkWidget *menuitem;

	g_return_if_fail (qlc->menu_manager);
	menuitem = gtk_ui_manager_get_widget (qlc->menu_manager, path);
	if (menuitem)
		gtk_widget_set_sensitive (menuitem, sensitive);
	else
	{
		g_warning
			("Unable to set sensitivity for a menu item "
			"which doesn't exist:\n%s", path);
	}
}
