/* fileout.c for QuickList */

/*  Quicklist
 *  www.quicklist.org for more information.
 *
 *  Current owner:  Bob 
 * 
 *  Author of this code file:  Robert Lissner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "includes.h"
#include "globals.h"

void write_the_file ();  /* writes a file to disk */
void get_rid_of_front (); /* gets rid of front file, moves a new
			     one to the front */
void any_save ();
void ask_about_all ();
void ask_about_save (); /* asks user if she wants to save the changed file */
static void fs_ok_clicked (GtkWidget *w, GtkFileSelection *fs);
static void filter_data_clicked (GtkWidget *w, gpointer *data);
static void highlighted_data_clicked (GtkWidget *w, gpointer *data);
void write_all_types (char* name);
void write_ql_file ();
void write_delimited (char separator);
void write_html ();
/* End of prototypes */

GtkSheetRange write_range; /* for writing less than whole file */

static char print_all; /* A (all), H (highlighted) or F(filter selected) */


static void all_data_clicked (GtkWidget *w, gpointer *data){
  print_all = 'A';
}


void any_save () {
  char  temp_file_name [1028];
  if (check_if_changed ())
    return;
  destroy_dialog ();
  if (dialog_mode == 'S')
    dialog1_win = gtk_file_selection_new ((char*)  _("Save this list"));
  else
    dialog1_win = gtk_file_selection_new ((char*)  _("Export a file"));

  gtk_window_position (GTK_WINDOW (dialog1_win), GTK_WIN_POS_CENTER); 
  strcpy (temp_file_name, front->file_path); 
  if (dialog_mode == 'E')
    set_suffix (temp_file_name, 2);
  gtk_file_selection_set_filename( GTK_FILE_SELECTION (dialog1_win),
				   temp_file_name); 
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
				  (dialog1_win)->ok_button),
		      "clicked", 
		      (GtkSignalFunc) fs_ok_clicked, dialog1_win);
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
				  (dialog1_win)->cancel_button),
		      "clicked",
		      (GtkSignalFunc) cancel_level1, NULL);
  if (dialog_mode == 'E')
  {
     ask_about_all ();
     file_type_menu (); /* output file */
    file_type = 2; /* export defaults to HTML */
  }
  else 
    file_type = 1; /* default to quicklist */
  gtk_widget_show_all (dialog1_win);  
}


/* ________________________________
  |                                |
  |    ask_about_all               |
  |________________________________|
  These buttons offer to export less than the whole file */
void ask_about_all () {
  GtkWidget* all_data;
  GtkWidget* filter_data;
  GtkWidget* highlighted_data;
  GtkWidget* hbox;
  
  print_all = 'A';
  hbox= gtk_hbox_new (FALSE, 5);
  all_data = gtk_radio_button_new_with_label (NULL, _("Entire file"));
  gtk_box_pack_start (GTK_BOX (hbox), all_data, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (all_data), "clicked", 
			GTK_SIGNAL_FUNC (all_data_clicked), NULL);
   
  filter_data = gtk_radio_button_new_with_label
    ( gtk_radio_button_group (GTK_RADIO_BUTTON (all_data)),
      _("Allowed by filter"));
  if (!front->filter_ptr)
    gtk_widget_set_sensitive (filter_data, FALSE);  
  gtk_box_pack_start (GTK_BOX (hbox), filter_data, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (filter_data), "clicked", 
		      GTK_SIGNAL_FUNC (filter_data_clicked), NULL);
  
  
  highlighted_data = gtk_radio_button_new_with_label
    ( gtk_radio_button_group (GTK_RADIO_BUTTON (all_data)),
      _("Highlighted cells"));
  gtk_box_pack_start (GTK_BOX (hbox), highlighted_data, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (highlighted_data), "clicked",
		      GTK_SIGNAL_FUNC (highlighted_data_clicked), NULL);
  
  /* there can only be a selection if some cells are selected, more than one */
    if (dialog_mode == 'S' || 
	(front->sel_type == 'E' || !front->sel_type == 'C'))
      gtk_widget_set_sensitive (highlighted_data, FALSE);  
    gtk_container_add (GTK_CONTAINER (GTK_FILE_SELECTION
				    (dialog1_win)->main_vbox), hbox);  
} /* end of ask_about_all */


/* ________________________________
  |                                |
  |    ask_about_clicked           |
  |________________________________|
 */
static void ask_about_clicked (GtkObject *object, gpointer entry) {
  destroy_dialog ();
  if ((gint) entry == 'Y')
    write_all_types (front->file_path); /* if user said Yes, save the file */
  get_rid_of_front ();
  if (close_mode == 'C') {
    maybe_create_initial_db ();
    return;
  }
  /* This follows for quitting, not closing.  Go to next file */
  while (front) {
    if (!front->changed)
      get_rid_of_front();
    else {
      ask_about_save();
      return;
    }
  }
    gtk_main_quit ();  
 }

/* ________________________________
  |                                |
  |    ask_about_save              |
  |________________________________|
 */
/* This dialog box is called by the close and quit routines to 
   just ask if the front file should be saved onto disk before
   the window is closed. */

void ask_about_save (void) {
  GtkWidget    *yes_button; 
  GtkWidget    *no_button; 
  GtkWidget    *cancel_button;
  GtkWidget    *label;
  
  make_basic_dialog1 ();
  gtk_signal_connect (GTK_OBJECT  (dialog1_win),
		      "delete_event",
		      (GtkSignalFunc) cancel_level1, NULL);
  gtk_window_set_title (GTK_WINDOW (dialog1_win), front->file_name);
  label = gtk_label_new (_("  This list has been changed.  Do you want to save it to disk?  "));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog1_win)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);  
  yes_button = gtk_button_new_with_label (_("   Yes  "));
  gtk_widget_show (yes_button);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog1_win)->action_area),
		      yes_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(yes_button), "clicked", 
		      GTK_SIGNAL_FUNC (ask_about_clicked),
		      (gpointer) 'Y');

  no_button = gtk_button_new_with_label (_("  No  "));
  gtk_widget_show (no_button);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog1_win)->action_area),
		      no_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(no_button),"clicked", \
		      GTK_SIGNAL_FUNC(ask_about_clicked),
		      (gpointer) 'N');
  cancel_button = gtk_button_new_with_label (_("  Cancel  "));
  gtk_widget_show (cancel_button);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog1_win)->action_area),
		      cancel_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(cancel_button),"clicked", \
		      GTK_SIGNAL_FUNC(cancel_level1), NULL );
  gtk_widget_show (dialog1_win);
} /* End of ask_about_save */ 


/* |--------------------------------|
   |       close_file               |
   |--------------------------------|
*/ 
void close_file (GtkWidget *w, gpointer *data) {
  if (check_if_changed ())
    return;
  if (dialog1_file == front)
    destroy_dialog ();
  if (!front->changed) { 
    get_rid_of_front();
    maybe_create_initial_db();
  }
  else {
    close_mode = 'C';
    ask_about_save ();
  }
} /* End of close_file callback */

/* |--------------------------------|
   |       delete_on_front          |
   |--------------------------------|
*/ 
gboolean delete_on_front (GtkWidget *widget, GdkEvent *event, gpointer data ) {
  if (check_if_changed ())
    return (TRUE);
  if (dialog1_file == front)
    destroy_dialog ();
  if (!front->changed) { 
    get_rid_of_front();
    maybe_create_initial_db();
  }
  else {
    close_mode = 'C';
    ask_about_save ();
  }
  return (TRUE);
} /* End of delete_on_front callback */


/* |--------------------------------|
   |       file_exit                |
   |--------------------------------|
*/ 
void file_exit (GtkWidget *w, gpointer *data) {
  while (front) {
    if (!front->changed)
      get_rid_of_front();
    else {
      close_mode = 'Q';
      ask_about_save ();
      return;
    }
  }
  gtk_main_quit ();
} /* End of exit routine */



void file_export (GtkWidget *w, gpointer *data){
  dialog_mode = 'E';
  any_save ();
}

/* ________________________________
  |                                |
  |        fs_ok_clicked           |
  |________________________________|
 */
/* This callback is when OK clicked on save_as file selection dialog box */
static void fs_ok_clicked (GtkWidget *w, GtkFileSelection *fs) {
  char this_file_path [1024];
  char window_title [120];
  char* linebufp;

  /* Be careful of the order of the next instructions */
  if (file_type == 1) {
    g_free (front->file_path);
    front->file_path = (char *) g_strdup (gtk_file_selection_get_filename
				     (GTK_FILE_SELECTION (fs)));
    
    linebufp = (char *) strrchr (front->file_path, '/');
    front->file_name = g_strdup (linebufp +1);
    strcpy (window_title, front->file_name);
    strcat (window_title, "  (QuickList)");
    gtk_window_set_title (GTK_WINDOW (front->list_win), window_title);
    strcpy (this_file_path, front->file_path);  
  }
  else
     strcpy (this_file_path, (gtk_file_selection_get_filename
				     (GTK_FILE_SELECTION (fs))));
  destroy_dialog ();
  write_all_types (this_file_path); 
}

static void filter_data_clicked (GtkWidget *w, gpointer *data){
  print_all = 'F';
}


static void highlighted_data_clicked (GtkWidget *w, gpointer *data){
  print_all = 'H';
}


/* ________________________________
  |                                |
  |        remove_ql_chars         |
  |________________________________|
  Routine removes backslash and trailing blanks, which are of no value */
void remove_ql_chars (char* text) {
  char* begin = text;
  char* linebufp = text;
  while (*linebufp) {
    if (*linebufp == '\\')
      *linebufp = '/';
    linebufp++;
  }
  linebufp--; /* skip back over ending zero */
  while (linebufp > begin && *linebufp == ' ')
    *linebufp-- = '\0';  /* removes trailing blanks */
} /* end of remove_ql_chars */
   

void save_as (GtkWidget *w, gpointer *data){
  dialog_mode = 'S';
  print_all = 'A';
  any_save ();
}



/* |--------------------------------|
   |      save_file                 |
   |--------------------------------| 
   Write the file onto disk with its present file path  */
void save_file (GtkWidget *w, gpointer *data) {
  if (check_if_changed ())
    return;
  print_all = 'A';
  if (!strstr (front->file_name, "Untitled")) {
    file_type = 1;
    write_all_types (front->file_path);
  }
  else save_as (NULL, NULL);
}


/* |--------------------------------|
   |    write_delimited             |
   |--------------------------------| 
   Write the file onto disk with called char as a separator.  */
void write_delimited (char separator) {
  char linebuf [4096];
  gchar *text;
  gint32 rowx;
  gint16 colx; /* indexes into array */
  gint x, y;
  gboolean first_in_row;  

  /* NOW WRITE THE DATA RECORDS.  Last row is always empty. */
  for (rowx = write_range.row0; rowx < write_range.rowi; rowx++) {    
      if (print_all != 'A' && !row_is_visible (rowx))
	  continue;
      first_in_row = TRUE;
      for (colx = write_range.col0; colx <= write_range.coli; colx++) {
	  text = gtk_sheet_cell_get_text ( GTK_SHEET (front->sheet),
					   rowx, colx);
	  if (!first_in_row)
	      fprintf (f, "%c", separator);
	  first_in_row = FALSE;
	  if (text) {
	      x = y = 0; /* remove separator characters from data */
	      do {
		  if (text [x] != separator)
		      linebuf [y++] = text [x];
	      } while (text [x++]); /* stop at end of string */
	      fprintf (f, "%s", linebuf);
	  }
      } 
      fprintf (f, "\n"); /* write nothing if nothing there */
  }
  fclose (f);
} /* end of write_delimited */
                     
/* |--------------------------------|
   |     write_ql_file              |
   |--------------------------------| 
   Write the file onto disk.  Called by save, save_as, close, quit */
void write_ql_file( ) {
  gchar *text;
  gint32 rowx;
  gint16 fieldx = 0;
  gint16 sortx = 0;
  gint16 filterx = 0;
  gint16 subx = 0;
  gint16 reportx = 0;
  gint16 colx = 0; /* indexes into array */
  gint16 blank_fields; /* try to not write trailing \\\\ */
  gboolean got_data; /* try to not write blank records */

  get_window_size_loc (GTK_WIDGET (front->list_win));

  fprintf (f, "QUICKLIST %s 06/10/99 %u %u %u %u %u %u %u %u\n",
           VERSION,
	   front->last_field + 1,
	   front->sort_ct, 
	   front->filter_ct, 
	   front->report_ct,
	   front->width, 
	   front->height,
	   front->x,
	   front->y);
  for (fieldx = 0; fieldx <= front->last_field; fieldx++) {
    remove_ql_chars (front->fields[fieldx].name);
    fprintf (f, "FIELD %u %u %u %u %u %u %u %u %s\n",
  		  front->fields[fieldx].type,
		  front->fields[fieldx].formatting, 
		  front->fields[fieldx].decimal_places,
		  front->fields[fieldx].justification,
		  front->fields[fieldx].sheet_column,
		  front->fields[fieldx].width,
		  front->fields[fieldx].unused1,
		  front->fields[fieldx].unused2,
		  front->fields[fieldx].name);
  }
  
  for (sortx = 0; sortx < front->sort_ct; sortx++) {
    remove_ql_chars (front->sorts[sortx].name);
    fprintf (f, "SORT %u %u %s\\",
	     front->sorts[sortx].unused1,
	     front->sorts[sortx].unused2,
	     front->sorts[sortx].name);
    for (subx = 0; subx < front->sorts[sortx].line_ct; subx++)
      fprintf (f, " %u %u",
	       front->sorts[sortx].line[subx].field,
	       front->sorts[sortx].line[subx].ascending);
    fprintf (f, "\n");
  } /* end of printing one sort record */

  /* Here we need to write a filter. */
  for (filterx = 0; filterx < front->filter_ct; filterx++) {
    remove_ql_chars (front->filters[filterx].name);
    fprintf (f, "FILTER %d %d %s",
	     front->filters[filterx].by_and,
	     front->filters[filterx].use_nocase,
	     front->filters[filterx].name);
    for (subx = 0; subx < front->filters[filterx].line_ct; subx++) {
      fprintf (f, "\\%u %u",
	       front->filters[filterx].line[subx].field,	   
	       front->filters[filterx].line[subx].type);
      remove_ql_chars (front->filters[filterx].line[subx].compare);
	fprintf (f, " %s", 
		 front->filters[filterx].line[subx].compare);
    }
    fprintf (f, "\n"); /* Finish off the filter */
  }
	
  /* Now a report column */
  for (reportx = 0; reportx < front->report_ct; reportx++) {
    for (colx = 0; colx <= front->reports[reportx].last_column; colx++)
      fprintf (f, "COLUMN %u %u %u %u %u %u\n",
	       front->reports[reportx].column[colx].field,
	       front->reports[reportx].column[colx].width,
	       front->reports[reportx].column[colx].group,
	       front->reports[reportx].column[colx].total,
	       front->reports[reportx].column[colx].unused1,
	       front->reports[reportx].column[colx].unused2);
      
    remove_ql_chars ( front->reports[reportx].name);
    fprintf (f, "REPORT %i %i %u %u %s\\\\\n",
	     front->reports[reportx].sort,
	     front->reports[reportx].filter,
	     front->reports[reportx].width,
	     front->reports[reportx].height,
	     front->reports[reportx].name);
    
  } /* end of writing report columns and report records */
  fprintf (f, "DATA 0 0\n");

  /* NOW WRITE THE DATA RECORDS.  Last row is always empty. 
   The logic is difficult enough that I use an intermediate variable */
  for (rowx = 0; rowx < front->last_row; rowx++) {
    got_data = FALSE; /* to not write empty records */
    blank_fields = 0; /* to not write trailing \\\\\ */
     for (fieldx = 0; fieldx <= front->last_field; fieldx++) {
       colx = front->fields [fieldx].sheet_column;
       text = gtk_sheet_cell_get_text ( GTK_SHEET (front->sheet),
					rowx, colx);
       if (text) {
	 while (blank_fields) { /* write the skipped blank fields */
	   fprintf (f, "\\");
	   blank_fields--;
	 }

	 remove_ql_chars (text);
	 fprintf (f, "%s\\", text);
	 got_data = TRUE;
       }
       else
	 blank_fields++; 
     } 
     if (got_data)
       fprintf (f, "\n"); /* write nothing if nothing there */
  }
  fprintf (f, "\n");/* write nothing if nothing there */
  fclose (f);
  front->changed = FALSE;
}
                           
/* |--------------------------------|
   |      write_html                |
   |--------------------------------|
*/ 
void write_html () {  
  gchar *text;
  gint32 rowx;
  gint16 fieldx;
  gint16 justification;
  
  gint16 colx = 0; /* indexes into array */

  /* Output Head Info Stuff */
  fprintf (f, 
	   "<html>\n"
	   "<head>\n"
	   "<title>%s</title>\n"
	   "<meta name=\"Generator\" content=\"QUICKLIST %s\">\n"
	   "</head>\n\n"
	   "<body bgcolor=\"#ffffff\">\n"
	   "<table width=\"2\">\n"
	   "  <tr>\n",
	   front->file_path, VERSION); 
  for (colx = write_range.col0; colx <= write_range.coli; colx++) {
    fieldx = front->col_to_field [colx];
    fprintf (f, "    <th>%s</th>\n",
		  front->fields [fieldx].name);
  }
  fprintf (f, "  </tr>\n");

  for (rowx = write_range.row0; rowx <= write_range.rowi; rowx++) {
    if (print_all != 'A' && !row_is_visible (rowx))
	continue;
    fprintf (f, "  <tr>\n");
    for (colx = write_range.col0; colx <= write_range.coli; colx++) {
      text = gtk_sheet_cell_get_text( GTK_SHEET (front->sheet),
				      rowx, colx);
      fputs ("<td>", f);
      if (text) {
	fieldx = front->col_to_field [colx];
	justification = front->fields [fieldx].justification;
	if (justification == GTK_JUSTIFY_CENTER)
	  fputs ("<center>", f);
 	else if (justification == GTK_JUSTIFY_RIGHT)
	  fputs ("<right>", f);
	fprintf (f, "%s", text);	
	if (justification == GTK_JUSTIFY_CENTER)
	  fputs ("</center>", f);
 	else if (justification == GTK_JUSTIFY_RIGHT)
	  fputs ("</right>", f);
      }
      fputs ("</td>\n", f);
    } 
    fprintf (f, "  </tr>\n");
  }
  fprintf (f, "</table>\n</body>\n</html>\n");
  fclose (f);
  return;
} /* end of html output */
                           
/* |--------------------------------|
   |      write_all_types           |
   |--------------------------------|
   This puts all file types onto disk */ 
void write_all_types (char* name) {
  char backup_name [1024];
  
  strcpy (backup_name, name);
  strcat (backup_name, "~");
  rename (name, backup_name);

  /* determine if whole file is to be written */
  write_range.row0 = write_range.col0 = 0;
  write_range.rowi = front->last_row - 1;
  write_range.coli = front->last_field;
  if (print_all == 'H') /* highlighted */
    write_range = front->sel_range;

  if (!(f = fopen (name, "w"))) {
    level1_error (_("Can't write the file.  Strange."), "Go back");
    return;
  }

  switch (file_type) {
  case 1:  
    write_ql_file ();
    front->changed = FALSE;
    break;
  case 2:
    write_html ();
    break;
  case 3:
    write_delimited (',');
    break;
  case 4:
    write_delimited ('\t');
    break;
  }
  
  dim_all_menus ();
} /* end of write_all_types */




