=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: QuantLibTestSuite.rb,v 1.6 2002/01/16 15:17:06 nando Exp $

require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

require 'american_option'
require 'barrier_option'
require 'binary_option'
require 'cliquet_option'
require 'covariance'
require 'dates'
require 'day_counters'
require 'distributions'
require 'european_option'
require 'european_with_dividends'
require 'finite_difference_european'
require 'implied_volatility'
require 'montecarlo_pricers'
require 'mc_multifactor_pricers'
require 'piecewise_flat_forward'
require 'random_generators'
require 'risk_statistics'
require 'segment_integral'
require 'statistics'
require 'swap'

suite = RUNIT::TestSuite.new
suite.add_test(FdAmericanOptionTest.suite)
suite.add_test(BarrierOptionTest.suite)
suite.add_test(BinaryOptionTest.suite)
suite.add_test(CliquetOptionTest.suite)
suite.add_test(CovarianceTest.suite)
suite.add_test(DateTest.suite)
suite.add_test(DayCounterTest.suite)
suite.add_test(DistributionTest.suite)
suite.add_test(EuropeanOptionTest.suite)
suite.add_test(FdDividendEuropeanOptionTest.suite)
suite.add_test(FdEuropeanOptionTest.suite)
suite.add_test(ImpliedVolatilityTest.suite)
suite.add_test(MonteCarloPricerTest.suite)
suite.add_test(McMultiFactorPricerTest.suite)
suite.add_test(PiecewiseFlatForwardTest.suite)
suite.add_test(RNGTest.suite)
suite.add_test(RiskStatisticsTest.suite)
suite.add_test(SegmentIntegralTest.suite)
suite.add_test(StatisticsTest.suite)
suite.add_test(SimpleSwapTest.suite)

result = RUNIT::CUI::TestRunner.run(suite)
unless result.succeed?
    exit(1)
end


