

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Matrix.i,v 1.4 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_matrix_i
#define quantlib_matrix_i

%include String.i
%include Types.i

%{
using QuantLib::Math::Matrix;
typedef QuantLib::Math::Matrix::row_iterator MatrixRow;
using QuantLib::Math::outerProduct;
using QuantLib::Math::transpose;
using QuantLib::Math::matrixSqrt;
%}

class MatrixRow {
  private:
    // access control - no constructor exported
    MatrixRow();
  public:
    ~MatrixRow();
};

%addmethods MatrixRow {
    double __getitem__(int i) {
        return (*self)[i];
    }
    void __setitem__(int i, double x) {
        (*self)[i] = x;
    }
};

class Matrix {
  public:
    Matrix(size_t rows, size_t columns, double value = 0.0);
    ~Matrix();
    size_t rows() const;
    size_t columns() const;
};

%addmethods Matrix {
    MatrixRow __getitem__(int i) {
        return (*self)[i];
    }
    Matrix __add__(const Matrix& m) {
        return *self+m;
    }
    Matrix __sub__(const Matrix& m) {
        return *self-m;
    }
    Matrix __mul__(double x) {
        return *self*x;
    }
    Matrix __div__(double x) {
        return *self/x;
    }
    String __str__() {
        String s;
        for (size_t j=0; j<self->rows(); j++) {
    	    s += "\n";
            s += QuantLib::DoubleFormatter::toString((*self)[j][0]);
            for (size_t i=1; i<self->columns(); i++) {
                s += ",";
                s += QuantLib::DoubleFormatter::toString((*self)[j][i]);
            }
        }
        s += "\n";
        return s;
    }
};

// functions

Matrix transpose(const Matrix& m);
Matrix outerProduct(const Array& v1, const Array& v2);
%inline %{
    Matrix matrixProduct(const Matrix& m1, const Matrix& m2) {
        return m1*m2;
    }
%}
Matrix matrixSqrt(const Matrix& m);



#endif
