

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: History.i,v 1.7 2002/01/16 14:51:30 nando Exp $

#ifndef quantlib_history_i
#define quantlib_history_i

%include Date.i
%include Vectors.i
%include String.i


// History class

%{
using QuantLib::History;
typedef QuantLib::History::const_iterator HistoryIterator;
typedef QuantLib::History::const_valid_iterator HistoryValidIterator;
typedef QuantLib::History::const_data_iterator HistoryDataIterator;
typedef QuantLib::History::const_valid_data_iterator HistoryValidDataIterator;
typedef HistoryIterator HistoryEntry;
typedef HistoryValidIterator HistoryValidEntry;
using QuantLib::DateFormatter;
using QuantLib::DoubleFormatter;
%}

class HistoryEntry {
    %pragma(ruby) include = "Comparable";
  private:
    // access control - no constructor exported
    HistoryEntry();
  public:
    ~HistoryEntry();
};

%addmethods HistoryEntry {
    void crash() {}
    Date date() {
        return (*self)->date();
    }
    double value() {
        return (*self)->value();
    }
    HistoryEntry succ() {
        return (*self)+1;
    }
    int __cmp__(const HistoryEntry& other) {
        return (*self == other ? 0 : (*self < other ? -1 : 1));
    }
    String __str__() {
        return DateFormatter::toString((*self)->date()) +
        "\t" + ((*self)->value() == Null<double>() ? String("Null") :
        DoubleFormatter::toString((*self)->value()));
    }
    bool isValid() {
        return (*self)->value() != Null<double>();
    }
    %pragma(ruby) pred = "isValid";
}


class HistoryValidEntry {
    %pragma(ruby) include = "Comparable";
  private:
    // access control - no constructor exported
    HistoryValidEntry();
  public:
    ~HistoryValidEntry();
};

%addmethods HistoryValidEntry {
    void crash() {}
    Date date() {
        return (*self)->date();
    }
    double value() {
        return (*self)->value();
    }
    HistoryValidEntry succ() {
        HistoryValidEntry temp = *self;
        return ++temp;
    }
    int __cmp__(const HistoryValidEntry& other) {
        return ((*self)->date() == other->date() ? 0 :
               ((*self)->date() < other->date() ? -1 : 1));
    }
    String __str__() {
        return DateFormatter::toString((*self)->date()) +
        "\t" + ((*self)->value() == Null<double>() ? String("Null") :
        DoubleFormatter::toString((*self)->value()));
    }
}


class History {
    %pragma(ruby) include = "Enumerable";
  public:
    History(DateVector dates, DoubleVector values);
    ~History();
};


%addmethods History {
    void crash() {}
    int __len__() {
        return self->size();
    }
    double __getitem__(Date d) {
        return (*self)[d];
    }
    String __str__() {
        return "Historical data from " +
            DateFormatter::toString(self->firstDate()) +
            " to " + DateFormatter::toString(self->lastDate());
    }
    HistoryEntry first() {
        return self->begin();
    }
    HistoryEntry last() {
        return self->end()-1;
    }
    HistoryEntry entry(Date d) {
        QL_REQUIRE(d >= self->firstDate() && d <= self->lastDate(),
            "date outside history range");
        return self->iterator(d);
    }
    HistoryValidEntry firstValid() {
        return self->vbegin();
    }
    HistoryValidEntry lastValid() {
        return --(self->vend());
    }
    HistoryValidEntry validEntry(Date d) {
        QL_REQUIRE(d >= self->firstDate() && d <= self->lastDate(),
            "date outside history range");
        return self->valid_iterator(d);
    }
    void each() {
        for (HistoryEntry i=self->begin(); i!=self->end(); i++) {
            HistoryEntry* e = new HistoryEntry(i);
            rb_yield(Wrap_HistoryEntry(cHistoryEntry,e));
        }
    }
}


#endif
