Polymer({

    is: 'paper-card',

    properties: {

      /**
       * The title of the card.
       */
      heading: {
        type: String,
        value: '',
        observer: '_headingChanged'
      },

      /**
       * The url of the title image of the card.
       */
      image: {
        type: String,
        value: ''
      },

      /**
       * When `true`, any change to the image url property will cause the
       * `placeholder` image to be shown until the image is fully rendered.
       */
      preloadImage: {
        type: Boolean,
        value: false
      },

      /**
       * When `preloadImage` is true, setting `fadeImage` to true will cause the
       * image to fade into place.
       */
      fadeImage: {
        type: Boolean,
        value: false
      },

      /**
       * The z-depth of the card, from 0-5.
       */
      elevation: {
        type: Number,
        value: 1,
        reflectToAttribute: true
      },

      /**
       * Set this to true to animate the card shadow when setting a new
       * `z` value.
       */
      animatedShadow: {
        type: Boolean,
        value: false
      },

      /**
       * Read-only property used to pass down the `animatedShadow` value to
       * the underlying paper-material style (since they have different names).
       */
      animated: {
        type: Boolean,
        reflectToAttribute: true,
        readOnly: true,
        computed: '_computeAnimated(animatedShadow)'
      }
    },

    _headingChanged: function(heading) {
      var label = this.getAttribute('aria-label');
      this.setAttribute('aria-label', heading);
    },

    _computeHeadingClass: function(image) {
      var cls = 'title-text';
      if (image)
        cls += ' over-image';
      return cls;
    },

    _computeAnimated: function(animatedShadow) {
      return animatedShadow;
    }
  });