/*
 * Copyright (C) 2012 Apple Inc. All rights reserved.
 * Copyright (C) Research In Motion Limited 2011. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef Latin1TextIterator_h
#define Latin1TextIterator_h

#include "wtf/Allocator.h"
#include "wtf/text/WTFString.h"

namespace blink {

class Latin1TextIterator {
    STACK_ALLOCATED();
public:
    // The passed in LChar pointer starts at 'offset'.
    // The iterator operates on the range [offset, endOffset].
    // 'endCharacter' denotes the maximum length of the UChar array,
    // which might exceed 'endOffset'.
    Latin1TextIterator(const LChar* characters, int offset, int endOffset)
        : m_characters(characters)
        , m_offset(offset)
        , m_endOffset(endOffset)
    {
    }

    bool consume(UChar32& character)
    {
        if (m_offset >= m_endOffset)
            return false;

        character = *m_characters;
        return true;
    }

    void advance()
    {
        m_characters++;
        m_offset++;
    }

    int offset() const { return m_offset; }
    const LChar* characters() const { return m_characters; }
    // FIXME: Only used by SimpleShaper, should be removed once the SimpleShaper
    // is removed.
    unsigned glyphLength() const { return 1; }

private:
    const LChar* m_characters;
    int m_offset;
    int m_endOffset;
};

} // namespace blink

#endif
