/***************************************************************************
    File                 : AxesDialog.cpp
    Project              : QtiPlot
    --------------------------------------------------------------------
    Copyright            : (C) 2006 by Ion Vasilief, Tilman Hoener zu Siederdissen
    Email (use @ for *)  : ion_vasilief*yahoo.fr, thzs*gmx.net
    Description          : General plot options dialog

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor,                    *
 *   Boston, MA  02110-1301  USA                                           *
 *                                                                         *
 ***************************************************************************/
#include "AxesDialog.h"
#include "../../ApplicationWindow.h"
#include "../../MyParser.h"
#include "../../ColorButton.h"
#include "../../TextFormatButtons.h"
#include "../../Table.h"
#include "../../DoubleSpinBox.h"
#include "../../ColorBox.h"
#include "../../TextDialog.h"
#include "../Graph.h"
#include "../Grid.h"
#include "../ScaleDraw.h"
#include "../ScaleEngine.h"

#include <QCheckBox>
#include <QComboBox>
#include <QLabel>
#include <QPushButton>
#include <QSpinBox>
#include <QTabWidget>
#include <QLayout>
#include <QMessageBox>
#include <QFontDialog>
#include <QDate>
#include <QList>
#include <QListWidget>
#include <QVector>
#include <QGroupBox>
#include <QDateTimeEdit>
#include <QTimeEdit>

#include <qwt_plot.h>
#include <qwt_scale_widget.h>

/* XPM */
static const char* const bottom_scl_xpm[] = {
"36 38 75 1",
" 	c None",
".	c #FFFFFF",
"+	c #818181",
"@	c #070707",
"#	c #101010",
"$	c #EEEEEE",
"%	c #1D1D1D",
"&	c #ACACAC",
"*	c #151515",
"=	c #121212",
"-	c #929292",
";	c #242424",
">	c #D5D5D5",
",	c #C9C9C9",
"'	c #2A2A2A",
")	c #5E5E5E",
"!	c #000000",
"~	c #C8C8C8",
"{	c #D2D2D2",
"]	c #090909",
"^	c #060606",
"/	c #FEFEFE",
"(	c #FCFCFC",
"_	c #F7F7F7",
":	c #CECECE",
"<	c #444444",
"[	c #E0E0E0",
"}	c #464646",
"|	c #E8E8E8",
"1	c #282828",
"2	c #D3D3D3",
"3	c #D1D1D1",
"4	c #A4A4A4",
"5	c #484848",
"6	c #EBEBEB",
"7	c #7D7D7D",
"8	c #050505",
"9	c #7F7F7F",
"0	c #FDFDFD",
"a	c #7D6F6F",
"b	c #F38C82",
"c	c #E71E09",
"d	c #E82612",
"e	c #FDEFEE",
"f	c #E9321F",
"g	c #F7B3AC",
"h	c #E82B17",
"i	c #E82814",
"j	c #F49C93",
"k	c #EA3826",
"l	c #FBD8D5",
"m	c #F9CEC9",
"n	c #EA3E2C",
"o	c #EF6D5F",
"p	c #E71803",
"q	c #F9CDC8",
"r	c #FAD6D2",
"s	c #E7200B",
"t	c #E71D08",
"u	c #FEFCFC",
"v	c #FEF7F7",
"w	c #FAD2CE",
"x	c #ED5546",
"y	c #FCE2E0",
"z	c #ED5748",
"A	c #FCEAE8",
"B	c #EA3C2A",
"C	c #FAD7D3",
"D	c #FAD5D1",
"E	c #F6ACA5",
"F	c #ED594A",
"G	c #FDECEB",
"H	c #F2897E",
"I	c #E71C07",
"J	c #F28B80",
"....................................",
"......+@#+......$%......&*=-........",
"......;>,'......)!......%~{]........",
"......^/(^......_!........:<........",
"......^((^.......!.......[}|........",
"......123;.......!......456.........",
"......78^9.......!......*!!!........",
"+@#+................................",
";>,'...(!0.......!.......!.....+@#+.",
"^/(^...!!!!!!!!!!!!!!!!!!!!!!..;>,'.",
"^((^...!aaaaaaaaaaaaaaaaaaaa!..^/(^.",
"123;..!!aaaaaaaaaaaaaaaaaaaa!!.^((^.",
"78^9...!aaaaaaaaaaaaaaaaaaaa!..123;.",
".......!aaaaaaaaaaaaaaaaaaaa!..78^9.",
".......!aaaaaaaaaaaaaaaaaaaa!.......",
"$%.....!aaaaaaaaaaaaaaaaaaaa!.......",
")!.....!aaaaaaaaaaaaaaaaaaaa!..$%...",
"_!.....!aaaaaaaaaaaaaaaaaaaa!..)!...",
".!....!!aaaaaaaaaaaaaaaaaaaa!!._!...",
".!.....!aaaaaaaaaaaaaaaaaaaa!...!...",
".!.....!aaaaaaaaaaaaaaaaaaaa!...!...",
".......!aaaaaaaaaaaaaaaaaaaa!...!...",
"&*=-...!aaaaaaaaaaaaaaaaaaaa!.......",
"%~{]...!aaaaaaaaaaaaaaaaaaaa!..&*=-.",
"..:<...!aaaaaaaaaaaaaaaaaaaa!..%~{].",
".[}|..!!aaaaaaaaaaaaaaaaaaaa!!...:<.",
"456....!aaaaaaaaaaaaaaaaaaaa!...[}|.",
"*!!!...!aaaaaaaaaaaaaaaaaaaa!..456..",
".......!!!!!!!!!!!!!!!!!!!!!!..*!!!.",
".........!........!.......!.........",
"....................................",
"........bcdb.....ef......ghij.......",
"........klmn.....op......fqrs.......",
"........t/ut.....vp........wx.......",
"........tuut......p.......yzA.......",
"........BCDk......p......EFG........",
"........HItJ......p......hppp.......",
"...................................."};

/* XPM */
static const char* const top_scl_xpm[] = {
"36 38 75 1",
" 	c None",
".	c #FFFFFF",
"+	c #F38C82",
"@	c #E71E09",
"#	c #E82612",
"$	c #FEFAFA",
"%	c #E9321F",
"&	c #F7B3AC",
"*	c #E82B17",
"=	c #E82814",
"-	c #F49C93",
";	c #EA3826",
">	c #FBD8D5",
",	c #F9CEC9",
"'	c #EA3E2C",
")	c #EF6D5F",
"!	c #E71803",
"~	c #F9CDC8",
"{	c #FAD6D2",
"]	c #E7200B",
"^	c #E71D08",
"/	c #FEFEFE",
"(	c #FEFCFC",
"_	c #FAD2CE",
":	c #ED5546",
"<	c #FCE2E0",
"[	c #ED5748",
"}	c #FCEAE8",
"|	c #EA3C2A",
"1	c #FAD7D3",
"2	c #FAD5D1",
"3	c #F6ACA5",
"4	c #ED594A",
"5	c #FDF2F1",
"6	c #F2897E",
"7	c #E71C07",
"8	c #F28B80",
"9	c #818181",
"0	c #070707",
"a	c #101010",
"b	c #242424",
"c	c #D5D5D5",
"d	c #C9C9C9",
"e	c #2A2A2A",
"f	c #000000",
"g	c #060606",
"h	c #FCFCFC",
"i	c #7D6F6F",
"j	c #282828",
"k	c #D3D3D3",
"l	c #D1D1D1",
"m	c #7D7D7D",
"n	c #050505",
"o	c #7F7F7F",
"p	c #FAFAFA",
"q	c #1D1D1D",
"r	c #5E5E5E",
"s	c #ACACAC",
"t	c #151515",
"u	c #121212",
"v	c #929292",
"w	c #C8C8C8",
"x	c #D2D2D2",
"y	c #090909",
"z	c #CECECE",
"A	c #444444",
"B	c #E0E0E0",
"C	c #464646",
"D	c #E8E8E8",
"E	c #A4A4A4",
"F	c #484848",
"G	c #F1F1F1",
"H	c #EEEEEE",
"I	c #F7F7F7",
"J	c #EBEBEB",
"....................................",
".......+@#+.....$%......&*=-........",
".......;>,'.....)!......%~{]........",
".......^/(^......!........_:........",
".......^((^......!.......<[}........",
".......|12;......!......345.........",
".......67^8......!......*!!!........",
"90a9................................",
"bcde....f........f.......f.....90a9.",
"g/hg...ffffffffffffffffffffff..bcde.",
"ghhg...fiiiiiiiiiiiiiiiiiiiif..g/hg.",
"jklb..ffiiiiiiiiiiiiiiiiiiiiff.ghhg.",
"mngo...fiiiiiiiiiiiiiiiiiiiif..jklb.",
".......fiiiiiiiiiiiiiiiiiiiif..mngo.",
".......fiiiiiiiiiiiiiiiiiiiif.......",
"pq.....fiiiiiiiiiiiiiiiiiiiif.......",
"rf.....fiiiiiiiiiiiiiiiiiiiif..pq...",
".f.....fiiiiiiiiiiiiiiiiiiiif..rf...",
".f....ffiiiiiiiiiiiiiiiiiiiiff..f...",
".f.....fiiiiiiiiiiiiiiiiiiiif...f...",
".f.....fiiiiiiiiiiiiiiiiiiiif...f...",
".......fiiiiiiiiiiiiiiiiiiiif...f...",
"stuv...fiiiiiiiiiiiiiiiiiiiif.......",
"qwxy...fiiiiiiiiiiiiiiiiiiiif..stuv.",
"..zA...fiiiiiiiiiiiiiiiiiiiif..qwxy.",
".BCD..ffiiiiiiiiiiiiiiiiiiiiff...zA.",
"EFG....fiiiiiiiiiiiiiiiiiiiif...BCD.",
"tfff...fiiiiiiiiiiiiiiiiiiiif..EFG..",
".......ffffffffffffffffffffff..tfff.",
".........f........f.......f.........",
"....................................",
".......90a9......Hq......stuv.......",
".......bcde......rf......qwxy.......",
".......g/hg......If........zA.......",
".......ghhg.......f.......BCD.......",
".......jklb.......f......EFJ........",
".......mngo.......f......tfff.......",
"...................................."};

/* XPM */
static const char* const left_scl_xpm[] = {
"36 36 72 1",
" 	c None",
".	c #FFFFFF",
"+	c #818181",
"@	c #070707",
"#	c #101010",
"$	c #FAFAFA",
"%	c #1D1D1D",
"&	c #ACACAC",
"*	c #151515",
"=	c #121212",
"-	c #929292",
";	c #242424",
">	c #D5D5D5",
",	c #C9C9C9",
"'	c #2A2A2A",
")	c #5E5E5E",
"!	c #000000",
"~	c #C8C8C8",
"{	c #D2D2D2",
"]	c #090909",
"^	c #060606",
"/	c #FEFEFE",
"(	c #FCFCFC",
"_	c #CECECE",
":	c #444444",
"<	c #E0E0E0",
"[	c #464646",
"}	c #E8E8E8",
"|	c #282828",
"1	c #D3D3D3",
"2	c #D1D1D1",
"3	c #A4A4A4",
"4	c #484848",
"5	c #F1F1F1",
"6	c #7D7D7D",
"7	c #050505",
"8	c #7F7F7F",
"9	c #F38C82",
"0	c #E71E09",
"a	c #E82612",
"b	c #EA3826",
"c	c #FBD8D5",
"d	c #F9CEC9",
"e	c #EA3E2C",
"f	c #E71D08",
"g	c #FEFCFC",
"h	c #7D6F6F",
"i	c #EA3C2A",
"j	c #FAD7D3",
"k	c #FAD5D1",
"l	c #F2897E",
"m	c #E71C07",
"n	c #F28B80",
"o	c #FEFAFA",
"p	c #E9321F",
"q	c #EF6D5F",
"r	c #E71803",
"s	c #F7B3AC",
"t	c #E82B17",
"u	c #E82814",
"v	c #F49C93",
"w	c #F9CDC8",
"x	c #FAD6D2",
"y	c #E7200B",
"z	c #FAD2CE",
"A	c #ED5546",
"B	c #FCE2E0",
"C	c #ED5748",
"D	c #FCEAE8",
"E	c #F6ACA5",
"F	c #ED594A",
"G	c #FDF2F1",
".......+@#+......$%......&*=-.......",
".......;>,'......)!......%~{].......",
".......^/(^.......!........_:.......",
".......^((^.......!.......<[}.......",
".......|12;.......!......345........",
".......67^8.......!......*!!!.......",
"....................................",
".90a9...!........!.......!.....+@#+.",
".bcde..!!!!!!!!!!!!!!!!!!!!!!..;>,'.",
".f/gf..!hhhhhhhhhhhhhhhhhhhh!..^/(^.",
".fggf.!!hhhhhhhhhhhhhhhhhhhh!!.^((^.",
".ijkb..!hhhhhhhhhhhhhhhhhhhh!..|12;.",
".lmfn..!hhhhhhhhhhhhhhhhhhhh!..67^8.",
".......!hhhhhhhhhhhhhhhhhhhh!.......",
".......!hhhhhhhhhhhhhhhhhhhh!.......",
"..op...!hhhhhhhhhhhhhhhhhhhh!...%...",
"..qr...!hhhhhhhhhhhhhhhhhhhh!..)!...",
"...r..!!hhhhhhhhhhhhhhhhhhhh!!..!...",
"...r...!hhhhhhhhhhhhhhhhhhhh!...!...",
"...r...!hhhhhhhhhhhhhhhhhhhh!...!...",
"...r...!hhhhhhhhhhhhhhhhhhhh!...!...",
".......!hhhhhhhhhhhhhhhhhhhh!.......",
".stuv..!hhhhhhhhhhhhhhhhhhhh!..&*=-.",
".pwxy..!hhhhhhhhhhhhhhhhhhhh!..%~{].",
"...zA.!!hhhhhhhhhhhhhhhhhhhh!!..._:.",
"..BCD..!hhhhhhhhhhhhhhhhhhhh!...<[}.",
".EFG...!hhhhhhhhhhhhhhhhhhhh!..34...",
".trrr..!!!!!!!!!!!!!!!!!!!!!!..*!!!.",
".........!........!.......!.........",
"....................................",
".......+@#+......$%......&*=-.......",
".......;>,'......)!......%~{].......",
".......^/(^.......!........_:.......",
".......^((^.......!.......<[}.......",
".......|12;.......!......345........",
".......67^8.......!......*!!!......."};

/* XPM */
static const char* const right_scl_xpm[] = {
"36 36 72 1",
" 	c None",
".	c #FFFFFF",
"+	c #818181",
"@	c #070707",
"#	c #101010",
"$	c #FAFAFA",
"%	c #1D1D1D",
"&	c #ACACAC",
"*	c #151515",
"=	c #121212",
"-	c #929292",
";	c #242424",
">	c #D5D5D5",
",	c #C9C9C9",
"'	c #2A2A2A",
")	c #5E5E5E",
"!	c #000000",
"~	c #C8C8C8",
"{	c #D2D2D2",
"]	c #090909",
"^	c #060606",
"/	c #FEFEFE",
"(	c #FCFCFC",
"_	c #CECECE",
":	c #444444",
"<	c #E0E0E0",
"[	c #464646",
"}	c #E8E8E8",
"|	c #282828",
"1	c #D3D3D3",
"2	c #D1D1D1",
"3	c #A4A4A4",
"4	c #484848",
"5	c #F1F1F1",
"6	c #7D7D7D",
"7	c #050505",
"8	c #7F7F7F",
"9	c #F38C82",
"0	c #E71E09",
"a	c #E82612",
"b	c #EA3826",
"c	c #FBD8D5",
"d	c #F9CEC9",
"e	c #EA3E2C",
"f	c #7D6F6F",
"g	c #E71D08",
"h	c #FEFCFC",
"i	c #EA3C2A",
"j	c #FAD7D3",
"k	c #FAD5D1",
"l	c #F2897E",
"m	c #E71C07",
"n	c #F28B80",
"o	c #FEFAFA",
"p	c #E9321F",
"q	c #EF6D5F",
"r	c #E71803",
"s	c #F7B3AC",
"t	c #E82B17",
"u	c #E82814",
"v	c #F49C93",
"w	c #F9CDC8",
"x	c #FAD6D2",
"y	c #E7200B",
"z	c #FAD2CE",
"A	c #ED5546",
"B	c #FCE2E0",
"C	c #ED5748",
"D	c #FCEAE8",
"E	c #F6ACA5",
"F	c #ED594A",
"G	c #FDF2F1",
".......+@#+......$%......&*=-.......",
".......;>,'......)!......%~{].......",
".......^/(^.......!........_:.......",
".......^((^.......!.......<[}.......",
".......|12;.......!......345........",
".......67^8.......!......*!!!.......",
"....................................",
".+@#+...!........!.......!.....90a9.",
".;>,'..!!!!!!!!!!!!!!!!!!!!!!..bcde.",
".^/(^..!ffffffffffffffffffff!..g/hg.",
".^((^.!!ffffffffffffffffffff!!.ghhg.",
".|12;..!ffffffffffffffffffff!..ijkb.",
".67^8..!ffffffffffffffffffff!..lmgn.",
".......!ffffffffffffffffffff!.......",
".......!ffffffffffffffffffff!.......",
".$%....!ffffffffffffffffffff!...op..",
".)!....!ffffffffffffffffffff!...qr..",
"..!...!!ffffffffffffffffffff!!...r..",
"..!....!ffffffffffffffffffff!....r..",
"..!....!ffffffffffffffffffff!....r..",
"..!....!ffffffffffffffffffff!....r..",
".......!ffffffffffffffffffff!.......",
".&*=-..!ffffffffffffffffffff!..stuv.",
".%~{]..!ffffffffffffffffffff!..pwxy.",
"..._:.!!ffffffffffffffffffff!!...zA.",
"..<[}..!ffffffffffffffffffff!...BCD.",
".345...!ffffffffffffffffffff!..EFG..",
".*!!!..!!!!!!!!!!!!!!!!!!!!!!..trrr.",
".........!........!.......!.........",
"....................................",
".......+@#+......$%......&*=-.......",
".......;>,'......)!......%~{].......",
".......^/(^.......!........_:.......",
".......^((^.......!.......<[}.......",
".......|12;.......!......345........",
".......67^8.......!......*!!!......."};

static const char* const image2_data[] = {
"74 77 171 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #E0E0E0",
"@ 	c #FAFAFA",
"# 	c #363636",
"$ 	c #ABABAB",
"% 	c #000000",
"& 	c #BDBDBD",
"* 	c #737373",
"= 	c #858585",
"- 	c #FFE8E8",
"; 	c #FFF7F7",
"> 	c #FFD1D1",
", 	c #FFF0F0",
"' 	c #E6E6E6",
") 	c #FFB2B2",
"! 	c #FFE6E6",
"~ 	c #FF6666",
"{ 	c #FFCCCC",
"] 	c #C9C9C9",
"^ 	c #939493",
"/ 	c #808080",
"( 	c #878787",
"_ 	c #D6D6D6",
": 	c #969696",
"< 	c #030303",
"[ 	c #383838",
"} 	c #4C4C4C",
"| 	c #1A1A1A",
"1 	c #080808",
"2 	c #C2C2C2",
"3 	c #EBEBEB",
"4 	c #F0F0F0",
"5 	c #8C8C8C",
"6 	c #7A7A7A",
"7 	c #A3A3A3",
"8 	c #999999",
"9 	c #A1A1A1",
"0 	c #828282",
"a 	c #949494",
"b 	c #F2F2F2",
"c 	c #474747",
"d 	c #545454",
"e 	c #0F0F0F",
"f 	c #B5B5B5",
"g 	c #CFCFCF",
"h 	c #262626",
"i 	c #333333",
"j 	c #DEDEDE",
"k 	c #FDFDFD",
"l 	c #D7D7D7",
"m 	c #B7B7B7",
"n 	c #C4C4C4",
"o 	c #F7F7F7",
"p 	c #CCCCCC",
"q 	c #2E2E2E",
"r 	c #B2B2B2",
"s 	c #DFDFDF",
"t 	c #ACACAC",
"u 	c #ADADAD",
"v 	c #D3D3D3",
"w 	c #CDCDCD",
"x 	c #AAAAAA",
"y 	c #D4C3C3",
"z 	c #A9A9A9",
"A 	c #AAA8A8",
"B 	c #DB7F7F",
"C 	c #E3E3E3",
"D 	c #E5E5E5",
"E 	c #F2DADA",
"F 	c #B19999",
"G 	c #FFC4C4",
"H 	c #D2D2D2",
"I 	c #FFD4D4",
"J 	c #EA6565",
"K 	c #E2E2E2",
"L 	c #FFA1A1",
"M 	c #C8C8C8",
"N 	c #AFAFAF",
"O 	c #FF9999",
"P 	c #F5C6C6",
"Q 	c #E9E9E9",
"R 	c #B6B6B6",
"S 	c #CFB4B4",
"T 	c #B9B9B9",
"U 	c #F5F5F5",
"V 	c #ACA7A7",
"W 	c #EAEAEA",
"X 	c #F9F9F9",
"Y 	c #B8B8B8",
"Z 	c #C0A6A6",
"` 	c #B4B4B4",
" .	c #EFEFEF",
"..	c #F2C3C3",
"+.	c #EEEEEE",
"@.	c #BCBCBC",
"#.	c #C5C5C5",
"$.	c #DADADA",
"%.	c #BEBEBE",
"&.	c #B0B0B0",
"*.	c #FBFBFB",
"=.	c #C6C6C6",
"-.	c #B1B1B1",
";.	c #BABABA",
">.	c #AEAEAE",
",.	c #D0D0D0",
"'.	c #FCFCFC",
").	c #141414",
"!.	c #D8D8D8",
"~.	c #C7C7C7",
"{.	c #575757",
"].	c #3D3D3D",
"^.	c #C3C3C3",
"/.	c #5E5E5E",
"(.	c #7D7D7D",
"_.	c #B3B3B3",
":.	c #F6C8C8",
"<.	c #757575",
"[.	c #919191",
"}.	c #CAB3B3",
"|.	c #EDEDED",
"1.	c #ADA8A8",
"2.	c #666666",
"3.	c #2B2B2B",
"4.	c #BBBBBB",
"5.	c #C9AAAA",
"6.	c #292929",
"7.	c #D4D4D4",
"8.	c #FBC9C9",
"9.	c #E8E8E8",
"0.	c #9C9C9C",
"a.	c #E4E4E4",
"b.	c #E7E7E7",
"c.	c #CACACA",
"d.	c #C1C1C1",
"e.	c #E39090",
"f.	c #CBCBCB",
"g.	c #ADA3A3",
"h.	c #C8B0B0",
"i.	c #F59A9A",
"j.	c #C0A9A9",
"k.	c #C9BFBF",
"l.	c #7A4747",
"m.	c #A18C8C",
"n.	c #8C8282",
"o.	c #332929",
"p.	c #242424",
"q.	c #0A0A0A",
"r.	c #454545",
"s.	c #595959",
"t.	c #525252",
"u.	c #5C5C5C",
"v.	c #D9D9D9",
"w.	c #121212",
"x.	c #8A8A8A",
"y.	c #171717",
"z.	c #A8A8A8",
"A.	c #696969",
"B.	c #707070",
"C.	c #9E9E9E",
"D.	c #404040",
"E.	c #616161",
"F.	c #8F8F8F",
"G.	c #4F4F4F",
"H.	c #050505",
"I.	c #DBDBDB",
"J.	c #4A4A4A",
"K.	c #212121",
"L.	c #3B3B3B",
"M.	c #636363",
"N.	c #D1D1D1",
". . . . . . . . . . + . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . @ # . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . $ % & . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . * % = . . . . . . . . . . . - . . . . . . . . . . . ; > . . . . . . . . . . . . , . . . . . . . . . . . - - . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . ] ^ / ( _ . ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . : < [ } | 1 ] ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . 2 ' . . 3 % / ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . . . 4 % 5 ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . . . 6 1 + ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . . 7 < 8 @ 5 % 9 . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . 0 < a . b c % d . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . b d e f . . . ' % . . . . . . . . . . . . ) . . . . . . . . . . . ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". g h i j . . . . ' % . . . . . . . . . . . . ) . . . . k l m m m n o ! ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
"p 1 q $ r r r g . ' % . . . . . . . . . . . . ) . . . s t u ] v w r x y ~ . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
"7 i i i i i i : . ' % . . . . . . . . . . . . ) . . p z _ . . . . . l A B . . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . ) . C x D . . . . . . . E F ] . . . . . . . . . . . { . . . . . . . . . . . ) ) . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . G . u H . . . . . . . . I J x K . . . . . . . . . . { . . . . . . . . . . . L G . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { M N . . . . . . . . . { ~ _ $ o . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . P x Q . . . . . . . . . { ~ . & R . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . S T . . . . . . . . . . { ~ . U $ _ . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . 4 V W . . . . . . . . . . { ~ . . K x X . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . Y Z . . . . . . . . . . . { ~ . . . ` n . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . .  .x ... . . . . . . . . . . { ~ . . . +.$ +.. . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . @.n { . . . . . . . . . . . { ~ . . . . #.R . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . x +.{ . . . . . . . . . . . { ~ . . . . X z o . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . $.u . { . . . . . . . . . . . { ~ . . . . . %.&.*.. . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . ` =.. { . . . . . . . . . . . { ~ . . . . . . -.=.. . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . 4 z X . { . . . . . . . . . . . { ~ . . . . . . + t . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . #.;.. . { . . . . . . . . . . . { ~ . . . . . . . >.v . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . u $.. . { . . . . . . . . . . . { ~ . . . . . . . _ t . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . n 2 . ' % . . . . . . . + t k . . { . . . . . . . . . . . { ~ . . . . . . . . t ,.. . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . '.& ).5 . ' % . . . . . . . m #.. . . { . . . . . . . . . . . { ~ . . . . . . . . !.t . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . f % % % ~.. ' % . . . . . . . x W . . . { . . . . . . . . . . . { ~ . . . . . . . . . N ] . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . a 1 @ . ' % . . . . . . s u . . . . { . . . . . . . . . . . { ~ . . . . . . . . . l u k { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . {.].. . ' % . . . . . . %.%.. . . . { . . . . . . . . . . . { ~ . . . . . . . . . . r ^.{ . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . | 6 . U /.% (.. . . . . _.' . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . 4 u :.. . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . + % r . o <.% [.. . . . o $ '.. . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . ^.}.. . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . 7 % |.. . ' % . . . . . ,._.. . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . o 1.D . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . 2.3.. . . ' % . . . . . 4.=.. . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . 5.-.. . . . . . . . . . O { . . . . . . . . . . . ",
". . p p 6.} p + . ' % . . . . . _.7.. . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . 8.t ,.. . . . . . . . . O { . . . . . . . . . . . ",
". 9.i i i i i 0.. ' % . . . . . x +.. . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { C x a.. . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . x . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . ,.u . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . b.t . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . &.4.. . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . ^.T . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . X u c.. . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . m H . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . +.$ p . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . t C . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . +.x _ . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . z X . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . + x _ . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . U x . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . K x H . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . a.f . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . ' &.d.X O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . $.-.. . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . X _.>.e.{ . . . . . . . . . . . ",
". . . . . . . . . ' % . . . M 4.. . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . f.g.h.U . . . . . . . . . . ",
". . . . . . . . . ' % . . . $.,.. . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . i.j.x Y b . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { b.@.x &.~.D . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . U f.m @.. . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . { ~ . . . . . . . . . . . . { . . . . . . . . . . . O { . . . . . . . . . . . ",
". . . . . . . . . ' % . . . . . . . . . . . . { . . . . . . . . . . . k.l.. . . . . . . . . . . . { . . . . . . . . . . . m.n.. . . . . . . 2 C . . ",
". . . . . . . . . ' % i i i i i i i i i i i i o.i i i i i i i i i i i p.q.i i i i i i i i i i i i o.i i i i i i i i i i i | ).i i i i i i i ).< r.~.",
". . . . . . . . . . Y r r r r r r r r r r r r r r r r r r r r r r r r (.p.r r r r r r r r r r r r r r r r r r r r r r r r s.c r r r r r r r t.u.2 . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 4 ] . . . . . . . . . . . . . . . . . . . . . . . . + v.. . . . . . . . . . . ",
". . . . '.= ).% w.[.. . . . . . . . . . . . . . . . . . . . . . . . . . x.8 . . . . . . . . . . . . . . . . . . . . . ~.2.[ i c 2 . . . . . . . . . ",
". . . . 2.y.z.p A.< j . . . . . . . . . . . . . . . . . . . . . . b &.B.< C.. . . . . . . . . . . . . . . . . . . . . D.t.[.a 3.1 9.. . . . . . . . ",
". . . p % &.. . + % r . . . . . . . . . . . . . . . . . . . . . . 2 } i % v.. . . . . . . . . . . . . . . . . . . . . 3 . . . &.% p . . . . . . . . ",
". . . E.h . . . ' % r . . . . . . . . . . . . . . . . . . . . . . . . / ).. . . . . . . . . . . . . . . . . . . . . . . . . . F.< 9.. . . . . . . . ",
". . . | * . . . ~.% ~.. . . . . . . . . . . . . . . . . . . . . . . . c G.. . . . . . . . . . . . . . . . . . . . . . . . . + ).E.. . . . . . . . . ",
". . j % &.. . . a H.U . . . . . . . . . . . . . . . . . . . . . . . '.q.x.. . . . . . . . . . . . . . . . . . . . . . . . j h # U . . . . . . . . . ",
". . Y % I.. . . G.D.. . . . . . . . . . . . . . . . . . . . . . . . p % ~.. . . . . . . . . . . . . . . . . . . . . . . n y.J.4 . . . . . . . . . . ",
". . r % ' . . 9.1 8 . . . . . . . . . . . . . . . . . . . . . . . . a 1 o . . . . . . . . . . . . . . . . . . . . . . [.H.<.'.. . . . . . . . . . . ",
". . & % 2 . '.s.K.U . . . . . . . . . . . . . . . . . . . . . . . . d L.. . . . . . . . . . . . . . . . . . . . . |.t.w.r . . . . . . . . . . . . . ",
". . @ 6.).} h y.p . . . . . . . . . . . . . . . . . . . . . . @ / / ).# / Y . . . . . . . . . . . . . . . . . . . M.% J.2.2.2.2.N.. . . . . . . . . ",
". . . 3 F./ a 4 . . . . . . . . . . . . . . . . . . . . . . . |./ / / / / n . . . . . . . . . . . . . . . . . . . 0./ / / / / / 9.. . . . . . . . . "};

static const char* const image3_data[] = {
"74 77 168 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #E0E0E0",
"@ 	c #FAFAFA",
"# 	c #363636",
"$ 	c #ABABAB",
"% 	c #000000",
"& 	c #BDBDBD",
"* 	c #737373",
"= 	c #858585",
"- 	c #E6E6E6",
"; 	c #C9C9C9",
"> 	c #939493",
", 	c #808080",
"' 	c #878787",
") 	c #D6D6D6",
"! 	c #969696",
"~ 	c #030303",
"{ 	c #383838",
"] 	c #4C4C4C",
"^ 	c #1A1A1A",
"/ 	c #080808",
"( 	c #C2C2C2",
"_ 	c #EBEBEB",
": 	c #F0F0F0",
"< 	c #8C8C8C",
"[ 	c #7A7A7A",
"} 	c #A3A3A3",
"| 	c #999999",
"1 	c #A1A1A1",
"2 	c #FFE6E6",
"3 	c #FFF0F0",
"4 	c #828282",
"5 	c #949494",
"6 	c #F2F2F2",
"7 	c #474747",
"8 	c #545454",
"9 	c #FF8080",
"0 	c #FFB2B2",
"a 	c #0F0F0F",
"b 	c #B5B5B5",
"c 	c #CFCFCF",
"d 	c #262626",
"e 	c #333333",
"f 	c #DEDEDE",
"g 	c #FDFDFD",
"h 	c #D7D7D7",
"i 	c #B7B7B7",
"j 	c #C4C4C4",
"k 	c #F7F7F7",
"l 	c #CCCCCC",
"m 	c #2E2E2E",
"n 	c #B2B2B2",
"o 	c #DFDFDF",
"p 	c #ACACAC",
"q 	c #ADADAD",
"r 	c #D3D3D3",
"s 	c #CDCDCD",
"t 	c #AAAAAA",
"u 	c #D4D4D4",
"v 	c #A9A9A9",
"w 	c #DBDBDB",
"x 	c #E3E3E3",
"y 	c #E5E5E5",
"z 	c #B1B1B1",
"A 	c #D2D2D2",
"B 	c #EAEAEA",
"C 	c #E2E2E2",
"D 	c #C8C8C8",
"E 	c #AFAFAF",
"F 	c #F5F5F5",
"G 	c #E9E9E9",
"H 	c #B6B6B6",
"I 	c #B9B9B9",
"J 	c #F9F9F9",
"K 	c #B8B8B8",
"L 	c #C0C0C0",
"M 	c #B4B4B4",
"N 	c #EFD9D9",
"O 	c #AAA8A8",
"P 	c #F2DBDB",
"Q 	c #EED6D6",
"R 	c #ABA8A8",
"S 	c #EED8D8",
"T 	c #BCB1B1",
"U 	c #C4B6B6",
"V 	c #C5B7B7",
"W 	c #B6ADAD",
"X 	c #EEEEEE",
"Y 	c #DADADA",
"Z 	c #BEBEBE",
"` 	c #B0B0B0",
" .	c #FBFBFB",
"..	c #C6C6C6",
"+.	c #C5C5C5",
"@.	c #BABABA",
"#.	c #AEAEAE",
"$.	c #D0D0D0",
"%.	c #FCFCFC",
"&.	c #141414",
"*.	c #D8D8D8",
"=.	c #C7C7C7",
"-.	c #575757",
";.	c #3D3D3D",
">.	c #C3C3C3",
",.	c #5E5E5E",
"'.	c #7D6E6E",
").	c #FF9999",
"!.	c #B39D9D",
"~.	c #E69292",
"{.	c #F09393",
"].	c #ADA2A2",
"^.	c #F49999",
"/.	c #FFC2C2",
"(.	c #757575",
"_.	c #918787",
":.	c #F7AEAE",
"<.	c #ABA6A6",
"[.	c #FCB2B2",
"}.	c #C3A0A0",
"|.	c #C7A4A4",
"1.	c #FFD1D1",
"2.	c #EDEDED",
"3.	c #B3B3B3",
"4.	c #666666",
"5.	c #2B2B2B",
"6.	c #BBBBBB",
"7.	c #292929",
"8.	c #E8E8E8",
"9.	c #9C9C9C",
"0.	c #E4E4E4",
"a.	c #E7E7E7",
"b.	c #CACACA",
"c.	c #E4A7A7",
"d.	c #B59F9F",
"e.	c #E6A7A7",
"f.	c #B0A3A3",
"g.	c #C19E9E",
"h.	c #F9B0B0",
"i.	c #CBCBCB",
"j.	c #F4F4F4",
"k.	c #BCBCBC",
"l.	c #707070",
"m.	c #242424",
"n.	c #0A0A0A",
"o.	c #454545",
"p.	c #7D7D7D",
"q.	c #595959",
"r.	c #525252",
"s.	c #5C5C5C",
"t.	c #D9D9D9",
"u.	c #121212",
"v.	c #919191",
"w.	c #8A8A8A",
"x.	c #171717",
"y.	c #A8A8A8",
"z.	c #696969",
"A.	c #9E9E9E",
"B.	c #404040",
"C.	c #616161",
"D.	c #8F8F8F",
"E.	c #4F4F4F",
"F.	c #050505",
"G.	c #4A4A4A",
"H.	c #212121",
"I.	c #3B3B3B",
"J.	c #636363",
"K.	c #D1D1D1",
". . . . . . . . . . + . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . @ # . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . $ % & . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . * % = . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . ; > , ' ) . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . ! ~ { ] ^ / ; - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . ( - . . _ % , - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . : % < - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . [ / + - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . } ~ | @ < % 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 3 . . . ",
". . . . 4 ~ 5 . 6 7 % 8 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 0 . . . ",
". . 6 8 a b . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". c d e f . . . . - % . . . . . . . . . . . . . . . . . g h i i i j k . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
"l / m $ n n n c . - % . . . . . . . . . . . . . . . . o p q ; r s n t u . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
"} e e e e e e ! . - % . . . . . . . . . . . . . . . l v ) . . . . . h t w . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . x t y . . . . . . . 6 z ; . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . q A . . . . . . . . . B t C . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . D E . . . . . . . . . . . ) $ k . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . F t G . . . . . . . . . . . . & H . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . c I . . . . . . . . . . . . . F $ ) . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . : p B . . . . . . . . . . . . . . C t J . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . K L . . . . . . . . . . . . . . . . M j . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % 2 2 2 2 2 2 2 2 2 2 N O P 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 Q R S 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 3 . . . ",
". . . . . . . . . - % 2 2 2 2 2 2 2 2 2 2 T U 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 V W 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 3 . . . ",
". . . . . . . . . - % . . . . . . . . . . t X . . . . . . . . . . . . . . . . . . J v k . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . Y q . . . . . . . . . . . . . . . . . . . . Z `  .. . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . M ... . . . . . . . . . . . . . . . . . . . . z ... . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . : v J . . . . . . . . . . . . . . . . . . . . . + p . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . +.@.. . . . . . . . . . . . . . . . . . . . . . . #.r . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . q Y . . . . . . . . . . . . . . . . . . . . . . . ) p . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . j ( . - % . . . . . . . + p g . . . . . . . . . . . . . . . . . . . . . . . . p $.. . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . %.& &.< . - % . . . . . . . i +.. . . . . . . . . . . . . . . . . . . . . . . . . *.p . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . b % % % =.. - % . . . . . . . t B . . . . . . . . . . . . . . . . . . . . . . . . . . E ; . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . 5 / @ . - % . . . . . . o q . . . . . . . . . . . . . . . . . . . . . . . . . . . h q g . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . -.;.. . - % . . . . . . Z Z . . . . . . . . . . . . . . . . . . . . . . . . . . . . n >.. . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . ^ [ . F ,.% '.).).).).).!.~.).).).).).).).).).).).).).).).).).).).).).).).).).).).).{.].^.).).).).).).).).).).).).).).).).).).).)./.. . . ",
". . . . + % n . k (.% _.0 0 0 0 :.<.[.0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 }.|.0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1.. . . ",
". . . . } % 2.. . - % . . . . . $.3.. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . k p y . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . 4.5.. . . - % . . . . . 6.... . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ; z . . . . . . . . . . . . . . . . . . . . . . . ",
". . l l 7.] l + . - % . . . . . 3.u . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  .p $.. . . . . . . . . . . . . . . . . . . . . . ",
". 8.e e e e e 9.. - % . . . . . t X . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . x t 0.. . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . t . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . $.q . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . a.p . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ` 6.. . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . >.I . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . J q b.. . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . i A . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . X $ l . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . p x . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . X t ) . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . v J . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . + t ) . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . F t . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . C t A . . . . . . . . . . . . . . . ",
". . . . . . . . . - % 0 0 0 c.d.0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 e.f.g.h.0 0 0 0 0 0 0 0 0 1.. . . ",
". . . . . . . . . - % . . . Y z . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . J 3.#.x . . . . . . . . . . . . ",
". . . . . . . . . - % . . . D 6.. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . i.p D F . . . . . . . . . . ",
". . . . . . . . . - % . . . Y $.. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . j.L t K 6 . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . a.k.t ` =.y . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F i.i k.. . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . - % . . . . . . . . . . . . . . . . . . . . . . . . ; l.. . . . . . . . . . . . . . . . . . . . . . . . 1 < . . . . . . . ( x . . ",
". . . . . . . . . - % e e e e e e e e e e e e e e e e e e e e e e e e m.n.e e e e e e e e e e e e e e e e e e e e e e e e ^ &.e e e e e e e &.~ o.=.",
". . . . . . . . . . K n n n n n n n n n n n n n n n n n n n n n n n n p.m.n n n n n n n n n n n n n n n n n n n n n n n n q.7 n n n n n n n r.s.( . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . : ; . . . . . . . . . . . . . . . . . . . . . . . . + t.. . . . . . . . . . . ",
". . . . %.= &.% u.v.. . . . . . . . . . . . . . . . . . . . . . . . . . w.| . . . . . . . . . . . . . . . . . . . . . =.4.{ e 7 ( . . . . . . . . . ",
". . . . 4.x.y.l z.~ f . . . . . . . . . . . . . . . . . . . . . . 6 ` l.~ A.. . . . . . . . . . . . . . . . . . . . . B.r.v.5 5./ 8.. . . . . . . . ",
". . . l % ` . . + % n . . . . . . . . . . . . . . . . . . . . . . ( ] e % t.. . . . . . . . . . . . . . . . . . . . . _ . . . ` % l . . . . . . . . ",
". . . C.d . . . - % n . . . . . . . . . . . . . . . . . . . . . . . . , &.. . . . . . . . . . . . . . . . . . . . . . . . . . D.~ 8.. . . . . . . . ",
". . . ^ * . . . =.% =.. . . . . . . . . . . . . . . . . . . . . . . . 7 E.. . . . . . . . . . . . . . . . . . . . . . . . . + &.C.. . . . . . . . . ",
". . f % ` . . . 5 F.F . . . . . . . . . . . . . . . . . . . . . . . %.n.w.. . . . . . . . . . . . . . . . . . . . . . . . f d # F . . . . . . . . . ",
". . K % w . . . E.B.. . . . . . . . . . . . . . . . . . . . . . . . l % =.. . . . . . . . . . . . . . . . . . . . . . . j x.G.: . . . . . . . . . . ",
". . n % - . . 8./ | . . . . . . . . . . . . . . . . . . . . . . . . 5 / k . . . . . . . . . . . . . . . . . . . . . . v.F.(.%.. . . . . . . . . . . ",
". . & % ( . %.q.H.F . . . . . . . . . . . . . . . . . . . . . . . . 8 I.. . . . . . . . . . . . . . . . . . . . . 2.r.u.n . . . . . . . . . . . . . ",
". . @ 7.&.] d x.l . . . . . . . . . . . . . . . . . . . . . . @ , , &.# , K . . . . . . . . . . . . . . . . . . . J.% G.4.4.4.4.K.. . . . . . . . . ",
". . . _ D., 5 : . . . . . . . . . . . . . . . . . . . . . . . 2., , , , , j . . . . . . . . . . . . . . . . . . . 9., , , , , , 8.. . . . . . . . . "};

static const char* const image4_data[] = {
"35 32 4 1",
"# c #000000",
"a c #bfbfbf",
"b c #ff0000",
". c #ffffff",
"...................................",
".........#.....#.....#.....#.......",
".....#.#.#.#.#.#.#.#.#.#.#.#.......",
".....#.#.#.#.#.#.#.#.#.#.#.#.......",
"....##########################.....",
"....#aaaaaaaaaaaaaaaaaaaaaaaa#.....",
"..###aaaaaaaaaaaaaaaaaaaaaaaa###...",
"....#aaaaaaaaaaaaaaaaaaaaaaaa#.....",
"..###aaaaaaaaaaaaaaaaaaaaaaaa###...",
"....#aaaaaaaaaaaaaaaaaaaaaaaa#.....",
".####aaaaaaaaaaaaaaaa#aaaaaaa####..",
"....#aaaaaaaaaaaaaaa#a#aaaaaa#.....",
"..###aaaaaaaaaaaaaaa#a#aaaaaa###...",
"....#aaaaaaaaaaaaaa#aaa#aaaaa#.....",
"..###aaaaaaa#aaaaaa#aaa#aaaaa###...",
"....#aaaaaa#a#aaaa#aaaaa#aaaa#.....",
".####aaaaaa#a#aaaa#aaaaa#aaaa####..",
"....#aaaaa#aaa#aa#aaaaaaa#aaa#.....",
"..###aaaaa#aaa###aaaaaaaaa######...",
"....#aaaa#aaaaa#aaaaaaaaaaaaa#.....",
"..###aaaa#aaaaa#aaaaaaaaaaaaa###...",
"....#aaa#aaaaaaa#aaaaaaaaaaaa#.....",
".#######aaaaaaaaa#####aaaaaaa####..",
"....#aaaaaaaaaaaaaaaaaaaaaaaa#.....",
"..###aaaaaaaaaaaaaaaaaaaaaaaa###...",
"....#aaaaaaaaaaaaaaaaaaaaaaaa#.....",
"....bbbbbbbbbbbbbbbbbbbbbbbbbb.....",
"....bbbbbbbbbbbbbbbbbbbbbbbbbb.....",
".....b.b.b.b.b.b.b.b.b.b.b.b.......",
".....b.b.b.b.b.b.b.b.b.b.b.b.......",
".........b.....b.....b.....b.......",
"..................................."};

static const char* const image5_data[] = {
"33 32 4 1",
"# c #000000",
"b c #bfbfbf",
"a c #ff0000",
". c #ffffff",
".................................",
".........#.....#.....#.....#.....",
".....#.#.#.#.#.#.#.#.#.#.#.#.....",
".....#.#.#.#.#.#.#.#.#.#.#.#.....",
"....aa########################...",
"....aabbbbbbbbbbbbbbbbbbbbbbb#...",
"..aaaabbbbbbbbbbbbbbbbbbbbbbb###.",
"....aabbbbbbbbbbbbbbbbbbbbbbb#...",
"..aaaabbbbbbbbbbbbbbbbbbbbbbb###.",
"....aabbbbbbbbbbbbbbbbbbbbbbb#...",
".aaaaabbbbbbbbbbbbbbb#bbbbbbb####",
"....aabbbbbbbbbbbbbb#b#bbbbbb#...",
"..aaaabbbbbbbbbbbbbb#b#bbbbbb###.",
"....aabbbbbbbbbbbbb#bbb#bbbbb#...",
"..aaaabbbbbb#bbbbbb#bbb#bbbbb###.",
"....aabbbbb#b#bbbb#bbbbb#bbbb#...",
".aaaaabbbbb#b#bbbb#bbbbb#bbbb####",
"....aabbbb#bbb#bb#bbbbbbb#bbb#...",
"..aaaabbbb#bbb###bbbbbbbbb######.",
"....aabbb#bbbbb#bbbbbbbbbbbbb#...",
"..aaaabbb#bbbbb#bbbbbbbbbbbbb###.",
"....aabb#bbbbbbb#bbbbbbbbbbbb#...",
".aaaaa##bbbbbbbbb#####bbbbbbb####",
"....aabbbbbbbbbbbbbbbbbbbbbbb#...",
"..aaaabbbbbbbbbbbbbbbbbbbbbbb###.",
"....aabbbbbbbbbbbbbbbbbbbbbbb#...",
"....aabbbbbbbbbbbbbbbbbbbbbbb#...",
"....aa########################...",
".....#.#.#.#.#.#.#.#.#.#.#.#.....",
".....#.#.#.#.#.#.#.#.#.#.#.#.....",
".........#.....#.....#.....#.....",
"................................."};

static const char* const image6_data[] = {
"34 34 4 1",
"a c #000000",
"b c #bfbfbf",
"# c #ff0000",
". c #ffffff",
"..................................",
"..................................",
".........#.....#.....#.....#......",
".....#.#.#.#.#.#.#.#.#.#.#.#......",
".....#.#.#.#.#.#.#.#.#.#.#.#......",
"....##########################....",
"....##########################....",
"..aaabbbbbbbbbbbbbbbbbbbbbbbbaaa..",
"....abbbbbbbbbbbbbbbbbbbbbbbba....",
"..aaabbbbbbbbbbbbbbbbbbbbbbbbaaa..",
"....abbbbbbbbbbbbbbbbbbbbbbbba....",
".aaaabbbbbbbbbbbbbbbbabbbbbbbaaaa.",
"....abbbbbbbbbbbbbbbababbbbbba....",
"..aaabbbbbbbbbbbbbbbababbbbbbaaa..",
"....abbbbbbbbbbbbbbabbbabbbbba....",
"..aaabbbbbbbabbbbbbabbbabbbbbaaa..",
"....abbbbbbababbbbabbbbbabbbba....",
".aaaabbbbbbababbbbabbbbbabbbbaaaa.",
"....abbbbbabbbabbabbbbbbbabbba....",
"..aaabbbbbabbbaaabbbbbbbbbaaaaaa..",
"....abbbbabbbbbabbbbbbbbbbbbba....",
"..aaabbbbabbbbbabbbbbbbbbbbbbaaa..",
"....abbbabbbbbbbabbbbbbbbbbbba....",
".aaaaaaabbbbbbbbbaaaaabbbbbbbaaaa.",
"....abbbbbbbbbbbbbbbbbbbbbbbba....",
"..aaabbbbbbbbbbbbbbbbbbbbbbbbaaa..",
"....abbbbbbbbbbbbbbbbbbbbbbbba....",
"....abbbbbbbbbbbbbbbbbbbbbbbba....",
"....aaaaaaaaaaaaaaaaaaaaaaaaaa....",
".....a.a.a.a.a.a.a.a.a.a.a.a......",
".....a.a.a.a.a.a.a.a.a.a.a.a......",
".........a.....a.....a.....a......",
"..................................",
".................................."};

static const char* const image7_data[] = {
"32 32 4 1",
"# c #000000",
"b c #bfbfbf",
"a c #ff0000",
". c #ffffff",
"................................",
"........#.....#.....#.....#.....",
"....#.#.#.#.#.#.#.#.#.#.#.#.....",
"....#.#.#.#.#.#.#.#.#.#.#.#.....",
"...########################aa...",
"...#bbbbbbbbbbbbbbbbbbbbbbbaa...",
".###bbbbbbbbbbbbbbbbbbbbbbbaaaa.",
"...#bbbbbbbbbbbbbbbbbbbbbbbaa...",
".###bbbbbbbbbbbbbbbbbbbbbbbaaaa.",
"...#bbbbbbbbbbbbbbbbbbbbbbbaa...",
"####bbbbbbbbbbbbbbbb#bbbbbbaaaaa",
"...#bbbbbbbbbbbbbbb#b#bbbbbaa...",
".###bbbbbbbbbbbbbbb#b#bbbbbaaaa.",
"...#bbbbbbbbbbbbbb#bbb#bbbbaa...",
".###bbbbbbb#bbbbbb#bbb#bbbbaaaa.",
"...#bbbbbb#b#bbbb#bbbbb#bbbaa...",
"####bbbbbb#b#bbbb#bbbbb#bbbaaaaa",
"...#bbbbb#bbb#bb#bbbbbbb#bbaa...",
".###bbbbb#bbb###bbbbbbbbb##aaaa.",
"...#bbbb#bbbbb#bbbbbbbbbbbbaa...",
".###bbbb#bbbbb#bbbbbbbbbbbbaaaa.",
"...#bbb#bbbbbbb#bbbbbbbbbbbaa...",
"#######bbbbbbbbb#####bbbbbbaaaaa",
"...#bbbbbbbbbbbbbbbbbbbbbbbaa...",
".###bbbbbbbbbbbbbbbbbbbbbbbaaaa.",
"...#bbbbbbbbbbbbbbbbbbbbbbbaa...",
"...#bbbbbbbbbbbbbbbbbbbbbbbaa...",
"...########################aa...",
"....#.#.#.#.#.#.#.#.#.#.#.#.....",
"....#.#.#.#.#.#.#.#.#.#.#.#.....",
"........#.....#.....#.....#.....",
"................................"};

#ifndef M_PI
#define M_PI	3.141592653589793238462643
#endif

AxesDialog::AxesDialog( QWidget* parent, Qt::WFlags fl )
: QDialog( parent, fl )
{
	QPixmap image4( ( const char** ) image4_data );
    QPixmap image5( ( const char** ) image5_data );
    QPixmap image6( ( const char** ) image6_data );
    QPixmap image7( ( const char** ) image7_data );
    setWindowTitle( tr( "QtiPlot - General Plot Options" ) );

    generalDialog = new QTabWidget();

    initScalesPage();
    initGridPage();
    initAxesPage();
    initFramePage();

    QHBoxLayout * bottomButtons = new QHBoxLayout();
    bottomButtons->addStretch();

    buttonApply = new QPushButton();
    buttonApply->setText( tr( "&Apply" ) );
    bottomButtons->addWidget( buttonApply );

    buttonOk = new QPushButton();
    buttonOk->setText( tr( "&OK" ) );
    buttonOk->setDefault( true );
    bottomButtons->addWidget( buttonOk );

    buttonCancel = new QPushButton();
    buttonCancel->setText( tr( "&Cancel" ) );
    bottomButtons->addWidget( buttonCancel );

    QVBoxLayout * mainLayout = new QVBoxLayout(this);
    mainLayout->addWidget(generalDialog);
    mainLayout->addLayout(bottomButtons);

    lastPage = scalesPage;

    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( buttonApply, SIGNAL( clicked() ), this, SLOT(updatePlot() ) );
    connect( generalDialog, SIGNAL( currentChanged ( QWidget * ) ),
            this, SLOT(pageChanged ( QWidget * ) ) );
}

void AxesDialog::initScalesPage()
{
    ApplicationWindow *app = (ApplicationWindow *)parent();
	scalesPage = new QWidget();

	QGroupBox * middleBox = new QGroupBox(QString());
	QGridLayout * middleLayout = new QGridLayout(middleBox);

	middleLayout->addWidget(new QLabel(tr( "From" )), 0, 0);
	boxStart = new DoubleSpinBox();
	boxStart->setLocale(app->locale());
    boxStart->setDecimals(app->d_decimal_digits);
	middleLayout->addWidget( boxStart, 0, 1 );

	boxStartDateTime = new QDateTimeEdit();
	boxStartDateTime->setCalendarPopup(true);
	middleLayout->addWidget( boxStartDateTime, 0, 1 );
	boxStartDateTime->hide();

	boxStartTime = new QTimeEdit();
	middleLayout->addWidget(boxStartTime, 0, 1 );
	boxStartTime->hide();

	middleLayout->addWidget(new QLabel(tr( "To" )), 1, 0);
	boxEnd = new DoubleSpinBox();
	boxEnd->setLocale(app->locale());
    boxEnd->setDecimals(app->d_decimal_digits);
	middleLayout->addWidget( boxEnd, 1, 1);

    boxEndDateTime = new QDateTimeEdit();
    boxEndDateTime->setCalendarPopup(true);
    middleLayout->addWidget(boxEndDateTime, 1, 1);
    boxEndDateTime->hide();

    boxEndTime = new QTimeEdit();
    middleLayout->addWidget(boxEndTime, 1, 1);
    boxEndTime->hide();

	boxScaleTypeLabel = new QLabel(tr( "Type" ));
	boxScaleType = new QComboBox();
	boxScaleType->addItem(tr( "linear" ) );
	boxScaleType->addItem(tr( "logarithmic" ) );
	middleLayout->addWidget( boxScaleTypeLabel, 2, 0);
	middleLayout->addWidget( boxScaleType, 2, 1);

	btnInvert = new QCheckBox();
	btnInvert->setText( tr( "Inverted" ) );
	btnInvert->setChecked(false);
	middleLayout->addWidget( btnInvert, 3, 1 );
	middleLayout->setRowStretch(4, 1);

	boxAxesBreaks = new QGroupBox(tr("Show Axis &Break"));
	boxAxesBreaks->setCheckable(true);
	boxAxesBreaks->setChecked(false);

	QGridLayout * breaksLayout = new QGridLayout(boxAxesBreaks);
	boxBreakDecoration = new QCheckBox(tr("Draw Break &Decoration"));
	breaksLayout->addWidget(boxBreakDecoration, 0, 1);

	breaksLayout->addWidget(new QLabel(tr("From")), 1, 0);
	boxBreakStart = new DoubleSpinBox();
	boxBreakStart->setLocale(app->locale());
    boxBreakStart->setDecimals(app->d_decimal_digits);
	breaksLayout->addWidget(boxBreakStart, 1, 1);

	breaksLayout->addWidget(new QLabel(tr("To")), 2, 0);
	boxBreakEnd = new DoubleSpinBox();
	boxBreakEnd->setLocale(app->locale());
    boxBreakEnd->setDecimals(app->d_decimal_digits);
	breaksLayout->addWidget(boxBreakEnd, 2, 1);

    breaksLayout->addWidget(new QLabel(tr("Position")), 3, 0);
    boxBreakPosition = new QSpinBox();
	boxBreakPosition->setSuffix(" (" + tr("% of Axis Length") + ")");
    breaksLayout->addWidget(boxBreakPosition, 3, 1);

	breaksLayout->addWidget(new QLabel(tr("Width")), 4, 0);
	boxBreakWidth = new QSpinBox();
	boxBreakWidth->setSuffix(" (" + tr("pixels") + ")");
	breaksLayout->addWidget(boxBreakWidth, 4, 1);

    boxLog10AfterBreak = new QCheckBox(tr("&Log10 Scale After Break"));
    breaksLayout->addWidget(boxLog10AfterBreak, 0, 3);

    breaksLayout->addWidget(new QLabel(tr("Step Before Break")), 1, 2);
    boxStepBeforeBreak = new DoubleSpinBox();
    boxStepBeforeBreak->setMinimum(0.0);
    boxStepBeforeBreak->setSpecialValueText(tr("Guess"));
	boxStepBeforeBreak->setLocale(app->locale());
    boxStepBeforeBreak->setDecimals(app->d_decimal_digits);
	breaksLayout->addWidget(boxStepBeforeBreak, 1, 3);

    breaksLayout->addWidget(new QLabel(tr("Step After Break")), 2, 2);
    boxStepAfterBreak = new DoubleSpinBox();
    boxStepAfterBreak->setMinimum(0.0);
    boxStepAfterBreak->setSpecialValueText(tr("Guess"));
	boxStepAfterBreak->setLocale(app->locale());
    boxStepAfterBreak->setDecimals(app->d_decimal_digits);
	breaksLayout->addWidget(boxStepAfterBreak, 2, 3);

    breaksLayout->addWidget(new QLabel(tr("Minor Ticks Before")), 3, 2);
    boxMinorTicksBeforeBreak = new QComboBox();
	boxMinorTicksBeforeBreak->setEditable(true);
	boxMinorTicksBeforeBreak->addItems(QStringList()<<"0"<<"1"<<"4"<<"9"<<"14"<<"19");
    breaksLayout->addWidget(boxMinorTicksBeforeBreak, 3, 3);

    breaksLayout->addWidget(new QLabel(tr("Minor Ticks After")), 4, 2);
    boxMinorTicksAfterBreak  = new QComboBox();
	boxMinorTicksAfterBreak->setEditable(true);
	boxMinorTicksAfterBreak->addItems(QStringList()<<"0"<<"1"<<"4"<<"9"<<"14"<<"19");
    breaksLayout->addWidget(boxMinorTicksAfterBreak, 4, 3);

	QGroupBox *rightBox = new QGroupBox(QString());
	QGridLayout *rightLayout = new QGridLayout(rightBox);

	QWidget * stepWidget = new QWidget();
	QHBoxLayout * stepWidgetLayout = new QHBoxLayout( stepWidget );
	stepWidgetLayout->setMargin(0);

	btnStep = new QCheckBox(tr("Step"));
	btnStep->setChecked(true);
	rightLayout->addWidget( btnStep, 0, 0 );

	boxStep = new DoubleSpinBox();
	boxStep->setMinimum(0.0);
	boxStep->setLocale(app->locale());
    boxStep->setDecimals(app->d_decimal_digits);
	stepWidgetLayout->addWidget(boxStep);

	boxUnit = new QComboBox();
	boxUnit->hide();
	stepWidgetLayout->addWidget( boxUnit );

	rightLayout->addWidget( stepWidget, 0, 1 );

	btnMajor = new QCheckBox();
	btnMajor->setText( tr( "Major Ticks" ) );
	rightLayout->addWidget( btnMajor, 1, 0);

	boxMajorValue = new QSpinBox();
	boxMajorValue->setDisabled(true);
	rightLayout->addWidget( boxMajorValue, 1, 1);

	minorBoxLabel = new QLabel( tr( "Minor Ticks" ));
	rightLayout->addWidget( minorBoxLabel, 2, 0);

	boxMinorValue = new QComboBox();
	boxMinorValue->setEditable(true);
	boxMinorValue->addItems(QStringList()<<"0"<<"1"<<"4"<<"9"<<"14"<<"19");
	rightLayout->addWidget( boxMinorValue, 2, 1);

	rightLayout->setRowStretch( 3, 1 );

    QHBoxLayout* hl = new QHBoxLayout();
	hl->addWidget(middleBox);
	hl->addWidget(rightBox);

    QVBoxLayout* vl = new QVBoxLayout();
	vl->addLayout(hl);
	vl->addWidget(boxAxesBreaks);

	QPixmap image0( ( const char** ) bottom_scl_xpm );
	QPixmap image1( ( const char** ) left_scl_xpm );
	QPixmap image2( ( const char** ) top_scl_xpm );
	QPixmap image3( ( const char** ) right_scl_xpm );

	axesList = new QListWidget();
	axesList->addItem( new QListWidgetItem(image0, tr( "Bottom" )));
	axesList->addItem( new QListWidgetItem(image1, tr( "Left" )));
	axesList->addItem( new QListWidgetItem(image2, tr( "Top" )));
	axesList->addItem( new QListWidgetItem(image3,  tr( "Right" )));
    axesList->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding));
	axesList->setIconSize(image0.size());
	axesList->setCurrentRow(-1);

	// calculate a sensible width for the items list
	// (default QListWidget size is 256 which looks too big)
	QFontMetrics fm(axesList->font());
	int width = 32;
	for(int i=0 ; i<axesList->count() ; i++)
		if( fm.width(axesList->item(i)->text()) > width)
			width = fm.width(axesList->item(i)->text());

	axesList->setMaximumWidth( axesList->iconSize().width() + width + 50 );
	// resize the list to the maximum width
	axesList->resize(axesList->maximumWidth(),axesList->height());

	QHBoxLayout* mainLayout = new QHBoxLayout(scalesPage);
	mainLayout->addWidget(axesList);
	mainLayout->addLayout(vl);

	generalDialog->addTab(scalesPage, tr( "Scale" ));

	connect(btnInvert,SIGNAL(clicked()), this, SLOT(updatePlot()));
	connect(axesList,SIGNAL(currentRowChanged(int)), this, SLOT(updateScale()));
	connect(boxScaleType,SIGNAL(activated(int)), this, SLOT(updateMinorTicksList(int)));
	connect(btnStep,SIGNAL(clicked()), this, SLOT(stepEnabled()));
	connect(btnMajor,SIGNAL(clicked()), this, SLOT(stepDisabled()));
}

void AxesDialog::initGridPage()
{
	gridPage = new QWidget();

    QGroupBox * rightBox = new QGroupBox(QString());
    QGridLayout * rightLayout = new QGridLayout(rightBox);

    boxMajorGrid = new QCheckBox();
    boxMajorGrid->setText( tr( "Major Grids" ) );
    boxMajorGrid->setChecked(true);
    rightLayout->addWidget( boxMajorGrid, 0, 1);

    boxMinorGrid = new QCheckBox();
    boxMinorGrid->setText( tr( "Minor Grids" ) );
    boxMinorGrid->setChecked(false);
    rightLayout->addWidget( boxMinorGrid, 0, 2);

    rightLayout->addWidget( new QLabel(tr( "Line Color" )), 1, 0 );

    boxColorMajor = new ColorBox(0);
    rightLayout->addWidget( boxColorMajor, 1, 1);

    boxColorMinor = new ColorBox(0);
    boxColorMinor->setDisabled(true);
    rightLayout->addWidget( boxColorMinor, 1, 2);

    rightLayout->addWidget( new QLabel(tr( "Line Type" )), 2, 0 );

    boxTypeMajor = new QComboBox();
    boxTypeMajor->addItem("_____");
    boxTypeMajor->addItem("- - -");
    boxTypeMajor->addItem(".....");
    boxTypeMajor->addItem("_._._");
    boxTypeMajor->addItem("_.._..");
    rightLayout->addWidget( boxTypeMajor, 2, 1);

    boxTypeMinor = new QComboBox();
    boxTypeMinor->addItem("_____");
    boxTypeMinor->addItem("- - -");
    boxTypeMinor->addItem(".....");
    boxTypeMinor->addItem("_._._");
    boxTypeMinor->addItem("_.._..");
    boxTypeMinor->setDisabled(true);
    rightLayout->addWidget( boxTypeMinor, 2, 2);

    rightLayout->addWidget( new QLabel(tr( "Thickness" )), 3, 0 );

    boxWidthMajor = new DoubleSpinBox('f');
	boxWidthMajor->setLocale(((ApplicationWindow *)parent())->locale());
	boxWidthMajor->setSingleStep(0.1);
    boxWidthMajor->setRange(0.1, 20);
    boxWidthMajor->setValue(1);
    rightLayout->addWidget( boxWidthMajor, 3, 1);

    boxWidthMinor = new DoubleSpinBox('f');
	boxWidthMinor->setLocale(((ApplicationWindow *)parent())->locale());
	boxWidthMinor->setSingleStep(0.1);
    boxWidthMinor->setRange(0.1, 20);
    boxWidthMinor->setValue(1);
    boxWidthMinor->setDisabled(true);
    rightLayout->addWidget( boxWidthMinor, 3, 2);

    rightLayout->addWidget( new QLabel(tr( "Axes" )), 4, 0 );

    boxGridXAxis = new QComboBox();
    boxGridXAxis->insertItem(tr("Bottom"));
    boxGridXAxis->insertItem(tr("Top"));
    rightLayout->addWidget( boxGridXAxis, 4, 1);

    boxGridYAxis = new QComboBox();
    boxGridYAxis->insertItem(tr("Left"));
    boxGridYAxis->insertItem(tr("Right"));
    rightLayout->addWidget(boxGridYAxis, 4, 2);

    rightLayout->addWidget( new QLabel(tr( "Additional lines" )), 5, 0);

    boxXLine = new QCheckBox(tr( "X=0" ));
    boxXLine->setDisabled(true);
    rightLayout->addWidget( boxXLine, 5, 1);

    boxYLine = new QCheckBox(tr( "Y=0" ));
    rightLayout->addWidget(boxYLine, 5, 2);

    rightLayout->addWidget( new QLabel(tr( "Apply To" )), 6, 0);
    boxApplyGridFormat = new QComboBox();
    boxApplyGridFormat->insertItem(tr("This Layer"));
    boxApplyGridFormat->insertItem(tr("This Window"));
    boxApplyGridFormat->insertItem(tr("All Windows"));
    rightLayout->addWidget(boxApplyGridFormat, 6, 1);

    boxAntialiseGrid = new QCheckBox(tr("An&tialised"));
    rightLayout->addWidget(boxAntialiseGrid, 6, 2);

    rightLayout->setRowStretch(7, 1);
    rightLayout->setColumnStretch(4, 1);

    QPixmap image2( ( const char** ) image2_data );
    QPixmap image3( ( const char** ) image3_data );

    axesGridList = new QListWidget();
    axesGridList->addItem( new QListWidgetItem(image3, tr( "Horizontal" )) );
    axesGridList->addItem( new QListWidgetItem(image2, tr( "Vertical" )) );
    axesGridList->setIconSize(image3.size());
    axesGridList->setCurrentRow(0);

    // calculate a sensible width for the items list
    // (default QListWidget size is 256 which looks too big)
    QFontMetrics fm(axesGridList->font());
    int width = 32,i;
    for(i=0 ; i<axesGridList->count() ; i++)
        if( fm.width(axesGridList->item(i)->text()) > width)
            width = fm.width(axesGridList->item(i)->text());

    axesGridList->setMaximumWidth( axesGridList->iconSize().width() + width + 50 );
    // resize the list to the maximum width
    axesGridList->resize(axesGridList->maximumWidth(),axesGridList->height());

    QHBoxLayout* mainLayout2 = new QHBoxLayout(gridPage);
    mainLayout2->addWidget(axesGridList);
    mainLayout2->addWidget(rightBox);

    generalDialog->addTab( gridPage, tr( "Grid" ) );

	//grid page slot connections
    connect(axesGridList, SIGNAL(currentRowChanged(int)), this, SLOT(showGridOptions(int)));

	connect(boxMajorGrid,SIGNAL(toggled(bool)), this, SLOT(majorGridEnabled(bool)));
	connect(boxMinorGrid,SIGNAL(toggled(bool)), this, SLOT(minorGridEnabled(bool)));
	connect(boxAntialiseGrid,SIGNAL(toggled(bool)), this, SLOT(updateGrid()));
	connect(boxColorMajor,SIGNAL(activated(int)),this, SLOT(updateGrid()));
	connect(boxColorMinor,SIGNAL(activated(int)),this, SLOT(updateGrid()));
	connect(boxTypeMajor,SIGNAL(activated(int)),this, SLOT(updateGrid()));
	connect(boxTypeMinor,SIGNAL(activated(int)),this, SLOT(updateGrid()));
	connect(boxWidthMajor,SIGNAL(valueChanged(double)),this, SLOT(updateGrid()));
	connect(boxWidthMinor,SIGNAL(valueChanged(double)),this, SLOT(updateGrid()));
	connect(boxXLine,SIGNAL(clicked()),this, SLOT(updatePlot()));
	connect(boxYLine,SIGNAL(clicked()),this, SLOT(updatePlot()));
}

void AxesDialog::initAxesPage()
{
	//axes page
	QPixmap image4( ( const char** ) image4_data );
	QPixmap image5( ( const char** ) image5_data );
	QPixmap image6( ( const char** ) image6_data );
	QPixmap image7( ( const char** ) image7_data );

	axesPage = new QWidget();

	axesTitlesList = new QListWidget();
	axesTitlesList->addItem( new QListWidgetItem(image4, tr("Bottom")));
	axesTitlesList->addItem( new QListWidgetItem(image5, tr("Left")));
	axesTitlesList->addItem( new QListWidgetItem(image6, tr("Top")));
	axesTitlesList->addItem( new QListWidgetItem(image7, tr("Right")));
	axesTitlesList->setIconSize(image6.size());
	axesTitlesList->setMaximumWidth((int)(image6.width()*1.5));
	axesTitlesList->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding));
	axesTitlesList->setCurrentRow(-1);

	// calculate a sensible width for the items list
	// (default QListWidget size is 256 which looks too big)
	QFontMetrics fm(axesTitlesList->font());
	int width = 32,i;
	for(i=0 ; i<axesTitlesList->count() ; i++)
		if( fm.width(axesTitlesList->item(i)->text()) > width)
			width = fm.width(axesTitlesList->item(i)->text());
	axesTitlesList->setMaximumWidth( axesTitlesList->iconSize().width() + width + 50 );
	// resize the list to the maximum width
	axesTitlesList->resize(axesTitlesList->maximumWidth(),axesTitlesList->height());

	QHBoxLayout * topLayout = new QHBoxLayout();

	boxShowAxis = new QCheckBox(tr("Show"));
	boxShowAxis->setChecked(true);
	topLayout->addWidget( boxShowAxis );

	labelBox = new QGroupBox(tr( "Title"));
	topLayout->addWidget( labelBox );

	QVBoxLayout *labelBoxLayout = new QVBoxLayout( labelBox );
    labelBoxLayout->setSpacing(2);

	boxTitle = new QTextEdit();
	boxTitle->setTextFormat(Qt::PlainText);
	QFontMetrics metrics(this->font());
	boxTitle->setMaximumHeight(3*metrics.height());
    labelBoxLayout->addWidget(boxTitle);

	QHBoxLayout *hl = new QHBoxLayout();
	hl->setMargin(0);
	hl->setSpacing(2);
	buttonLabelFont = new QPushButton(tr("&Font"));
	hl->addWidget(buttonLabelFont);

	formatButtons = new TextFormatButtons(boxTitle);
	formatButtons->toggleCurveButton(false);
	hl->addWidget(formatButtons);
	hl->addStretch();

	boxTitle->setMaximumWidth(buttonLabelFont->width() + formatButtons->width());
	labelBoxLayout->addLayout(hl);

	QHBoxLayout * bottomLayout = new QHBoxLayout();

	QGroupBox *leftBox = new QGroupBox(QString());
	bottomLayout->addWidget( leftBox );
	QGridLayout * leftBoxLayout = new QGridLayout( leftBox );

	leftBoxLayout->addWidget( new QLabel(tr( "Type" )), 0, 0 );

	boxAxisType= new QComboBox();
	boxAxisType->addItem(tr("Numeric"));
	boxAxisType->addItem(tr("Text from table"));
	boxAxisType->addItem(tr("Day of the week"));
	boxAxisType->addItem(tr("Month"));
	boxAxisType->addItem(tr("Time"));
	boxAxisType->addItem(tr("Date"));
	boxAxisType->addItem(tr("Column Headings"));
	leftBoxLayout->addWidget( boxAxisType, 0, 1 );

	leftBoxLayout->addWidget( new QLabel(tr( "Font" )), 1, 0 );

	btnAxesFont = new QPushButton();
	btnAxesFont->setText( tr( "Axis &Font" ) );
	leftBoxLayout->addWidget( btnAxesFont, 1, 1 );

	leftBoxLayout->addWidget( new QLabel(tr( "Color" )), 2, 0 );
	boxAxisColor= new ColorButton();
	leftBoxLayout->addWidget( boxAxisColor, 2, 1 );

	leftBoxLayout->addWidget( new QLabel(tr( "Major Ticks" )), 3, 0 );

	boxMajorTicksType= new QComboBox();
	boxMajorTicksType->addItem(tr( "None" ) );
	boxMajorTicksType->addItem(tr( "Out" ) );
	boxMajorTicksType->addItem(tr( "In & Out" ) );
	boxMajorTicksType->addItem(tr( "In" ) );
	leftBoxLayout->addWidget( boxMajorTicksType, 3, 1 );

	leftBoxLayout->addWidget( new QLabel(tr( "Minor Ticks" )), 4, 0 );

	boxMinorTicksType= new QComboBox();
	boxMinorTicksType->addItem(tr( "None" ) );
	boxMinorTicksType->addItem(tr( "Out" ) );
	boxMinorTicksType->addItem(tr( "In & Out" ) );
	boxMinorTicksType->addItem(tr( "In" ) );
	leftBoxLayout->addWidget( boxMinorTicksType, 4, 1);

	leftBoxLayout->addWidget( new QLabel(tr("Stand-off")), 5, 0);
	boxBaseline = new QSpinBox();
	boxBaseline->setRange( 0, 1000 );
	leftBoxLayout->addWidget( boxBaseline );

	boxShowLabels = new QGroupBox(tr("Show Labels"));
	boxShowLabels->setCheckable(true);
	boxShowLabels->setChecked(true);

	bottomLayout->addWidget( boxShowLabels );
	QGridLayout *rightBoxLayout = new QGridLayout( boxShowLabels );

	label1 = new QLabel(tr("Column"));
	rightBoxLayout->addWidget( label1, 0, 0 );

	boxColName = new QComboBox();
	rightBoxLayout->addWidget( boxColName, 0, 1 );

	labelTable = new QLabel(tr("Table"));
	rightBoxLayout->addWidget( labelTable, 1, 0 );

	boxTableName = new QComboBox();
	rightBoxLayout->addWidget( boxTableName, 1, 1 );

	label2 = new QLabel(tr( "Format" ));
	rightBoxLayout->addWidget( label2, 2, 0 );

	boxFormat = new QComboBox();
	boxFormat->setDuplicatesEnabled(false);
	rightBoxLayout->addWidget( boxFormat, 2, 1 );

	label3 = new QLabel(tr( "Precision" ));
	rightBoxLayout->addWidget( label3, 3, 0 );
	boxPrecision = new QSpinBox();
	boxPrecision->setRange( 0, 10 );
	rightBoxLayout->addWidget( boxPrecision, 3, 1 );

	rightBoxLayout->addWidget( new QLabel(tr( "Angle" )), 4, 0 );

	boxAngle = new QSpinBox();
	boxAngle->setRange( -90, 90 );
	boxAngle->setSingleStep(5);
	rightBoxLayout->addWidget( boxAngle, 4, 1 );

    rightBoxLayout->addWidget(new QLabel(tr( "Color" )), 5, 0);
	boxAxisNumColor = new ColorButton();
	rightBoxLayout->addWidget( boxAxisNumColor, 5, 1 );

	boxShowFormula = new QCheckBox(tr( "For&mula" ));
	rightBoxLayout->addWidget( boxShowFormula, 6, 0 );

	boxFormula = new QTextEdit();
	boxFormula->setTextFormat(Qt::PlainText);
	boxFormula->setMaximumHeight(3*metrics.height());
	boxFormula->hide();
	rightBoxLayout->addWidget( boxFormula, 6, 1 );
	rightBoxLayout->setRowStretch(7, 1);

	QVBoxLayout * rightLayout = new QVBoxLayout();
	rightLayout->addLayout( topLayout );
	rightLayout->addLayout( bottomLayout );
	rightLayout->addStretch(1);

	QHBoxLayout * mainLayout3 = new QHBoxLayout( axesPage );
	mainLayout3->addWidget( axesTitlesList );
	mainLayout3->addLayout( rightLayout );

	generalDialog->addTab( axesPage, tr( "Axis" ) );

	connect(buttonLabelFont, SIGNAL(clicked()), this, SLOT(customAxisLabelFont()));

	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(updateShowBox(int)));
	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(updateAxisColor(int)));
	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(updateTitleBox(int)));
	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(setTicksType(int)));
	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(setAxisType(int)));
	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(setBaselineDist(int)));
	connect(axesTitlesList,SIGNAL(currentRowChanged(int)), this, SLOT(updateLabelsFormat(int)));

	connect(boxShowLabels,SIGNAL(clicked(bool)), this, SLOT(updateTickLabelsList(bool)));

	connect(boxAxisColor, SIGNAL(colorChanged()), this, SLOT(pickAxisColor()));
    connect(boxAxisNumColor, SIGNAL(colorChanged()), this, SLOT(pickAxisNumColor()));
	connect(boxShowFormula, SIGNAL(clicked()), this, SLOT(showFormulaBox()));

	connect(boxMajorTicksType, SIGNAL(activated(int)), this, SLOT(updateMajTicksType(int)));
	connect(boxMinorTicksType, SIGNAL(activated(int)), this, SLOT(updateMinTicksType(int)));

	connect(boxShowAxis, SIGNAL(clicked()), this, SLOT(showAxis()));
	connect(boxFormat, SIGNAL(activated(int)), this, SLOT(setLabelsNumericFormat(int)));

	connect(btnAxesFont, SIGNAL(clicked()), this, SLOT(customAxisFont()));
	connect(boxBaseline, SIGNAL(valueChanged(int)), this, SLOT(changeBaselineDist(int)));
	connect(boxAxisType, SIGNAL(activated(int)), this, SLOT(showAxisFormatOptions(int)));
	connect(boxPrecision, SIGNAL(valueChanged(int)), this, SLOT(setLabelsNumericFormat(int)));
}

void AxesDialog::initFramePage()
{
	frame = new QWidget();

    boxFramed = new QGroupBox(tr("Canvas frame"));
    boxFramed->setCheckable (true);

    QGridLayout * boxFramedLayout = new QGridLayout( boxFramed );
    boxFramedLayout->addWidget( new QLabel(tr( "Color" )), 0, 0 );
    boxFrameColor= new ColorButton(boxFramed);
    boxFramedLayout->addWidget( boxFrameColor, 0, 1 );

    boxFramedLayout->addWidget( new QLabel(tr( "Width" )), 1, 0 );
    boxFrameWidth= new QSpinBox();
    boxFrameWidth->setMinimum(1);
    boxFramedLayout->addWidget( boxFrameWidth, 1, 1 );

    boxFramedLayout->setRowStretch( 2, 1 );

    QGroupBox * boxAxes = new QGroupBox(tr("Axes"));
    QGridLayout * boxAxesLayout = new QGridLayout( boxAxes );
    boxBackbones = new QCheckBox();
    boxBackbones->setText( tr( "Draw backbones" ) );
    boxAxesLayout->addWidget( boxBackbones, 0, 0 );

    boxAxesLayout->addWidget( new QLabel(tr( "Line Width" )), 1, 0 );
    boxAxesLinewidth = new QSpinBox();
    boxAxesLinewidth->setRange( 1, 100 );
    boxAxesLayout->addWidget( boxAxesLinewidth, 1, 1 );

    boxAxesLayout->addWidget( new QLabel(tr( "Major ticks length" )), 2, 0 );
    boxMajorTicksLength = new QSpinBox();
    boxMajorTicksLength->setRange( 0, 1000 );
    boxAxesLayout->addWidget( boxMajorTicksLength, 2, 1 );

    boxAxesLayout->addWidget( new QLabel(tr( "Minor ticks length" )), 3, 0 );
    boxMinorTicksLength = new QSpinBox();
    boxMinorTicksLength->setRange( 0, 1000 );
    boxAxesLayout->addWidget( boxMinorTicksLength, 3, 1 );

    boxAxesLayout->setRowStretch( 4, 1 );

    QHBoxLayout * mainLayout = new QHBoxLayout( frame );
    mainLayout->addWidget(boxFramed);
    mainLayout->addWidget(boxAxes);

    generalDialog->addTab(frame, tr( "General" ) );

	connect(boxFrameColor, SIGNAL(colorChanged()), this, SLOT(pickCanvasFrameColor()));
	connect(boxBackbones, SIGNAL(toggled(bool)), this, SLOT(drawAxesBackbones(bool)));
	connect(boxFramed, SIGNAL(toggled(bool)), this, SLOT(drawFrame(bool)));
	connect(boxFrameWidth, SIGNAL(valueChanged (int)), this, SLOT(updateFrame(int)));
	connect(boxAxesLinewidth, SIGNAL(valueChanged (int)), this, SLOT(changeAxesLinewidth(int)));
	connect(boxMajorTicksLength, SIGNAL(valueChanged (int)), this, SLOT(changeMajorTicksLength(int)));
	connect(boxMinorTicksLength, SIGNAL(valueChanged (int)), this, SLOT(changeMinorTicksLength(int)));
}

void AxesDialog::changeMinorTicksLength (int minLength)
{
	if (generalDialog->currentWidget() != frame)
		return;

    d_graph->changeTicksLength(minLength, boxMajorTicksLength->value());
	boxMajorTicksLength->setMinValue(minLength);
}

void AxesDialog::changeMajorTicksLength (int majLength)
{
	if (generalDialog->currentWidget() != frame)
		return;

    d_graph->changeTicksLength(boxMinorTicksLength->value(), majLength);
	boxMinorTicksLength->setMaxValue(majLength);
}

void AxesDialog::drawAxesBackbones(bool draw)
{
	if (generalDialog->currentWidget() != frame)
		return;

	d_graph->drawAxesBackbones(draw);
}

void AxesDialog::changeAxesLinewidth(int width)
{
	if (generalDialog->currentWidget() != frame)
		return;

    d_graph->setAxesLinewidth(width);
}

void AxesDialog::drawFrame(bool framed)
{
	if (generalDialog->currentWidget() != frame)
		return;

	if (framed)
		d_graph->setCanvasFrame(boxFrameWidth->value(), boxFrameColor->color());
	else
		d_graph->setCanvasFrame(0);
}

void AxesDialog::updateFrame(int width)
{
	if (generalDialog->currentWidget() != frame)
		return;

    d_graph->setCanvasFrame(width, boxFrameColor->color());
}

void AxesDialog::pickCanvasFrameColor()
{
	d_graph->setCanvasFrame(boxFrameWidth->value(), boxFrameColor->color());
}

void AxesDialog::showAxisFormatOptions(int format)
{
	int axis = mapToQwtAxisId();

	boxFormat->clear();
	boxFormat->setEditable(false);
	boxFormat->hide();
	boxPrecision->hide();
	boxColName->hide();
	label1->hide();
	label2->hide();
	label3->hide();
	boxShowFormula->hide();
	boxFormula->hide();
	boxTableName->hide();
	labelTable->hide();

	switch (format)
	{
		case 0:
			label2->show();
			boxFormat->show();
			boxFormat->insertItem(tr( "Automatic" ) );
			boxFormat->insertItem(tr( "Decimal: 100.0" ) );
			boxFormat->insertItem(tr( "Scientific: 1e2" ) );
			boxFormat->insertItem(tr( "Scientific: 10^2" ) );
			boxFormat->setCurrentIndex(d_graph->axisLabelFormat(axis));

			label3->show();
			boxPrecision->show();
			boxShowFormula->show();

			showAxisFormula(mapToQwtAxisId());
			break;

		case 1:
			label1->show();
			boxColName->show();
			break;

		case 2:
        {
            int day = (QDate::currentDate()).dayOfWeek();
            label2->show();
            boxFormat->show();
            boxFormat->insertItem(QDate::shortDayName(day));
            boxFormat->insertItem(QDate::longDayName(day));
            boxFormat->insertItem((QDate::shortDayName(day)).left(1));
            boxFormat->setCurrentIndex((d_graph->axisFormatInfo(axis)).toInt());
        }
        break;

		case 3:
        {
            int month = (QDate::currentDate()).month();
            label2->show();
            boxFormat->show();
            boxFormat->insertItem(QDate::shortMonthName(month));
            boxFormat->insertItem(QDate::longMonthName(month));
            boxFormat->insertItem((QDate::shortMonthName(month)).left(1));
            boxFormat->setCurrentIndex((d_graph->axisFormatInfo(axis)).toInt());
        }
        break;

		case 4:
        {
            label2->show();
            boxFormat->show();
            boxFormat->setEditable(true);

            QStringList lst = (d_graph->axisFormatInfo(axis)).split(";", QString::KeepEmptyParts);
            if (lst.count() == 2){
                boxFormat->insertItem(lst[1]);
                boxFormat->setCurrentText(lst[1]);
            }

            boxFormat->insertItem("h");
            boxFormat->insertItem("h ap");
            boxFormat->insertItem("h AP");
            boxFormat->insertItem("h:mm");
            boxFormat->insertItem("h:mm ap");
            boxFormat->insertItem("hh:mm");
            boxFormat->insertItem("h:mm:ss");
            boxFormat->insertItem("h:mm:ss.zzz");
            boxFormat->insertItem("mm:ss");
            boxFormat->insertItem("mm:ss.zzz");
            boxFormat->insertItem("hmm");
            boxFormat->insertItem("hmmss");
            boxFormat->insertItem("hhmmss");
        }
        break;

		case 5:
        {
            label2->show();
            boxFormat->show();
            boxFormat->setEditable(true);

            QStringList lst = (d_graph->axisFormatInfo(axis)).split(";", QString::KeepEmptyParts);
            if (lst.count() == 2){
                boxFormat->insertItem(lst[1]);
                boxFormat->setCurrentText(lst[1]);
            }
            boxFormat->insertItem("yyyy-MM-dd");
            boxFormat->insertItem("dd.MM.yyyy");
            boxFormat->insertItem("ddd MMMM d yy");
            boxFormat->insertItem("dd/MM/yyyy");
        }
        break;

		case 6:
        {
            labelTable->show();
            QString tableName = d_graph->axisFormatInfo(axis);
            if (tablesList.contains(tableName))
                boxTableName->setCurrentText(tableName);
            boxTableName->show();
        }
        break;
	}
}

void AxesDialog::updateAxisType(int)
{
int a=mapToQwtAxisId();
boxAxisType->setCurrentIndex(a);
}

void AxesDialog::showAxis()
{
	bool ok=boxShowAxis->isChecked();
	boxTitle->setEnabled(ok);
	boxAxisColor->setEnabled(ok);
    boxAxisNumColor->setEnabled(ok);
	btnAxesFont->setEnabled(ok);
	boxShowLabels->setEnabled(ok);
	boxMajorTicksType->setEnabled(ok);
	boxMinorTicksType->setEnabled(ok);
	boxAxisType->setEnabled(ok);
	boxBaseline->setEnabled(ok);
	labelBox->setEnabled(ok);

    int axis = -1;
    int a = axesTitlesList->currentRow();
    switch(a){
        case 0:
            axis = QwtPlot::xBottom;
            xAxisOn=ok;
        break;
        case 1:
            axis = QwtPlot::yLeft;
            yAxisOn=ok;
        break;
        case 2:
            axis = QwtPlot::xTop;
            topAxisOn=ok;
        break;
        case 3:
            axis = QwtPlot::yRight;
            rightAxisOn=ok;
        break;
    }

    bool labels=false;
    if (tickLabelsOn[axis] == "1")
        labels=true;

    boxFormat->setEnabled(labels && ok);
    boxColName->setEnabled(labels && ok);
    boxShowFormula->setEnabled(labels && ok);
	boxFormula->setEnabled(labels && ok);

	if (axis == QwtPlot::xBottom || axis == QwtPlot::xTop)
		boxAngle->setEnabled(labels && ok);
	else
		boxAngle->setDisabled(true);

	bool userFormat=true;
    if (boxFormat->currentIndex() == 0)
        userFormat=false;
	boxPrecision->setEnabled(labels && ok && userFormat);

	QString formula =  boxFormula->text();
	if (!boxShowFormula->isChecked())
	   formula = QString();

    showAxis(axis, boxAxisType->currentIndex(), boxColName->currentText(),ok, boxMajorTicksType->currentIndex(),
            boxMinorTicksType->currentIndex(), boxShowLabels->isChecked(), boxAxisColor->color(), boxFormat->currentIndex(),
            boxPrecision->value(), boxAngle->value(), boxBaseline->value(), formula, boxAxisNumColor->color());
}

void AxesDialog::updateShowBox(int axis)
{
	switch(axis)
	{
		case 0:
			{
				boxShowAxis->setChecked(xAxisOn);
				int labelsOn=tickLabelsOn[2].toInt();
				boxShowLabels->setChecked(labelsOn);
				boxAngle->setEnabled(labelsOn && xAxisOn);
				boxFormat->setEnabled(labelsOn && xAxisOn);
				boxAngle->setValue(xBottomLabelsRotation);
				break;
			}
		case 1:
			{
				boxShowAxis->setChecked(yAxisOn);
				int labelsOn=tickLabelsOn[0].toInt();
				boxShowLabels->setChecked(labelsOn);
				boxFormat->setEnabled(labelsOn && yAxisOn);
				boxAngle->setEnabled(false);
				boxAngle->setValue(0);
				break;
			}
		case 2:
			{
				boxShowAxis->setChecked(topAxisOn);

				int labelsOn=tickLabelsOn[3].toInt();
				boxShowLabels->setChecked(labelsOn);
				boxFormat->setEnabled(labelsOn && topAxisOn);
				boxAngle->setEnabled(labelsOn && topAxisOn);
				boxAngle->setValue(xTopLabelsRotation);
				break;
			}
		case 3:
			{
				boxShowAxis->setChecked(rightAxisOn);
				int labelsOn=tickLabelsOn[1].toInt();
				boxShowLabels->setChecked(labelsOn );
				boxFormat->setEnabled(labelsOn && rightAxisOn);
				boxAngle->setEnabled(false);
				boxAngle->setValue(0);
				break;
			}
	}

	bool ok=boxShowAxis->isChecked();
	boxTitle->setEnabled(ok);
	boxAxisColor->setEnabled(ok);
    boxAxisNumColor->setEnabled(ok);
	btnAxesFont->setEnabled(ok);
	boxShowLabels->setEnabled(ok);
	boxMajorTicksType->setEnabled(ok);
	boxMinorTicksType->setEnabled(ok);
	boxAxisType->setEnabled(ok);
	boxBaseline->setEnabled(ok);
	labelBox->setEnabled(ok);
}

void AxesDialog::customAxisFont()
{
	bool okF;
		int axis=-1;
		QFont fnt;
		switch(axesTitlesList->currentRow())
		{
			case 0:
				   {
					   axis = QwtPlot::xBottom;
					   fnt = QFontDialog::getFont( &okF, xBottomFont,this);
					   if (okF)
						   xBottomFont=fnt;
					   break;
				   }
			case 1:
				   {
					   axis = QwtPlot::yLeft;
					   fnt = QFontDialog::getFont( &okF, yLeftFont,this);
					   if (okF)
						   yLeftFont=fnt;
					   break;
				   }
			case 2:
				   {
					   axis = QwtPlot::xTop;
					   fnt = QFontDialog::getFont( &okF, xTopFont, this);
					   if (okF)
						   xTopFont=fnt;
					   break;
				   }
			case 3:
				   {
					   axis = QwtPlot::yRight;
					   fnt = QFontDialog::getFont( &okF, yRightFont, this);
					   if (okF)
						   yRightFont=fnt;
					   break;
				   }
		}

	d_graph->setAxisFont(axis, fnt);
}

void AxesDialog::accept()
{
	if (updatePlot())
		close();
}

void AxesDialog::majorGridEnabled(bool on)
{
	boxTypeMajor->setEnabled(on);
	boxColorMajor->setEnabled(on);
	boxWidthMajor->setEnabled(on);

    updateGrid();
}

void AxesDialog::minorGridEnabled(bool on)
{
	boxTypeMinor->setEnabled(on);
	boxColorMinor->setEnabled(on);
	boxWidthMinor->setEnabled(on);

	updateGrid();
}

void AxesDialog::updateGrid()
{
	if (generalDialog->currentWidget() != gridPage)
		return;

    switch(boxApplyGridFormat->currentIndex()){
        case 0:
        {
            applyChangesToGrid(d_graph->grid());
            d_graph->replot();
            d_graph->notifyChanges();
        }
        break;

        case 1:
        {
            MultiLayer *plot = d_graph->multiLayer();
            if (!plot)
                return;

            QList<Graph *> layers = plot->layersList();
			foreach(Graph *g, layers){
                if (g->isPiePlot())
                    continue;

                applyChangesToGrid(g->grid());
                g->replot();
            }
            plot->applicationWindow()->modifiedProject();
        }
        break;

        case 2:
        {
            ApplicationWindow *app = (ApplicationWindow *)parent();
            if (!app)
                return;

            QList<MdiSubWindow *> windows = app->windowsList();
            foreach(MdiSubWindow *w, windows){
                if (w->isA("MultiLayer")){
                    QList<Graph *> layers = ((MultiLayer*)w)->layersList();
                    foreach(Graph *g, layers){
                        if (g->isPiePlot())
                            continue;
                        applyChangesToGrid(g->grid());
                        g->replot();
                    }
                }
            }
            app->modifiedProject();
        }
        break;
    }
}

void AxesDialog::applyChangesToGrid(Grid *grid)
{
    if (!grid)
        return;

	if (axesGridList->currentRow() == 1){
		grid->enableX(boxMajorGrid->isChecked());
		grid->enableXMin(boxMinorGrid->isChecked());

		grid->setMajPenX(QPen(ColorBox::color(boxColorMajor->currentIndex()), boxWidthMajor->value(),
					 		Graph::getPenStyle(boxTypeMajor->currentIndex())));
		grid->setMinPenX(QPen(ColorBox::color(boxColorMinor->currentIndex()), boxWidthMinor->value(),
					 		Graph::getPenStyle(boxTypeMinor->currentIndex())));
	} else {
		grid->enableY(boxMajorGrid->isChecked());
		grid->enableYMin(boxMinorGrid->isChecked());

		grid->setMajPenY(QPen(ColorBox::color(boxColorMajor->currentIndex()), boxWidthMajor->value(),
					 		Graph::getPenStyle(boxTypeMajor->currentIndex())));
		grid->setMinPenY(QPen(ColorBox::color(boxColorMinor->currentIndex()), boxWidthMinor->value(),
					 		Graph::getPenStyle(boxTypeMinor->currentIndex())));
	}

	grid->enableZeroLineX(boxXLine->isChecked());
	grid->enableZeroLineY(boxYLine->isChecked());
	grid->setAxis(boxGridXAxis->currentIndex() + 2, boxGridYAxis->currentIndex());
	grid->setRenderHint(QwtPlotItem::RenderAntialiased, boxAntialiseGrid->isChecked());
}

void AxesDialog::showGridOptions(int axis)
{
    Grid *grd = (Grid *)d_graph->grid();
    if (!grd)
        return;

    boxMajorGrid->blockSignals(true);
	boxMinorGrid->blockSignals(true);
	boxWidthMajor->blockSignals(true);
	boxWidthMinor->blockSignals(true);
	boxColorMajor->blockSignals(true);
	boxColorMinor->blockSignals(true);
	boxTypeMajor->blockSignals(true);
	boxTypeMinor->blockSignals(true);
    boxAntialiseGrid->blockSignals(true);

    if (axis == 1) {
        boxMajorGrid->setChecked(grd->xEnabled());
        boxMinorGrid->setChecked(grd->xMinEnabled());

        boxXLine->setEnabled(true);
        boxYLine->setDisabled(true);

        boxGridXAxis->setEnabled(true);
        boxGridYAxis->setDisabled(true);

		QPen majPenX = grd->majPenX();
		boxTypeMajor->setCurrentIndex(majPenX.style() - 1);
    	boxColorMajor->setColor(majPenX.color());
    	boxWidthMajor->setValue(majPenX.widthF());

		QPen minPenX = grd->minPenX();
    	boxTypeMinor->setCurrentItem(minPenX.style() - 1);
    	boxColorMinor->setColor(minPenX.color());
    	boxWidthMinor->setValue(minPenX.widthF());
    } else if (axis == 0) {
        boxMajorGrid->setChecked(grd->yEnabled());
        boxMinorGrid->setChecked(grd->yMinEnabled());

        boxXLine->setDisabled(true);
        boxYLine->setEnabled(true);

        boxGridXAxis->setDisabled(true);
        boxGridYAxis->setEnabled(true);

		QPen majPenY = grd->majPenY();
		boxTypeMajor->setCurrentIndex(majPenY.style() - 1);
    	boxColorMajor->setColor(majPenY.color());
    	boxWidthMajor->setValue(majPenY.widthF());

		QPen minPenY = grd->minPenY();
    	boxTypeMinor->setCurrentItem(minPenY.style() - 1);
    	boxColorMinor->setColor(minPenY.color());
    	boxWidthMinor->setValue(minPenY.widthF());
	}

    bool majorOn = boxMajorGrid->isChecked();
    boxTypeMajor->setEnabled(majorOn);
	boxColorMajor->setEnabled(majorOn);
	boxWidthMajor->setEnabled(majorOn);

    bool minorOn = boxMinorGrid->isChecked();
    boxTypeMinor->setEnabled(minorOn);
    boxColorMinor->setEnabled(minorOn);
    boxWidthMinor->setEnabled(minorOn);

    boxGridXAxis->setCurrentIndex(grd->xAxis() - 2);
    boxGridYAxis->setCurrentIndex(grd->yAxis());

    boxXLine->setChecked(grd->xZeroLineEnabled());
    boxYLine->setChecked(grd->yZeroLineEnabled());

    boxAntialiseGrid->setChecked(grd->testRenderHint(QwtPlotItem::RenderAntialiased));

    boxAntialiseGrid->blockSignals(false);
	boxWidthMajor->blockSignals(false);
	boxWidthMinor->blockSignals(false);
	boxColorMajor->blockSignals(false);
	boxColorMinor->blockSignals(false);
	boxTypeMajor->blockSignals(false);
	boxTypeMinor->blockSignals(false);
	boxMajorGrid->blockSignals(false);
	boxMinorGrid->blockSignals(false);
}

void AxesDialog::stepEnabled()
{
	boxStep->setEnabled(btnStep->isChecked ());
	boxUnit->setEnabled(btnStep->isChecked ());
	boxMajorValue->setDisabled(btnStep->isChecked ());
	btnMajor->setChecked(!btnStep->isChecked ());
}

void AxesDialog::stepDisabled()
{
	boxStep->setDisabled(btnMajor->isChecked ());
	boxUnit->setDisabled(btnMajor->isChecked ());
	boxMajorValue->setEnabled(btnMajor->isChecked ());
	btnStep->setChecked(!btnMajor->isChecked ());
}

void AxesDialog::updateAxisColor(int)
{
	int a = mapToQwtAxisId();
	boxAxisColor->blockSignals(true);
    boxAxisColor->setColor(d_graph->axisColor(a));
	boxAxisColor->blockSignals(false);

	boxAxisNumColor->blockSignals(true);
    boxAxisNumColor->setColor(d_graph->axisLabelsColor(a));
	boxAxisNumColor->blockSignals(false);
}

void AxesDialog::changeBaselineDist(int baseline)
{
	int axis = mapToQwtAxisId();
	axesBaseline[axis] = baseline;

	if (d_graph->axisTitleString(axis) != boxTitle->text())
		d_graph->setAxisTitle(axis, boxTitle->text());

	QString formula = boxFormula->text();
	if (!boxShowFormula->isChecked())
		formula = QString();
	showAxis(axis, boxAxisType->currentIndex(), d_graph->axisFormatInfo(axis), boxShowAxis->isChecked(), boxMajorTicksType->currentIndex(), boxMinorTicksType->currentIndex(),
			boxShowLabels->isChecked(), boxAxisColor->color(), boxFormat->currentIndex(), boxPrecision->value(),
			boxAngle->value(), baseline, formula, boxAxisNumColor->color());
}

bool AxesDialog::updatePlot()
{
	if (generalDialog->currentWidget()==(QWidget*)scalesPage)
	{
        int a = mapToQwtAxis(axesList->currentRow());
        ScaleDraw::ScaleType type = d_graph->axisType(a);

		double start = 0.0, end = 0.0;
		if (type == ScaleDraw::Date){
            ScaleDraw *sclDraw = (ScaleDraw *)d_graph->axisScaleDraw(a);
            QDateTime origin = sclDraw->dateTimeOrigin();
            start = (double)origin.secsTo(boxStartDateTime->dateTime());
            end = (double)origin.secsTo(boxEndDateTime->dateTime());
		} else if (type == ScaleDraw::Time){
            ScaleDraw *sclDraw = (ScaleDraw *)d_graph->axisScaleDraw(a);
            QTime origin = sclDraw->dateTimeOrigin().time();
            start = (double)origin.msecsTo(boxStartTime->time());
            end = (double)origin.msecsTo(boxEndTime->time());
		} else {
            start = boxStart->value();
            end = boxEnd->value();
		}

		double step = 0.0;
        if (btnStep->isChecked()){
			step = boxStep->value();
        	if (type == ScaleDraw::Time){
		      switch (boxUnit->currentIndex())
                 {
			     case 0:
			     break;
			     case 1:
				 	step *= 1e3;
			     break;
			     case 2:
				 	step *= 6e4;
                 break;
			     case 3:
				     step *= 36e5;
		         break;
			     }
		   } else if (type == ScaleDraw::Date){
		        switch (boxUnit->currentIndex())
                    {
                    case 0:
						step *= 86400;
                    break;
                    case 1:
                         step *= 604800;
                    break;
                    }
	            }
          	}

		double breakLeft = -DBL_MAX, breakRight = DBL_MAX;
		if (boxAxesBreaks->isChecked()){
			breakLeft = qMin(boxBreakStart->value(), boxBreakEnd->value());
			breakRight = qMax(boxBreakStart->value(), boxBreakEnd->value());
		}

		d_graph->setScale(a, start, end, step, boxMajorValue->value(), boxMinorValue->currentText().toInt(),
                          boxScaleType->currentIndex(), btnInvert->isChecked(), breakLeft, breakRight,
                          boxBreakPosition->value(), boxStepBeforeBreak->value(), boxStepAfterBreak->value(),
                          boxMinorTicksBeforeBreak->currentText().toInt(), boxMinorTicksAfterBreak->currentText().toInt(),
                          boxLog10AfterBreak->isChecked(), boxBreakWidth->value(), boxBreakDecoration->isChecked());
		d_graph->notifyChanges();
	}
	else if (generalDialog->currentWidget() == gridPage)
		updateGrid();
	else if (generalDialog->currentWidget() == (QWidget*)axesPage)
	{
		int axis = mapToQwtAxisId();
		int format = boxAxisType->currentIndex();

		int baseline = boxBaseline->value();
		axesBaseline[axis] = baseline;

        QString formatInfo = QString::null;
		if (format == ScaleDraw::Numeric)
		{
			if (boxShowFormula->isChecked())
			{
				QString formula = boxFormula->text().lower();
				try
				{
					double value = 1.0;
					MyParser parser;
					if (formula.contains("x"))
						parser.DefineVar("x", &value);
					else if (formula.contains("y"))
						parser.DefineVar("y", &value);
					parser.SetExpr(formula.ascii());
					parser.Eval();
				}
				catch(mu::ParserError &e)
				{
					QMessageBox::critical(this, tr("QtiPlot - Formula input error"), QString::fromStdString(e.GetMsg())+"\n"+
							tr("Valid variables are 'x' for Top/Bottom axes and 'y' for Left/Right axes!"));
					boxFormula->setFocus();
					return false;
				}
			}
		} else if (format == ScaleDraw::Time || format == ScaleDraw::Date){
            QStringList lst = d_graph->axisFormatInfo(axis).split(";", QString::KeepEmptyParts);
            if ((int)lst.count() >= 2)
                lst[1] = boxFormat->currentText();
            formatInfo = lst.join(";");
        } else if (format == ScaleDraw::Day || format == ScaleDraw::Month)
            formatInfo = QString::number(boxFormat->currentIndex());
          else if (format == ScaleDraw::ColHeader)
            formatInfo = boxTableName->currentText();
          else
            formatInfo = boxColName->currentText();

		if (d_graph->axisTitleString(axis) != boxTitle->text())
			d_graph->setAxisTitle(axis, boxTitle->text());

		if (axis == QwtPlot::xBottom)
			xBottomLabelsRotation=boxAngle->value();
		else if (axis == QwtPlot::xTop)
			xTopLabelsRotation=boxAngle->value();

		QString formula = boxFormula->text();
		if (!boxShowFormula->isChecked())
			formula = QString();
		showAxis(axis, format, formatInfo, boxShowAxis->isChecked(), boxMajorTicksType->currentIndex(), boxMinorTicksType->currentIndex(),
				boxShowLabels->isChecked(), boxAxisColor->color(), boxFormat->currentIndex(),
				boxPrecision->value(), boxAngle->value(), baseline, formula, boxAxisNumColor->color());
	}
	else if (generalDialog->currentWidget()==(QWidget*)frame){
		d_graph->setAxesLinewidth(boxAxesLinewidth->value());
        d_graph->changeTicksLength(boxMinorTicksLength->value(), boxMajorTicksLength->value());
		if (boxFramed->isChecked())
        	d_graph->setCanvasFrame(boxFrameWidth->value(), boxFrameColor->color());
		else
			d_graph->setCanvasFrame(0);
        d_graph->drawAxesBackbones(boxBackbones->isChecked());
        d_graph->replot();
	}

	return true;
}

void AxesDialog::setGraph(Graph *g)
{
	ApplicationWindow *app = (ApplicationWindow *)this->parent();
	if (!app)
		return;

	if (!g)
        return;

	d_graph = g;

	tablesList = app->tableNames();
	boxTableName->insertStringList(tablesList);

	boxColName-> insertStringList(app->columnsList(Table::All));

	xAxisOn = g->axisEnabled(QwtPlot::xBottom);
	yAxisOn = g->axisEnabled(QwtPlot::yLeft);
	topAxisOn = g->axisEnabled(QwtPlot::xTop);
	rightAxisOn = g->axisEnabled(QwtPlot::yRight);

	xBottomFont = g->axisFont(QwtPlot::xBottom);
	yLeftFont = g->axisFont(QwtPlot::yLeft);
	xTopFont = g->axisFont(QwtPlot::xTop);
	yRightFont = g->axisFont(QwtPlot::yRight);

	majTicks = g->getMajorTicksType();
	minTicks = g->getMinorTicksType();

	updateTitleBox(0);

	xBottomLabelsRotation = g->labelsRotation(QwtPlot::xBottom);
	xTopLabelsRotation = g->labelsRotation(QwtPlot::xTop);

	for (int axis=0; axis<QwtPlot::axisCnt; axis++){
		const QwtScaleDraw *sd = g->axisScaleDraw (axis);
		tickLabelsOn << QString::number(sd->hasComponent(QwtAbstractScaleDraw::Labels));

		QwtScaleWidget *scale = (QwtScaleWidget *)g->axisWidget(axis);
		if (scale)
			axesBaseline << scale->margin();
		else
			axesBaseline << 0;
	}

	boxAxesLinewidth->setValue(g->axesLinewidth());
    boxBackbones->setChecked (d_graph->axesBackbones());

	boxFramed->setChecked(d_graph->canvasFrameWidth()>0);
	boxFrameColor->blockSignals(true);
	boxFrameColor->setColor(d_graph->canvasFrameColor());
	boxFrameColor->blockSignals(false);
	boxFrameWidth->setValue(d_graph->canvasFrameWidth());

	boxMinorTicksLength->setValue(g->minorTickLength());
	boxMajorTicksLength->setValue(g->majorTickLength());

	showGridOptions(axesGridList->currentRow());
}

int AxesDialog::mapToQwtAxisId()
{
return mapToQwtAxis(axesTitlesList->currentRow());
}

int AxesDialog::mapToQwtAxis(int axis)
{
int a=-1;
switch(axis)
        {
        case 0:
           a = QwtPlot::xBottom;
        break;
        case 1:
            a = QwtPlot::yLeft;
        break;
        case 2:
             a = QwtPlot::xTop;
        break;
        case 3:
             a = QwtPlot::yRight;
        break;
		}
return a;
}

void AxesDialog::updateScale()
{
    int axis = axesList->currentRow();

    boxStart->clear();
    boxEnd->clear();
    boxStep->clear();
    boxUnit->hide();
    boxUnit->clear();

    int a = mapToQwtAxis(axis);
    const QwtScaleDiv *scDiv = d_graph->axisScaleDiv(a);
    double start = QMIN(scDiv->lBound(), scDiv->hBound());
    double end = QMAX(scDiv->lBound(), scDiv->hBound());

    ScaleDraw::ScaleType type = d_graph->axisType(a);
	if (type == ScaleDraw::Date){
	    ScaleDraw *sclDraw = (ScaleDraw *)d_graph->axisScaleDraw(a);
        QDateTime origin = sclDraw->dateTimeOrigin();

	    boxStart->hide();
	    boxStartTime->hide();
        boxStartDateTime->show();
        boxStartDateTime->setDisplayFormat(sclDraw->format());
        boxStartDateTime->setDateTime(origin.addSecs((int)start));

        boxEnd->hide();
        boxEndTime->hide();
        boxEndDateTime->show();
        boxEndDateTime->setDisplayFormat(sclDraw->format());
        boxEndDateTime->setDateTime(origin.addSecs((int)end));

		boxUnit->show();
		boxUnit->insertItem(tr("days"));
		boxUnit->insertItem(tr("weeks"));
		boxStep->setValue(d_graph->axisStep(a)/86400.0);
		boxStep->setSingleStep(1);
	} else if (type == ScaleDraw::Time){
	    ScaleDraw *sclDraw = (ScaleDraw *)d_graph->axisScaleDraw(a);
        QTime origin = sclDraw->dateTimeOrigin().time();

	    boxStart->hide();
	    boxStartDateTime->hide();
        boxStartTime->show();
        boxStartTime->setDisplayFormat(sclDraw->format());
        boxStartTime->setTime(origin.addMSecs((int)start));

        boxEnd->hide();
        boxEndDateTime->hide();
        boxEndTime->show();
        boxEndTime->setDisplayFormat(sclDraw->format());
        boxEndTime->setTime(origin.addMSecs((int)end));

        boxUnit->show();
        boxUnit->insertItem(tr("millisec."));
        boxUnit->insertItem(tr("sec."));
        boxUnit->insertItem(tr("min."));
        boxUnit->insertItem(tr("hours"));
        boxUnit->setCurrentIndex(1);
        boxStep->setValue(d_graph->axisStep(a)/1e3);
        boxStep->setSingleStep(1000);
	} else {
	    boxStart->show();
        boxStart->setValue(start);
        boxStartTime->hide();
        boxStartDateTime->hide();
        boxEnd->show();
        boxEnd->setValue(end);
        boxEndTime->hide();
        boxEndDateTime->hide();
        boxStep->setValue(d_graph->axisStep(a));
        boxStep->setSingleStep(0.1);
	}

    double range = fabs(scDiv->range());
    ScaleEngine *sc_engine = (ScaleEngine *)d_graph->axisScaleEngine(a);
    if (sc_engine->axisBreakLeft() > -DBL_MAX)
        boxBreakStart->setValue(sc_engine->axisBreakLeft());
    else
        boxBreakStart->setValue(start + 0.25*range);

    if (sc_engine->axisBreakRight() < DBL_MAX)
        boxBreakEnd->setValue(sc_engine->axisBreakRight());
    else
        boxBreakEnd->setValue(start + 0.75*range);

    boxAxesBreaks->setChecked(sc_engine->hasBreak());
    boxBreakPosition->setValue(sc_engine->breakPosition());
    boxBreakWidth->setValue(sc_engine->breakWidth());
    boxStepBeforeBreak->setValue(sc_engine->stepBeforeBreak());
    boxStepAfterBreak->setValue(sc_engine->stepAfterBreak());

    QwtScaleTransformation::Type scale_type = sc_engine->type();
    boxMinorTicksBeforeBreak->clear();
    if (scale_type == QwtScaleTransformation::Log10)
        boxMinorTicksBeforeBreak->addItems(QStringList()<<"0"<<"2"<<"4"<<"8");
    else
        boxMinorTicksBeforeBreak->addItems(QStringList()<<"0"<<"1"<<"4"<<"9"<<"14"<<"19");
    boxMinorTicksBeforeBreak->setEditText(QString::number(sc_engine->minTicksBeforeBreak()));


    boxMinorTicksAfterBreak->setEditText(QString::number(sc_engine->minTicksAfterBreak()));
    boxLog10AfterBreak->setChecked(sc_engine->log10ScaleAfterBreak());
    boxBreakDecoration->setChecked(sc_engine->hasBreakDecoration());

	QwtValueList lst = scDiv->ticks (QwtScaleDiv::MajorTick);
	boxMajorValue->setValue(lst.count());

	if (d_graph->axisStep(a) != 0.0){
		btnStep->setChecked(true);
		boxStep->setEnabled(true);
		boxUnit->setEnabled(true);

		btnMajor->setChecked(false);
		boxMajorValue->setEnabled(false);
	} else{
		btnStep->setChecked(false);
		boxStep->setEnabled(false);
		boxUnit->setEnabled(false);
		btnMajor->setChecked(true);
		boxMajorValue->setEnabled(true);
	}

    btnInvert->setChecked(sc_engine->testAttribute(QwtScaleEngine::Inverted));
    boxScaleType->setCurrentItem(scale_type);

    boxMinorValue->clear();
    if (scale_type == QwtScaleTransformation::Log10)
        boxMinorValue->addItems(QStringList()<<"0"<<"2"<<"4"<<"8");
    else
        boxMinorValue->addItems(QStringList()<<"0"<<"1"<<"4"<<"9"<<"14"<<"19");

    boxMinorValue->setEditText(QString::number(d_graph->axisMaxMinor(a)));
}

void AxesDialog::updateTitleBox(int axis)
{
	int axisId = mapToQwtAxis(axis);
	boxTitle->setText(d_graph->axisTitleString(axisId));
}

void AxesDialog::pickAxisColor()
{
	int axis = mapToQwtAxisId();
	QString formula = boxFormula->text();
	if (!boxShowFormula->isChecked())
	   formula = QString();

    showAxis(axis, boxAxisType->currentIndex(), d_graph->axisFormatInfo(axis), boxShowAxis->isChecked(),
            boxMajorTicksType->currentIndex(), boxMinorTicksType->currentIndex(),
            boxShowLabels->isChecked(), boxAxisColor->color(), boxFormat->currentIndex(), boxPrecision->value(),
            boxAngle->value(), boxBaseline->value(), formula, boxAxisNumColor->color());
}

void AxesDialog::pickAxisNumColor()
{
  	int axis = mapToQwtAxisId();
  	QString formula = boxFormula->text();
  	if (!boxShowFormula->isChecked())
  	     formula = QString::null;

  	showAxis(axis, boxAxisType->currentIndex(), d_graph->axisFormatInfo(axis), boxShowAxis->isChecked(),
            boxMajorTicksType->currentIndex(), boxMinorTicksType->currentIndex(),
            boxShowLabels->isChecked(), boxAxisColor->color(), boxFormat->currentIndex(), boxPrecision->value(),
            boxAngle->value(), boxBaseline->value(), formula, boxAxisNumColor->color());
}

void AxesDialog::setAxisType(int)
{
	int a = mapToQwtAxisId();
	int style = (int)d_graph->axisType(a);
	boxAxisType->setCurrentIndex(style);
	showAxisFormatOptions(style);

	if (style == 1)
		boxColName->setCurrentText(d_graph->axisFormatInfo(a));
}

void AxesDialog::setBaselineDist(int)
{
    boxBaseline->setValue(axesBaseline[mapToQwtAxisId()]);
}

void AxesDialog::setTicksType(int)
{
	int a = mapToQwtAxisId();
	boxMajorTicksType->setCurrentIndex(majTicks[a]);
	boxMinorTicksType->setCurrentIndex(minTicks[a]);
}

void AxesDialog::updateMajTicksType(int)
{
	int axis=mapToQwtAxisId();
	int type=boxMajorTicksType->currentIndex();
	if (majTicks[axis] == type)
		return;

	majTicks[axis]=type;
	QString formula =  boxFormula->text();
	if (!boxShowFormula->isChecked())
		formula = QString();

    showAxis(axis, boxAxisType->currentIndex(), d_graph->axisFormatInfo(axis), boxShowAxis->isChecked(),
            type, boxMinorTicksType->currentIndex(), boxShowLabels->isChecked(), boxAxisColor->color(),
            boxFormat->currentIndex(),boxPrecision->value(), boxAngle->value(), boxBaseline->value(),
            formula, boxAxisNumColor->color());
}

void AxesDialog::updateMinTicksType(int)
{
	int axis = mapToQwtAxisId();
	int type = boxMinorTicksType->currentIndex();
	if (minTicks[axis] == type)
		return;

	minTicks[axis] = type;
	QString formula = boxFormula->text();
    if (!boxShowFormula->isChecked())
		formula = QString();

    showAxis(axis,boxAxisType->currentIndex(), d_graph->axisFormatInfo(axis), boxShowAxis->isChecked(),
            boxMajorTicksType->currentIndex(), type, boxShowLabels->isChecked(), boxAxisColor->color(),
            boxFormat->currentIndex(),boxPrecision->value(),
            boxAngle->value(), boxBaseline->value(), formula, boxAxisNumColor->color());
}

void AxesDialog::updateTickLabelsList(bool on)
{
	int axis = mapToQwtAxisId();
	if (axis == QwtPlot::xBottom || axis == QwtPlot::xTop)
		boxAngle->setEnabled(on);

	bool userFormat = true;
	if (boxFormat->currentIndex() == 0)
		userFormat = false;
	boxPrecision->setEnabled(on && userFormat);

	if (tickLabelsOn[axis] == QString::number(on))
		return;
	tickLabelsOn[axis]=QString::number(on);

    QString formatInfo = QString::null;
	int type = boxAxisType->currentIndex();
	if (type == ScaleDraw::Day || type == ScaleDraw::Month)
		formatInfo = QString::number(boxFormat->currentIndex());
	else if (type == ScaleDraw::Time || type == ScaleDraw::Date)
	{
		QStringList lst = (d_graph->axisFormatInfo(axis)).split(";", QString::SkipEmptyParts);
		lst[1] = boxFormat->currentText();
		formatInfo = lst.join(";");
	}
	else
		formatInfo = boxColName->currentText();

	QString formula = boxFormula->text();
	if (!boxShowFormula->isChecked())
	   formula = QString();

    showAxis(axis, type, formatInfo, boxShowAxis->isChecked(), boxMajorTicksType->currentIndex(), boxMinorTicksType->currentIndex(),
                  boxShowLabels->isChecked(), boxAxisColor->color(), boxFormat->currentIndex(), boxPrecision->value(),
	              boxAngle->value(), boxBaseline->value(), formula, boxAxisNumColor->color());
}

void AxesDialog::setCurrentScale(int axisPos)
{
int axis = -1;
switch (axisPos)
	{
	case QwtScaleDraw::LeftScale:
		axis = 1;
	break;
	case QwtScaleDraw::BottomScale:
		axis = 0;
	break;
	case QwtScaleDraw::RightScale:
		axis = 3;
	break;
	case QwtScaleDraw::TopScale:
		axis = 2;
	break;
	}
if (generalDialog->currentPage()==(QWidget*)scalesPage)
	axesList->setCurrentRow(axis);
else if (generalDialog->currentPage()==(QWidget*)axesPage)
	axesTitlesList->setCurrentRow(axis);
}

void AxesDialog::showAxesPage()
{
	if (generalDialog->currentWidget()!=(QWidget*)axesPage)
		generalDialog->setCurrentWidget(axesPage);
}

void AxesDialog::showGridPage()
{
	if (generalDialog->currentWidget()!=(QWidget*)gridPage)
		generalDialog->setCurrentWidget(gridPage);
}

void AxesDialog::setLabelsNumericFormat(int)
{
	int axis = mapToQwtAxisId();
	int type = boxAxisType->currentIndex();
	int prec = boxPrecision->value();
	int format = boxFormat->currentIndex();

    QString formatInfo = QString::null;
	if (type == ScaleDraw::Numeric){
		if (d_graph->axisLabelFormat(axis) == format &&
			d_graph->axisLabelPrecision(axis) == prec)
			return;

		if (format == 0)
			boxPrecision->setEnabled(false);
		else
			boxPrecision->setEnabled(true);
    } else if (type == ScaleDraw::Day || type == ScaleDraw::Month)
		formatInfo = QString::number(format);
	  else if (type == ScaleDraw::Time || type == ScaleDraw::Date){
		QStringList lst = d_graph->axisFormatInfo(axis).split(";", QString::SkipEmptyParts);
		lst[1] = boxFormat->currentText();
		formatInfo = lst.join(";");
	} else
		formatInfo = boxColName->currentText();

	QString formula =  boxFormula->text();
	if (!boxShowFormula->isChecked())
		formula = QString();

    showAxis(axis, type, formatInfo, boxShowAxis->isChecked(), boxMajorTicksType->currentIndex(),
			boxMinorTicksType->currentIndex(), boxShowLabels->isChecked(), boxAxisColor->color(),
			format, prec, boxAngle->value(), boxBaseline->value(), formula, boxAxisNumColor->color());
}

void AxesDialog::showAxisFormula(int axis)
{
    QString formula = d_graph->axisFormula(axis);
    if (!formula.isEmpty()){
        boxShowFormula->setChecked(true);
        boxFormula->show();
        boxFormula->setText(formula);
    } else {
        boxShowFormula->setChecked(false);
        boxFormula->clear();
        boxFormula->hide();
    }
}

void AxesDialog::updateLabelsFormat(int)
{
        if (boxAxisType->currentIndex() != ScaleDraw::Numeric)
        	return;

		int a = mapToQwtAxisId();
		int format = d_graph->axisLabelFormat(a);
        boxFormat->setCurrentIndex(format);
		boxPrecision->setValue(d_graph->axisLabelPrecision(a));

        if (format == 0)
        	boxPrecision->setEnabled(false);
        else
        	boxPrecision->setEnabled(true);

        QString formula = d_graph->axisFormula(a);
        if (!formula.isEmpty())
        {
        	boxShowFormula->setChecked(true);
        	boxFormula->show();
        	boxFormula->setText(formula);
        }
        else
        {
        	boxShowFormula->setChecked(false);
        	boxFormula->clear();
        	boxFormula->hide();
        }
}

void AxesDialog::showGeneralPage()
{
	generalDialog->showPage (frame);
}

void AxesDialog::showFormulaBox()
{
	if (boxShowFormula->isChecked())
		boxFormula->show();
	else
		boxFormula->hide();
}

void AxesDialog::customAxisLabelFont()
{
	int axis = mapToQwtAxisId();
		bool okF;
		QFont oldFont = d_graph->axisTitleFont(axis);
	QFont fnt = QFontDialog::getFont( &okF, oldFont,this);
	if (okF && fnt != oldFont)
		d_graph->setAxisTitleFont(axis, fnt);
}

void AxesDialog::pageChanged ( QWidget *page )
{
  	if (lastPage == scalesPage && page == axesPage){
  		axesTitlesList->setCurrentRow(axesList->currentRow());
  	    lastPage = page;
  	}else if (lastPage == axesPage && page == scalesPage){
  		axesList->setCurrentRow(axesTitlesList->currentRow());
  	    lastPage = page;
  	}
}

int AxesDialog::exec()
{
	axesList->setCurrentRow(0);
	axesGridList->setCurrentRow(0);
	axesTitlesList->setCurrentRow(0);

    setModal(true);
    show();
	return 0;
}

void AxesDialog::updateMinorTicksList(int scaleType)
{
	updatePlot();

	boxMinorValue->clear();
	if (scaleType)//log scale
		boxMinorValue->addItems(QStringList()<<"0"<<"2"<<"4"<<"8");
	else
		boxMinorValue->addItems(QStringList()<<"0"<<"1"<<"4"<<"9"<<"14"<<"19");

	int a = mapToQwtAxis(axesList->currentRow());
	boxMinorValue->setEditText(QString::number(d_graph->axisMaxMinor(a)));
}

void AxesDialog::showAxis(int axis, int type, const QString& labelsColName, bool axisOn,
		int majTicksType, int minTicksType, bool labelsOn, const QColor& c, int format,
		int prec, int rotation, int baselineDist, const QString& formula, const QColor& labelsColor)
{
	ApplicationWindow *app = (ApplicationWindow *)this->parent();
	if (!app)
		return;

	Table *w = app->table(labelsColName);
	if ((type == ScaleDraw::Text || type == ScaleDraw::ColHeader) && !w)
		return;

	if (!d_graph)
		return;
	d_graph->showAxis(axis, type, labelsColName, w, axisOn, majTicksType, minTicksType, labelsOn,
			c, format, prec, rotation, baselineDist, formula, labelsColor);
}
