// file kernel/n/x86/numerix.S: assembly code for mode = SLONG
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                 Fonctions assembleur pour le mode SLONG               |
 |                                                                       |
 +-----------------------------------------------------------------------*/


/* fichier de configuration spcifique  la machine cible */
#include "../../config.h"

/* nom des symboles exports */
#ifdef __USER_LABEL_PREFIX__
#define SUBR(nom)  CATENATE2(__USER_LABEL_PREFIX__,nom)
#define CATENATE2(x,y) CATENATE(x,y)
#define CATENATE(x,y)  x##y
#else
#define SUBR(nom) nom
#endif

/* alignement */
#ifdef __APPLE__
#define ALIGN_32 .align 5
#define ALIGN_4  .align 2
#else
#define ALIGN_32 .align 32
#define ALIGN_4  .align 4
#endif

/* entre et retour de fonction */
#if __ELF__
#define  ENTER(nom)                \
        ALIGN_32                  ;\
        .globl SUBR(nom)          ;\
        .type  SUBR(nom),@function;\
SUBR(nom):                        ;\
        pushl  %ebp               ;\
        movl   %esp,%ebp          ;\
        pushl  %edi               ;\
        pushl  %esi               ;\
        pushl  %ebx
#else
#define  ENTER(nom)                \
        ALIGN_32                  ;\
        .globl SUBR(nom)          ;\
SUBR(nom):                        ;\
        pushl  %ebp               ;\
        movl   %esp,%ebp          ;\
        pushl  %edi               ;\
        pushl  %esi               ;\
        pushl  %ebx
#endif

#define  RETURN_WITH_BP            \
        movl   -12(%ebp),%ebx     ;\
        movl    -8(%ebp),%esi     ;\
        movl    -4(%ebp),%edi     ;\
        movl   %ebp,%esp          ;\
        popl   %ebp               ;\
        ret

#define  RETURN_WITH_SP            \
        popl   %ebx               ;\
        popl   %esi               ;\
        popl   %edi               ;\
        popl   %ebp               ;\
        ret

/* instructions de rptition */
#ifdef __APPLE__
#define REP(x)   rep/x
#define REPE(x)  repe/x
#define REPNE(x) repne/x
#else
#define REP(x)   rep x
#define REPE(x)  repe x
#define REPNE(x) repne x
#endif

/* accs aux paramtres d appel */
#define arg1    8(%ebp)
#define arg2   12(%ebp)
#define arg3   16(%ebp)
#define arg4   20(%ebp)
#define arg5   24(%ebp)
#define arg6   28(%ebp)
#define arg7   32(%ebp)
#define arg8   36(%ebp)

/* variables locales */
#define tmp1  -16(%ebp)
#define tmp2  -20(%ebp)
#define tmp3  -24(%ebp)
#define tmp4  -28(%ebp)
#define tmp5  -32(%ebp)
#define tmp6  -36(%ebp)
#define tmp7  -40(%ebp)
#define tmp8  -44(%ebp)

/* affiche un message sur stdout */
#if defined(__linux__)
#define PRINTF pushl $1; call dprintf; leal 4(%esp),%esp
#elif defined(__CYGWIN__)
#define PRINTF call _printf
#endif

#define TRACE(msg)    \
  pusha             ; \
  pushf             ; \
  call 1f           ; \
  .string msg       ; \
1:                  ; \
  PRINTF            ; \
  leal 4(%esp),%esp ; \
  popf              ; \
  popa

/*
   allocation de mmoire temporaire
   entre : eax = nombre d octets  allouer
   sortie : esp <- esp - eax, eax <- ind.
*/
#if defined(__CYGWIN__) || defined(__MSVCRT__)
#define ALLOCA call __alloca
#else
#define ALLOCA subl %eax, %esp
#endif
	
                               /* +--------+
                                  |  Code  |
                                  +--------+ */

/* dboguage */ 
/* #include "dumpreg.S" */

/* addition/soustraction */
#include "add.S"

/* multiplication/carr */
#include "mul_n2.S"
#include "karatsuba.S"
#include "toom.S"

/* oprations modulo BASE^n +/- 1 */
#include "mmod.S"
#include "smod.S"

/* division/racine carre */
#include "div_n2.S"
#include "sqrt_n2.S"
#include "burnikel.S"

/* exponentiation modulaire */
#include "montgomery.S"
        
/* pgcd */
#include "gcd_n2.S"

/* divers */
#include "cmp.S"
#include "shift.S"
