/*
 ** Copyright 2004-2007 - INL
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __THREAD_CHECK__
#define __THREAD_CHECK__

#include <nuclient.h>
#include <QtGui>

class ThreadCheckConn : public QThread {
	Q_OBJECT

	nuauth_session_t *session;
	QString username, password;
	QMutex loop_mutex;
	bool loop_continue;
	bool report_errors;

signals:
	void tray_set_connected();
	void tray_set_stopped();
	void tray_set_trying();
	void tray_report_error();
	void tray_report_connected();
	void tray_report_disconnected();

protected:
	void run();
	void stopAuth();

public:
	ThreadCheckConn(QObject* _parent);

	void setUserInfos(QString _username, QString _password);
	void startAuth();
	void askStop();

};

#endif /* __THREAD_CHECK__ */
