/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.mapping.Procedure;
import gnu.mapping.ValueStack;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;

public class CallContext
implements Runnable {
    public Procedure proc;
    public int pc;
    public ValueStack vstack = new ValueStack();
    public Consumer consumer = this.vstack;
    public Object value1;
    public Object value2;
    public Object value3;
    public Object value4;
    public Object[] values;
    public int ivalue1;
    public int ivalue2;
    public int count;
    public int next;
    int where;
    static final int ARG_IN_VALUES_ARRAY = 0;
    static final int ARG_IN_VALUE1 = 1;
    static final int ARG_IN_VALUE2 = 2;
    static final int ARG_IN_VALUE3 = 3;
    static final int ARG_IN_VALUE4 = 4;
    static final int ARG_IN_IVALUE1 = 5;
    static final int ARG_IN_IVALUE2 = 6;

    public Object getArgAsObject(int i) {
        if (i < 8) {
            switch (this.where >> 4 * i & 0xF) {
                case 1: {
                    return this.value1;
                }
                case 2: {
                    return this.value2;
                }
                case 3: {
                    return this.value3;
                }
                case 4: {
                    return this.value4;
                }
            }
        }
        return this.values[i];
    }

    public Object getNextArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(this.proc, this.count);
        }
        return this.getArgAsObject(this.next++);
    }

    public Object getNextArg(Object defaultValue) {
        if (this.next >= this.count) {
            return defaultValue;
        }
        return this.getArgAsObject(this.next++);
    }

    public void lastArg() {
        if (this.next < this.count) {
            throw new WrongArguments(this.proc, this.count);
        }
        this.values = null;
    }

    public void setArgs() {
        this.count = 0;
        this.where = 0;
        this.next = 0;
    }

    public void setArgs(Object arg1) {
        this.value1 = arg1;
        this.count = 1;
        this.where = 1;
        this.next = 0;
    }

    public void setArgs(Object arg1, Object arg2) {
        this.value1 = arg1;
        this.value2 = arg2;
        this.count = 2;
        this.where = 33;
        this.next = 0;
    }

    public void setArgs(Object arg1, Object arg2, Object arg3) {
        this.value1 = arg1;
        this.value2 = arg2;
        this.value3 = arg3;
        this.count = 3;
        this.where = 801;
        this.next = 0;
    }

    public void setArgs(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.value1 = arg1;
        this.value2 = arg2;
        this.value3 = arg3;
        this.value4 = arg4;
        this.count = 4;
        this.where = 17185;
        this.next = 0;
    }

    public void setArgsN(Object[] args) {
        this.values = args;
        this.count = args.length;
        this.where = 0;
        this.next = 0;
    }

    public Object[] getArgs() {
        if (this.where == 0) {
            return this.values;
        }
        int i = this.count;
        Object[] args = new Object[i];
        while (--i >= 0) {
            args[i] = this.getArgAsObject(i);
        }
        return args;
    }

    public void runUntilDone() throws Throwable {
        Procedure proc;
        while ((proc = this.proc) != null) {
            this.proc = null;
            proc.apply(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object runUntilValue() throws Throwable {
        Consumer consumerSave = this.consumer;
        ValueStack vst = this.vstack;
        this.consumer = vst;
        int dindexSave = vst.gapStart;
        int oindexSave = vst.oindex;
        try {
            this.runUntilDone();
            Object object = Values.make(vst, dindexSave, vst.gapStart);
            Object var7_6 = null;
            this.consumer = consumerSave;
            vst.gapStart = dindexSave;
            vst.oindex = oindexSave;
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.consumer = consumerSave;
            vst.gapStart = dindexSave;
            vst.oindex = oindexSave;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUntilValue(Consumer out) throws Throwable {
        Consumer consumerSave = this.consumer;
        this.consumer = out;
        try {
            this.runUntilDone();
        }
        finally {
            this.consumer = consumerSave;
        }
    }

    public void run() {
        try {
            this.runUntilDone();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new WrappedException(ex);
        }
    }

    public void writeValue(Object value) {
        Values.writeValues(value, this.consumer);
    }
}

