/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class CatchClause
extends ScopeExp {
    Expression body;
    CatchClause next;

    public CatchClause(String name, ClassType type) {
        this.addDeclaration(name, type);
    }

    public final CatchClause getNext() {
        return this.next;
    }

    public final void setNext(CatchClause next) {
        this.next = next;
    }

    public final Expression getBody() {
        return this.body;
    }

    public final void setBody(Expression body) {
        this.body = body;
    }

    public final Declaration getDeclaration() {
        return this.firstDecl();
    }

    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Declaration catchDecl = this.firstDecl();
        Variable catchVar = catchDecl.allocateVariable(code);
        code.enterScope(this.scope);
        code.emitCatchStart((ClassType)catchDecl.getType());
        catchDecl.compileStore(comp);
        this.body.compileWithPosition(comp, target);
        code.emitCatchEnd();
        code.popScope();
    }

    protected void walkChildren(ExpWalker walker) {
        this.body = this.body.walk(walker);
    }

    public void print(OutPort ps) {
        ps.print("(Catch ? ");
        this.body.print(ps);
        ps.print(")");
    }
}

